
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "dataElements"
})
@Generated("jsonschema2pojo")
public class TrackerDataView implements Serializable
{

    @JsonProperty("attributes")
    private List<String> attributes;
    @JsonProperty("dataElements")
    private List<String> dataElements;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3105620455177611945L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerDataView() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerDataView(TrackerDataView source) {
        super();
        this.attributes = source.attributes;
        this.dataElements = source.dataElements;
    }

    public TrackerDataView(List<String> attributes, List<String> dataElements) {
        super();
        this.attributes = attributes;
        this.dataElements = dataElements;
    }

    @JsonProperty("attributes")
    public Optional<List<String>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public TrackerDataView withAttributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("dataElements")
    public Optional<List<String>> getDataElements() {
        return Optional.ofNullable(dataElements);
    }

    @JsonProperty("dataElements")
    public void setDataElements(List<String> dataElements) {
        this.dataElements = dataElements;
    }

    public TrackerDataView withDataElements(List<String> dataElements) {
        this.dataElements = dataElements;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerDataView withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributes".equals(name)) {
            if (value instanceof List) {
                setAttributes(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataElements".equals(name)) {
                if (value instanceof List) {
                    setDataElements(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElements\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributes".equals(name)) {
            return getAttributes();
        } else {
            if ("dataElements".equals(name)) {
                return getDataElements();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerDataView.NOT_FOUND_VALUE);
        if (TrackerDataView.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerDataView with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerDataView.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("dataElements");
        sb.append('=');
        sb.append(((this.dataElements == null)?"<null>":this.dataElements));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataElements == null)? 0 :this.dataElements.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerDataView) == false) {
            return false;
        }
        TrackerDataView rhs = ((TrackerDataView) other);
        return ((((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataElements == rhs.dataElements)||((this.dataElements!= null)&&this.dataElements.equals(rhs.dataElements))));
    }

}
