
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "skipIndexDeletion"
})
@Generated("jsonschema2pojo")
public class TrackerTrigramIndexJobParameters implements Serializable
{

    @JsonProperty("attributes")
    private List<String> attributes;
    @JsonProperty("skipIndexDeletion")
    private Boolean skipIndexDeletion;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2304486779878215846L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerTrigramIndexJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerTrigramIndexJobParameters(TrackerTrigramIndexJobParameters source) {
        super();
        this.attributes = source.attributes;
        this.skipIndexDeletion = source.skipIndexDeletion;
    }

    public TrackerTrigramIndexJobParameters(List<String> attributes, Boolean skipIndexDeletion) {
        super();
        this.attributes = attributes;
        this.skipIndexDeletion = skipIndexDeletion;
    }

    @JsonProperty("attributes")
    public Optional<List<String>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public TrackerTrigramIndexJobParameters withAttributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("skipIndexDeletion")
    public Optional<Boolean> getSkipIndexDeletion() {
        return Optional.ofNullable(skipIndexDeletion);
    }

    @JsonProperty("skipIndexDeletion")
    public void setSkipIndexDeletion(Boolean skipIndexDeletion) {
        this.skipIndexDeletion = skipIndexDeletion;
    }

    public TrackerTrigramIndexJobParameters withSkipIndexDeletion(Boolean skipIndexDeletion) {
        this.skipIndexDeletion = skipIndexDeletion;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerTrigramIndexJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributes".equals(name)) {
            if (value instanceof List) {
                setAttributes(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("skipIndexDeletion".equals(name)) {
                if (value instanceof Boolean) {
                    setSkipIndexDeletion(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipIndexDeletion\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributes".equals(name)) {
            return getAttributes();
        } else {
            if ("skipIndexDeletion".equals(name)) {
                return getSkipIndexDeletion();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerTrigramIndexJobParameters.NOT_FOUND_VALUE);
        if (TrackerTrigramIndexJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerTrigramIndexJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerTrigramIndexJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("skipIndexDeletion");
        sb.append('=');
        sb.append(((this.skipIndexDeletion == null)?"<null>":this.skipIndexDeletion));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.skipIndexDeletion == null)? 0 :this.skipIndexDeletion.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerTrigramIndexJobParameters) == false) {
            return false;
        }
        TrackerTrigramIndexJobParameters rhs = ((TrackerTrigramIndexJobParameters) other);
        return ((((this.skipIndexDeletion == rhs.skipIndexDeletion)||((this.skipIndexDeletion!= null)&&this.skipIndexDeletion.equals(rhs.skipIndexDeletion)))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
