
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "endDate",
    "notification",
    "ou",
    "persist",
    "startDate",
    "vrg"
})
@Generated("jsonschema2pojo")
public class ValidationRulesAnalysisParams implements Serializable
{

    @JsonProperty("endDate")
    private String endDate;
    @JsonProperty("notification")
    private Boolean notification;
    @JsonProperty("ou")
    private String ou;
    @JsonProperty("persist")
    private Boolean persist;
    @JsonProperty("startDate")
    private String startDate;
    @JsonProperty("vrg")
    private String vrg;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2008529442993778249L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValidationRulesAnalysisParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ValidationRulesAnalysisParams(ValidationRulesAnalysisParams source) {
        super();
        this.endDate = source.endDate;
        this.notification = source.notification;
        this.ou = source.ou;
        this.persist = source.persist;
        this.startDate = source.startDate;
        this.vrg = source.vrg;
    }

    public ValidationRulesAnalysisParams(String endDate, Boolean notification, String ou, Boolean persist, String startDate, String vrg) {
        super();
        this.endDate = endDate;
        this.notification = notification;
        this.ou = ou;
        this.persist = persist;
        this.startDate = startDate;
        this.vrg = vrg;
    }

    @JsonProperty("endDate")
    public Optional<String> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ValidationRulesAnalysisParams withEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("notification")
    public Optional<Boolean> getNotification() {
        return Optional.ofNullable(notification);
    }

    @JsonProperty("notification")
    public void setNotification(Boolean notification) {
        this.notification = notification;
    }

    public ValidationRulesAnalysisParams withNotification(Boolean notification) {
        this.notification = notification;
        return this;
    }

    @JsonProperty("ou")
    public Optional<String> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(String ou) {
        this.ou = ou;
    }

    public ValidationRulesAnalysisParams withOu(String ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("persist")
    public Optional<Boolean> getPersist() {
        return Optional.ofNullable(persist);
    }

    @JsonProperty("persist")
    public void setPersist(Boolean persist) {
        this.persist = persist;
    }

    public ValidationRulesAnalysisParams withPersist(Boolean persist) {
        this.persist = persist;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<String> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public ValidationRulesAnalysisParams withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("vrg")
    public Optional<String> getVrg() {
        return Optional.ofNullable(vrg);
    }

    @JsonProperty("vrg")
    public void setVrg(String vrg) {
        this.vrg = vrg;
    }

    public ValidationRulesAnalysisParams withVrg(String vrg) {
        this.vrg = vrg;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValidationRulesAnalysisParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("endDate".equals(name)) {
            if (value instanceof String) {
                setEndDate(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"endDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("notification".equals(name)) {
                if (value instanceof Boolean) {
                    setNotification(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"notification\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("ou".equals(name)) {
                    if (value instanceof String) {
                        setOu(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"ou\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("persist".equals(name)) {
                        if (value instanceof Boolean) {
                            setPersist(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"persist\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("startDate".equals(name)) {
                            if (value instanceof String) {
                                setStartDate(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"startDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("vrg".equals(name)) {
                                if (value instanceof String) {
                                    setVrg(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"vrg\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("endDate".equals(name)) {
            return getEndDate();
        } else {
            if ("notification".equals(name)) {
                return getNotification();
            } else {
                if ("ou".equals(name)) {
                    return getOu();
                } else {
                    if ("persist".equals(name)) {
                        return getPersist();
                    } else {
                        if ("startDate".equals(name)) {
                            return getStartDate();
                        } else {
                            if ("vrg".equals(name)) {
                                return getVrg();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValidationRulesAnalysisParams.NOT_FOUND_VALUE);
        if (ValidationRulesAnalysisParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValidationRulesAnalysisParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidationRulesAnalysisParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("notification");
        sb.append('=');
        sb.append(((this.notification == null)?"<null>":this.notification));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("persist");
        sb.append('=');
        sb.append(((this.persist == null)?"<null>":this.persist));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("vrg");
        sb.append('=');
        sb.append(((this.vrg == null)?"<null>":this.vrg));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.notification == null)? 0 :this.notification.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.vrg == null)? 0 :this.vrg.hashCode()));
        result = ((result* 31)+((this.persist == null)? 0 :this.persist.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValidationRulesAnalysisParams) == false) {
            return false;
        }
        ValidationRulesAnalysisParams rhs = ((ValidationRulesAnalysisParams) other);
        return ((((((((this.notification == rhs.notification)||((this.notification!= null)&&this.notification.equals(rhs.notification)))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.vrg == rhs.vrg)||((this.vrg!= null)&&this.vrg.equals(rhs.vrg))))&&((this.persist == rhs.persist)||((this.persist!= null)&&this.persist.equals(rhs.persist))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

}
