
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dimensions",
    "pager"
})
@Generated("jsonschema2pojo")
public class AnalyticsDimensionsPagingWrapper implements Serializable
{

    @JsonProperty("dimensions")
    private List<Object> dimensions;
    @JsonProperty("pager")
    private Pager pager;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8053054167857302443L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AnalyticsDimensionsPagingWrapper() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public AnalyticsDimensionsPagingWrapper(AnalyticsDimensionsPagingWrapper source) {
        super();
        this.dimensions = source.dimensions;
        this.pager = source.pager;
    }

    public AnalyticsDimensionsPagingWrapper(List<Object> dimensions, Pager pager) {
        super();
        this.dimensions = dimensions;
        this.pager = pager;
    }

    @JsonProperty("dimensions")
    public Optional<List<Object>> getDimensions() {
        return Optional.ofNullable(dimensions);
    }

    @JsonProperty("dimensions")
    public void setDimensions(List<Object> dimensions) {
        this.dimensions = dimensions;
    }

    public AnalyticsDimensionsPagingWrapper withDimensions(List<Object> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @JsonProperty("pager")
    public Optional<Pager> getPager() {
        return Optional.ofNullable(pager);
    }

    @JsonProperty("pager")
    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public AnalyticsDimensionsPagingWrapper withPager(Pager pager) {
        this.pager = pager;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AnalyticsDimensionsPagingWrapper withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dimensions".equals(name)) {
            if (value instanceof List) {
                setDimensions(((List<Object> ) value));
            } else {
                throw new IllegalArgumentException(("property \"dimensions\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("pager".equals(name)) {
                if (value instanceof Pager) {
                    setPager(((Pager) value));
                } else {
                    throw new IllegalArgumentException(("property \"pager\" is of type \"org.hisp.dhis.api.model.v2_39_1.Pager\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dimensions".equals(name)) {
            return getDimensions();
        } else {
            if ("pager".equals(name)) {
                return getPager();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AnalyticsDimensionsPagingWrapper.NOT_FOUND_VALUE);
        if (AnalyticsDimensionsPagingWrapper.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AnalyticsDimensionsPagingWrapper with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AnalyticsDimensionsPagingWrapper.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dimensions");
        sb.append('=');
        sb.append(((this.dimensions == null)?"<null>":this.dimensions));
        sb.append(',');
        sb.append("pager");
        sb.append('=');
        sb.append(((this.pager == null)?"<null>":this.pager));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.pager == null)? 0 :this.pager.hashCode()));
        result = ((result* 31)+((this.dimensions == null)? 0 :this.dimensions.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AnalyticsDimensionsPagingWrapper) == false) {
            return false;
        }
        AnalyticsDimensionsPagingWrapper rhs = ((AnalyticsDimensionsPagingWrapper) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.pager == rhs.pager)||((this.pager!= null)&&this.pager.equals(rhs.pager))))&&((this.dimensions == rhs.dimensions)||((this.dimensions!= null)&&this.dimensions.equals(rhs.dimensions))));
    }

}
