
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "category",
    "categoryOptions"
})
@Generated("jsonschema2pojo")
public class CategoryDimension implements Serializable
{

    @JsonProperty("category")
    private Category category;
    @JsonProperty("categoryOptions")
    private List<CategoryOption> categoryOptions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4682260570306076128L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CategoryDimension() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CategoryDimension(CategoryDimension source) {
        super();
        this.category = source.category;
        this.categoryOptions = source.categoryOptions;
    }

    public CategoryDimension(Category category, List<CategoryOption> categoryOptions) {
        super();
        this.category = category;
        this.categoryOptions = categoryOptions;
    }

    @JsonProperty("category")
    public Optional<Category> getCategory() {
        return Optional.ofNullable(category);
    }

    @JsonProperty("category")
    public void setCategory(Category category) {
        this.category = category;
    }

    public CategoryDimension withCategory(Category category) {
        this.category = category;
        return this;
    }

    @JsonProperty("categoryOptions")
    public Optional<List<CategoryOption>> getCategoryOptions() {
        return Optional.ofNullable(categoryOptions);
    }

    @JsonProperty("categoryOptions")
    public void setCategoryOptions(List<CategoryOption> categoryOptions) {
        this.categoryOptions = categoryOptions;
    }

    public CategoryDimension withCategoryOptions(List<CategoryOption> categoryOptions) {
        this.categoryOptions = categoryOptions;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CategoryDimension withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("category".equals(name)) {
            if (value instanceof Category) {
                setCategory(((Category) value));
            } else {
                throw new IllegalArgumentException(("property \"category\" is of type \"org.hisp.dhis.api.model.v2_39_1.Category\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("categoryOptions".equals(name)) {
                if (value instanceof List) {
                    setCategoryOptions(((List<CategoryOption> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CategoryOption>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("category".equals(name)) {
            return getCategory();
        } else {
            if ("categoryOptions".equals(name)) {
                return getCategoryOptions();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CategoryDimension.NOT_FOUND_VALUE);
        if (CategoryDimension.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CategoryDimension with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CategoryDimension.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("category");
        sb.append('=');
        sb.append(((this.category == null)?"<null>":this.category));
        sb.append(',');
        sb.append("categoryOptions");
        sb.append('=');
        sb.append(((this.categoryOptions == null)?"<null>":this.categoryOptions));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.categoryOptions == null)? 0 :this.categoryOptions.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.category == null)? 0 :this.category.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CategoryDimension) == false) {
            return false;
        }
        CategoryDimension rhs = ((CategoryDimension) other);
        return ((((this.categoryOptions == rhs.categoryOptions)||((this.categoryOptions!= null)&&this.categoryOptions.equals(rhs.categoryOptions)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.category == rhs.category)||((this.category!= null)&&this.category.equals(rhs.category))));
    }

}
