
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionCombo",
    "auditType",
    "categoryOptionCombo",
    "created",
    "dataElement",
    "modifiedBy",
    "organisationUnit",
    "period",
    "value"
})
@Generated("jsonschema2pojo")
public class DataValueAudit implements Serializable
{

    @JsonProperty("attributeOptionCombo")
    private CategoryOptionCombo attributeOptionCombo;
    @JsonProperty("auditType")
    private AuditType auditType;
    @JsonProperty("categoryOptionCombo")
    private CategoryOptionCombo categoryOptionCombo;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("modifiedBy")
    private String modifiedBy;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("period")
    private Period period;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6382025118014911526L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueAudit() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataValueAudit(DataValueAudit source) {
        super();
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.auditType = source.auditType;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.created = source.created;
        this.dataElement = source.dataElement;
        this.modifiedBy = source.modifiedBy;
        this.organisationUnit = source.organisationUnit;
        this.period = source.period;
        this.value = source.value;
    }

    public DataValueAudit(CategoryOptionCombo attributeOptionCombo, AuditType auditType, CategoryOptionCombo categoryOptionCombo, Date created, DataElement dataElement, String modifiedBy, OrganisationUnit organisationUnit, Period period, String value) {
        super();
        this.attributeOptionCombo = attributeOptionCombo;
        this.auditType = auditType;
        this.categoryOptionCombo = categoryOptionCombo;
        this.created = created;
        this.dataElement = dataElement;
        this.modifiedBy = modifiedBy;
        this.organisationUnit = organisationUnit;
        this.period = period;
        this.value = value;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<CategoryOptionCombo> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataValueAudit withAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("auditType")
    public Optional<AuditType> getAuditType() {
        return Optional.ofNullable(auditType);
    }

    @JsonProperty("auditType")
    public void setAuditType(AuditType auditType) {
        this.auditType = auditType;
    }

    public DataValueAudit withAuditType(AuditType auditType) {
        this.auditType = auditType;
        return this;
    }

    @JsonProperty("categoryOptionCombo")
    public Optional<CategoryOptionCombo> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(CategoryOptionCombo categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValueAudit withCategoryOptionCombo(CategoryOptionCombo categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataValueAudit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public DataValueAudit withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("modifiedBy")
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    @JsonProperty("modifiedBy")
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public DataValueAudit withModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public DataValueAudit withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<Period> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(Period period) {
        this.period = period;
    }

    public DataValueAudit withPeriod(Period period) {
        this.period = period;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public DataValueAudit withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueAudit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributeOptionCombo".equals(name)) {
            if (value instanceof CategoryOptionCombo) {
                setAttributeOptionCombo(((CategoryOptionCombo) value));
            } else {
                throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"org.hisp.dhis.api.model.v2_39_1.CategoryOptionCombo\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("auditType".equals(name)) {
                if (value instanceof AuditType) {
                    setAuditType(((AuditType) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditType\" is of type \"org.hisp.dhis.api.model.v2_39_1.AuditType\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("categoryOptionCombo".equals(name)) {
                    if (value instanceof CategoryOptionCombo) {
                        setCategoryOptionCombo(((CategoryOptionCombo) value));
                    } else {
                        throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"org.hisp.dhis.api.model.v2_39_1.CategoryOptionCombo\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("dataElement".equals(name)) {
                            if (value instanceof DataElement) {
                                setDataElement(((DataElement) value));
                            } else {
                                throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_39_1.DataElement\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("modifiedBy".equals(name)) {
                                if (value instanceof String) {
                                    setModifiedBy(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"modifiedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("organisationUnit".equals(name)) {
                                    if (value instanceof OrganisationUnit) {
                                        setOrganisationUnit(((OrganisationUnit) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_39_1.OrganisationUnit\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("period".equals(name)) {
                                        if (value instanceof Period) {
                                            setPeriod(((Period) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_39_1.Period\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("value".equals(name)) {
                                            if (value instanceof String) {
                                                setValue(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributeOptionCombo".equals(name)) {
            return getAttributeOptionCombo();
        } else {
            if ("auditType".equals(name)) {
                return getAuditType();
            } else {
                if ("categoryOptionCombo".equals(name)) {
                    return getCategoryOptionCombo();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("dataElement".equals(name)) {
                            return getDataElement();
                        } else {
                            if ("modifiedBy".equals(name)) {
                                return getModifiedBy();
                            } else {
                                if ("organisationUnit".equals(name)) {
                                    return getOrganisationUnit();
                                } else {
                                    if ("period".equals(name)) {
                                        return getPeriod();
                                    } else {
                                        if ("value".equals(name)) {
                                            return getValue();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueAudit.NOT_FOUND_VALUE);
        if (DataValueAudit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueAudit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueAudit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("auditType");
        sb.append('=');
        sb.append(((this.auditType == null)?"<null>":this.auditType));
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("modifiedBy");
        sb.append('=');
        sb.append(((this.modifiedBy == null)?"<null>":this.modifiedBy));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.modifiedBy == null)? 0 :this.modifiedBy.hashCode()));
        result = ((result* 31)+((this.auditType == null)? 0 :this.auditType.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueAudit) == false) {
            return false;
        }
        DataValueAudit rhs = ((DataValueAudit) other);
        return (((((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.modifiedBy == rhs.modifiedBy)||((this.modifiedBy!= null)&&this.modifiedBy.equals(rhs.modifiedBy))))&&((this.auditType == rhs.auditType)||((this.auditType!= null)&&this.auditType.equals(rhs.auditType))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

}
