
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "conflicts",
    "importCount",
    "status",
    "totalConflictOccurrenceCount"
})
@Generated("jsonschema2pojo")
public class GeoJsonImportReport implements Serializable
{

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    private List<Object> conflicts;
    @JsonProperty("importCount")
    private ImportCount importCount;
    @JsonProperty("status")
    private GeoJsonImportReport.ImportStatus status;
    @JsonProperty("totalConflictOccurrenceCount")
    private Integer totalConflictOccurrenceCount;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 252279847900027919L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GeoJsonImportReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public GeoJsonImportReport(GeoJsonImportReport source) {
        super();
        this.conflicts = source.conflicts;
        this.importCount = source.importCount;
        this.status = source.status;
        this.totalConflictOccurrenceCount = source.totalConflictOccurrenceCount;
    }

    public GeoJsonImportReport(List<Object> conflicts, ImportCount importCount, GeoJsonImportReport.ImportStatus status, Integer totalConflictOccurrenceCount) {
        super();
        this.conflicts = conflicts;
        this.importCount = importCount;
        this.status = status;
        this.totalConflictOccurrenceCount = totalConflictOccurrenceCount;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    public Optional<List<Object>> getConflicts() {
        return Optional.ofNullable(conflicts);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    public void setConflicts(List<Object> conflicts) {
        this.conflicts = conflicts;
    }

    public GeoJsonImportReport withConflicts(List<Object> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    @JsonProperty("importCount")
    public Optional<ImportCount> getImportCount() {
        return Optional.ofNullable(importCount);
    }

    @JsonProperty("importCount")
    public void setImportCount(ImportCount importCount) {
        this.importCount = importCount;
    }

    public GeoJsonImportReport withImportCount(ImportCount importCount) {
        this.importCount = importCount;
        return this;
    }

    @JsonProperty("status")
    public Optional<GeoJsonImportReport.ImportStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(GeoJsonImportReport.ImportStatus status) {
        this.status = status;
    }

    public GeoJsonImportReport withStatus(GeoJsonImportReport.ImportStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("totalConflictOccurrenceCount")
    public Optional<Integer> getTotalConflictOccurrenceCount() {
        return Optional.ofNullable(totalConflictOccurrenceCount);
    }

    @JsonProperty("totalConflictOccurrenceCount")
    public void setTotalConflictOccurrenceCount(Integer totalConflictOccurrenceCount) {
        this.totalConflictOccurrenceCount = totalConflictOccurrenceCount;
    }

    public GeoJsonImportReport withTotalConflictOccurrenceCount(Integer totalConflictOccurrenceCount) {
        this.totalConflictOccurrenceCount = totalConflictOccurrenceCount;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GeoJsonImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("conflicts".equals(name)) {
            if (value instanceof List) {
                setConflicts(((List<Object> ) value));
            } else {
                throw new IllegalArgumentException(("property \"conflicts\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("importCount".equals(name)) {
                if (value instanceof ImportCount) {
                    setImportCount(((ImportCount) value));
                } else {
                    throw new IllegalArgumentException(("property \"importCount\" is of type \"org.hisp.dhis.api.model.v2_39_1.ImportCount\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("status".equals(name)) {
                    if (value instanceof GeoJsonImportReport.ImportStatus) {
                        setStatus(((GeoJsonImportReport.ImportStatus) value));
                    } else {
                        throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("totalConflictOccurrenceCount".equals(name)) {
                        if (value instanceof Integer) {
                            setTotalConflictOccurrenceCount(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"totalConflictOccurrenceCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("conflicts".equals(name)) {
            return getConflicts();
        } else {
            if ("importCount".equals(name)) {
                return getImportCount();
            } else {
                if ("status".equals(name)) {
                    return getStatus();
                } else {
                    if ("totalConflictOccurrenceCount".equals(name)) {
                        return getTotalConflictOccurrenceCount();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GeoJsonImportReport.NOT_FOUND_VALUE);
        if (GeoJsonImportReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GeoJsonImportReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeoJsonImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("conflicts");
        sb.append('=');
        sb.append(((this.conflicts == null)?"<null>":this.conflicts));
        sb.append(',');
        sb.append("importCount");
        sb.append('=');
        sb.append(((this.importCount == null)?"<null>":this.importCount));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("totalConflictOccurrenceCount");
        sb.append('=');
        sb.append(((this.totalConflictOccurrenceCount == null)?"<null>":this.totalConflictOccurrenceCount));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.importCount == null)? 0 :this.importCount.hashCode()));
        result = ((result* 31)+((this.conflicts == null)? 0 :this.conflicts.hashCode()));
        result = ((result* 31)+((this.totalConflictOccurrenceCount == null)? 0 :this.totalConflictOccurrenceCount.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GeoJsonImportReport) == false) {
            return false;
        }
        GeoJsonImportReport rhs = ((GeoJsonImportReport) other);
        return ((((((this.importCount == rhs.importCount)||((this.importCount!= null)&&this.importCount.equals(rhs.importCount)))&&((this.conflicts == rhs.conflicts)||((this.conflicts!= null)&&this.conflicts.equals(rhs.conflicts))))&&((this.totalConflictOccurrenceCount == rhs.totalConflictOccurrenceCount)||((this.totalConflictOccurrenceCount!= null)&&this.totalConflictOccurrenceCount.equals(rhs.totalConflictOccurrenceCount))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum ImportStatus {

        SUCCESS("SUCCESS"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, GeoJsonImportReport.ImportStatus> CONSTANTS = new HashMap<String, GeoJsonImportReport.ImportStatus>();

        static {
            for (GeoJsonImportReport.ImportStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GeoJsonImportReport.ImportStatus fromValue(String value) {
            GeoJsonImportReport.ImportStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
