
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeValues",
    "code",
    "color",
    "created",
    "createdBy",
    "description",
    "dimensionItem",
    "dimensionItemType",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "featureType",
    "formName",
    "geometry",
    "groupSets",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "name",
    "organisationUnits",
    "publicAccess",
    "queryMods",
    "sharing",
    "shortName",
    "symbol",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class OrganisationUnitGroup implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("color")
    private String color;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType dimensionItemType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("featureType")
    private org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType featureType;
    @JsonProperty("formName")
    private String formName;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    @JsonProperty("groupSets")
    private List<OrganisationUnitGroupSet> groupSets;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets;
    @JsonProperty("name")
    private String name;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("queryMods")
    private QueryModifiers queryMods;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("symbol")
    private String symbol;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6479670349236733515L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrganisationUnitGroup() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OrganisationUnitGroup(OrganisationUnitGroup source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.color = source.color;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.dimensionItemType = source.dimensionItemType;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.featureType = source.featureType;
        this.formName = source.formName;
        this.geometry = source.geometry;
        this.groupSets = source.groupSets;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.name = source.name;
        this.organisationUnits = source.organisationUnits;
        this.publicAccess = source.publicAccess;
        this.queryMods = source.queryMods;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.symbol = source.symbol;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public OrganisationUnitGroup(Access access, org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType, List<AttributeValue> attributeValues, String code, String color, Date created, User createdBy, String description, String dimensionItem, org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType dimensionItemType, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType featureType, String formName, Object geometry, List<OrganisationUnitGroupSet> groupSets, String href, String id, Date lastUpdated, User lastUpdatedBy, LegendSet legendSet, List<LegendSet> legendSets, String name, List<OrganisationUnit> organisationUnits, String publicAccess, QueryModifiers queryMods, Sharing sharing, String shortName, String symbol, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeValues = attributeValues;
        this.code = code;
        this.color = color;
        this.created = created;
        this.createdBy = createdBy;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.dimensionItemType = dimensionItemType;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.featureType = featureType;
        this.formName = formName;
        this.geometry = geometry;
        this.groupSets = groupSets;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.name = name;
        this.organisationUnits = organisationUnits;
        this.publicAccess = publicAccess;
        this.queryMods = queryMods;
        this.sharing = sharing;
        this.shortName = shortName;
        this.symbol = symbol;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public OrganisationUnitGroup withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<org.hisp.dhis.api.model.v2_39_1.Category.AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public OrganisationUnitGroup withAggregationType(org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public OrganisationUnitGroup withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public OrganisationUnitGroup withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("color")
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    @JsonProperty("color")
    public void setColor(String color) {
        this.color = color;
    }

    public OrganisationUnitGroup withColor(String color) {
        this.color = color;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public OrganisationUnitGroup withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public OrganisationUnitGroup withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public OrganisationUnitGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public OrganisationUnitGroup withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public OrganisationUnitGroup withDimensionItemType(org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public OrganisationUnitGroup withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public OrganisationUnitGroup withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public OrganisationUnitGroup withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public OrganisationUnitGroup withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public OrganisationUnitGroup withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public OrganisationUnitGroup withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public OrganisationUnitGroup withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("featureType")
    public Optional<org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType> getFeatureType() {
        return Optional.ofNullable(featureType);
    }

    @JsonProperty("featureType")
    public void setFeatureType(org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
    }

    public OrganisationUnitGroup withFeatureType(org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public OrganisationUnitGroup withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public OrganisationUnitGroup withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("groupSets")
    public Optional<List<OrganisationUnitGroupSet>> getGroupSets() {
        return Optional.ofNullable(groupSets);
    }

    @JsonProperty("groupSets")
    public void setGroupSets(List<OrganisationUnitGroupSet> groupSets) {
        this.groupSets = groupSets;
    }

    public OrganisationUnitGroup withGroupSets(List<OrganisationUnitGroupSet> groupSets) {
        this.groupSets = groupSets;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public OrganisationUnitGroup withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public OrganisationUnitGroup withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public OrganisationUnitGroup withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public OrganisationUnitGroup withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public OrganisationUnitGroup withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public OrganisationUnitGroup withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public OrganisationUnitGroup withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public OrganisationUnitGroup withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public OrganisationUnitGroup withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("queryMods")
    public Optional<QueryModifiers> getQueryMods() {
        return Optional.ofNullable(queryMods);
    }

    @JsonProperty("queryMods")
    public void setQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
    }

    public OrganisationUnitGroup withQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public OrganisationUnitGroup withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public OrganisationUnitGroup withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("symbol")
    public Optional<String> getSymbol() {
        return Optional.ofNullable(symbol);
    }

    @JsonProperty("symbol")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public OrganisationUnitGroup withSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public OrganisationUnitGroup withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public OrganisationUnitGroup withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public OrganisationUnitGroup withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public OrganisationUnitGroup withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrganisationUnitGroup withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_39_1.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationType".equals(name)) {
                if (value instanceof org.hisp.dhis.api.model.v2_39_1.Category.AggregationType) {
                    setAggregationType(((org.hisp.dhis.api.model.v2_39_1.Category.AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_39_1.Category.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("color".equals(name)) {
                            if (value instanceof String) {
                                setColor(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"color\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("created".equals(name)) {
                                if (value instanceof Date) {
                                    setCreated(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdBy".equals(name)) {
                                    if (value instanceof User) {
                                        setCreatedBy(((User) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("description".equals(name)) {
                                        if (value instanceof String) {
                                            setDescription(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dimensionItem".equals(name)) {
                                            if (value instanceof String) {
                                                setDimensionItem(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("dimensionItemType".equals(name)) {
                                                if (value instanceof org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType) {
                                                    setDimensionItemType(((org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_39_1.CategoryOption.DimensionItemType\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayDescription".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayDescription(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("displayFormName".equals(name)) {
                                                        if (value instanceof String) {
                                                            setDisplayFormName(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("displayName".equals(name)) {
                                                            if (value instanceof String) {
                                                                setDisplayName(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("displayShortName".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDisplayShortName(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("externalAccess".equals(name)) {
                                                                    if (value instanceof Boolean) {
                                                                        setExternalAccess(((Boolean) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("favorite".equals(name)) {
                                                                        if (value instanceof Boolean) {
                                                                            setFavorite(((Boolean) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("favorites".equals(name)) {
                                                                            if (value instanceof List) {
                                                                                setFavorites(((List<String> ) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("featureType".equals(name)) {
                                                                                if (value instanceof org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType) {
                                                                                    setFeatureType(((org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v2_39_1.ProgramStage.FeatureType\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("formName".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setFormName(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("geometry".equals(name)) {
                                                                                        if (value instanceof Object) {
                                                                                            setGeometry(((Object) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("groupSets".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setGroupSets(((List<OrganisationUnitGroupSet> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"groupSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnitGroupSet>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("href".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setHref(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("id".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setId(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("lastUpdated".equals(name)) {
                                                                                                        if (value instanceof Date) {
                                                                                                            setLastUpdated(((Date) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                                            if (value instanceof User) {
                                                                                                                setLastUpdatedBy(((User) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                if (value instanceof LegendSet) {
                                                                                                                    setLegendSet(((LegendSet) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_39_1.LegendSet\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("legendSets".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setLegendSets(((List<LegendSet> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.LegendSet>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("name".equals(name)) {
                                                                                                                        if (value instanceof String) {
                                                                                                                            setName(((String) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("organisationUnits".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setOrganisationUnits(((List<OrganisationUnit> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setPublicAccess(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("queryMods".equals(name)) {
                                                                                                                                    if (value instanceof QueryModifiers) {
                                                                                                                                        setQueryMods(((QueryModifiers) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"queryMods\" is of type \"org.hisp.dhis.api.model.v2_39_1.QueryModifiers\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                        if (value instanceof Sharing) {
                                                                                                                                            setSharing(((Sharing) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_39_1.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                            if (value instanceof String) {
                                                                                                                                                setShortName(((String) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("symbol".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setSymbol(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"symbol\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("translations".equals(name)) {
                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                        setTranslations(((List<Translation> ) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("user".equals(name)) {
                                                                                                                                                        if (value instanceof User) {
                                                                                                                                                            setUser(((User) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationType".equals(name)) {
                return getAggregationType();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("color".equals(name)) {
                            return getColor();
                        } else {
                            if ("created".equals(name)) {
                                return getCreated();
                            } else {
                                if ("createdBy".equals(name)) {
                                    return getCreatedBy();
                                } else {
                                    if ("description".equals(name)) {
                                        return getDescription();
                                    } else {
                                        if ("dimensionItem".equals(name)) {
                                            return getDimensionItem();
                                        } else {
                                            if ("dimensionItemType".equals(name)) {
                                                return getDimensionItemType();
                                            } else {
                                                if ("displayDescription".equals(name)) {
                                                    return getDisplayDescription();
                                                } else {
                                                    if ("displayFormName".equals(name)) {
                                                        return getDisplayFormName();
                                                    } else {
                                                        if ("displayName".equals(name)) {
                                                            return getDisplayName();
                                                        } else {
                                                            if ("displayShortName".equals(name)) {
                                                                return getDisplayShortName();
                                                            } else {
                                                                if ("externalAccess".equals(name)) {
                                                                    return getExternalAccess();
                                                                } else {
                                                                    if ("favorite".equals(name)) {
                                                                        return getFavorite();
                                                                    } else {
                                                                        if ("favorites".equals(name)) {
                                                                            return getFavorites();
                                                                        } else {
                                                                            if ("featureType".equals(name)) {
                                                                                return getFeatureType();
                                                                            } else {
                                                                                if ("formName".equals(name)) {
                                                                                    return getFormName();
                                                                                } else {
                                                                                    if ("geometry".equals(name)) {
                                                                                        return getGeometry();
                                                                                    } else {
                                                                                        if ("groupSets".equals(name)) {
                                                                                            return getGroupSets();
                                                                                        } else {
                                                                                            if ("href".equals(name)) {
                                                                                                return getHref();
                                                                                            } else {
                                                                                                if ("id".equals(name)) {
                                                                                                    return getId();
                                                                                                } else {
                                                                                                    if ("lastUpdated".equals(name)) {
                                                                                                        return getLastUpdated();
                                                                                                    } else {
                                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                                            return getLastUpdatedBy();
                                                                                                        } else {
                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                return getLegendSet();
                                                                                                            } else {
                                                                                                                if ("legendSets".equals(name)) {
                                                                                                                    return getLegendSets();
                                                                                                                } else {
                                                                                                                    if ("name".equals(name)) {
                                                                                                                        return getName();
                                                                                                                    } else {
                                                                                                                        if ("organisationUnits".equals(name)) {
                                                                                                                            return getOrganisationUnits();
                                                                                                                        } else {
                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                return getPublicAccess();
                                                                                                                            } else {
                                                                                                                                if ("queryMods".equals(name)) {
                                                                                                                                    return getQueryMods();
                                                                                                                                } else {
                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                        return getSharing();
                                                                                                                                    } else {
                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                            return getShortName();
                                                                                                                                        } else {
                                                                                                                                            if ("symbol".equals(name)) {
                                                                                                                                                return getSymbol();
                                                                                                                                            } else {
                                                                                                                                                if ("translations".equals(name)) {
                                                                                                                                                    return getTranslations();
                                                                                                                                                } else {
                                                                                                                                                    if ("user".equals(name)) {
                                                                                                                                                        return getUser();
                                                                                                                                                    } else {
                                                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                                                            return getUserAccesses();
                                                                                                                                                        } else {
                                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                return getUserGroupAccesses();
                                                                                                                                                            } else {
                                                                                                                                                                return notFoundValue;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrganisationUnitGroup.NOT_FOUND_VALUE);
        if (OrganisationUnitGroup.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrganisationUnitGroup with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrganisationUnitGroup.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("color");
        sb.append('=');
        sb.append(((this.color == null)?"<null>":this.color));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("groupSets");
        sb.append('=');
        sb.append(((this.groupSets == null)?"<null>":this.groupSets));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("queryMods");
        sb.append('=');
        sb.append(((this.queryMods == null)?"<null>":this.queryMods));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("symbol");
        sb.append('=');
        sb.append(((this.symbol == null)?"<null>":this.symbol));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.symbol == null)? 0 :this.symbol.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.color == null)? 0 :this.color.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.queryMods == null)? 0 :this.queryMods.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.groupSets == null)? 0 :this.groupSets.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrganisationUnitGroup) == false) {
            return false;
        }
        OrganisationUnitGroup rhs = ((OrganisationUnitGroup) other);
        return ((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.symbol == rhs.symbol)||((this.symbol!= null)&&this.symbol.equals(rhs.symbol))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.color == rhs.color)||((this.color!= null)&&this.color.equals(rhs.color))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.queryMods == rhs.queryMods)||((this.queryMods!= null)&&this.queryMods.equals(rhs.queryMods))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.groupSets == rhs.groupSets)||((this.groupSets!= null)&&this.groupSets.equals(rhs.groupSets))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))));
    }

}
