
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "completedBy",
    "created",
    "createdAtClient",
    "createdBy",
    "createdByUserInfo",
    "deleted",
    "displayName",
    "endDate",
    "enrollmentDate",
    "externalAccess",
    "favorite",
    "favorites",
    "followup",
    "geometry",
    "href",
    "id",
    "incidentDate",
    "lastUpdated",
    "lastUpdatedAtClient",
    "lastUpdatedBy",
    "lastUpdatedByUserInfo",
    "messageConversations",
    "name",
    "organisationUnit",
    "program",
    "programStageInstances",
    "publicAccess",
    "relationshipItems",
    "sharing",
    "status",
    "storedBy",
    "trackedEntityComments",
    "trackedEntityInstance",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramInstance implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdAtClient")
    private Date createdAtClient;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("createdByUserInfo")
    private UserInfoSnapshot createdByUserInfo;
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("enrollmentDate")
    private Date enrollmentDate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("followup")
    private Boolean followup;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("incidentDate")
    private Date incidentDate;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedAtClient")
    private Date lastUpdatedAtClient;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("lastUpdatedByUserInfo")
    private UserInfoSnapshot lastUpdatedByUserInfo;
    @JsonProperty("messageConversations")
    private List<MessageConversation> messageConversations;
    @JsonProperty("name")
    private String name;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("programStageInstances")
    private List<ProgramStageInstance> programStageInstances;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("relationshipItems")
    private List<RelationshipItem__2> relationshipItems;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus status;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("trackedEntityComments")
    private List<TrackedEntityComment> trackedEntityComments;
    @JsonProperty("trackedEntityInstance")
    private TrackedEntityInstance__1 trackedEntityInstance;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 350674846798796774L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramInstance() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramInstance(ProgramInstance source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.completedBy = source.completedBy;
        this.created = source.created;
        this.createdAtClient = source.createdAtClient;
        this.createdBy = source.createdBy;
        this.createdByUserInfo = source.createdByUserInfo;
        this.deleted = source.deleted;
        this.displayName = source.displayName;
        this.endDate = source.endDate;
        this.enrollmentDate = source.enrollmentDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.followup = source.followup;
        this.geometry = source.geometry;
        this.href = source.href;
        this.id = source.id;
        this.incidentDate = source.incidentDate;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedAtClient = source.lastUpdatedAtClient;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.lastUpdatedByUserInfo = source.lastUpdatedByUserInfo;
        this.messageConversations = source.messageConversations;
        this.name = source.name;
        this.organisationUnit = source.organisationUnit;
        this.program = source.program;
        this.programStageInstances = source.programStageInstances;
        this.publicAccess = source.publicAccess;
        this.relationshipItems = source.relationshipItems;
        this.sharing = source.sharing;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.trackedEntityComments = source.trackedEntityComments;
        this.trackedEntityInstance = source.trackedEntityInstance;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public ProgramInstance(Access access, List<AttributeValue> attributeValues, String code, String completedBy, Date created, Date createdAtClient, User createdBy, UserInfoSnapshot createdByUserInfo, Boolean deleted, String displayName, Date endDate, Date enrollmentDate, Boolean externalAccess, Boolean favorite, List<String> favorites, Boolean followup, Object geometry, String href, String id, Date incidentDate, Date lastUpdated, Date lastUpdatedAtClient, User lastUpdatedBy, UserInfoSnapshot lastUpdatedByUserInfo, List<MessageConversation> messageConversations, String name, OrganisationUnit organisationUnit, Program program, List<ProgramStageInstance> programStageInstances, String publicAccess, List<RelationshipItem__2> relationshipItems, Sharing sharing, org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus status, String storedBy, List<TrackedEntityComment> trackedEntityComments, TrackedEntityInstance__1 trackedEntityInstance, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.completedBy = completedBy;
        this.created = created;
        this.createdAtClient = createdAtClient;
        this.createdBy = createdBy;
        this.createdByUserInfo = createdByUserInfo;
        this.deleted = deleted;
        this.displayName = displayName;
        this.endDate = endDate;
        this.enrollmentDate = enrollmentDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.followup = followup;
        this.geometry = geometry;
        this.href = href;
        this.id = id;
        this.incidentDate = incidentDate;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        this.lastUpdatedBy = lastUpdatedBy;
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        this.messageConversations = messageConversations;
        this.name = name;
        this.organisationUnit = organisationUnit;
        this.program = program;
        this.programStageInstances = programStageInstances;
        this.publicAccess = publicAccess;
        this.relationshipItems = relationshipItems;
        this.sharing = sharing;
        this.status = status;
        this.storedBy = storedBy;
        this.trackedEntityComments = trackedEntityComments;
        this.trackedEntityInstance = trackedEntityInstance;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramInstance withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramInstance withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramInstance withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public ProgramInstance withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramInstance withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdAtClient")
    public Optional<Date> getCreatedAtClient() {
        return Optional.ofNullable(createdAtClient);
    }

    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(Date createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public ProgramInstance withCreatedAtClient(Date createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramInstance withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("createdByUserInfo")
    public Optional<UserInfoSnapshot> getCreatedByUserInfo() {
        return Optional.ofNullable(createdByUserInfo);
    }

    @JsonProperty("createdByUserInfo")
    public void setCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
    }

    public ProgramInstance withCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public ProgramInstance withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramInstance withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public ProgramInstance withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("enrollmentDate")
    public Optional<Date> getEnrollmentDate() {
        return Optional.ofNullable(enrollmentDate);
    }

    @JsonProperty("enrollmentDate")
    public void setEnrollmentDate(Date enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
    }

    public ProgramInstance withEnrollmentDate(Date enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramInstance withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramInstance withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramInstance withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(followup);
    }

    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public ProgramInstance withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public ProgramInstance withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramInstance withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramInstance withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("incidentDate")
    public Optional<Date> getIncidentDate() {
        return Optional.ofNullable(incidentDate);
    }

    @JsonProperty("incidentDate")
    public void setIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
    }

    public ProgramInstance withIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramInstance withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedAtClient")
    public Optional<Date> getLastUpdatedAtClient() {
        return Optional.ofNullable(lastUpdatedAtClient);
    }

    @JsonProperty("lastUpdatedAtClient")
    public void setLastUpdatedAtClient(Date lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
    }

    public ProgramInstance withLastUpdatedAtClient(Date lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramInstance withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public Optional<UserInfoSnapshot> getLastUpdatedByUserInfo() {
        return Optional.ofNullable(lastUpdatedByUserInfo);
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public void setLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
    }

    public ProgramInstance withLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        return this;
    }

    @JsonProperty("messageConversations")
    public Optional<List<MessageConversation>> getMessageConversations() {
        return Optional.ofNullable(messageConversations);
    }

    @JsonProperty("messageConversations")
    public void setMessageConversations(List<MessageConversation> messageConversations) {
        this.messageConversations = messageConversations;
    }

    public ProgramInstance withMessageConversations(List<MessageConversation> messageConversations) {
        this.messageConversations = messageConversations;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramInstance withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public ProgramInstance withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public ProgramInstance withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStageInstances")
    public Optional<List<ProgramStageInstance>> getProgramStageInstances() {
        return Optional.ofNullable(programStageInstances);
    }

    @JsonProperty("programStageInstances")
    public void setProgramStageInstances(List<ProgramStageInstance> programStageInstances) {
        this.programStageInstances = programStageInstances;
    }

    public ProgramInstance withProgramStageInstances(List<ProgramStageInstance> programStageInstances) {
        this.programStageInstances = programStageInstances;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramInstance withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("relationshipItems")
    public Optional<List<RelationshipItem__2>> getRelationshipItems() {
        return Optional.ofNullable(relationshipItems);
    }

    @JsonProperty("relationshipItems")
    public void setRelationshipItems(List<RelationshipItem__2> relationshipItems) {
        this.relationshipItems = relationshipItems;
    }

    public ProgramInstance withRelationshipItems(List<RelationshipItem__2> relationshipItems) {
        this.relationshipItems = relationshipItems;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramInstance withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus status) {
        this.status = status;
    }

    public ProgramInstance withStatus(org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public ProgramInstance withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("trackedEntityComments")
    public Optional<List<TrackedEntityComment>> getTrackedEntityComments() {
        return Optional.ofNullable(trackedEntityComments);
    }

    @JsonProperty("trackedEntityComments")
    public void setTrackedEntityComments(List<TrackedEntityComment> trackedEntityComments) {
        this.trackedEntityComments = trackedEntityComments;
    }

    public ProgramInstance withTrackedEntityComments(List<TrackedEntityComment> trackedEntityComments) {
        this.trackedEntityComments = trackedEntityComments;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstance__1> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public ProgramInstance withTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramInstance withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ProgramInstance withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramInstance withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramInstance withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramInstance withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_39_1.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("completedBy".equals(name)) {
                        if (value instanceof String) {
                            setCompletedBy(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdAtClient".equals(name)) {
                                if (value instanceof Date) {
                                    setCreatedAtClient(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdBy".equals(name)) {
                                    if (value instanceof User) {
                                        setCreatedBy(((User) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("createdByUserInfo".equals(name)) {
                                        if (value instanceof UserInfoSnapshot) {
                                            setCreatedByUserInfo(((UserInfoSnapshot) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"createdByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_39_1.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("deleted".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setDeleted(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("displayName".equals(name)) {
                                                if (value instanceof String) {
                                                    setDisplayName(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("endDate".equals(name)) {
                                                    if (value instanceof Date) {
                                                        setEndDate(((Date) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("enrollmentDate".equals(name)) {
                                                        if (value instanceof Date) {
                                                            setEnrollmentDate(((Date) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"enrollmentDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("externalAccess".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setExternalAccess(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorite".equals(name)) {
                                                                if (value instanceof Boolean) {
                                                                    setFavorite(((Boolean) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("favorites".equals(name)) {
                                                                    if (value instanceof List) {
                                                                        setFavorites(((List<String> ) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("followup".equals(name)) {
                                                                        if (value instanceof Boolean) {
                                                                            setFollowup(((Boolean) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("geometry".equals(name)) {
                                                                            if (value instanceof Object) {
                                                                                setGeometry(((Object) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("href".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setHref(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("id".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setId(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("incidentDate".equals(name)) {
                                                                                        if (value instanceof Date) {
                                                                                            setIncidentDate(((Date) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"incidentDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("lastUpdated".equals(name)) {
                                                                                            if (value instanceof Date) {
                                                                                                setLastUpdated(((Date) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("lastUpdatedAtClient".equals(name)) {
                                                                                                if (value instanceof Date) {
                                                                                                    setLastUpdatedAtClient(((Date) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedAtClient\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                    if (value instanceof User) {
                                                                                                        setLastUpdatedBy(((User) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("lastUpdatedByUserInfo".equals(name)) {
                                                                                                        if (value instanceof UserInfoSnapshot) {
                                                                                                            setLastUpdatedByUserInfo(((UserInfoSnapshot) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_39_1.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("messageConversations".equals(name)) {
                                                                                                            if (value instanceof List) {
                                                                                                                setMessageConversations(((List<MessageConversation> ) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"messageConversations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.MessageConversation>\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("name".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setName(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("organisationUnit".equals(name)) {
                                                                                                                    if (value instanceof OrganisationUnit) {
                                                                                                                        setOrganisationUnit(((OrganisationUnit) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_39_1.OrganisationUnit\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("program".equals(name)) {
                                                                                                                        if (value instanceof Program) {
                                                                                                                            setProgram(((Program) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_39_1.Program\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("programStageInstances".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setProgramStageInstances(((List<ProgramStageInstance> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"programStageInstances\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramStageInstance>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setPublicAccess(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("relationshipItems".equals(name)) {
                                                                                                                                    if (value instanceof List) {
                                                                                                                                        setRelationshipItems(((List<RelationshipItem__2> ) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"relationshipItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.RelationshipItem__2>\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                        if (value instanceof Sharing) {
                                                                                                                                            setSharing(((Sharing) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_39_1.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("status".equals(name)) {
                                                                                                                                            if (value instanceof org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus) {
                                                                                                                                                setStatus(((org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_39_1.EventChart.ProgramStatus\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("storedBy".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setStoredBy(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("trackedEntityComments".equals(name)) {
                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                        setTrackedEntityComments(((List<TrackedEntityComment> ) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"trackedEntityComments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.TrackedEntityComment>\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("trackedEntityInstance".equals(name)) {
                                                                                                                                                        if (value instanceof TrackedEntityInstance__1) {
                                                                                                                                                            setTrackedEntityInstance(((TrackedEntityInstance__1) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v2_39_1.TrackedEntityInstance__1\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                setTranslations(((List<Translation> ) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("user".equals(name)) {
                                                                                                                                                                if (value instanceof User) {
                                                                                                                                                                    setUser(((User) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                        setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                            setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("completedBy".equals(name)) {
                        return getCompletedBy();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdAtClient".equals(name)) {
                                return getCreatedAtClient();
                            } else {
                                if ("createdBy".equals(name)) {
                                    return getCreatedBy();
                                } else {
                                    if ("createdByUserInfo".equals(name)) {
                                        return getCreatedByUserInfo();
                                    } else {
                                        if ("deleted".equals(name)) {
                                            return getDeleted();
                                        } else {
                                            if ("displayName".equals(name)) {
                                                return getDisplayName();
                                            } else {
                                                if ("endDate".equals(name)) {
                                                    return getEndDate();
                                                } else {
                                                    if ("enrollmentDate".equals(name)) {
                                                        return getEnrollmentDate();
                                                    } else {
                                                        if ("externalAccess".equals(name)) {
                                                            return getExternalAccess();
                                                        } else {
                                                            if ("favorite".equals(name)) {
                                                                return getFavorite();
                                                            } else {
                                                                if ("favorites".equals(name)) {
                                                                    return getFavorites();
                                                                } else {
                                                                    if ("followup".equals(name)) {
                                                                        return getFollowup();
                                                                    } else {
                                                                        if ("geometry".equals(name)) {
                                                                            return getGeometry();
                                                                        } else {
                                                                            if ("href".equals(name)) {
                                                                                return getHref();
                                                                            } else {
                                                                                if ("id".equals(name)) {
                                                                                    return getId();
                                                                                } else {
                                                                                    if ("incidentDate".equals(name)) {
                                                                                        return getIncidentDate();
                                                                                    } else {
                                                                                        if ("lastUpdated".equals(name)) {
                                                                                            return getLastUpdated();
                                                                                        } else {
                                                                                            if ("lastUpdatedAtClient".equals(name)) {
                                                                                                return getLastUpdatedAtClient();
                                                                                            } else {
                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                    return getLastUpdatedBy();
                                                                                                } else {
                                                                                                    if ("lastUpdatedByUserInfo".equals(name)) {
                                                                                                        return getLastUpdatedByUserInfo();
                                                                                                    } else {
                                                                                                        if ("messageConversations".equals(name)) {
                                                                                                            return getMessageConversations();
                                                                                                        } else {
                                                                                                            if ("name".equals(name)) {
                                                                                                                return getName();
                                                                                                            } else {
                                                                                                                if ("organisationUnit".equals(name)) {
                                                                                                                    return getOrganisationUnit();
                                                                                                                } else {
                                                                                                                    if ("program".equals(name)) {
                                                                                                                        return getProgram();
                                                                                                                    } else {
                                                                                                                        if ("programStageInstances".equals(name)) {
                                                                                                                            return getProgramStageInstances();
                                                                                                                        } else {
                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                return getPublicAccess();
                                                                                                                            } else {
                                                                                                                                if ("relationshipItems".equals(name)) {
                                                                                                                                    return getRelationshipItems();
                                                                                                                                } else {
                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                        return getSharing();
                                                                                                                                    } else {
                                                                                                                                        if ("status".equals(name)) {
                                                                                                                                            return getStatus();
                                                                                                                                        } else {
                                                                                                                                            if ("storedBy".equals(name)) {
                                                                                                                                                return getStoredBy();
                                                                                                                                            } else {
                                                                                                                                                if ("trackedEntityComments".equals(name)) {
                                                                                                                                                    return getTrackedEntityComments();
                                                                                                                                                } else {
                                                                                                                                                    if ("trackedEntityInstance".equals(name)) {
                                                                                                                                                        return getTrackedEntityInstance();
                                                                                                                                                    } else {
                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                            return getTranslations();
                                                                                                                                                        } else {
                                                                                                                                                            if ("user".equals(name)) {
                                                                                                                                                                return getUser();
                                                                                                                                                            } else {
                                                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                                                    return getUserAccesses();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                        return getUserGroupAccesses();
                                                                                                                                                                    } else {
                                                                                                                                                                        return notFoundValue;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramInstance.NOT_FOUND_VALUE);
        if (ProgramInstance.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramInstance with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramInstance.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("createdByUserInfo");
        sb.append('=');
        sb.append(((this.createdByUserInfo == null)?"<null>":this.createdByUserInfo));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("enrollmentDate");
        sb.append('=');
        sb.append(((this.enrollmentDate == null)?"<null>":this.enrollmentDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("incidentDate");
        sb.append('=');
        sb.append(((this.incidentDate == null)?"<null>":this.incidentDate));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedAtClient");
        sb.append('=');
        sb.append(((this.lastUpdatedAtClient == null)?"<null>":this.lastUpdatedAtClient));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("lastUpdatedByUserInfo");
        sb.append('=');
        sb.append(((this.lastUpdatedByUserInfo == null)?"<null>":this.lastUpdatedByUserInfo));
        sb.append(',');
        sb.append("messageConversations");
        sb.append('=');
        sb.append(((this.messageConversations == null)?"<null>":this.messageConversations));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStageInstances");
        sb.append('=');
        sb.append(((this.programStageInstances == null)?"<null>":this.programStageInstances));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("relationshipItems");
        sb.append('=');
        sb.append(((this.relationshipItems == null)?"<null>":this.relationshipItems));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntityComments");
        sb.append('=');
        sb.append(((this.trackedEntityComments == null)?"<null>":this.trackedEntityComments));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.enrollmentDate == null)? 0 :this.enrollmentDate.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.messageConversations == null)? 0 :this.messageConversations.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdatedByUserInfo == null)? 0 :this.lastUpdatedByUserInfo.hashCode()));
        result = ((result* 31)+((this.trackedEntityComments == null)? 0 :this.trackedEntityComments.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.relationshipItems == null)? 0 :this.relationshipItems.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.createdByUserInfo == null)? 0 :this.createdByUserInfo.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.programStageInstances == null)? 0 :this.programStageInstances.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.incidentDate == null)? 0 :this.incidentDate.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.lastUpdatedAtClient == null)? 0 :this.lastUpdatedAtClient.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramInstance) == false) {
            return false;
        }
        ProgramInstance rhs = ((ProgramInstance) other);
        return ((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.enrollmentDate == rhs.enrollmentDate)||((this.enrollmentDate!= null)&&this.enrollmentDate.equals(rhs.enrollmentDate))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.messageConversations == rhs.messageConversations)||((this.messageConversations!= null)&&this.messageConversations.equals(rhs.messageConversations))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdatedByUserInfo == rhs.lastUpdatedByUserInfo)||((this.lastUpdatedByUserInfo!= null)&&this.lastUpdatedByUserInfo.equals(rhs.lastUpdatedByUserInfo))))&&((this.trackedEntityComments == rhs.trackedEntityComments)||((this.trackedEntityComments!= null)&&this.trackedEntityComments.equals(rhs.trackedEntityComments))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.relationshipItems == rhs.relationshipItems)||((this.relationshipItems!= null)&&this.relationshipItems.equals(rhs.relationshipItems))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.createdByUserInfo == rhs.createdByUserInfo)||((this.createdByUserInfo!= null)&&this.createdByUserInfo.equals(rhs.createdByUserInfo))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.programStageInstances == rhs.programStageInstances)||((this.programStageInstances!= null)&&this.programStageInstances.equals(rhs.programStageInstances))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.incidentDate == rhs.incidentDate)||((this.incidentDate!= null)&&this.incidentDate.equals(rhs.incidentDate))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.lastUpdatedAtClient == rhs.lastUpdatedAtClient)||((this.lastUpdatedAtClient!= null)&&this.lastUpdatedAtClient.equals(rhs.lastUpdatedAtClient))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
