
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bidirectional",
    "created",
    "from",
    "lastUpdated",
    "relationship",
    "relationshipName",
    "relationshipType",
    "to"
})
@Generated("jsonschema2pojo")
public class Relationship implements Serializable
{

    @JsonProperty("bidirectional")
    private Boolean bidirectional;
    @JsonProperty("created")
    private String created;
    @JsonProperty("from")
    private RelationshipItem from;
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    @JsonProperty("relationship")
    private String relationship;
    @JsonProperty("relationshipName")
    private String relationshipName;
    @JsonProperty("relationshipType")
    private String relationshipType;
    @JsonProperty("to")
    private RelationshipItem to;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5882661867162285025L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Relationship() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Relationship(Relationship source) {
        super();
        this.bidirectional = source.bidirectional;
        this.created = source.created;
        this.from = source.from;
        this.lastUpdated = source.lastUpdated;
        this.relationship = source.relationship;
        this.relationshipName = source.relationshipName;
        this.relationshipType = source.relationshipType;
        this.to = source.to;
    }

    public Relationship(Boolean bidirectional, String created, RelationshipItem from, String lastUpdated, String relationship, String relationshipName, String relationshipType, RelationshipItem to) {
        super();
        this.bidirectional = bidirectional;
        this.created = created;
        this.from = from;
        this.lastUpdated = lastUpdated;
        this.relationship = relationship;
        this.relationshipName = relationshipName;
        this.relationshipType = relationshipType;
        this.to = to;
    }

    @JsonProperty("bidirectional")
    public Optional<Boolean> getBidirectional() {
        return Optional.ofNullable(bidirectional);
    }

    @JsonProperty("bidirectional")
    public void setBidirectional(Boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    public Relationship withBidirectional(Boolean bidirectional) {
        this.bidirectional = bidirectional;
        return this;
    }

    @JsonProperty("created")
    public Optional<String> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public Relationship withCreated(String created) {
        this.created = created;
        return this;
    }

    @JsonProperty("from")
    public Optional<RelationshipItem> getFrom() {
        return Optional.ofNullable(from);
    }

    @JsonProperty("from")
    public void setFrom(RelationshipItem from) {
        this.from = from;
    }

    public Relationship withFrom(RelationshipItem from) {
        this.from = from;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<String> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Relationship withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("relationship")
    public Optional<String> getRelationship() {
        return Optional.ofNullable(relationship);
    }

    @JsonProperty("relationship")
    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public Relationship withRelationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    @JsonProperty("relationshipName")
    public Optional<String> getRelationshipName() {
        return Optional.ofNullable(relationshipName);
    }

    @JsonProperty("relationshipName")
    public void setRelationshipName(String relationshipName) {
        this.relationshipName = relationshipName;
    }

    public Relationship withRelationshipName(String relationshipName) {
        this.relationshipName = relationshipName;
        return this;
    }

    @JsonProperty("relationshipType")
    public Optional<String> getRelationshipType() {
        return Optional.ofNullable(relationshipType);
    }

    @JsonProperty("relationshipType")
    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public Relationship withRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @JsonProperty("to")
    public Optional<RelationshipItem> getTo() {
        return Optional.ofNullable(to);
    }

    @JsonProperty("to")
    public void setTo(RelationshipItem to) {
        this.to = to;
    }

    public Relationship withTo(RelationshipItem to) {
        this.to = to;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Relationship withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("bidirectional".equals(name)) {
            if (value instanceof Boolean) {
                setBidirectional(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"bidirectional\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("created".equals(name)) {
                if (value instanceof String) {
                    setCreated(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("from".equals(name)) {
                    if (value instanceof RelationshipItem) {
                        setFrom(((RelationshipItem) value));
                    } else {
                        throw new IllegalArgumentException(("property \"from\" is of type \"org.hisp.dhis.api.model.v2_39_1.RelationshipItem\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("lastUpdated".equals(name)) {
                        if (value instanceof String) {
                            setLastUpdated(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("relationship".equals(name)) {
                            if (value instanceof String) {
                                setRelationship(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"relationship\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("relationshipName".equals(name)) {
                                if (value instanceof String) {
                                    setRelationshipName(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"relationshipName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("relationshipType".equals(name)) {
                                    if (value instanceof String) {
                                        setRelationshipType(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"relationshipType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("to".equals(name)) {
                                        if (value instanceof RelationshipItem) {
                                            setTo(((RelationshipItem) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"to\" is of type \"org.hisp.dhis.api.model.v2_39_1.RelationshipItem\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("bidirectional".equals(name)) {
            return getBidirectional();
        } else {
            if ("created".equals(name)) {
                return getCreated();
            } else {
                if ("from".equals(name)) {
                    return getFrom();
                } else {
                    if ("lastUpdated".equals(name)) {
                        return getLastUpdated();
                    } else {
                        if ("relationship".equals(name)) {
                            return getRelationship();
                        } else {
                            if ("relationshipName".equals(name)) {
                                return getRelationshipName();
                            } else {
                                if ("relationshipType".equals(name)) {
                                    return getRelationshipType();
                                } else {
                                    if ("to".equals(name)) {
                                        return getTo();
                                    } else {
                                        return notFoundValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Relationship.NOT_FOUND_VALUE);
        if (Relationship.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Relationship with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Relationship.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bidirectional");
        sb.append('=');
        sb.append(((this.bidirectional == null)?"<null>":this.bidirectional));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("from");
        sb.append('=');
        sb.append(((this.from == null)?"<null>":this.from));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("relationship");
        sb.append('=');
        sb.append(((this.relationship == null)?"<null>":this.relationship));
        sb.append(',');
        sb.append("relationshipName");
        sb.append('=');
        sb.append(((this.relationshipName == null)?"<null>":this.relationshipName));
        sb.append(',');
        sb.append("relationshipType");
        sb.append('=');
        sb.append(((this.relationshipType == null)?"<null>":this.relationshipType));
        sb.append(',');
        sb.append("to");
        sb.append('=');
        sb.append(((this.to == null)?"<null>":this.to));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.relationshipName == null)? 0 :this.relationshipName.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.bidirectional == null)? 0 :this.bidirectional.hashCode()));
        result = ((result* 31)+((this.relationshipType == null)? 0 :this.relationshipType.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.from == null)? 0 :this.from.hashCode()));
        result = ((result* 31)+((this.to == null)? 0 :this.to.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.relationship == null)? 0 :this.relationship.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Relationship) == false) {
            return false;
        }
        Relationship rhs = ((Relationship) other);
        return ((((((((((this.relationshipName == rhs.relationshipName)||((this.relationshipName!= null)&&this.relationshipName.equals(rhs.relationshipName)))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.bidirectional == rhs.bidirectional)||((this.bidirectional!= null)&&this.bidirectional.equals(rhs.bidirectional))))&&((this.relationshipType == rhs.relationshipType)||((this.relationshipType!= null)&&this.relationshipType.equals(rhs.relationshipType))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.from == rhs.from)||((this.from!= null)&&this.from.equals(rhs.from))))&&((this.to == rhs.to)||((this.to!= null)&&this.to.equals(rhs.to))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.relationship == rhs.relationship)||((this.relationship!= null)&&this.relationship.equals(rhs.relationship))));
    }

}
