
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "method",
    "parameter"
})
@Generated("jsonschema2pojo")
public class TextPatternSegment implements Serializable
{

    @JsonProperty("method")
    private TextPatternSegment.TextPatternMethod method;
    @JsonProperty("parameter")
    private String parameter;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8416195528434472794L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TextPatternSegment() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TextPatternSegment(TextPatternSegment source) {
        super();
        this.method = source.method;
        this.parameter = source.parameter;
    }

    public TextPatternSegment(TextPatternSegment.TextPatternMethod method, String parameter) {
        super();
        this.method = method;
        this.parameter = parameter;
    }

    @JsonProperty("method")
    public Optional<TextPatternSegment.TextPatternMethod> getMethod() {
        return Optional.ofNullable(method);
    }

    @JsonProperty("method")
    public void setMethod(TextPatternSegment.TextPatternMethod method) {
        this.method = method;
    }

    public TextPatternSegment withMethod(TextPatternSegment.TextPatternMethod method) {
        this.method = method;
        return this;
    }

    @JsonProperty("parameter")
    public Optional<String> getParameter() {
        return Optional.ofNullable(parameter);
    }

    @JsonProperty("parameter")
    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public TextPatternSegment withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TextPatternSegment withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("method".equals(name)) {
            if (value instanceof TextPatternSegment.TextPatternMethod) {
                setMethod(((TextPatternSegment.TextPatternMethod) value));
            } else {
                throw new IllegalArgumentException(("property \"method\" is of type \"org.hisp.dhis.api.model.v2_39_1.TextPatternSegment.TextPatternMethod\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("parameter".equals(name)) {
                if (value instanceof String) {
                    setParameter(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"parameter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("method".equals(name)) {
            return getMethod();
        } else {
            if ("parameter".equals(name)) {
                return getParameter();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TextPatternSegment.NOT_FOUND_VALUE);
        if (TextPatternSegment.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TextPatternSegment with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextPatternSegment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("method");
        sb.append('=');
        sb.append(((this.method == null)?"<null>":this.method));
        sb.append(',');
        sb.append("parameter");
        sb.append('=');
        sb.append(((this.parameter == null)?"<null>":this.parameter));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.method == null)? 0 :this.method.hashCode()));
        result = ((result* 31)+((this.parameter == null)? 0 :this.parameter.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TextPatternSegment) == false) {
            return false;
        }
        TextPatternSegment rhs = ((TextPatternSegment) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.method == rhs.method)||((this.method!= null)&&this.method.equals(rhs.method))))&&((this.parameter == rhs.parameter)||((this.parameter!= null)&&this.parameter.equals(rhs.parameter))));
    }

    @Generated("jsonschema2pojo")
    public enum TextPatternMethod {

        TEXT("TEXT"),
        RANDOM("RANDOM"),
        SEQUENTIAL("SEQUENTIAL"),
        ORG_UNIT_CODE("ORG_UNIT_CODE"),
        CURRENT_DATE("CURRENT_DATE");
        private final String value;
        private final static Map<String, TextPatternSegment.TextPatternMethod> CONSTANTS = new HashMap<String, TextPatternSegment.TextPatternMethod>();

        static {
            for (TextPatternSegment.TextPatternMethod c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TextPatternMethod(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TextPatternSegment.TextPatternMethod fromValue(String value) {
            TextPatternSegment.TextPatternMethod constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
