
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "created",
    "lastUpdated",
    "storedBy",
    "trackedEntityAttribute",
    "trackedEntityInstance",
    "value"
})
@Generated("jsonschema2pojo")
public class TrackedEntityAttributeValue implements Serializable
{

    @JsonProperty("created")
    private Date created;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("trackedEntityAttribute")
    private TrackedEntityAttribute trackedEntityAttribute;
    @JsonProperty("trackedEntityInstance")
    private TrackedEntityInstance__1 trackedEntityInstance;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8126318208098633420L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityAttributeValue() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityAttributeValue(TrackedEntityAttributeValue source) {
        super();
        this.created = source.created;
        this.lastUpdated = source.lastUpdated;
        this.storedBy = source.storedBy;
        this.trackedEntityAttribute = source.trackedEntityAttribute;
        this.trackedEntityInstance = source.trackedEntityInstance;
        this.value = source.value;
    }

    public TrackedEntityAttributeValue(Date created, Date lastUpdated, String storedBy, TrackedEntityAttribute trackedEntityAttribute, TrackedEntityInstance__1 trackedEntityInstance, String value) {
        super();
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.storedBy = storedBy;
        this.trackedEntityAttribute = trackedEntityAttribute;
        this.trackedEntityInstance = trackedEntityInstance;
        this.value = value;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public TrackedEntityAttributeValue withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public TrackedEntityAttributeValue withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public TrackedEntityAttributeValue withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("trackedEntityAttribute")
    public Optional<TrackedEntityAttribute> getTrackedEntityAttribute() {
        return Optional.ofNullable(trackedEntityAttribute);
    }

    @JsonProperty("trackedEntityAttribute")
    public void setTrackedEntityAttribute(TrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
    }

    public TrackedEntityAttributeValue withTrackedEntityAttribute(TrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstance__1> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public TrackedEntityAttributeValue withTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public TrackedEntityAttributeValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityAttributeValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("created".equals(name)) {
            if (value instanceof Date) {
                setCreated(((Date) value));
            } else {
                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("lastUpdated".equals(name)) {
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("storedBy".equals(name)) {
                    if (value instanceof String) {
                        setStoredBy(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("trackedEntityAttribute".equals(name)) {
                        if (value instanceof TrackedEntityAttribute) {
                            setTrackedEntityAttribute(((TrackedEntityAttribute) value));
                        } else {
                            throw new IllegalArgumentException(("property \"trackedEntityAttribute\" is of type \"org.hisp.dhis.api.model.v2_39_1.TrackedEntityAttribute\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("trackedEntityInstance".equals(name)) {
                            if (value instanceof TrackedEntityInstance__1) {
                                setTrackedEntityInstance(((TrackedEntityInstance__1) value));
                            } else {
                                throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v2_39_1.TrackedEntityInstance__1\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("value".equals(name)) {
                                if (value instanceof String) {
                                    setValue(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("created".equals(name)) {
            return getCreated();
        } else {
            if ("lastUpdated".equals(name)) {
                return getLastUpdated();
            } else {
                if ("storedBy".equals(name)) {
                    return getStoredBy();
                } else {
                    if ("trackedEntityAttribute".equals(name)) {
                        return getTrackedEntityAttribute();
                    } else {
                        if ("trackedEntityInstance".equals(name)) {
                            return getTrackedEntityInstance();
                        } else {
                            if ("value".equals(name)) {
                                return getValue();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityAttributeValue.NOT_FOUND_VALUE);
        if (TrackedEntityAttributeValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityAttributeValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityAttributeValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntityAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttribute == null)?"<null>":this.trackedEntityAttribute));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttribute == null)? 0 :this.trackedEntityAttribute.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityAttributeValue) == false) {
            return false;
        }
        TrackedEntityAttributeValue rhs = ((TrackedEntityAttributeValue) other);
        return ((((((((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.trackedEntityAttribute == rhs.trackedEntityAttribute)||((this.trackedEntityAttribute!= null)&&this.trackedEntityAttribute.equals(rhs.trackedEntityAttribute))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
