
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataElement",
    "filter",
    "legendSet",
    "programStage"
})
@Generated("jsonschema2pojo")
public class TrackedEntityDataElementDimension implements Serializable
{

    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("filter")
    private String filter;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3058461834927665755L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityDataElementDimension() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityDataElementDimension(TrackedEntityDataElementDimension source) {
        super();
        this.dataElement = source.dataElement;
        this.filter = source.filter;
        this.legendSet = source.legendSet;
        this.programStage = source.programStage;
    }

    public TrackedEntityDataElementDimension(DataElement dataElement, String filter, LegendSet legendSet, ProgramStage programStage) {
        super();
        this.dataElement = dataElement;
        this.filter = filter;
        this.legendSet = legendSet;
        this.programStage = programStage;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public TrackedEntityDataElementDimension withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public TrackedEntityDataElementDimension withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public TrackedEntityDataElementDimension withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public TrackedEntityDataElementDimension withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityDataElementDimension withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataElement".equals(name)) {
            if (value instanceof DataElement) {
                setDataElement(((DataElement) value));
            } else {
                throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_39_1.DataElement\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("filter".equals(name)) {
                if (value instanceof String) {
                    setFilter(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("legendSet".equals(name)) {
                    if (value instanceof LegendSet) {
                        setLegendSet(((LegendSet) value));
                    } else {
                        throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_39_1.LegendSet\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("programStage".equals(name)) {
                        if (value instanceof ProgramStage) {
                            setProgramStage(((ProgramStage) value));
                        } else {
                            throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_39_1.ProgramStage\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataElement".equals(name)) {
            return getDataElement();
        } else {
            if ("filter".equals(name)) {
                return getFilter();
            } else {
                if ("legendSet".equals(name)) {
                    return getLegendSet();
                } else {
                    if ("programStage".equals(name)) {
                        return getProgramStage();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityDataElementDimension.NOT_FOUND_VALUE);
        if (TrackedEntityDataElementDimension.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityDataElementDimension with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityDataElementDimension.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityDataElementDimension) == false) {
            return false;
        }
        TrackedEntityDataElementDimension rhs = ((TrackedEntityDataElementDimension) other);
        return ((((((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter)))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
