
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "filter",
    "legendSet",
    "programIndicator"
})
@Generated("jsonschema2pojo")
public class TrackedEntityProgramIndicatorDimension implements Serializable
{

    @JsonProperty("filter")
    private String filter;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("programIndicator")
    private ProgramIndicator programIndicator;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7309399196949380761L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityProgramIndicatorDimension() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityProgramIndicatorDimension(TrackedEntityProgramIndicatorDimension source) {
        super();
        this.filter = source.filter;
        this.legendSet = source.legendSet;
        this.programIndicator = source.programIndicator;
    }

    public TrackedEntityProgramIndicatorDimension(String filter, LegendSet legendSet, ProgramIndicator programIndicator) {
        super();
        this.filter = filter;
        this.legendSet = legendSet;
        this.programIndicator = programIndicator;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public TrackedEntityProgramIndicatorDimension withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public TrackedEntityProgramIndicatorDimension withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("programIndicator")
    public Optional<ProgramIndicator> getProgramIndicator() {
        return Optional.ofNullable(programIndicator);
    }

    @JsonProperty("programIndicator")
    public void setProgramIndicator(ProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
    }

    public TrackedEntityProgramIndicatorDimension withProgramIndicator(ProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityProgramIndicatorDimension withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("filter".equals(name)) {
            if (value instanceof String) {
                setFilter(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("legendSet".equals(name)) {
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_39_1.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("programIndicator".equals(name)) {
                    if (value instanceof ProgramIndicator) {
                        setProgramIndicator(((ProgramIndicator) value));
                    } else {
                        throw new IllegalArgumentException(("property \"programIndicator\" is of type \"org.hisp.dhis.api.model.v2_39_1.ProgramIndicator\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("filter".equals(name)) {
            return getFilter();
        } else {
            if ("legendSet".equals(name)) {
                return getLegendSet();
            } else {
                if ("programIndicator".equals(name)) {
                    return getProgramIndicator();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityProgramIndicatorDimension.NOT_FOUND_VALUE);
        if (TrackedEntityProgramIndicatorDimension.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityProgramIndicatorDimension with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityProgramIndicatorDimension.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("programIndicator");
        sb.append('=');
        sb.append(((this.programIndicator == null)?"<null>":this.programIndicator));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.programIndicator == null)? 0 :this.programIndicator.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityProgramIndicatorDimension) == false) {
            return false;
        }
        TrackedEntityProgramIndicatorDimension rhs = ((TrackedEntityProgramIndicatorDimension) other);
        return (((((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter)))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.programIndicator == rhs.programIndicator)||((this.programIndicator!= null)&&this.programIndicator.equals(rhs.programIndicator))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
