
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "analysisDisplayProperty",
    "dbLocale",
    "messageEmailNotification",
    "messageSmsNotification",
    "style",
    "trackerDashboardLayout",
    "uiLocale"
})
@Generated("jsonschema2pojo")
public class UserSettings implements Serializable
{

    @JsonProperty("analysisDisplayProperty")
    private UserSettings.DisplayProperty analysisDisplayProperty;
    /**
     * Undefined
     * 
     */
    @JsonProperty("dbLocale")
    private Object dbLocale;
    @JsonProperty("messageEmailNotification")
    private Boolean messageEmailNotification;
    @JsonProperty("messageSmsNotification")
    private Boolean messageSmsNotification;
    @JsonProperty("style")
    private String style;
    @JsonProperty("trackerDashboardLayout")
    private String trackerDashboardLayout;
    /**
     * Undefined
     * 
     */
    @JsonProperty("uiLocale")
    private Object uiLocale;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5035605613596658927L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UserSettings() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public UserSettings(UserSettings source) {
        super();
        this.analysisDisplayProperty = source.analysisDisplayProperty;
        this.dbLocale = source.dbLocale;
        this.messageEmailNotification = source.messageEmailNotification;
        this.messageSmsNotification = source.messageSmsNotification;
        this.style = source.style;
        this.trackerDashboardLayout = source.trackerDashboardLayout;
        this.uiLocale = source.uiLocale;
    }

    public UserSettings(UserSettings.DisplayProperty analysisDisplayProperty, Object dbLocale, Boolean messageEmailNotification, Boolean messageSmsNotification, String style, String trackerDashboardLayout, Object uiLocale) {
        super();
        this.analysisDisplayProperty = analysisDisplayProperty;
        this.dbLocale = dbLocale;
        this.messageEmailNotification = messageEmailNotification;
        this.messageSmsNotification = messageSmsNotification;
        this.style = style;
        this.trackerDashboardLayout = trackerDashboardLayout;
        this.uiLocale = uiLocale;
    }

    @JsonProperty("analysisDisplayProperty")
    public Optional<UserSettings.DisplayProperty> getAnalysisDisplayProperty() {
        return Optional.ofNullable(analysisDisplayProperty);
    }

    @JsonProperty("analysisDisplayProperty")
    public void setAnalysisDisplayProperty(UserSettings.DisplayProperty analysisDisplayProperty) {
        this.analysisDisplayProperty = analysisDisplayProperty;
    }

    public UserSettings withAnalysisDisplayProperty(UserSettings.DisplayProperty analysisDisplayProperty) {
        this.analysisDisplayProperty = analysisDisplayProperty;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dbLocale")
    public Optional<Object> getDbLocale() {
        return Optional.ofNullable(dbLocale);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dbLocale")
    public void setDbLocale(Object dbLocale) {
        this.dbLocale = dbLocale;
    }

    public UserSettings withDbLocale(Object dbLocale) {
        this.dbLocale = dbLocale;
        return this;
    }

    @JsonProperty("messageEmailNotification")
    public Optional<Boolean> getMessageEmailNotification() {
        return Optional.ofNullable(messageEmailNotification);
    }

    @JsonProperty("messageEmailNotification")
    public void setMessageEmailNotification(Boolean messageEmailNotification) {
        this.messageEmailNotification = messageEmailNotification;
    }

    public UserSettings withMessageEmailNotification(Boolean messageEmailNotification) {
        this.messageEmailNotification = messageEmailNotification;
        return this;
    }

    @JsonProperty("messageSmsNotification")
    public Optional<Boolean> getMessageSmsNotification() {
        return Optional.ofNullable(messageSmsNotification);
    }

    @JsonProperty("messageSmsNotification")
    public void setMessageSmsNotification(Boolean messageSmsNotification) {
        this.messageSmsNotification = messageSmsNotification;
    }

    public UserSettings withMessageSmsNotification(Boolean messageSmsNotification) {
        this.messageSmsNotification = messageSmsNotification;
        return this;
    }

    @JsonProperty("style")
    public Optional<String> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(String style) {
        this.style = style;
    }

    public UserSettings withStyle(String style) {
        this.style = style;
        return this;
    }

    @JsonProperty("trackerDashboardLayout")
    public Optional<String> getTrackerDashboardLayout() {
        return Optional.ofNullable(trackerDashboardLayout);
    }

    @JsonProperty("trackerDashboardLayout")
    public void setTrackerDashboardLayout(String trackerDashboardLayout) {
        this.trackerDashboardLayout = trackerDashboardLayout;
    }

    public UserSettings withTrackerDashboardLayout(String trackerDashboardLayout) {
        this.trackerDashboardLayout = trackerDashboardLayout;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("uiLocale")
    public Optional<Object> getUiLocale() {
        return Optional.ofNullable(uiLocale);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("uiLocale")
    public void setUiLocale(Object uiLocale) {
        this.uiLocale = uiLocale;
    }

    public UserSettings withUiLocale(Object uiLocale) {
        this.uiLocale = uiLocale;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public UserSettings withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("analysisDisplayProperty".equals(name)) {
            if (value instanceof UserSettings.DisplayProperty) {
                setAnalysisDisplayProperty(((UserSettings.DisplayProperty) value));
            } else {
                throw new IllegalArgumentException(("property \"analysisDisplayProperty\" is of type \"org.hisp.dhis.api.model.v2_39_1.UserSettings.DisplayProperty\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dbLocale".equals(name)) {
                if (value instanceof Object) {
                    setDbLocale(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"dbLocale\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("messageEmailNotification".equals(name)) {
                    if (value instanceof Boolean) {
                        setMessageEmailNotification(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"messageEmailNotification\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("messageSmsNotification".equals(name)) {
                        if (value instanceof Boolean) {
                            setMessageSmsNotification(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"messageSmsNotification\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("style".equals(name)) {
                            if (value instanceof String) {
                                setStyle(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"style\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("trackerDashboardLayout".equals(name)) {
                                if (value instanceof String) {
                                    setTrackerDashboardLayout(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"trackerDashboardLayout\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("uiLocale".equals(name)) {
                                    if (value instanceof Object) {
                                        setUiLocale(((Object) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"uiLocale\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("analysisDisplayProperty".equals(name)) {
            return getAnalysisDisplayProperty();
        } else {
            if ("dbLocale".equals(name)) {
                return getDbLocale();
            } else {
                if ("messageEmailNotification".equals(name)) {
                    return getMessageEmailNotification();
                } else {
                    if ("messageSmsNotification".equals(name)) {
                        return getMessageSmsNotification();
                    } else {
                        if ("style".equals(name)) {
                            return getStyle();
                        } else {
                            if ("trackerDashboardLayout".equals(name)) {
                                return getTrackerDashboardLayout();
                            } else {
                                if ("uiLocale".equals(name)) {
                                    return getUiLocale();
                                } else {
                                    return notFoundValue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, UserSettings.NOT_FOUND_VALUE);
        if (UserSettings.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public UserSettings with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UserSettings.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("analysisDisplayProperty");
        sb.append('=');
        sb.append(((this.analysisDisplayProperty == null)?"<null>":this.analysisDisplayProperty));
        sb.append(',');
        sb.append("dbLocale");
        sb.append('=');
        sb.append(((this.dbLocale == null)?"<null>":this.dbLocale));
        sb.append(',');
        sb.append("messageEmailNotification");
        sb.append('=');
        sb.append(((this.messageEmailNotification == null)?"<null>":this.messageEmailNotification));
        sb.append(',');
        sb.append("messageSmsNotification");
        sb.append('=');
        sb.append(((this.messageSmsNotification == null)?"<null>":this.messageSmsNotification));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("trackerDashboardLayout");
        sb.append('=');
        sb.append(((this.trackerDashboardLayout == null)?"<null>":this.trackerDashboardLayout));
        sb.append(',');
        sb.append("uiLocale");
        sb.append('=');
        sb.append(((this.uiLocale == null)?"<null>":this.uiLocale));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.trackerDashboardLayout == null)? 0 :this.trackerDashboardLayout.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.dbLocale == null)? 0 :this.dbLocale.hashCode()));
        result = ((result* 31)+((this.messageSmsNotification == null)? 0 :this.messageSmsNotification.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.uiLocale == null)? 0 :this.uiLocale.hashCode()));
        result = ((result* 31)+((this.messageEmailNotification == null)? 0 :this.messageEmailNotification.hashCode()));
        result = ((result* 31)+((this.analysisDisplayProperty == null)? 0 :this.analysisDisplayProperty.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof UserSettings) == false) {
            return false;
        }
        UserSettings rhs = ((UserSettings) other);
        return (((((((((this.trackerDashboardLayout == rhs.trackerDashboardLayout)||((this.trackerDashboardLayout!= null)&&this.trackerDashboardLayout.equals(rhs.trackerDashboardLayout)))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.dbLocale == rhs.dbLocale)||((this.dbLocale!= null)&&this.dbLocale.equals(rhs.dbLocale))))&&((this.messageSmsNotification == rhs.messageSmsNotification)||((this.messageSmsNotification!= null)&&this.messageSmsNotification.equals(rhs.messageSmsNotification))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.uiLocale == rhs.uiLocale)||((this.uiLocale!= null)&&this.uiLocale.equals(rhs.uiLocale))))&&((this.messageEmailNotification == rhs.messageEmailNotification)||((this.messageEmailNotification!= null)&&this.messageEmailNotification.equals(rhs.messageEmailNotification))))&&((this.analysisDisplayProperty == rhs.analysisDisplayProperty)||((this.analysisDisplayProperty!= null)&&this.analysisDisplayProperty.equals(rhs.analysisDisplayProperty))));
    }

    @Generated("jsonschema2pojo")
    public enum DisplayProperty {

        NAME("NAME"),
        SHORTNAME("SHORTNAME");
        private final String value;
        private final static Map<String, UserSettings.DisplayProperty> CONSTANTS = new HashMap<String, UserSettings.DisplayProperty>();

        static {
            for (UserSettings.DisplayProperty c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DisplayProperty(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static UserSettings.DisplayProperty fromValue(String value) {
            UserSettings.DisplayProperty constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
