
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "categoryAttribute",
    "categoryOptionAttribute",
    "categoryOptionComboAttribute",
    "categoryOptionGroupAttribute",
    "categoryOptionGroupSetAttribute",
    "code",
    "constantAttribute",
    "created",
    "createdBy",
    "dataElementAttribute",
    "dataElementGroupAttribute",
    "dataElementGroupSetAttribute",
    "dataSetAttribute",
    "description",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "documentAttribute",
    "eventChartAttribute",
    "eventReportAttribute",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "id",
    "indicatorAttribute",
    "indicatorGroupAttribute",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSetAttribute",
    "mandatory",
    "mapAttribute",
    "name",
    "objectTypes",
    "optionAttribute",
    "optionSet",
    "optionSetAttribute",
    "organisationUnitAttribute",
    "organisationUnitGroupAttribute",
    "organisationUnitGroupSetAttribute",
    "programAttribute",
    "programIndicatorAttribute",
    "programStageAttribute",
    "publicAccess",
    "relationshipTypeAttribute",
    "sectionAttribute",
    "sharing",
    "shortName",
    "sortOrder",
    "sqlViewAttribute",
    "trackedEntityAttributeAttribute",
    "trackedEntityTypeAttribute",
    "translations",
    "unique",
    "user",
    "userAccesses",
    "userAttribute",
    "userGroupAccesses",
    "userGroupAttribute",
    "validationRuleAttribute",
    "validationRuleGroupAttribute",
    "valueType",
    "visualizationAttribute"
})
@Generated("jsonschema2pojo")
public class Attribute implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryAttribute")
    private Boolean categoryAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionAttribute")
    private Boolean categoryOptionAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionComboAttribute")
    private Boolean categoryOptionComboAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionGroupAttribute")
    private Boolean categoryOptionGroupAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionGroupSetAttribute")
    private Boolean categoryOptionGroupSetAttribute;
    @JsonProperty("code")
    private String code;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("constantAttribute")
    private Boolean constantAttribute;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementAttribute")
    private Boolean dataElementAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementGroupAttribute")
    private Boolean dataElementGroupAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementGroupSetAttribute")
    private Boolean dataElementGroupSetAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataSetAttribute")
    private Boolean dataSetAttribute;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("documentAttribute")
    private Boolean documentAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventChartAttribute")
    private Boolean eventChartAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventReportAttribute")
    private Boolean eventReportAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("indicatorAttribute")
    private Boolean indicatorAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("indicatorGroupAttribute")
    private Boolean indicatorGroupAttribute;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("legendSetAttribute")
    private Boolean legendSetAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mandatory")
    private Boolean mandatory;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mapAttribute")
    private Boolean mapAttribute;
    @JsonProperty("name")
    private String name;
    @JsonProperty("objectTypes")
    private List<String> objectTypes;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("optionAttribute")
    private Boolean optionAttribute;
    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    @JsonPropertyDescription("A UID reference to a OptionSet  \n(Java name `org.hisp.dhis.option.OptionSet`)")
    private RefOptionSet optionSet;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("optionSetAttribute")
    private Boolean optionSetAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitAttribute")
    private Boolean organisationUnitAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitGroupAttribute")
    private Boolean organisationUnitGroupAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitGroupSetAttribute")
    private Boolean organisationUnitGroupSetAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programAttribute")
    private Boolean programAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programIndicatorAttribute")
    private Boolean programIndicatorAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programStageAttribute")
    private Boolean programStageAttribute;
    @JsonProperty("publicAccess")
    private String publicAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("relationshipTypeAttribute")
    private Boolean relationshipTypeAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sectionAttribute")
    private Boolean sectionAttribute;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sqlViewAttribute")
    private Boolean sqlViewAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityAttributeAttribute")
    private Boolean trackedEntityAttributeAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityTypeAttribute")
    private Boolean trackedEntityTypeAttribute;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unique")
    private Boolean unique;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userAttribute")
    private Boolean userAttribute;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userGroupAttribute")
    private Boolean userGroupAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationRuleAttribute")
    private Boolean validationRuleAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationRuleGroupAttribute")
    private Boolean validationRuleGroupAttribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private Attribute.ValueType valueType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("visualizationAttribute")
    private Boolean visualizationAttribute;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6777227127312140911L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Attribute() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Attribute(Attribute source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.categoryAttribute = source.categoryAttribute;
        this.categoryOptionAttribute = source.categoryOptionAttribute;
        this.categoryOptionComboAttribute = source.categoryOptionComboAttribute;
        this.categoryOptionGroupAttribute = source.categoryOptionGroupAttribute;
        this.categoryOptionGroupSetAttribute = source.categoryOptionGroupSetAttribute;
        this.code = source.code;
        this.constantAttribute = source.constantAttribute;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataElementAttribute = source.dataElementAttribute;
        this.dataElementGroupAttribute = source.dataElementGroupAttribute;
        this.dataElementGroupSetAttribute = source.dataElementGroupSetAttribute;
        this.dataSetAttribute = source.dataSetAttribute;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.documentAttribute = source.documentAttribute;
        this.eventChartAttribute = source.eventChartAttribute;
        this.eventReportAttribute = source.eventReportAttribute;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.indicatorAttribute = source.indicatorAttribute;
        this.indicatorGroupAttribute = source.indicatorGroupAttribute;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSetAttribute = source.legendSetAttribute;
        this.mandatory = source.mandatory;
        this.mapAttribute = source.mapAttribute;
        this.name = source.name;
        this.objectTypes = source.objectTypes;
        this.optionAttribute = source.optionAttribute;
        this.optionSet = source.optionSet;
        this.optionSetAttribute = source.optionSetAttribute;
        this.organisationUnitAttribute = source.organisationUnitAttribute;
        this.organisationUnitGroupAttribute = source.organisationUnitGroupAttribute;
        this.organisationUnitGroupSetAttribute = source.organisationUnitGroupSetAttribute;
        this.programAttribute = source.programAttribute;
        this.programIndicatorAttribute = source.programIndicatorAttribute;
        this.programStageAttribute = source.programStageAttribute;
        this.publicAccess = source.publicAccess;
        this.relationshipTypeAttribute = source.relationshipTypeAttribute;
        this.sectionAttribute = source.sectionAttribute;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.sortOrder = source.sortOrder;
        this.sqlViewAttribute = source.sqlViewAttribute;
        this.trackedEntityAttributeAttribute = source.trackedEntityAttributeAttribute;
        this.trackedEntityTypeAttribute = source.trackedEntityTypeAttribute;
        this.translations = source.translations;
        this.unique = source.unique;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userAttribute = source.userAttribute;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userGroupAttribute = source.userGroupAttribute;
        this.validationRuleAttribute = source.validationRuleAttribute;
        this.validationRuleGroupAttribute = source.validationRuleGroupAttribute;
        this.valueType = source.valueType;
        this.visualizationAttribute = source.visualizationAttribute;
    }

    public Attribute(Access access, List<AttributeValue> attributeValues, Boolean categoryAttribute, Boolean categoryOptionAttribute, Boolean categoryOptionComboAttribute, Boolean categoryOptionGroupAttribute, Boolean categoryOptionGroupSetAttribute, String code, Boolean constantAttribute, Date created, RefUser createdBy, Boolean dataElementAttribute, Boolean dataElementGroupAttribute, Boolean dataElementGroupSetAttribute, Boolean dataSetAttribute, String description, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean documentAttribute, Boolean eventChartAttribute, Boolean eventReportAttribute, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, String id, Boolean indicatorAttribute, Boolean indicatorGroupAttribute, Date lastUpdated, RefUser lastUpdatedBy, Boolean legendSetAttribute, Boolean mandatory, Boolean mapAttribute, String name, List<String> objectTypes, Boolean optionAttribute, RefOptionSet optionSet, Boolean optionSetAttribute, Boolean organisationUnitAttribute, Boolean organisationUnitGroupAttribute, Boolean organisationUnitGroupSetAttribute, Boolean programAttribute, Boolean programIndicatorAttribute, Boolean programStageAttribute, String publicAccess, Boolean relationshipTypeAttribute, Boolean sectionAttribute, Sharing sharing, String shortName, Integer sortOrder, Boolean sqlViewAttribute, Boolean trackedEntityAttributeAttribute, Boolean trackedEntityTypeAttribute, List<Translation> translations, Boolean unique, RefUser user, List<UserAccess> userAccesses, Boolean userAttribute, List<UserGroupAccess> userGroupAccesses, Boolean userGroupAttribute, Boolean validationRuleAttribute, Boolean validationRuleGroupAttribute, Attribute.ValueType valueType, Boolean visualizationAttribute) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.categoryAttribute = categoryAttribute;
        this.categoryOptionAttribute = categoryOptionAttribute;
        this.categoryOptionComboAttribute = categoryOptionComboAttribute;
        this.categoryOptionGroupAttribute = categoryOptionGroupAttribute;
        this.categoryOptionGroupSetAttribute = categoryOptionGroupSetAttribute;
        this.code = code;
        this.constantAttribute = constantAttribute;
        this.created = created;
        this.createdBy = createdBy;
        this.dataElementAttribute = dataElementAttribute;
        this.dataElementGroupAttribute = dataElementGroupAttribute;
        this.dataElementGroupSetAttribute = dataElementGroupSetAttribute;
        this.dataSetAttribute = dataSetAttribute;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.documentAttribute = documentAttribute;
        this.eventChartAttribute = eventChartAttribute;
        this.eventReportAttribute = eventReportAttribute;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.indicatorAttribute = indicatorAttribute;
        this.indicatorGroupAttribute = indicatorGroupAttribute;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSetAttribute = legendSetAttribute;
        this.mandatory = mandatory;
        this.mapAttribute = mapAttribute;
        this.name = name;
        this.objectTypes = objectTypes;
        this.optionAttribute = optionAttribute;
        this.optionSet = optionSet;
        this.optionSetAttribute = optionSetAttribute;
        this.organisationUnitAttribute = organisationUnitAttribute;
        this.organisationUnitGroupAttribute = organisationUnitGroupAttribute;
        this.organisationUnitGroupSetAttribute = organisationUnitGroupSetAttribute;
        this.programAttribute = programAttribute;
        this.programIndicatorAttribute = programIndicatorAttribute;
        this.programStageAttribute = programStageAttribute;
        this.publicAccess = publicAccess;
        this.relationshipTypeAttribute = relationshipTypeAttribute;
        this.sectionAttribute = sectionAttribute;
        this.sharing = sharing;
        this.shortName = shortName;
        this.sortOrder = sortOrder;
        this.sqlViewAttribute = sqlViewAttribute;
        this.trackedEntityAttributeAttribute = trackedEntityAttributeAttribute;
        this.trackedEntityTypeAttribute = trackedEntityTypeAttribute;
        this.translations = translations;
        this.unique = unique;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userAttribute = userAttribute;
        this.userGroupAccesses = userGroupAccesses;
        this.userGroupAttribute = userGroupAttribute;
        this.validationRuleAttribute = validationRuleAttribute;
        this.validationRuleGroupAttribute = validationRuleGroupAttribute;
        this.valueType = valueType;
        this.visualizationAttribute = visualizationAttribute;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Attribute withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Attribute withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryAttribute")
    public Boolean getCategoryAttribute() {
        return categoryAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryAttribute")
    public void setCategoryAttribute(Boolean categoryAttribute) {
        this.categoryAttribute = categoryAttribute;
    }

    public Attribute withCategoryAttribute(Boolean categoryAttribute) {
        this.categoryAttribute = categoryAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionAttribute")
    public Boolean getCategoryOptionAttribute() {
        return categoryOptionAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionAttribute")
    public void setCategoryOptionAttribute(Boolean categoryOptionAttribute) {
        this.categoryOptionAttribute = categoryOptionAttribute;
    }

    public Attribute withCategoryOptionAttribute(Boolean categoryOptionAttribute) {
        this.categoryOptionAttribute = categoryOptionAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionComboAttribute")
    public Boolean getCategoryOptionComboAttribute() {
        return categoryOptionComboAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionComboAttribute")
    public void setCategoryOptionComboAttribute(Boolean categoryOptionComboAttribute) {
        this.categoryOptionComboAttribute = categoryOptionComboAttribute;
    }

    public Attribute withCategoryOptionComboAttribute(Boolean categoryOptionComboAttribute) {
        this.categoryOptionComboAttribute = categoryOptionComboAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionGroupAttribute")
    public Boolean getCategoryOptionGroupAttribute() {
        return categoryOptionGroupAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionGroupAttribute")
    public void setCategoryOptionGroupAttribute(Boolean categoryOptionGroupAttribute) {
        this.categoryOptionGroupAttribute = categoryOptionGroupAttribute;
    }

    public Attribute withCategoryOptionGroupAttribute(Boolean categoryOptionGroupAttribute) {
        this.categoryOptionGroupAttribute = categoryOptionGroupAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionGroupSetAttribute")
    public Boolean getCategoryOptionGroupSetAttribute() {
        return categoryOptionGroupSetAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionGroupSetAttribute")
    public void setCategoryOptionGroupSetAttribute(Boolean categoryOptionGroupSetAttribute) {
        this.categoryOptionGroupSetAttribute = categoryOptionGroupSetAttribute;
    }

    public Attribute withCategoryOptionGroupSetAttribute(Boolean categoryOptionGroupSetAttribute) {
        this.categoryOptionGroupSetAttribute = categoryOptionGroupSetAttribute;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Attribute withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("constantAttribute")
    public Boolean getConstantAttribute() {
        return constantAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("constantAttribute")
    public void setConstantAttribute(Boolean constantAttribute) {
        this.constantAttribute = constantAttribute;
    }

    public Attribute withConstantAttribute(Boolean constantAttribute) {
        this.constantAttribute = constantAttribute;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Attribute withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public Attribute withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementAttribute")
    public Boolean getDataElementAttribute() {
        return dataElementAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementAttribute")
    public void setDataElementAttribute(Boolean dataElementAttribute) {
        this.dataElementAttribute = dataElementAttribute;
    }

    public Attribute withDataElementAttribute(Boolean dataElementAttribute) {
        this.dataElementAttribute = dataElementAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementGroupAttribute")
    public Boolean getDataElementGroupAttribute() {
        return dataElementGroupAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementGroupAttribute")
    public void setDataElementGroupAttribute(Boolean dataElementGroupAttribute) {
        this.dataElementGroupAttribute = dataElementGroupAttribute;
    }

    public Attribute withDataElementGroupAttribute(Boolean dataElementGroupAttribute) {
        this.dataElementGroupAttribute = dataElementGroupAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementGroupSetAttribute")
    public Boolean getDataElementGroupSetAttribute() {
        return dataElementGroupSetAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementGroupSetAttribute")
    public void setDataElementGroupSetAttribute(Boolean dataElementGroupSetAttribute) {
        this.dataElementGroupSetAttribute = dataElementGroupSetAttribute;
    }

    public Attribute withDataElementGroupSetAttribute(Boolean dataElementGroupSetAttribute) {
        this.dataElementGroupSetAttribute = dataElementGroupSetAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataSetAttribute")
    public Boolean getDataSetAttribute() {
        return dataSetAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataSetAttribute")
    public void setDataSetAttribute(Boolean dataSetAttribute) {
        this.dataSetAttribute = dataSetAttribute;
    }

    public Attribute withDataSetAttribute(Boolean dataSetAttribute) {
        this.dataSetAttribute = dataSetAttribute;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Attribute withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Attribute withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Attribute withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Attribute withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Attribute withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("documentAttribute")
    public Boolean getDocumentAttribute() {
        return documentAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("documentAttribute")
    public void setDocumentAttribute(Boolean documentAttribute) {
        this.documentAttribute = documentAttribute;
    }

    public Attribute withDocumentAttribute(Boolean documentAttribute) {
        this.documentAttribute = documentAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventChartAttribute")
    public Boolean getEventChartAttribute() {
        return eventChartAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventChartAttribute")
    public void setEventChartAttribute(Boolean eventChartAttribute) {
        this.eventChartAttribute = eventChartAttribute;
    }

    public Attribute withEventChartAttribute(Boolean eventChartAttribute) {
        this.eventChartAttribute = eventChartAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventReportAttribute")
    public Boolean getEventReportAttribute() {
        return eventReportAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventReportAttribute")
    public void setEventReportAttribute(Boolean eventReportAttribute) {
        this.eventReportAttribute = eventReportAttribute;
    }

    public Attribute withEventReportAttribute(Boolean eventReportAttribute) {
        this.eventReportAttribute = eventReportAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Attribute withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Attribute withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Attribute withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Attribute withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Attribute withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Attribute withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("indicatorAttribute")
    public Boolean getIndicatorAttribute() {
        return indicatorAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("indicatorAttribute")
    public void setIndicatorAttribute(Boolean indicatorAttribute) {
        this.indicatorAttribute = indicatorAttribute;
    }

    public Attribute withIndicatorAttribute(Boolean indicatorAttribute) {
        this.indicatorAttribute = indicatorAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("indicatorGroupAttribute")
    public Boolean getIndicatorGroupAttribute() {
        return indicatorGroupAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("indicatorGroupAttribute")
    public void setIndicatorGroupAttribute(Boolean indicatorGroupAttribute) {
        this.indicatorGroupAttribute = indicatorGroupAttribute;
    }

    public Attribute withIndicatorGroupAttribute(Boolean indicatorGroupAttribute) {
        this.indicatorGroupAttribute = indicatorGroupAttribute;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Attribute withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Attribute withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("legendSetAttribute")
    public Boolean getLegendSetAttribute() {
        return legendSetAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("legendSetAttribute")
    public void setLegendSetAttribute(Boolean legendSetAttribute) {
        this.legendSetAttribute = legendSetAttribute;
    }

    public Attribute withLegendSetAttribute(Boolean legendSetAttribute) {
        this.legendSetAttribute = legendSetAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mandatory")
    public Boolean getMandatory() {
        return mandatory;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Attribute withMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mapAttribute")
    public Boolean getMapAttribute() {
        return mapAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mapAttribute")
    public void setMapAttribute(Boolean mapAttribute) {
        this.mapAttribute = mapAttribute;
    }

    public Attribute withMapAttribute(Boolean mapAttribute) {
        this.mapAttribute = mapAttribute;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Attribute withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("objectTypes")
    public Optional<List<String>> getObjectTypes() {
        return Optional.ofNullable(objectTypes);
    }

    @JsonProperty("objectTypes")
    public void setObjectTypes(List<String> objectTypes) {
        this.objectTypes = objectTypes;
    }

    public Attribute withObjectTypes(List<String> objectTypes) {
        this.objectTypes = objectTypes;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("optionAttribute")
    public Boolean getOptionAttribute() {
        return optionAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("optionAttribute")
    public void setOptionAttribute(Boolean optionAttribute) {
        this.optionAttribute = optionAttribute;
    }

    public Attribute withOptionAttribute(Boolean optionAttribute) {
        this.optionAttribute = optionAttribute;
        return this;
    }

    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    public Optional<RefOptionSet> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    public void setOptionSet(RefOptionSet optionSet) {
        this.optionSet = optionSet;
    }

    public Attribute withOptionSet(RefOptionSet optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("optionSetAttribute")
    public Boolean getOptionSetAttribute() {
        return optionSetAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("optionSetAttribute")
    public void setOptionSetAttribute(Boolean optionSetAttribute) {
        this.optionSetAttribute = optionSetAttribute;
    }

    public Attribute withOptionSetAttribute(Boolean optionSetAttribute) {
        this.optionSetAttribute = optionSetAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitAttribute")
    public Boolean getOrganisationUnitAttribute() {
        return organisationUnitAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitAttribute")
    public void setOrganisationUnitAttribute(Boolean organisationUnitAttribute) {
        this.organisationUnitAttribute = organisationUnitAttribute;
    }

    public Attribute withOrganisationUnitAttribute(Boolean organisationUnitAttribute) {
        this.organisationUnitAttribute = organisationUnitAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitGroupAttribute")
    public Boolean getOrganisationUnitGroupAttribute() {
        return organisationUnitGroupAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitGroupAttribute")
    public void setOrganisationUnitGroupAttribute(Boolean organisationUnitGroupAttribute) {
        this.organisationUnitGroupAttribute = organisationUnitGroupAttribute;
    }

    public Attribute withOrganisationUnitGroupAttribute(Boolean organisationUnitGroupAttribute) {
        this.organisationUnitGroupAttribute = organisationUnitGroupAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitGroupSetAttribute")
    public Boolean getOrganisationUnitGroupSetAttribute() {
        return organisationUnitGroupSetAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("organisationUnitGroupSetAttribute")
    public void setOrganisationUnitGroupSetAttribute(Boolean organisationUnitGroupSetAttribute) {
        this.organisationUnitGroupSetAttribute = organisationUnitGroupSetAttribute;
    }

    public Attribute withOrganisationUnitGroupSetAttribute(Boolean organisationUnitGroupSetAttribute) {
        this.organisationUnitGroupSetAttribute = organisationUnitGroupSetAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programAttribute")
    public Boolean getProgramAttribute() {
        return programAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programAttribute")
    public void setProgramAttribute(Boolean programAttribute) {
        this.programAttribute = programAttribute;
    }

    public Attribute withProgramAttribute(Boolean programAttribute) {
        this.programAttribute = programAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programIndicatorAttribute")
    public Boolean getProgramIndicatorAttribute() {
        return programIndicatorAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programIndicatorAttribute")
    public void setProgramIndicatorAttribute(Boolean programIndicatorAttribute) {
        this.programIndicatorAttribute = programIndicatorAttribute;
    }

    public Attribute withProgramIndicatorAttribute(Boolean programIndicatorAttribute) {
        this.programIndicatorAttribute = programIndicatorAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programStageAttribute")
    public Boolean getProgramStageAttribute() {
        return programStageAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programStageAttribute")
    public void setProgramStageAttribute(Boolean programStageAttribute) {
        this.programStageAttribute = programStageAttribute;
    }

    public Attribute withProgramStageAttribute(Boolean programStageAttribute) {
        this.programStageAttribute = programStageAttribute;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Attribute withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("relationshipTypeAttribute")
    public Boolean getRelationshipTypeAttribute() {
        return relationshipTypeAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("relationshipTypeAttribute")
    public void setRelationshipTypeAttribute(Boolean relationshipTypeAttribute) {
        this.relationshipTypeAttribute = relationshipTypeAttribute;
    }

    public Attribute withRelationshipTypeAttribute(Boolean relationshipTypeAttribute) {
        this.relationshipTypeAttribute = relationshipTypeAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sectionAttribute")
    public Boolean getSectionAttribute() {
        return sectionAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sectionAttribute")
    public void setSectionAttribute(Boolean sectionAttribute) {
        this.sectionAttribute = sectionAttribute;
    }

    public Attribute withSectionAttribute(Boolean sectionAttribute) {
        this.sectionAttribute = sectionAttribute;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Attribute withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Attribute withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Attribute withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sqlViewAttribute")
    public Boolean getSqlViewAttribute() {
        return sqlViewAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sqlViewAttribute")
    public void setSqlViewAttribute(Boolean sqlViewAttribute) {
        this.sqlViewAttribute = sqlViewAttribute;
    }

    public Attribute withSqlViewAttribute(Boolean sqlViewAttribute) {
        this.sqlViewAttribute = sqlViewAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityAttributeAttribute")
    public Boolean getTrackedEntityAttributeAttribute() {
        return trackedEntityAttributeAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityAttributeAttribute")
    public void setTrackedEntityAttributeAttribute(Boolean trackedEntityAttributeAttribute) {
        this.trackedEntityAttributeAttribute = trackedEntityAttributeAttribute;
    }

    public Attribute withTrackedEntityAttributeAttribute(Boolean trackedEntityAttributeAttribute) {
        this.trackedEntityAttributeAttribute = trackedEntityAttributeAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityTypeAttribute")
    public Boolean getTrackedEntityTypeAttribute() {
        return trackedEntityTypeAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityTypeAttribute")
    public void setTrackedEntityTypeAttribute(Boolean trackedEntityTypeAttribute) {
        this.trackedEntityTypeAttribute = trackedEntityTypeAttribute;
    }

    public Attribute withTrackedEntityTypeAttribute(Boolean trackedEntityTypeAttribute) {
        this.trackedEntityTypeAttribute = trackedEntityTypeAttribute;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Attribute withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unique")
    public Boolean getUnique() {
        return unique;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unique")
    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public Attribute withUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public Attribute withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Attribute withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userAttribute")
    public Boolean getUserAttribute() {
        return userAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userAttribute")
    public void setUserAttribute(Boolean userAttribute) {
        this.userAttribute = userAttribute;
    }

    public Attribute withUserAttribute(Boolean userAttribute) {
        this.userAttribute = userAttribute;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Attribute withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userGroupAttribute")
    public Boolean getUserGroupAttribute() {
        return userGroupAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userGroupAttribute")
    public void setUserGroupAttribute(Boolean userGroupAttribute) {
        this.userGroupAttribute = userGroupAttribute;
    }

    public Attribute withUserGroupAttribute(Boolean userGroupAttribute) {
        this.userGroupAttribute = userGroupAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationRuleAttribute")
    public Boolean getValidationRuleAttribute() {
        return validationRuleAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationRuleAttribute")
    public void setValidationRuleAttribute(Boolean validationRuleAttribute) {
        this.validationRuleAttribute = validationRuleAttribute;
    }

    public Attribute withValidationRuleAttribute(Boolean validationRuleAttribute) {
        this.validationRuleAttribute = validationRuleAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationRuleGroupAttribute")
    public Boolean getValidationRuleGroupAttribute() {
        return validationRuleGroupAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationRuleGroupAttribute")
    public void setValidationRuleGroupAttribute(Boolean validationRuleGroupAttribute) {
        this.validationRuleGroupAttribute = validationRuleGroupAttribute;
    }

    public Attribute withValidationRuleGroupAttribute(Boolean validationRuleGroupAttribute) {
        this.validationRuleGroupAttribute = validationRuleGroupAttribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public Attribute.ValueType getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(Attribute.ValueType valueType) {
        this.valueType = valueType;
    }

    public Attribute withValueType(Attribute.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("visualizationAttribute")
    public Boolean getVisualizationAttribute() {
        return visualizationAttribute;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("visualizationAttribute")
    public void setVisualizationAttribute(Boolean visualizationAttribute) {
        this.visualizationAttribute = visualizationAttribute;
    }

    public Attribute withVisualizationAttribute(Boolean visualizationAttribute) {
        this.visualizationAttribute = visualizationAttribute;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Attribute withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("categoryAttribute".equals(name)) {
                    if (value instanceof Boolean) {
                        setCategoryAttribute(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"categoryAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("categoryOptionAttribute".equals(name)) {
                        if (value instanceof Boolean) {
                            setCategoryOptionAttribute(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"categoryOptionAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("categoryOptionComboAttribute".equals(name)) {
                            if (value instanceof Boolean) {
                                setCategoryOptionComboAttribute(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"categoryOptionComboAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("categoryOptionGroupAttribute".equals(name)) {
                                if (value instanceof Boolean) {
                                    setCategoryOptionGroupAttribute(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"categoryOptionGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("categoryOptionGroupSetAttribute".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setCategoryOptionGroupSetAttribute(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"categoryOptionGroupSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("code".equals(name)) {
                                        if (value instanceof String) {
                                            setCode(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("constantAttribute".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setConstantAttribute(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"constantAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("created".equals(name)) {
                                                if (value instanceof Date) {
                                                    setCreated(((Date) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("createdBy".equals(name)) {
                                                    if (value instanceof RefUser) {
                                                        setCreatedBy(((RefUser) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("dataElementAttribute".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setDataElementAttribute(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"dataElementAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("dataElementGroupAttribute".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setDataElementGroupAttribute(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"dataElementGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("dataElementGroupSetAttribute".equals(name)) {
                                                                if (value instanceof Boolean) {
                                                                    setDataElementGroupSetAttribute(((Boolean) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"dataElementGroupSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("dataSetAttribute".equals(name)) {
                                                                    if (value instanceof Boolean) {
                                                                        setDataSetAttribute(((Boolean) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"dataSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("description".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setDescription(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("displayDescription".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setDisplayDescription(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("displayFormName".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setDisplayFormName(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("displayName".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setDisplayName(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("displayShortName".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setDisplayShortName(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("documentAttribute".equals(name)) {
                                                                                            if (value instanceof Boolean) {
                                                                                                setDocumentAttribute(((Boolean) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"documentAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("eventChartAttribute".equals(name)) {
                                                                                                if (value instanceof Boolean) {
                                                                                                    setEventChartAttribute(((Boolean) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"eventChartAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("eventReportAttribute".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setEventReportAttribute(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"eventReportAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("externalAccess".equals(name)) {
                                                                                                        if (value instanceof Boolean) {
                                                                                                            setExternalAccess(((Boolean) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("favorite".equals(name)) {
                                                                                                            if (value instanceof Boolean) {
                                                                                                                setFavorite(((Boolean) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("favorites".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setFavorites(((List<String> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("formName".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setFormName(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("href".equals(name)) {
                                                                                                                        if (value instanceof String) {
                                                                                                                            setHref(((String) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("id".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setId(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("indicatorAttribute".equals(name)) {
                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                    setIndicatorAttribute(((Boolean) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"indicatorAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("indicatorGroupAttribute".equals(name)) {
                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                        setIndicatorGroupAttribute(((Boolean) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"indicatorGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("lastUpdated".equals(name)) {
                                                                                                                                        if (value instanceof Date) {
                                                                                                                                            setLastUpdated(((Date) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                                                                            if (value instanceof RefUser) {
                                                                                                                                                setLastUpdatedBy(((RefUser) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("legendSetAttribute".equals(name)) {
                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                    setLegendSetAttribute(((Boolean) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"legendSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("mandatory".equals(name)) {
                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                        setMandatory(((Boolean) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"mandatory\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("mapAttribute".equals(name)) {
                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                            setMapAttribute(((Boolean) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"mapAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("name".equals(name)) {
                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                setName(((String) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("objectTypes".equals(name)) {
                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                    setObjectTypes(((List<String> ) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"objectTypes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("optionAttribute".equals(name)) {
                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                        setOptionAttribute(((Boolean) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"optionAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("optionSet".equals(name)) {
                                                                                                                                                                        if (value instanceof RefOptionSet) {
                                                                                                                                                                            setOptionSet(((RefOptionSet) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"optionSet\" is of type \"org.hisp.dhis.api.model.v40_0.RefOptionSet\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("optionSetAttribute".equals(name)) {
                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                setOptionSetAttribute(((Boolean) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"optionSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("organisationUnitAttribute".equals(name)) {
                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                    setOrganisationUnitAttribute(((Boolean) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"organisationUnitAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("organisationUnitGroupAttribute".equals(name)) {
                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                        setOrganisationUnitGroupAttribute(((Boolean) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"organisationUnitGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("organisationUnitGroupSetAttribute".equals(name)) {
                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                            setOrganisationUnitGroupSetAttribute(((Boolean) value));
                                                                                                                                                                                        } else {
                                                                                                                                                                                            throw new IllegalArgumentException(("property \"organisationUnitGroupSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                        }
                                                                                                                                                                                        return true;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("programAttribute".equals(name)) {
                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                setProgramAttribute(((Boolean) value));
                                                                                                                                                                                            } else {
                                                                                                                                                                                                throw new IllegalArgumentException(("property \"programAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                            }
                                                                                                                                                                                            return true;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("programIndicatorAttribute".equals(name)) {
                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                    setProgramIndicatorAttribute(((Boolean) value));
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"programIndicatorAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                }
                                                                                                                                                                                                return true;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("programStageAttribute".equals(name)) {
                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                        setProgramStageAttribute(((Boolean) value));
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"programStageAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                    }
                                                                                                                                                                                                    return true;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                                            setPublicAccess(((String) value));
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        return true;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("relationshipTypeAttribute".equals(name)) {
                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                setRelationshipTypeAttribute(((Boolean) value));
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"relationshipTypeAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                            }
                                                                                                                                                                                                            return true;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("sectionAttribute".equals(name)) {
                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                    setSectionAttribute(((Boolean) value));
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"sectionAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                }
                                                                                                                                                                                                                return true;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("sharing".equals(name)) {
                                                                                                                                                                                                                    if (value instanceof Sharing) {
                                                                                                                                                                                                                        setSharing(((Sharing) value));
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("shortName".equals(name)) {
                                                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                                                            setShortName(((String) value));
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                            if (value instanceof Integer) {
                                                                                                                                                                                                                                setSortOrder(((Integer) value));
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("sqlViewAttribute".equals(name)) {
                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                    setSqlViewAttribute(((Boolean) value));
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"sqlViewAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("trackedEntityAttributeAttribute".equals(name)) {
                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                        setTrackedEntityAttributeAttribute(((Boolean) value));
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"trackedEntityAttributeAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("trackedEntityTypeAttribute".equals(name)) {
                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                            setTrackedEntityTypeAttribute(((Boolean) value));
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"trackedEntityTypeAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                setTranslations(((List<Translation> ) value));
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("unique".equals(name)) {
                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                    setUnique(((Boolean) value));
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"unique\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("user".equals(name)) {
                                                                                                                                                                                                                                                    if (value instanceof RefUser) {
                                                                                                                                                                                                                                                        setUser(((RefUser) value));
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                                            setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("userAttribute".equals(name)) {
                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                setUserAttribute(((Boolean) value));
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"userAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("userGroupAttribute".equals(name)) {
                                                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                        setUserGroupAttribute(((Boolean) value));
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    if ("validationRuleAttribute".equals(name)) {
                                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                            setValidationRuleAttribute(((Boolean) value));
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"validationRuleAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        if ("validationRuleGroupAttribute".equals(name)) {
                                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                setValidationRuleGroupAttribute(((Boolean) value));
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"validationRuleGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            if ("valueType".equals(name)) {
                                                                                                                                                                                                                                                                                if (value instanceof Attribute.ValueType) {
                                                                                                                                                                                                                                                                                    setValueType(((Attribute.ValueType) value));
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.Attribute.ValueType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                if ("visualizationAttribute".equals(name)) {
                                                                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                        setVisualizationAttribute(((Boolean) value));
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"visualizationAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("categoryAttribute".equals(name)) {
                    return getCategoryAttribute();
                } else {
                    if ("categoryOptionAttribute".equals(name)) {
                        return getCategoryOptionAttribute();
                    } else {
                        if ("categoryOptionComboAttribute".equals(name)) {
                            return getCategoryOptionComboAttribute();
                        } else {
                            if ("categoryOptionGroupAttribute".equals(name)) {
                                return getCategoryOptionGroupAttribute();
                            } else {
                                if ("categoryOptionGroupSetAttribute".equals(name)) {
                                    return getCategoryOptionGroupSetAttribute();
                                } else {
                                    if ("code".equals(name)) {
                                        return getCode();
                                    } else {
                                        if ("constantAttribute".equals(name)) {
                                            return getConstantAttribute();
                                        } else {
                                            if ("created".equals(name)) {
                                                return getCreated();
                                            } else {
                                                if ("createdBy".equals(name)) {
                                                    return getCreatedBy();
                                                } else {
                                                    if ("dataElementAttribute".equals(name)) {
                                                        return getDataElementAttribute();
                                                    } else {
                                                        if ("dataElementGroupAttribute".equals(name)) {
                                                            return getDataElementGroupAttribute();
                                                        } else {
                                                            if ("dataElementGroupSetAttribute".equals(name)) {
                                                                return getDataElementGroupSetAttribute();
                                                            } else {
                                                                if ("dataSetAttribute".equals(name)) {
                                                                    return getDataSetAttribute();
                                                                } else {
                                                                    if ("description".equals(name)) {
                                                                        return getDescription();
                                                                    } else {
                                                                        if ("displayDescription".equals(name)) {
                                                                            return getDisplayDescription();
                                                                        } else {
                                                                            if ("displayFormName".equals(name)) {
                                                                                return getDisplayFormName();
                                                                            } else {
                                                                                if ("displayName".equals(name)) {
                                                                                    return getDisplayName();
                                                                                } else {
                                                                                    if ("displayShortName".equals(name)) {
                                                                                        return getDisplayShortName();
                                                                                    } else {
                                                                                        if ("documentAttribute".equals(name)) {
                                                                                            return getDocumentAttribute();
                                                                                        } else {
                                                                                            if ("eventChartAttribute".equals(name)) {
                                                                                                return getEventChartAttribute();
                                                                                            } else {
                                                                                                if ("eventReportAttribute".equals(name)) {
                                                                                                    return getEventReportAttribute();
                                                                                                } else {
                                                                                                    if ("externalAccess".equals(name)) {
                                                                                                        return getExternalAccess();
                                                                                                    } else {
                                                                                                        if ("favorite".equals(name)) {
                                                                                                            return getFavorite();
                                                                                                        } else {
                                                                                                            if ("favorites".equals(name)) {
                                                                                                                return getFavorites();
                                                                                                            } else {
                                                                                                                if ("formName".equals(name)) {
                                                                                                                    return getFormName();
                                                                                                                } else {
                                                                                                                    if ("href".equals(name)) {
                                                                                                                        return getHref();
                                                                                                                    } else {
                                                                                                                        if ("id".equals(name)) {
                                                                                                                            return getId();
                                                                                                                        } else {
                                                                                                                            if ("indicatorAttribute".equals(name)) {
                                                                                                                                return getIndicatorAttribute();
                                                                                                                            } else {
                                                                                                                                if ("indicatorGroupAttribute".equals(name)) {
                                                                                                                                    return getIndicatorGroupAttribute();
                                                                                                                                } else {
                                                                                                                                    if ("lastUpdated".equals(name)) {
                                                                                                                                        return getLastUpdated();
                                                                                                                                    } else {
                                                                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                                                                            return getLastUpdatedBy();
                                                                                                                                        } else {
                                                                                                                                            if ("legendSetAttribute".equals(name)) {
                                                                                                                                                return getLegendSetAttribute();
                                                                                                                                            } else {
                                                                                                                                                if ("mandatory".equals(name)) {
                                                                                                                                                    return getMandatory();
                                                                                                                                                } else {
                                                                                                                                                    if ("mapAttribute".equals(name)) {
                                                                                                                                                        return getMapAttribute();
                                                                                                                                                    } else {
                                                                                                                                                        if ("name".equals(name)) {
                                                                                                                                                            return getName();
                                                                                                                                                        } else {
                                                                                                                                                            if ("objectTypes".equals(name)) {
                                                                                                                                                                return getObjectTypes();
                                                                                                                                                            } else {
                                                                                                                                                                if ("optionAttribute".equals(name)) {
                                                                                                                                                                    return getOptionAttribute();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("optionSet".equals(name)) {
                                                                                                                                                                        return getOptionSet();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("optionSetAttribute".equals(name)) {
                                                                                                                                                                            return getOptionSetAttribute();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("organisationUnitAttribute".equals(name)) {
                                                                                                                                                                                return getOrganisationUnitAttribute();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("organisationUnitGroupAttribute".equals(name)) {
                                                                                                                                                                                    return getOrganisationUnitGroupAttribute();
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("organisationUnitGroupSetAttribute".equals(name)) {
                                                                                                                                                                                        return getOrganisationUnitGroupSetAttribute();
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("programAttribute".equals(name)) {
                                                                                                                                                                                            return getProgramAttribute();
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("programIndicatorAttribute".equals(name)) {
                                                                                                                                                                                                return getProgramIndicatorAttribute();
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("programStageAttribute".equals(name)) {
                                                                                                                                                                                                    return getProgramStageAttribute();
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                                                                                                                        return getPublicAccess();
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("relationshipTypeAttribute".equals(name)) {
                                                                                                                                                                                                            return getRelationshipTypeAttribute();
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("sectionAttribute".equals(name)) {
                                                                                                                                                                                                                return getSectionAttribute();
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("sharing".equals(name)) {
                                                                                                                                                                                                                    return getSharing();
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("shortName".equals(name)) {
                                                                                                                                                                                                                        return getShortName();
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                            return getSortOrder();
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("sqlViewAttribute".equals(name)) {
                                                                                                                                                                                                                                return getSqlViewAttribute();
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("trackedEntityAttributeAttribute".equals(name)) {
                                                                                                                                                                                                                                    return getTrackedEntityAttributeAttribute();
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("trackedEntityTypeAttribute".equals(name)) {
                                                                                                                                                                                                                                        return getTrackedEntityTypeAttribute();
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                                                                                                            return getTranslations();
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("unique".equals(name)) {
                                                                                                                                                                                                                                                return getUnique();
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("user".equals(name)) {
                                                                                                                                                                                                                                                    return getUser();
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                        return getUserAccesses();
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("userAttribute".equals(name)) {
                                                                                                                                                                                                                                                            return getUserAttribute();
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                                return getUserGroupAccesses();
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("userGroupAttribute".equals(name)) {
                                                                                                                                                                                                                                                                    return getUserGroupAttribute();
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    if ("validationRuleAttribute".equals(name)) {
                                                                                                                                                                                                                                                                        return getValidationRuleAttribute();
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        if ("validationRuleGroupAttribute".equals(name)) {
                                                                                                                                                                                                                                                                            return getValidationRuleGroupAttribute();
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            if ("valueType".equals(name)) {
                                                                                                                                                                                                                                                                                return getValueType();
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                if ("visualizationAttribute".equals(name)) {
                                                                                                                                                                                                                                                                                    return getVisualizationAttribute();
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Attribute.NOT_FOUND_VALUE);
        if (Attribute.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Attribute with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Attribute.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryAttribute");
        sb.append('=');
        sb.append(((this.categoryAttribute == null)?"<null>":this.categoryAttribute));
        sb.append(',');
        sb.append("categoryOptionAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionAttribute == null)?"<null>":this.categoryOptionAttribute));
        sb.append(',');
        sb.append("categoryOptionComboAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionComboAttribute == null)?"<null>":this.categoryOptionComboAttribute));
        sb.append(',');
        sb.append("categoryOptionGroupAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionGroupAttribute == null)?"<null>":this.categoryOptionGroupAttribute));
        sb.append(',');
        sb.append("categoryOptionGroupSetAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetAttribute == null)?"<null>":this.categoryOptionGroupSetAttribute));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("constantAttribute");
        sb.append('=');
        sb.append(((this.constantAttribute == null)?"<null>":this.constantAttribute));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataElementAttribute");
        sb.append('=');
        sb.append(((this.dataElementAttribute == null)?"<null>":this.dataElementAttribute));
        sb.append(',');
        sb.append("dataElementGroupAttribute");
        sb.append('=');
        sb.append(((this.dataElementGroupAttribute == null)?"<null>":this.dataElementGroupAttribute));
        sb.append(',');
        sb.append("dataElementGroupSetAttribute");
        sb.append('=');
        sb.append(((this.dataElementGroupSetAttribute == null)?"<null>":this.dataElementGroupSetAttribute));
        sb.append(',');
        sb.append("dataSetAttribute");
        sb.append('=');
        sb.append(((this.dataSetAttribute == null)?"<null>":this.dataSetAttribute));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("documentAttribute");
        sb.append('=');
        sb.append(((this.documentAttribute == null)?"<null>":this.documentAttribute));
        sb.append(',');
        sb.append("eventChartAttribute");
        sb.append('=');
        sb.append(((this.eventChartAttribute == null)?"<null>":this.eventChartAttribute));
        sb.append(',');
        sb.append("eventReportAttribute");
        sb.append('=');
        sb.append(((this.eventReportAttribute == null)?"<null>":this.eventReportAttribute));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("indicatorAttribute");
        sb.append('=');
        sb.append(((this.indicatorAttribute == null)?"<null>":this.indicatorAttribute));
        sb.append(',');
        sb.append("indicatorGroupAttribute");
        sb.append('=');
        sb.append(((this.indicatorGroupAttribute == null)?"<null>":this.indicatorGroupAttribute));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSetAttribute");
        sb.append('=');
        sb.append(((this.legendSetAttribute == null)?"<null>":this.legendSetAttribute));
        sb.append(',');
        sb.append("mandatory");
        sb.append('=');
        sb.append(((this.mandatory == null)?"<null>":this.mandatory));
        sb.append(',');
        sb.append("mapAttribute");
        sb.append('=');
        sb.append(((this.mapAttribute == null)?"<null>":this.mapAttribute));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("objectTypes");
        sb.append('=');
        sb.append(((this.objectTypes == null)?"<null>":this.objectTypes));
        sb.append(',');
        sb.append("optionAttribute");
        sb.append('=');
        sb.append(((this.optionAttribute == null)?"<null>":this.optionAttribute));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("optionSetAttribute");
        sb.append('=');
        sb.append(((this.optionSetAttribute == null)?"<null>":this.optionSetAttribute));
        sb.append(',');
        sb.append("organisationUnitAttribute");
        sb.append('=');
        sb.append(((this.organisationUnitAttribute == null)?"<null>":this.organisationUnitAttribute));
        sb.append(',');
        sb.append("organisationUnitGroupAttribute");
        sb.append('=');
        sb.append(((this.organisationUnitGroupAttribute == null)?"<null>":this.organisationUnitGroupAttribute));
        sb.append(',');
        sb.append("organisationUnitGroupSetAttribute");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetAttribute == null)?"<null>":this.organisationUnitGroupSetAttribute));
        sb.append(',');
        sb.append("programAttribute");
        sb.append('=');
        sb.append(((this.programAttribute == null)?"<null>":this.programAttribute));
        sb.append(',');
        sb.append("programIndicatorAttribute");
        sb.append('=');
        sb.append(((this.programIndicatorAttribute == null)?"<null>":this.programIndicatorAttribute));
        sb.append(',');
        sb.append("programStageAttribute");
        sb.append('=');
        sb.append(((this.programStageAttribute == null)?"<null>":this.programStageAttribute));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("relationshipTypeAttribute");
        sb.append('=');
        sb.append(((this.relationshipTypeAttribute == null)?"<null>":this.relationshipTypeAttribute));
        sb.append(',');
        sb.append("sectionAttribute");
        sb.append('=');
        sb.append(((this.sectionAttribute == null)?"<null>":this.sectionAttribute));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("sqlViewAttribute");
        sb.append('=');
        sb.append(((this.sqlViewAttribute == null)?"<null>":this.sqlViewAttribute));
        sb.append(',');
        sb.append("trackedEntityAttributeAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttributeAttribute == null)?"<null>":this.trackedEntityAttributeAttribute));
        sb.append(',');
        sb.append("trackedEntityTypeAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityTypeAttribute == null)?"<null>":this.trackedEntityTypeAttribute));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("unique");
        sb.append('=');
        sb.append(((this.unique == null)?"<null>":this.unique));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userAttribute");
        sb.append('=');
        sb.append(((this.userAttribute == null)?"<null>":this.userAttribute));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userGroupAttribute");
        sb.append('=');
        sb.append(((this.userGroupAttribute == null)?"<null>":this.userGroupAttribute));
        sb.append(',');
        sb.append("validationRuleAttribute");
        sb.append('=');
        sb.append(((this.validationRuleAttribute == null)?"<null>":this.validationRuleAttribute));
        sb.append(',');
        sb.append("validationRuleGroupAttribute");
        sb.append('=');
        sb.append(((this.validationRuleGroupAttribute == null)?"<null>":this.validationRuleGroupAttribute));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("visualizationAttribute");
        sb.append('=');
        sb.append(((this.visualizationAttribute == null)?"<null>":this.visualizationAttribute));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indicatorAttribute == null)? 0 :this.indicatorAttribute.hashCode()));
        result = ((result* 31)+((this.indicatorGroupAttribute == null)? 0 :this.indicatorGroupAttribute.hashCode()));
        result = ((result* 31)+((this.mapAttribute == null)? 0 :this.mapAttribute.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userGroupAttribute == null)? 0 :this.userGroupAttribute.hashCode()));
        result = ((result* 31)+((this.dataElementAttribute == null)? 0 :this.dataElementAttribute.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.constantAttribute == null)? 0 :this.constantAttribute.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.categoryOptionAttribute == null)? 0 :this.categoryOptionAttribute.hashCode()));
        result = ((result* 31)+((this.eventChartAttribute == null)? 0 :this.eventChartAttribute.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.optionSetAttribute == null)? 0 :this.optionSetAttribute.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.sqlViewAttribute == null)? 0 :this.sqlViewAttribute.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.visualizationAttribute == null)? 0 :this.visualizationAttribute.hashCode()));
        result = ((result* 31)+((this.legendSetAttribute == null)? 0 :this.legendSetAttribute.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.organisationUnitAttribute == null)? 0 :this.organisationUnitAttribute.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttributeAttribute == null)? 0 :this.trackedEntityAttributeAttribute.hashCode()));
        result = ((result* 31)+((this.dataSetAttribute == null)? 0 :this.dataSetAttribute.hashCode()));
        result = ((result* 31)+((this.documentAttribute == null)? 0 :this.documentAttribute.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.unique == null)? 0 :this.unique.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.validationRuleGroupAttribute == null)? 0 :this.validationRuleGroupAttribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.objectTypes == null)? 0 :this.objectTypes.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.dataElementGroupAttribute == null)? 0 :this.dataElementGroupAttribute.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.sectionAttribute == null)? 0 :this.sectionAttribute.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.trackedEntityTypeAttribute == null)? 0 :this.trackedEntityTypeAttribute.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.userAttribute == null)? 0 :this.userAttribute.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupAttribute == null)? 0 :this.categoryOptionGroupAttribute.hashCode()));
        result = ((result* 31)+((this.mandatory == null)? 0 :this.mandatory.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.eventReportAttribute == null)? 0 :this.eventReportAttribute.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.programStageAttribute == null)? 0 :this.programStageAttribute.hashCode()));
        result = ((result* 31)+((this.programAttribute == null)? 0 :this.programAttribute.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.categoryAttribute == null)? 0 :this.categoryAttribute.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboAttribute == null)? 0 :this.categoryOptionComboAttribute.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetAttribute == null)? 0 :this.categoryOptionGroupSetAttribute.hashCode()));
        result = ((result* 31)+((this.programIndicatorAttribute == null)? 0 :this.programIndicatorAttribute.hashCode()));
        result = ((result* 31)+((this.validationRuleAttribute == null)? 0 :this.validationRuleAttribute.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupAttribute == null)? 0 :this.organisationUnitGroupAttribute.hashCode()));
        result = ((result* 31)+((this.dataElementGroupSetAttribute == null)? 0 :this.dataElementGroupSetAttribute.hashCode()));
        result = ((result* 31)+((this.relationshipTypeAttribute == null)? 0 :this.relationshipTypeAttribute.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetAttribute == null)? 0 :this.organisationUnitGroupSetAttribute.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.optionAttribute == null)? 0 :this.optionAttribute.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Attribute) == false) {
            return false;
        }
        Attribute rhs = ((Attribute) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.indicatorAttribute == rhs.indicatorAttribute)||((this.indicatorAttribute!= null)&&this.indicatorAttribute.equals(rhs.indicatorAttribute)))&&((this.indicatorGroupAttribute == rhs.indicatorGroupAttribute)||((this.indicatorGroupAttribute!= null)&&this.indicatorGroupAttribute.equals(rhs.indicatorGroupAttribute))))&&((this.mapAttribute == rhs.mapAttribute)||((this.mapAttribute!= null)&&this.mapAttribute.equals(rhs.mapAttribute))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userGroupAttribute == rhs.userGroupAttribute)||((this.userGroupAttribute!= null)&&this.userGroupAttribute.equals(rhs.userGroupAttribute))))&&((this.dataElementAttribute == rhs.dataElementAttribute)||((this.dataElementAttribute!= null)&&this.dataElementAttribute.equals(rhs.dataElementAttribute))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.constantAttribute == rhs.constantAttribute)||((this.constantAttribute!= null)&&this.constantAttribute.equals(rhs.constantAttribute))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.categoryOptionAttribute == rhs.categoryOptionAttribute)||((this.categoryOptionAttribute!= null)&&this.categoryOptionAttribute.equals(rhs.categoryOptionAttribute))))&&((this.eventChartAttribute == rhs.eventChartAttribute)||((this.eventChartAttribute!= null)&&this.eventChartAttribute.equals(rhs.eventChartAttribute))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.optionSetAttribute == rhs.optionSetAttribute)||((this.optionSetAttribute!= null)&&this.optionSetAttribute.equals(rhs.optionSetAttribute))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.sqlViewAttribute == rhs.sqlViewAttribute)||((this.sqlViewAttribute!= null)&&this.sqlViewAttribute.equals(rhs.sqlViewAttribute))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.visualizationAttribute == rhs.visualizationAttribute)||((this.visualizationAttribute!= null)&&this.visualizationAttribute.equals(rhs.visualizationAttribute))))&&((this.legendSetAttribute == rhs.legendSetAttribute)||((this.legendSetAttribute!= null)&&this.legendSetAttribute.equals(rhs.legendSetAttribute))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.organisationUnitAttribute == rhs.organisationUnitAttribute)||((this.organisationUnitAttribute!= null)&&this.organisationUnitAttribute.equals(rhs.organisationUnitAttribute))))&&((this.trackedEntityAttributeAttribute == rhs.trackedEntityAttributeAttribute)||((this.trackedEntityAttributeAttribute!= null)&&this.trackedEntityAttributeAttribute.equals(rhs.trackedEntityAttributeAttribute))))&&((this.dataSetAttribute == rhs.dataSetAttribute)||((this.dataSetAttribute!= null)&&this.dataSetAttribute.equals(rhs.dataSetAttribute))))&&((this.documentAttribute == rhs.documentAttribute)||((this.documentAttribute!= null)&&this.documentAttribute.equals(rhs.documentAttribute))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.unique == rhs.unique)||((this.unique!= null)&&this.unique.equals(rhs.unique))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.validationRuleGroupAttribute == rhs.validationRuleGroupAttribute)||((this.validationRuleGroupAttribute!= null)&&this.validationRuleGroupAttribute.equals(rhs.validationRuleGroupAttribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.objectTypes == rhs.objectTypes)||((this.objectTypes!= null)&&this.objectTypes.equals(rhs.objectTypes))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.dataElementGroupAttribute == rhs.dataElementGroupAttribute)||((this.dataElementGroupAttribute!= null)&&this.dataElementGroupAttribute.equals(rhs.dataElementGroupAttribute))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.sectionAttribute == rhs.sectionAttribute)||((this.sectionAttribute!= null)&&this.sectionAttribute.equals(rhs.sectionAttribute))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.trackedEntityTypeAttribute == rhs.trackedEntityTypeAttribute)||((this.trackedEntityTypeAttribute!= null)&&this.trackedEntityTypeAttribute.equals(rhs.trackedEntityTypeAttribute))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.userAttribute == rhs.userAttribute)||((this.userAttribute!= null)&&this.userAttribute.equals(rhs.userAttribute))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.categoryOptionGroupAttribute == rhs.categoryOptionGroupAttribute)||((this.categoryOptionGroupAttribute!= null)&&this.categoryOptionGroupAttribute.equals(rhs.categoryOptionGroupAttribute))))&&((this.mandatory == rhs.mandatory)||((this.mandatory!= null)&&this.mandatory.equals(rhs.mandatory))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.eventReportAttribute == rhs.eventReportAttribute)||((this.eventReportAttribute!= null)&&this.eventReportAttribute.equals(rhs.eventReportAttribute))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.programStageAttribute == rhs.programStageAttribute)||((this.programStageAttribute!= null)&&this.programStageAttribute.equals(rhs.programStageAttribute))))&&((this.programAttribute == rhs.programAttribute)||((this.programAttribute!= null)&&this.programAttribute.equals(rhs.programAttribute))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.categoryAttribute == rhs.categoryAttribute)||((this.categoryAttribute!= null)&&this.categoryAttribute.equals(rhs.categoryAttribute))))&&((this.categoryOptionComboAttribute == rhs.categoryOptionComboAttribute)||((this.categoryOptionComboAttribute!= null)&&this.categoryOptionComboAttribute.equals(rhs.categoryOptionComboAttribute))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.categoryOptionGroupSetAttribute == rhs.categoryOptionGroupSetAttribute)||((this.categoryOptionGroupSetAttribute!= null)&&this.categoryOptionGroupSetAttribute.equals(rhs.categoryOptionGroupSetAttribute))))&&((this.programIndicatorAttribute == rhs.programIndicatorAttribute)||((this.programIndicatorAttribute!= null)&&this.programIndicatorAttribute.equals(rhs.programIndicatorAttribute))))&&((this.validationRuleAttribute == rhs.validationRuleAttribute)||((this.validationRuleAttribute!= null)&&this.validationRuleAttribute.equals(rhs.validationRuleAttribute))))&&((this.organisationUnitGroupAttribute == rhs.organisationUnitGroupAttribute)||((this.organisationUnitGroupAttribute!= null)&&this.organisationUnitGroupAttribute.equals(rhs.organisationUnitGroupAttribute))))&&((this.dataElementGroupSetAttribute == rhs.dataElementGroupSetAttribute)||((this.dataElementGroupSetAttribute!= null)&&this.dataElementGroupSetAttribute.equals(rhs.dataElementGroupSetAttribute))))&&((this.relationshipTypeAttribute == rhs.relationshipTypeAttribute)||((this.relationshipTypeAttribute!= null)&&this.relationshipTypeAttribute.equals(rhs.relationshipTypeAttribute))))&&((this.organisationUnitGroupSetAttribute == rhs.organisationUnitGroupSetAttribute)||((this.organisationUnitGroupSetAttribute!= null)&&this.organisationUnitGroupSetAttribute.equals(rhs.organisationUnitGroupSetAttribute))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.optionAttribute == rhs.optionAttribute)||((this.optionAttribute!= null)&&this.optionAttribute.equals(rhs.optionAttribute))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueType {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, Attribute.ValueType> CONSTANTS = new HashMap<String, Attribute.ValueType>();

        static {
            for (Attribute.ValueType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Attribute.ValueType fromValue(String value) {
            Attribute.ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
