
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "available",
    "message",
    "statusCode",
    "statusPhrase"
})
@Generated("jsonschema2pojo")
public class AvailabilityStatus implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("available")
    private Boolean available;
    @JsonProperty("message")
    private String message;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("statusCode")
    private Integer statusCode;
    @JsonProperty("statusPhrase")
    private String statusPhrase;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8507515062434730660L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AvailabilityStatus() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public AvailabilityStatus(AvailabilityStatus source) {
        super();
        this.available = source.available;
        this.message = source.message;
        this.statusCode = source.statusCode;
        this.statusPhrase = source.statusPhrase;
    }

    public AvailabilityStatus(Boolean available, String message, Integer statusCode, String statusPhrase) {
        super();
        this.available = available;
        this.message = message;
        this.statusCode = statusCode;
        this.statusPhrase = statusPhrase;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("available")
    public Boolean getAvailable() {
        return available;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("available")
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public AvailabilityStatus withAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public AvailabilityStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("statusCode")
    public Integer getStatusCode() {
        return statusCode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("statusCode")
    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public AvailabilityStatus withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @JsonProperty("statusPhrase")
    public Optional<String> getStatusPhrase() {
        return Optional.ofNullable(statusPhrase);
    }

    @JsonProperty("statusPhrase")
    public void setStatusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
    }

    public AvailabilityStatus withStatusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AvailabilityStatus withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("available".equals(name)) {
            if (value instanceof Boolean) {
                setAvailable(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"available\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("message".equals(name)) {
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("statusCode".equals(name)) {
                    if (value instanceof Integer) {
                        setStatusCode(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"statusCode\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("statusPhrase".equals(name)) {
                        if (value instanceof String) {
                            setStatusPhrase(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"statusPhrase\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("available".equals(name)) {
            return getAvailable();
        } else {
            if ("message".equals(name)) {
                return getMessage();
            } else {
                if ("statusCode".equals(name)) {
                    return getStatusCode();
                } else {
                    if ("statusPhrase".equals(name)) {
                        return getStatusPhrase();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AvailabilityStatus.NOT_FOUND_VALUE);
        if (AvailabilityStatus.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AvailabilityStatus with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AvailabilityStatus.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("available");
        sb.append('=');
        sb.append(((this.available == null)?"<null>":this.available));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("statusCode");
        sb.append('=');
        sb.append(((this.statusCode == null)?"<null>":this.statusCode));
        sb.append(',');
        sb.append("statusPhrase");
        sb.append('=');
        sb.append(((this.statusPhrase == null)?"<null>":this.statusPhrase));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.statusPhrase == null)? 0 :this.statusPhrase.hashCode()));
        result = ((result* 31)+((this.available == null)? 0 :this.available.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.statusCode == null)? 0 :this.statusCode.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AvailabilityStatus) == false) {
            return false;
        }
        AvailabilityStatus rhs = ((AvailabilityStatus) other);
        return ((((((this.statusPhrase == rhs.statusPhrase)||((this.statusPhrase!= null)&&this.statusPhrase.equals(rhs.statusPhrase)))&&((this.available == rhs.available)||((this.available!= null)&&this.available.equals(rhs.available))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.statusCode == rhs.statusCode)||((this.statusCode!= null)&&this.statusCode.equals(rhs.statusCode))));
    }

}
