
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "patch",
    "targetIds"
})
@Generated("jsonschema2pojo")
public class BulkJsonPatch implements Serializable
{

    @JsonProperty("patch")
    private JsonPatch patch;
    @JsonProperty("targetIds")
    private TargetIds targetIds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 820832068673083845L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BulkJsonPatch() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public BulkJsonPatch(BulkJsonPatch source) {
        super();
        this.patch = source.patch;
        this.targetIds = source.targetIds;
    }

    public BulkJsonPatch(JsonPatch patch, TargetIds targetIds) {
        super();
        this.patch = patch;
        this.targetIds = targetIds;
    }

    @JsonProperty("patch")
    public Optional<JsonPatch> getPatch() {
        return Optional.ofNullable(patch);
    }

    @JsonProperty("patch")
    public void setPatch(JsonPatch patch) {
        this.patch = patch;
    }

    public BulkJsonPatch withPatch(JsonPatch patch) {
        this.patch = patch;
        return this;
    }

    @JsonProperty("targetIds")
    public Optional<TargetIds> getTargetIds() {
        return Optional.ofNullable(targetIds);
    }

    @JsonProperty("targetIds")
    public void setTargetIds(TargetIds targetIds) {
        this.targetIds = targetIds;
    }

    public BulkJsonPatch withTargetIds(TargetIds targetIds) {
        this.targetIds = targetIds;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public BulkJsonPatch withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("patch".equals(name)) {
            if (value instanceof JsonPatch) {
                setPatch(((JsonPatch) value));
            } else {
                throw new IllegalArgumentException(("property \"patch\" is of type \"org.hisp.dhis.api.model.v40_0.JsonPatch\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("targetIds".equals(name)) {
                if (value instanceof TargetIds) {
                    setTargetIds(((TargetIds) value));
                } else {
                    throw new IllegalArgumentException(("property \"targetIds\" is of type \"org.hisp.dhis.api.model.v40_0.TargetIds\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("patch".equals(name)) {
            return getPatch();
        } else {
            if ("targetIds".equals(name)) {
                return getTargetIds();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, BulkJsonPatch.NOT_FOUND_VALUE);
        if (BulkJsonPatch.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public BulkJsonPatch with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BulkJsonPatch.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("patch");
        sb.append('=');
        sb.append(((this.patch == null)?"<null>":this.patch));
        sb.append(',');
        sb.append("targetIds");
        sb.append('=');
        sb.append(((this.targetIds == null)?"<null>":this.targetIds));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.patch == null)? 0 :this.patch.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.targetIds == null)? 0 :this.targetIds.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof BulkJsonPatch) == false) {
            return false;
        }
        BulkJsonPatch rhs = ((BulkJsonPatch) other);
        return ((((this.patch == rhs.patch)||((this.patch!= null)&&this.patch.equals(rhs.patch)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.targetIds == rhs.targetIds)||((this.targetIds!= null)&&this.targetIds.equals(rhs.targetIds))));
    }

}
