
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeValues",
    "categories",
    "categoryOptionCombos",
    "categoryOptionGroups",
    "code",
    "created",
    "createdBy",
    "description",
    "dimensionItem",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "endDate",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "id",
    "isDefault",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "name",
    "organisationUnits",
    "publicAccess",
    "queryMods",
    "sharing",
    "shortName",
    "startDate",
    "style",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class CategoryOption implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private CategoryOption.AggregationType aggregationType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("categories")
    private List<RefCategory> categories;
    @JsonProperty("categoryOptionCombos")
    private List<RefCategoryOptionCombo> categoryOptionCombos;
    @JsonProperty("categoryOptionGroups")
    private List<RefCategoryOptionGroup> categoryOptionGroups;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("endDate")
    private Date endDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    private Boolean isDefault;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private RefLegendSet legendSet;
    @JsonProperty("legendSets")
    private List<RefLegendSet> legendSets;
    @JsonProperty("name")
    private String name;
    @JsonProperty("organisationUnits")
    private List<RefOrganisationUnit> organisationUnits;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("queryMods")
    private QueryModifiers queryMods;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1616146914546995936L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CategoryOption() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CategoryOption(CategoryOption source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeValues = source.attributeValues;
        this.categories = source.categories;
        this.categoryOptionCombos = source.categoryOptionCombos;
        this.categoryOptionGroups = source.categoryOptionGroups;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.endDate = source.endDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.isDefault = source.isDefault;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.name = source.name;
        this.organisationUnits = source.organisationUnits;
        this.publicAccess = source.publicAccess;
        this.queryMods = source.queryMods;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.startDate = source.startDate;
        this.style = source.style;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public CategoryOption(Access access, CategoryOption.AggregationType aggregationType, List<AttributeValue> attributeValues, List<RefCategory> categories, List<RefCategoryOptionCombo> categoryOptionCombos, List<RefCategoryOptionGroup> categoryOptionGroups, String code, Date created, RefUser createdBy, String description, String dimensionItem, String displayDescription, String displayFormName, String displayName, String displayShortName, Date endDate, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, String id, Boolean isDefault, Date lastUpdated, RefUser lastUpdatedBy, RefLegendSet legendSet, List<RefLegendSet> legendSets, String name, List<RefOrganisationUnit> organisationUnits, String publicAccess, QueryModifiers queryMods, Sharing sharing, String shortName, Date startDate, ObjectStyle style, List<Translation> translations, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeValues = attributeValues;
        this.categories = categories;
        this.categoryOptionCombos = categoryOptionCombos;
        this.categoryOptionGroups = categoryOptionGroups;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.endDate = endDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.isDefault = isDefault;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.name = name;
        this.organisationUnits = organisationUnits;
        this.publicAccess = publicAccess;
        this.queryMods = queryMods;
        this.sharing = sharing;
        this.shortName = shortName;
        this.startDate = startDate;
        this.style = style;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public CategoryOption withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public CategoryOption.AggregationType getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(CategoryOption.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public CategoryOption withAggregationType(CategoryOption.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public CategoryOption withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categories")
    public Optional<List<RefCategory>> getCategories() {
        return Optional.ofNullable(categories);
    }

    @JsonProperty("categories")
    public void setCategories(List<RefCategory> categories) {
        this.categories = categories;
    }

    public CategoryOption withCategories(List<RefCategory> categories) {
        this.categories = categories;
        return this;
    }

    @JsonProperty("categoryOptionCombos")
    public Optional<List<RefCategoryOptionCombo>> getCategoryOptionCombos() {
        return Optional.ofNullable(categoryOptionCombos);
    }

    @JsonProperty("categoryOptionCombos")
    public void setCategoryOptionCombos(List<RefCategoryOptionCombo> categoryOptionCombos) {
        this.categoryOptionCombos = categoryOptionCombos;
    }

    public CategoryOption withCategoryOptionCombos(List<RefCategoryOptionCombo> categoryOptionCombos) {
        this.categoryOptionCombos = categoryOptionCombos;
        return this;
    }

    @JsonProperty("categoryOptionGroups")
    public Optional<List<RefCategoryOptionGroup>> getCategoryOptionGroups() {
        return Optional.ofNullable(categoryOptionGroups);
    }

    @JsonProperty("categoryOptionGroups")
    public void setCategoryOptionGroups(List<RefCategoryOptionGroup> categoryOptionGroups) {
        this.categoryOptionGroups = categoryOptionGroups;
    }

    public CategoryOption withCategoryOptionGroups(List<RefCategoryOptionGroup> categoryOptionGroups) {
        this.categoryOptionGroups = categoryOptionGroups;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public CategoryOption withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public CategoryOption withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public CategoryOption withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CategoryOption withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public CategoryOption withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public CategoryOption withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public CategoryOption withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CategoryOption withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public CategoryOption withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public CategoryOption withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public CategoryOption withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public CategoryOption withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public CategoryOption withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public CategoryOption withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public CategoryOption withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public CategoryOption withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    public Boolean getIsDefault() {
        return isDefault;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public CategoryOption withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public CategoryOption withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public CategoryOption withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public Optional<RefLegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(RefLegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public CategoryOption withLegendSet(RefLegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<RefLegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<RefLegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public CategoryOption withLegendSets(List<RefLegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public CategoryOption withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<RefOrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<RefOrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public CategoryOption withOrganisationUnits(List<RefOrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public CategoryOption withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("queryMods")
    public Optional<QueryModifiers> getQueryMods() {
        return Optional.ofNullable(queryMods);
    }

    @JsonProperty("queryMods")
    public void setQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
    }

    public CategoryOption withQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public CategoryOption withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public CategoryOption withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public CategoryOption withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public CategoryOption withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public CategoryOption withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public CategoryOption withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public CategoryOption withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public CategoryOption withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CategoryOption withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationType".equals(name)) {
                if (value instanceof CategoryOption.AggregationType) {
                    setAggregationType(((CategoryOption.AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.CategoryOption.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("categories".equals(name)) {
                        if (value instanceof List) {
                            setCategories(((List<RefCategory> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"categories\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefCategory>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("categoryOptionCombos".equals(name)) {
                            if (value instanceof List) {
                                setCategoryOptionCombos(((List<RefCategoryOptionCombo> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"categoryOptionCombos\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefCategoryOptionCombo>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("categoryOptionGroups".equals(name)) {
                                if (value instanceof List) {
                                    setCategoryOptionGroups(((List<RefCategoryOptionGroup> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"categoryOptionGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefCategoryOptionGroup>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("code".equals(name)) {
                                    if (value instanceof String) {
                                        setCode(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("created".equals(name)) {
                                        if (value instanceof Date) {
                                            setCreated(((Date) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("createdBy".equals(name)) {
                                            if (value instanceof RefUser) {
                                                setCreatedBy(((RefUser) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("description".equals(name)) {
                                                if (value instanceof String) {
                                                    setDescription(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("dimensionItem".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDimensionItem(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("displayDescription".equals(name)) {
                                                        if (value instanceof String) {
                                                            setDisplayDescription(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("displayFormName".equals(name)) {
                                                            if (value instanceof String) {
                                                                setDisplayFormName(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("displayName".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDisplayName(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("displayShortName".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setDisplayShortName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("endDate".equals(name)) {
                                                                        if (value instanceof Date) {
                                                                            setEndDate(((Date) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("externalAccess".equals(name)) {
                                                                            if (value instanceof Boolean) {
                                                                                setExternalAccess(((Boolean) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("favorite".equals(name)) {
                                                                                if (value instanceof Boolean) {
                                                                                    setFavorite(((Boolean) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("favorites".equals(name)) {
                                                                                    if (value instanceof List) {
                                                                                        setFavorites(((List<String> ) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("formName".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setFormName(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("href".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setHref(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("id".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setId(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("isDefault".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setIsDefault(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"isDefault\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("lastUpdated".equals(name)) {
                                                                                                        if (value instanceof Date) {
                                                                                                            setLastUpdated(((Date) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                                            if (value instanceof RefUser) {
                                                                                                                setLastUpdatedBy(((RefUser) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                if (value instanceof RefLegendSet) {
                                                                                                                    setLegendSet(((RefLegendSet) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v40_0.RefLegendSet\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("legendSets".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setLegendSets(((List<RefLegendSet> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefLegendSet>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("name".equals(name)) {
                                                                                                                        if (value instanceof String) {
                                                                                                                            setName(((String) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("organisationUnits".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setOrganisationUnits(((List<RefOrganisationUnit> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefOrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setPublicAccess(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("queryMods".equals(name)) {
                                                                                                                                    if (value instanceof QueryModifiers) {
                                                                                                                                        setQueryMods(((QueryModifiers) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"queryMods\" is of type \"org.hisp.dhis.api.model.v40_0.QueryModifiers\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                        if (value instanceof Sharing) {
                                                                                                                                            setSharing(((Sharing) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                            if (value instanceof String) {
                                                                                                                                                setShortName(((String) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("startDate".equals(name)) {
                                                                                                                                                if (value instanceof Date) {
                                                                                                                                                    setStartDate(((Date) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("style".equals(name)) {
                                                                                                                                                    if (value instanceof ObjectStyle) {
                                                                                                                                                        setStyle(((ObjectStyle) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_0.ObjectStyle\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                            if (value instanceof RefUser) {
                                                                                                                                                                setUser(((RefUser) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationType".equals(name)) {
                return getAggregationType();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("categories".equals(name)) {
                        return getCategories();
                    } else {
                        if ("categoryOptionCombos".equals(name)) {
                            return getCategoryOptionCombos();
                        } else {
                            if ("categoryOptionGroups".equals(name)) {
                                return getCategoryOptionGroups();
                            } else {
                                if ("code".equals(name)) {
                                    return getCode();
                                } else {
                                    if ("created".equals(name)) {
                                        return getCreated();
                                    } else {
                                        if ("createdBy".equals(name)) {
                                            return getCreatedBy();
                                        } else {
                                            if ("description".equals(name)) {
                                                return getDescription();
                                            } else {
                                                if ("dimensionItem".equals(name)) {
                                                    return getDimensionItem();
                                                } else {
                                                    if ("displayDescription".equals(name)) {
                                                        return getDisplayDescription();
                                                    } else {
                                                        if ("displayFormName".equals(name)) {
                                                            return getDisplayFormName();
                                                        } else {
                                                            if ("displayName".equals(name)) {
                                                                return getDisplayName();
                                                            } else {
                                                                if ("displayShortName".equals(name)) {
                                                                    return getDisplayShortName();
                                                                } else {
                                                                    if ("endDate".equals(name)) {
                                                                        return getEndDate();
                                                                    } else {
                                                                        if ("externalAccess".equals(name)) {
                                                                            return getExternalAccess();
                                                                        } else {
                                                                            if ("favorite".equals(name)) {
                                                                                return getFavorite();
                                                                            } else {
                                                                                if ("favorites".equals(name)) {
                                                                                    return getFavorites();
                                                                                } else {
                                                                                    if ("formName".equals(name)) {
                                                                                        return getFormName();
                                                                                    } else {
                                                                                        if ("href".equals(name)) {
                                                                                            return getHref();
                                                                                        } else {
                                                                                            if ("id".equals(name)) {
                                                                                                return getId();
                                                                                            } else {
                                                                                                if ("isDefault".equals(name)) {
                                                                                                    return getIsDefault();
                                                                                                } else {
                                                                                                    if ("lastUpdated".equals(name)) {
                                                                                                        return getLastUpdated();
                                                                                                    } else {
                                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                                            return getLastUpdatedBy();
                                                                                                        } else {
                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                return getLegendSet();
                                                                                                            } else {
                                                                                                                if ("legendSets".equals(name)) {
                                                                                                                    return getLegendSets();
                                                                                                                } else {
                                                                                                                    if ("name".equals(name)) {
                                                                                                                        return getName();
                                                                                                                    } else {
                                                                                                                        if ("organisationUnits".equals(name)) {
                                                                                                                            return getOrganisationUnits();
                                                                                                                        } else {
                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                return getPublicAccess();
                                                                                                                            } else {
                                                                                                                                if ("queryMods".equals(name)) {
                                                                                                                                    return getQueryMods();
                                                                                                                                } else {
                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                        return getSharing();
                                                                                                                                    } else {
                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                            return getShortName();
                                                                                                                                        } else {
                                                                                                                                            if ("startDate".equals(name)) {
                                                                                                                                                return getStartDate();
                                                                                                                                            } else {
                                                                                                                                                if ("style".equals(name)) {
                                                                                                                                                    return getStyle();
                                                                                                                                                } else {
                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                        return getTranslations();
                                                                                                                                                    } else {
                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                            return getUser();
                                                                                                                                                        } else {
                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                return getUserAccesses();
                                                                                                                                                            } else {
                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                                                } else {
                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CategoryOption.NOT_FOUND_VALUE);
        if (CategoryOption.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CategoryOption with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CategoryOption.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categories");
        sb.append('=');
        sb.append(((this.categories == null)?"<null>":this.categories));
        sb.append(',');
        sb.append("categoryOptionCombos");
        sb.append('=');
        sb.append(((this.categoryOptionCombos == null)?"<null>":this.categoryOptionCombos));
        sb.append(',');
        sb.append("categoryOptionGroups");
        sb.append('=');
        sb.append(((this.categoryOptionGroups == null)?"<null>":this.categoryOptionGroups));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("isDefault");
        sb.append('=');
        sb.append(((this.isDefault == null)?"<null>":this.isDefault));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("queryMods");
        sb.append('=');
        sb.append(((this.queryMods == null)?"<null>":this.queryMods));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.queryMods == null)? 0 :this.queryMods.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.categories == null)? 0 :this.categories.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombos == null)? 0 :this.categoryOptionCombos.hashCode()));
        result = ((result* 31)+((this.isDefault == null)? 0 :this.isDefault.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroups == null)? 0 :this.categoryOptionGroups.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CategoryOption) == false) {
            return false;
        }
        CategoryOption rhs = ((CategoryOption) other);
        return (((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.queryMods == rhs.queryMods)||((this.queryMods!= null)&&this.queryMods.equals(rhs.queryMods))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.categories == rhs.categories)||((this.categories!= null)&&this.categories.equals(rhs.categories))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.categoryOptionCombos == rhs.categoryOptionCombos)||((this.categoryOptionCombos!= null)&&this.categoryOptionCombos.equals(rhs.categoryOptionCombos))))&&((this.isDefault == rhs.isDefault)||((this.isDefault!= null)&&this.isDefault.equals(rhs.isDefault))))&&((this.categoryOptionGroups == rhs.categoryOptionGroups)||((this.categoryOptionGroups!= null)&&this.categoryOptionGroups.equals(rhs.categoryOptionGroups))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, CategoryOption.AggregationType> CONSTANTS = new HashMap<String, CategoryOption.AggregationType>();

        static {
            for (CategoryOption.AggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CategoryOption.AggregationType fromValue(String value) {
            CategoryOption.AggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
