
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataDimensionItemType",
    "dataElement",
    "dataElementOperand",
    "expressionDimensionItem",
    "indicator",
    "programAttribute",
    "programDataElement",
    "programIndicator",
    "reportingRate"
})
@Generated("jsonschema2pojo")
public class DataDimensionItem implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionItemType")
    private DataDimensionItem.DataDimensionItemType dataDimensionItemType;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private RefDataElement dataElement;
    /**
     * A UID reference to a DataElementOperand  
     * (Java name `org.hisp.dhis.dataelement.DataElementOperand`)
     * 
     */
    @JsonProperty("dataElementOperand")
    @JsonPropertyDescription("A UID reference to a DataElementOperand  \n(Java name `org.hisp.dhis.dataelement.DataElementOperand`)")
    private RefDataElementOperand dataElementOperand;
    /**
     * A UID reference to a ExpressionDimensionItem  
     * (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)
     * 
     */
    @JsonProperty("expressionDimensionItem")
    @JsonPropertyDescription("A UID reference to a ExpressionDimensionItem  \n(Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)")
    private RefExpressionDimensionItem expressionDimensionItem;
    /**
     * A UID reference to a Indicator  
     * (Java name `org.hisp.dhis.indicator.Indicator`)
     * 
     */
    @JsonProperty("indicator")
    @JsonPropertyDescription("A UID reference to a Indicator  \n(Java name `org.hisp.dhis.indicator.Indicator`)")
    private RefIndicator indicator;
    /**
     * A UID reference to a ProgramTrackedEntityAttributeDimensionItem  
     * (Java name `org.hisp.dhis.program.ProgramTrackedEntityAttributeDimensionItem`)
     * 
     */
    @JsonProperty("programAttribute")
    @JsonPropertyDescription("A UID reference to a ProgramTrackedEntityAttributeDimensionItem  \n(Java name `org.hisp.dhis.program.ProgramTrackedEntityAttributeDimensionItem`)")
    private RefProgramTrackedEntityAttributeDimensionItem programAttribute;
    /**
     * A UID reference to a ProgramDataElementDimensionItem  
     * (Java name `org.hisp.dhis.program.ProgramDataElementDimensionItem`)
     * 
     */
    @JsonProperty("programDataElement")
    @JsonPropertyDescription("A UID reference to a ProgramDataElementDimensionItem  \n(Java name `org.hisp.dhis.program.ProgramDataElementDimensionItem`)")
    private RefProgramDataElementDimensionItem programDataElement;
    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    @JsonPropertyDescription("A UID reference to a ProgramIndicator  \n(Java name `org.hisp.dhis.program.ProgramIndicator`)")
    private RefProgramIndicator programIndicator;
    /**
     * A UID reference to a ReportingRate  
     * (Java name `org.hisp.dhis.common.ReportingRate`)
     * 
     */
    @JsonProperty("reportingRate")
    @JsonPropertyDescription("A UID reference to a ReportingRate  \n(Java name `org.hisp.dhis.common.ReportingRate`)")
    private RefReportingRate reportingRate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6720990945254889112L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataDimensionItem() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataDimensionItem(DataDimensionItem source) {
        super();
        this.dataDimensionItemType = source.dataDimensionItemType;
        this.dataElement = source.dataElement;
        this.dataElementOperand = source.dataElementOperand;
        this.expressionDimensionItem = source.expressionDimensionItem;
        this.indicator = source.indicator;
        this.programAttribute = source.programAttribute;
        this.programDataElement = source.programDataElement;
        this.programIndicator = source.programIndicator;
        this.reportingRate = source.reportingRate;
    }

    public DataDimensionItem(DataDimensionItem.DataDimensionItemType dataDimensionItemType, RefDataElement dataElement, RefDataElementOperand dataElementOperand, RefExpressionDimensionItem expressionDimensionItem, RefIndicator indicator, RefProgramTrackedEntityAttributeDimensionItem programAttribute, RefProgramDataElementDimensionItem programDataElement, RefProgramIndicator programIndicator, RefReportingRate reportingRate) {
        super();
        this.dataDimensionItemType = dataDimensionItemType;
        this.dataElement = dataElement;
        this.dataElementOperand = dataElementOperand;
        this.expressionDimensionItem = expressionDimensionItem;
        this.indicator = indicator;
        this.programAttribute = programAttribute;
        this.programDataElement = programDataElement;
        this.programIndicator = programIndicator;
        this.reportingRate = reportingRate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionItemType")
    public DataDimensionItem.DataDimensionItemType getDataDimensionItemType() {
        return dataDimensionItemType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionItemType")
    public void setDataDimensionItemType(DataDimensionItem.DataDimensionItemType dataDimensionItemType) {
        this.dataDimensionItemType = dataDimensionItemType;
    }

    public DataDimensionItem withDataDimensionItemType(DataDimensionItem.DataDimensionItemType dataDimensionItemType) {
        this.dataDimensionItemType = dataDimensionItemType;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<RefDataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(RefDataElement dataElement) {
        this.dataElement = dataElement;
    }

    public DataDimensionItem withDataElement(RefDataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    /**
     * A UID reference to a DataElementOperand  
     * (Java name `org.hisp.dhis.dataelement.DataElementOperand`)
     * 
     */
    @JsonProperty("dataElementOperand")
    public Optional<RefDataElementOperand> getDataElementOperand() {
        return Optional.ofNullable(dataElementOperand);
    }

    /**
     * A UID reference to a DataElementOperand  
     * (Java name `org.hisp.dhis.dataelement.DataElementOperand`)
     * 
     */
    @JsonProperty("dataElementOperand")
    public void setDataElementOperand(RefDataElementOperand dataElementOperand) {
        this.dataElementOperand = dataElementOperand;
    }

    public DataDimensionItem withDataElementOperand(RefDataElementOperand dataElementOperand) {
        this.dataElementOperand = dataElementOperand;
        return this;
    }

    /**
     * A UID reference to a ExpressionDimensionItem  
     * (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)
     * 
     */
    @JsonProperty("expressionDimensionItem")
    public Optional<RefExpressionDimensionItem> getExpressionDimensionItem() {
        return Optional.ofNullable(expressionDimensionItem);
    }

    /**
     * A UID reference to a ExpressionDimensionItem  
     * (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)
     * 
     */
    @JsonProperty("expressionDimensionItem")
    public void setExpressionDimensionItem(RefExpressionDimensionItem expressionDimensionItem) {
        this.expressionDimensionItem = expressionDimensionItem;
    }

    public DataDimensionItem withExpressionDimensionItem(RefExpressionDimensionItem expressionDimensionItem) {
        this.expressionDimensionItem = expressionDimensionItem;
        return this;
    }

    /**
     * A UID reference to a Indicator  
     * (Java name `org.hisp.dhis.indicator.Indicator`)
     * 
     */
    @JsonProperty("indicator")
    public Optional<RefIndicator> getIndicator() {
        return Optional.ofNullable(indicator);
    }

    /**
     * A UID reference to a Indicator  
     * (Java name `org.hisp.dhis.indicator.Indicator`)
     * 
     */
    @JsonProperty("indicator")
    public void setIndicator(RefIndicator indicator) {
        this.indicator = indicator;
    }

    public DataDimensionItem withIndicator(RefIndicator indicator) {
        this.indicator = indicator;
        return this;
    }

    /**
     * A UID reference to a ProgramTrackedEntityAttributeDimensionItem  
     * (Java name `org.hisp.dhis.program.ProgramTrackedEntityAttributeDimensionItem`)
     * 
     */
    @JsonProperty("programAttribute")
    public Optional<RefProgramTrackedEntityAttributeDimensionItem> getProgramAttribute() {
        return Optional.ofNullable(programAttribute);
    }

    /**
     * A UID reference to a ProgramTrackedEntityAttributeDimensionItem  
     * (Java name `org.hisp.dhis.program.ProgramTrackedEntityAttributeDimensionItem`)
     * 
     */
    @JsonProperty("programAttribute")
    public void setProgramAttribute(RefProgramTrackedEntityAttributeDimensionItem programAttribute) {
        this.programAttribute = programAttribute;
    }

    public DataDimensionItem withProgramAttribute(RefProgramTrackedEntityAttributeDimensionItem programAttribute) {
        this.programAttribute = programAttribute;
        return this;
    }

    /**
     * A UID reference to a ProgramDataElementDimensionItem  
     * (Java name `org.hisp.dhis.program.ProgramDataElementDimensionItem`)
     * 
     */
    @JsonProperty("programDataElement")
    public Optional<RefProgramDataElementDimensionItem> getProgramDataElement() {
        return Optional.ofNullable(programDataElement);
    }

    /**
     * A UID reference to a ProgramDataElementDimensionItem  
     * (Java name `org.hisp.dhis.program.ProgramDataElementDimensionItem`)
     * 
     */
    @JsonProperty("programDataElement")
    public void setProgramDataElement(RefProgramDataElementDimensionItem programDataElement) {
        this.programDataElement = programDataElement;
    }

    public DataDimensionItem withProgramDataElement(RefProgramDataElementDimensionItem programDataElement) {
        this.programDataElement = programDataElement;
        return this;
    }

    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    public Optional<RefProgramIndicator> getProgramIndicator() {
        return Optional.ofNullable(programIndicator);
    }

    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    public void setProgramIndicator(RefProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
    }

    public DataDimensionItem withProgramIndicator(RefProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
        return this;
    }

    /**
     * A UID reference to a ReportingRate  
     * (Java name `org.hisp.dhis.common.ReportingRate`)
     * 
     */
    @JsonProperty("reportingRate")
    public Optional<RefReportingRate> getReportingRate() {
        return Optional.ofNullable(reportingRate);
    }

    /**
     * A UID reference to a ReportingRate  
     * (Java name `org.hisp.dhis.common.ReportingRate`)
     * 
     */
    @JsonProperty("reportingRate")
    public void setReportingRate(RefReportingRate reportingRate) {
        this.reportingRate = reportingRate;
    }

    public DataDimensionItem withReportingRate(RefReportingRate reportingRate) {
        this.reportingRate = reportingRate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataDimensionItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataDimensionItemType".equals(name)) {
            if (value instanceof DataDimensionItem.DataDimensionItemType) {
                setDataDimensionItemType(((DataDimensionItem.DataDimensionItemType) value));
            } else {
                throw new IllegalArgumentException(("property \"dataDimensionItemType\" is of type \"org.hisp.dhis.api.model.v40_0.DataDimensionItem.DataDimensionItemType\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataElement".equals(name)) {
                if (value instanceof RefDataElement) {
                    setDataElement(((RefDataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v40_0.RefDataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElementOperand".equals(name)) {
                    if (value instanceof RefDataElementOperand) {
                        setDataElementOperand(((RefDataElementOperand) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElementOperand\" is of type \"org.hisp.dhis.api.model.v40_0.RefDataElementOperand\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("expressionDimensionItem".equals(name)) {
                        if (value instanceof RefExpressionDimensionItem) {
                            setExpressionDimensionItem(((RefExpressionDimensionItem) value));
                        } else {
                            throw new IllegalArgumentException(("property \"expressionDimensionItem\" is of type \"org.hisp.dhis.api.model.v40_0.RefExpressionDimensionItem\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("indicator".equals(name)) {
                            if (value instanceof RefIndicator) {
                                setIndicator(((RefIndicator) value));
                            } else {
                                throw new IllegalArgumentException(("property \"indicator\" is of type \"org.hisp.dhis.api.model.v40_0.RefIndicator\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("programAttribute".equals(name)) {
                                if (value instanceof RefProgramTrackedEntityAttributeDimensionItem) {
                                    setProgramAttribute(((RefProgramTrackedEntityAttributeDimensionItem) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"programAttribute\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgramTrackedEntityAttributeDimensionItem\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("programDataElement".equals(name)) {
                                    if (value instanceof RefProgramDataElementDimensionItem) {
                                        setProgramDataElement(((RefProgramDataElementDimensionItem) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"programDataElement\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgramDataElementDimensionItem\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("programIndicator".equals(name)) {
                                        if (value instanceof RefProgramIndicator) {
                                            setProgramIndicator(((RefProgramIndicator) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"programIndicator\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgramIndicator\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("reportingRate".equals(name)) {
                                            if (value instanceof RefReportingRate) {
                                                setReportingRate(((RefReportingRate) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"reportingRate\" is of type \"org.hisp.dhis.api.model.v40_0.RefReportingRate\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataDimensionItemType".equals(name)) {
            return getDataDimensionItemType();
        } else {
            if ("dataElement".equals(name)) {
                return getDataElement();
            } else {
                if ("dataElementOperand".equals(name)) {
                    return getDataElementOperand();
                } else {
                    if ("expressionDimensionItem".equals(name)) {
                        return getExpressionDimensionItem();
                    } else {
                        if ("indicator".equals(name)) {
                            return getIndicator();
                        } else {
                            if ("programAttribute".equals(name)) {
                                return getProgramAttribute();
                            } else {
                                if ("programDataElement".equals(name)) {
                                    return getProgramDataElement();
                                } else {
                                    if ("programIndicator".equals(name)) {
                                        return getProgramIndicator();
                                    } else {
                                        if ("reportingRate".equals(name)) {
                                            return getReportingRate();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataDimensionItem.NOT_FOUND_VALUE);
        if (DataDimensionItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataDimensionItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataDimensionItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataDimensionItemType");
        sb.append('=');
        sb.append(((this.dataDimensionItemType == null)?"<null>":this.dataDimensionItemType));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dataElementOperand");
        sb.append('=');
        sb.append(((this.dataElementOperand == null)?"<null>":this.dataElementOperand));
        sb.append(',');
        sb.append("expressionDimensionItem");
        sb.append('=');
        sb.append(((this.expressionDimensionItem == null)?"<null>":this.expressionDimensionItem));
        sb.append(',');
        sb.append("indicator");
        sb.append('=');
        sb.append(((this.indicator == null)?"<null>":this.indicator));
        sb.append(',');
        sb.append("programAttribute");
        sb.append('=');
        sb.append(((this.programAttribute == null)?"<null>":this.programAttribute));
        sb.append(',');
        sb.append("programDataElement");
        sb.append('=');
        sb.append(((this.programDataElement == null)?"<null>":this.programDataElement));
        sb.append(',');
        sb.append("programIndicator");
        sb.append('=');
        sb.append(((this.programIndicator == null)?"<null>":this.programIndicator));
        sb.append(',');
        sb.append("reportingRate");
        sb.append('=');
        sb.append(((this.reportingRate == null)?"<null>":this.reportingRate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indicator == null)? 0 :this.indicator.hashCode()));
        result = ((result* 31)+((this.programDataElement == null)? 0 :this.programDataElement.hashCode()));
        result = ((result* 31)+((this.programAttribute == null)? 0 :this.programAttribute.hashCode()));
        result = ((result* 31)+((this.reportingRate == null)? 0 :this.reportingRate.hashCode()));
        result = ((result* 31)+((this.dataElementOperand == null)? 0 :this.dataElementOperand.hashCode()));
        result = ((result* 31)+((this.dataDimensionItemType == null)? 0 :this.dataDimensionItemType.hashCode()));
        result = ((result* 31)+((this.programIndicator == null)? 0 :this.programIndicator.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.expressionDimensionItem == null)? 0 :this.expressionDimensionItem.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataDimensionItem) == false) {
            return false;
        }
        DataDimensionItem rhs = ((DataDimensionItem) other);
        return (((((((((((this.indicator == rhs.indicator)||((this.indicator!= null)&&this.indicator.equals(rhs.indicator)))&&((this.programDataElement == rhs.programDataElement)||((this.programDataElement!= null)&&this.programDataElement.equals(rhs.programDataElement))))&&((this.programAttribute == rhs.programAttribute)||((this.programAttribute!= null)&&this.programAttribute.equals(rhs.programAttribute))))&&((this.reportingRate == rhs.reportingRate)||((this.reportingRate!= null)&&this.reportingRate.equals(rhs.reportingRate))))&&((this.dataElementOperand == rhs.dataElementOperand)||((this.dataElementOperand!= null)&&this.dataElementOperand.equals(rhs.dataElementOperand))))&&((this.dataDimensionItemType == rhs.dataDimensionItemType)||((this.dataDimensionItemType!= null)&&this.dataDimensionItemType.equals(rhs.dataDimensionItemType))))&&((this.programIndicator == rhs.programIndicator)||((this.programIndicator!= null)&&this.programIndicator.equals(rhs.programIndicator))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.expressionDimensionItem == rhs.expressionDimensionItem)||((this.expressionDimensionItem!= null)&&this.expressionDimensionItem.equals(rhs.expressionDimensionItem))));
    }

    @Generated("jsonschema2pojo")
    public enum DataDimensionItemType {

        INDICATOR("INDICATOR"),
        DATA_ELEMENT("DATA_ELEMENT"),
        DATA_ELEMENT_OPERAND("DATA_ELEMENT_OPERAND"),
        REPORTING_RATE("REPORTING_RATE"),
        PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
        PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        EXPRESSION_DIMENSION_ITEM("EXPRESSION_DIMENSION_ITEM"),
        VALIDATION_RULE("VALIDATION_RULE");
        private final String value;
        private final static Map<String, DataDimensionItem.DataDimensionItemType> CONSTANTS = new HashMap<String, DataDimensionItem.DataDimensionItemType>();

        static {
            for (DataDimensionItem.DataDimensionItemType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataDimensionItemType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataDimensionItem.DataDimensionItemType fromValue(String value) {
            DataDimensionItem.DataDimensionItemType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
