
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "description",
    "displayName",
    "introduction",
    "isSlow",
    "issuesIdType",
    "name",
    "recommendation",
    "section",
    "severity"
})
@Generated("jsonschema2pojo")
public class DataIntegrityCheck implements Serializable
{

    @JsonProperty("code")
    private String code;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("introduction")
    private String introduction;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isSlow")
    private Boolean isSlow;
    @JsonProperty("issuesIdType")
    private String issuesIdType;
    @JsonProperty("name")
    private String name;
    @JsonProperty("recommendation")
    private String recommendation;
    @JsonProperty("section")
    private String section;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("severity")
    private DataIntegrityCheck.Severity severity;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -2927277976860896836L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataIntegrityCheck() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataIntegrityCheck(DataIntegrityCheck source) {
        super();
        this.code = source.code;
        this.description = source.description;
        this.displayName = source.displayName;
        this.introduction = source.introduction;
        this.isSlow = source.isSlow;
        this.issuesIdType = source.issuesIdType;
        this.name = source.name;
        this.recommendation = source.recommendation;
        this.section = source.section;
        this.severity = source.severity;
    }

    public DataIntegrityCheck(String code, String description, String displayName, String introduction, Boolean isSlow, String issuesIdType, String name, String recommendation, String section, DataIntegrityCheck.Severity severity) {
        super();
        this.code = code;
        this.description = description;
        this.displayName = displayName;
        this.introduction = introduction;
        this.isSlow = isSlow;
        this.issuesIdType = issuesIdType;
        this.name = name;
        this.recommendation = recommendation;
        this.section = section;
        this.severity = severity;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DataIntegrityCheck withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataIntegrityCheck withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DataIntegrityCheck withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("introduction")
    public Optional<String> getIntroduction() {
        return Optional.ofNullable(introduction);
    }

    @JsonProperty("introduction")
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public DataIntegrityCheck withIntroduction(String introduction) {
        this.introduction = introduction;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isSlow")
    public Boolean getIsSlow() {
        return isSlow;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isSlow")
    public void setIsSlow(Boolean isSlow) {
        this.isSlow = isSlow;
    }

    public DataIntegrityCheck withIsSlow(Boolean isSlow) {
        this.isSlow = isSlow;
        return this;
    }

    @JsonProperty("issuesIdType")
    public Optional<String> getIssuesIdType() {
        return Optional.ofNullable(issuesIdType);
    }

    @JsonProperty("issuesIdType")
    public void setIssuesIdType(String issuesIdType) {
        this.issuesIdType = issuesIdType;
    }

    public DataIntegrityCheck withIssuesIdType(String issuesIdType) {
        this.issuesIdType = issuesIdType;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataIntegrityCheck withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("recommendation")
    public Optional<String> getRecommendation() {
        return Optional.ofNullable(recommendation);
    }

    @JsonProperty("recommendation")
    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    public DataIntegrityCheck withRecommendation(String recommendation) {
        this.recommendation = recommendation;
        return this;
    }

    @JsonProperty("section")
    public Optional<String> getSection() {
        return Optional.ofNullable(section);
    }

    @JsonProperty("section")
    public void setSection(String section) {
        this.section = section;
    }

    public DataIntegrityCheck withSection(String section) {
        this.section = section;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("severity")
    public DataIntegrityCheck.Severity getSeverity() {
        return severity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("severity")
    public void setSeverity(DataIntegrityCheck.Severity severity) {
        this.severity = severity;
    }

    public DataIntegrityCheck withSeverity(DataIntegrityCheck.Severity severity) {
        this.severity = severity;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataIntegrityCheck withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("code".equals(name)) {
            if (value instanceof String) {
                setCode(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("description".equals(name)) {
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("displayName".equals(name)) {
                    if (value instanceof String) {
                        setDisplayName(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("introduction".equals(name)) {
                        if (value instanceof String) {
                            setIntroduction(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"introduction\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("isSlow".equals(name)) {
                            if (value instanceof Boolean) {
                                setIsSlow(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"isSlow\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("issuesIdType".equals(name)) {
                                if (value instanceof String) {
                                    setIssuesIdType(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"issuesIdType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("name".equals(name)) {
                                    if (value instanceof String) {
                                        setName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("recommendation".equals(name)) {
                                        if (value instanceof String) {
                                            setRecommendation(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"recommendation\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("section".equals(name)) {
                                            if (value instanceof String) {
                                                setSection(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"section\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("severity".equals(name)) {
                                                if (value instanceof DataIntegrityCheck.Severity) {
                                                    setSeverity(((DataIntegrityCheck.Severity) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"severity\" is of type \"org.hisp.dhis.api.model.v40_0.DataIntegrityCheck.Severity\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("code".equals(name)) {
            return getCode();
        } else {
            if ("description".equals(name)) {
                return getDescription();
            } else {
                if ("displayName".equals(name)) {
                    return getDisplayName();
                } else {
                    if ("introduction".equals(name)) {
                        return getIntroduction();
                    } else {
                        if ("isSlow".equals(name)) {
                            return getIsSlow();
                        } else {
                            if ("issuesIdType".equals(name)) {
                                return getIssuesIdType();
                            } else {
                                if ("name".equals(name)) {
                                    return getName();
                                } else {
                                    if ("recommendation".equals(name)) {
                                        return getRecommendation();
                                    } else {
                                        if ("section".equals(name)) {
                                            return getSection();
                                        } else {
                                            if ("severity".equals(name)) {
                                                return getSeverity();
                                            } else {
                                                return notFoundValue;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataIntegrityCheck.NOT_FOUND_VALUE);
        if (DataIntegrityCheck.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataIntegrityCheck with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataIntegrityCheck.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("introduction");
        sb.append('=');
        sb.append(((this.introduction == null)?"<null>":this.introduction));
        sb.append(',');
        sb.append("isSlow");
        sb.append('=');
        sb.append(((this.isSlow == null)?"<null>":this.isSlow));
        sb.append(',');
        sb.append("issuesIdType");
        sb.append('=');
        sb.append(((this.issuesIdType == null)?"<null>":this.issuesIdType));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("recommendation");
        sb.append('=');
        sb.append(((this.recommendation == null)?"<null>":this.recommendation));
        sb.append(',');
        sb.append("section");
        sb.append('=');
        sb.append(((this.section == null)?"<null>":this.section));
        sb.append(',');
        sb.append("severity");
        sb.append('=');
        sb.append(((this.severity == null)?"<null>":this.severity));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.severity == null)? 0 :this.severity.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.isSlow == null)? 0 :this.isSlow.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.recommendation == null)? 0 :this.recommendation.hashCode()));
        result = ((result* 31)+((this.section == null)? 0 :this.section.hashCode()));
        result = ((result* 31)+((this.issuesIdType == null)? 0 :this.issuesIdType.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.introduction == null)? 0 :this.introduction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataIntegrityCheck) == false) {
            return false;
        }
        DataIntegrityCheck rhs = ((DataIntegrityCheck) other);
        return ((((((((((((this.severity == rhs.severity)||((this.severity!= null)&&this.severity.equals(rhs.severity)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.isSlow == rhs.isSlow)||((this.isSlow!= null)&&this.isSlow.equals(rhs.isSlow))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.recommendation == rhs.recommendation)||((this.recommendation!= null)&&this.recommendation.equals(rhs.recommendation))))&&((this.section == rhs.section)||((this.section!= null)&&this.section.equals(rhs.section))))&&((this.issuesIdType == rhs.issuesIdType)||((this.issuesIdType!= null)&&this.issuesIdType.equals(rhs.issuesIdType))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.introduction == rhs.introduction)||((this.introduction!= null)&&this.introduction.equals(rhs.introduction))));
    }

    @Generated("jsonschema2pojo")
    public enum Severity {

        INFO("INFO"),
        WARNING("WARNING"),
        SEVERE("SEVERE"),
        CRITICAL("CRITICAL");
        private final String value;
        private final static Map<String, DataIntegrityCheck.Severity> CONSTANTS = new HashMap<String, DataIntegrityCheck.Severity>();

        static {
            for (DataIntegrityCheck.Severity c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Severity(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataIntegrityCheck.Severity fromValue(String value) {
            DataIntegrityCheck.Severity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
