
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "code",
    "created",
    "displayName",
    "lastUpdated",
    "storedBy",
    "value",
    "valueType"
})
@Generated("jsonschema2pojo")
public class Dxf2EventsTrackedentityAttribute implements Serializable
{

    @JsonProperty("attribute")
    private String attribute;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private String created;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("value")
    private String value;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private Dxf2EventsTrackedentityAttribute.ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1968666787895511864L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Dxf2EventsTrackedentityAttribute() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Dxf2EventsTrackedentityAttribute(Dxf2EventsTrackedentityAttribute source) {
        super();
        this.attribute = source.attribute;
        this.code = source.code;
        this.created = source.created;
        this.displayName = source.displayName;
        this.lastUpdated = source.lastUpdated;
        this.storedBy = source.storedBy;
        this.value = source.value;
        this.valueType = source.valueType;
    }

    public Dxf2EventsTrackedentityAttribute(String attribute, String code, String created, String displayName, String lastUpdated, String storedBy, String value, Dxf2EventsTrackedentityAttribute.ValueType valueType) {
        super();
        this.attribute = attribute;
        this.code = code;
        this.created = created;
        this.displayName = displayName;
        this.lastUpdated = lastUpdated;
        this.storedBy = storedBy;
        this.value = value;
        this.valueType = valueType;
    }

    @JsonProperty("attribute")
    public Optional<String> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Dxf2EventsTrackedentityAttribute withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Dxf2EventsTrackedentityAttribute withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<String> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public Dxf2EventsTrackedentityAttribute withCreated(String created) {
        this.created = created;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Dxf2EventsTrackedentityAttribute withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<String> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Dxf2EventsTrackedentityAttribute withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public Dxf2EventsTrackedentityAttribute withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public Dxf2EventsTrackedentityAttribute withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public Dxf2EventsTrackedentityAttribute.ValueType getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(Dxf2EventsTrackedentityAttribute.ValueType valueType) {
        this.valueType = valueType;
    }

    public Dxf2EventsTrackedentityAttribute withValueType(Dxf2EventsTrackedentityAttribute.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Dxf2EventsTrackedentityAttribute withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (value instanceof String) {
                setAttribute(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("code".equals(name)) {
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("created".equals(name)) {
                    if (value instanceof String) {
                        setCreated(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("displayName".equals(name)) {
                        if (value instanceof String) {
                            setDisplayName(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("lastUpdated".equals(name)) {
                            if (value instanceof String) {
                                setLastUpdated(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("storedBy".equals(name)) {
                                if (value instanceof String) {
                                    setStoredBy(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("value".equals(name)) {
                                    if (value instanceof String) {
                                        setValue(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("valueType".equals(name)) {
                                        if (value instanceof Dxf2EventsTrackedentityAttribute.ValueType) {
                                            setValueType(((Dxf2EventsTrackedentityAttribute.ValueType) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.Dxf2EventsTrackedentityAttribute.ValueType\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return getAttribute();
        } else {
            if ("code".equals(name)) {
                return getCode();
            } else {
                if ("created".equals(name)) {
                    return getCreated();
                } else {
                    if ("displayName".equals(name)) {
                        return getDisplayName();
                    } else {
                        if ("lastUpdated".equals(name)) {
                            return getLastUpdated();
                        } else {
                            if ("storedBy".equals(name)) {
                                return getStoredBy();
                            } else {
                                if ("value".equals(name)) {
                                    return getValue();
                                } else {
                                    if ("valueType".equals(name)) {
                                        return getValueType();
                                    } else {
                                        return notFoundValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Dxf2EventsTrackedentityAttribute.NOT_FOUND_VALUE);
        if (Dxf2EventsTrackedentityAttribute.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Dxf2EventsTrackedentityAttribute with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dxf2EventsTrackedentityAttribute.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Dxf2EventsTrackedentityAttribute) == false) {
            return false;
        }
        Dxf2EventsTrackedentityAttribute rhs = ((Dxf2EventsTrackedentityAttribute) other);
        return ((((((((((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueType {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, Dxf2EventsTrackedentityAttribute.ValueType> CONSTANTS = new HashMap<String, Dxf2EventsTrackedentityAttribute.ValueType>();

        static {
            for (Dxf2EventsTrackedentityAttribute.ValueType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dxf2EventsTrackedentityAttribute.ValueType fromValue(String value) {
            Dxf2EventsTrackedentityAttribute.ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
