
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "entries",
    "pager"
})
@Generated("jsonschema2pojo")
public class EntriesResponse implements Serializable
{

    @JsonProperty("entries")
    private List<Entry> entries;
    @JsonProperty("pager")
    private WebapiControllerDatastoreControllerPager pager;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 796067871094774379L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EntriesResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EntriesResponse(EntriesResponse source) {
        super();
        this.entries = source.entries;
        this.pager = source.pager;
    }

    public EntriesResponse(List<Entry> entries, WebapiControllerDatastoreControllerPager pager) {
        super();
        this.entries = entries;
        this.pager = pager;
    }

    @JsonProperty("entries")
    public Optional<List<Entry>> getEntries() {
        return Optional.ofNullable(entries);
    }

    @JsonProperty("entries")
    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public EntriesResponse withEntries(List<Entry> entries) {
        this.entries = entries;
        return this;
    }

    @JsonProperty("pager")
    public Optional<WebapiControllerDatastoreControllerPager> getPager() {
        return Optional.ofNullable(pager);
    }

    @JsonProperty("pager")
    public void setPager(WebapiControllerDatastoreControllerPager pager) {
        this.pager = pager;
    }

    public EntriesResponse withPager(WebapiControllerDatastoreControllerPager pager) {
        this.pager = pager;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EntriesResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("entries".equals(name)) {
            if (value instanceof List) {
                setEntries(((List<Entry> ) value));
            } else {
                throw new IllegalArgumentException(("property \"entries\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Entry>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("pager".equals(name)) {
                if (value instanceof WebapiControllerDatastoreControllerPager) {
                    setPager(((WebapiControllerDatastoreControllerPager) value));
                } else {
                    throw new IllegalArgumentException(("property \"pager\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerDatastoreControllerPager\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("entries".equals(name)) {
            return getEntries();
        } else {
            if ("pager".equals(name)) {
                return getPager();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EntriesResponse.NOT_FOUND_VALUE);
        if (EntriesResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EntriesResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EntriesResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entries");
        sb.append('=');
        sb.append(((this.entries == null)?"<null>":this.entries));
        sb.append(',');
        sb.append("pager");
        sb.append('=');
        sb.append(((this.pager == null)?"<null>":this.pager));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.entries == null)? 0 :this.entries.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.pager == null)? 0 :this.pager.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EntriesResponse) == false) {
            return false;
        }
        EntriesResponse rhs = ((EntriesResponse) other);
        return ((((this.entries == rhs.entries)||((this.entries!= null)&&this.entries.equals(rhs.entries)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.pager == rhs.pager)||((this.pager!= null)&&this.pager.equals(rhs.pager))));
    }

}
