
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataItem",
    "dateFilter",
    "eq",
    "ge",
    "gt",
    "in",
    "le",
    "like",
    "lt"
})
@Generated("jsonschema2pojo")
public class EventDataFilter implements Serializable
{

    @JsonProperty("dataItem")
    private String dataItem;
    @JsonProperty("dateFilter")
    private DateFilterPeriod dateFilter;
    @JsonProperty("eq")
    private String eq;
    @JsonProperty("ge")
    private String ge;
    @JsonProperty("gt")
    private String gt;
    @JsonProperty("in")
    private List<String> in;
    @JsonProperty("le")
    private String le;
    @JsonProperty("like")
    private String like;
    @JsonProperty("lt")
    private String lt;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1690493349301265744L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventDataFilter() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EventDataFilter(EventDataFilter source) {
        super();
        this.dataItem = source.dataItem;
        this.dateFilter = source.dateFilter;
        this.eq = source.eq;
        this.ge = source.ge;
        this.gt = source.gt;
        this.in = source.in;
        this.le = source.le;
        this.like = source.like;
        this.lt = source.lt;
    }

    public EventDataFilter(String dataItem, DateFilterPeriod dateFilter, String eq, String ge, String gt, List<String> in, String le, String like, String lt) {
        super();
        this.dataItem = dataItem;
        this.dateFilter = dateFilter;
        this.eq = eq;
        this.ge = ge;
        this.gt = gt;
        this.in = in;
        this.le = le;
        this.like = like;
        this.lt = lt;
    }

    @JsonProperty("dataItem")
    public Optional<String> getDataItem() {
        return Optional.ofNullable(dataItem);
    }

    @JsonProperty("dataItem")
    public void setDataItem(String dataItem) {
        this.dataItem = dataItem;
    }

    public EventDataFilter withDataItem(String dataItem) {
        this.dataItem = dataItem;
        return this;
    }

    @JsonProperty("dateFilter")
    public Optional<DateFilterPeriod> getDateFilter() {
        return Optional.ofNullable(dateFilter);
    }

    @JsonProperty("dateFilter")
    public void setDateFilter(DateFilterPeriod dateFilter) {
        this.dateFilter = dateFilter;
    }

    public EventDataFilter withDateFilter(DateFilterPeriod dateFilter) {
        this.dateFilter = dateFilter;
        return this;
    }

    @JsonProperty("eq")
    public Optional<String> getEq() {
        return Optional.ofNullable(eq);
    }

    @JsonProperty("eq")
    public void setEq(String eq) {
        this.eq = eq;
    }

    public EventDataFilter withEq(String eq) {
        this.eq = eq;
        return this;
    }

    @JsonProperty("ge")
    public Optional<String> getGe() {
        return Optional.ofNullable(ge);
    }

    @JsonProperty("ge")
    public void setGe(String ge) {
        this.ge = ge;
    }

    public EventDataFilter withGe(String ge) {
        this.ge = ge;
        return this;
    }

    @JsonProperty("gt")
    public Optional<String> getGt() {
        return Optional.ofNullable(gt);
    }

    @JsonProperty("gt")
    public void setGt(String gt) {
        this.gt = gt;
    }

    public EventDataFilter withGt(String gt) {
        this.gt = gt;
        return this;
    }

    @JsonProperty("in")
    public Optional<List<String>> getIn() {
        return Optional.ofNullable(in);
    }

    @JsonProperty("in")
    public void setIn(List<String> in) {
        this.in = in;
    }

    public EventDataFilter withIn(List<String> in) {
        this.in = in;
        return this;
    }

    @JsonProperty("le")
    public Optional<String> getLe() {
        return Optional.ofNullable(le);
    }

    @JsonProperty("le")
    public void setLe(String le) {
        this.le = le;
    }

    public EventDataFilter withLe(String le) {
        this.le = le;
        return this;
    }

    @JsonProperty("like")
    public Optional<String> getLike() {
        return Optional.ofNullable(like);
    }

    @JsonProperty("like")
    public void setLike(String like) {
        this.like = like;
    }

    public EventDataFilter withLike(String like) {
        this.like = like;
        return this;
    }

    @JsonProperty("lt")
    public Optional<String> getLt() {
        return Optional.ofNullable(lt);
    }

    @JsonProperty("lt")
    public void setLt(String lt) {
        this.lt = lt;
    }

    public EventDataFilter withLt(String lt) {
        this.lt = lt;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventDataFilter withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataItem".equals(name)) {
            if (value instanceof String) {
                setDataItem(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"dataItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dateFilter".equals(name)) {
                if (value instanceof DateFilterPeriod) {
                    setDateFilter(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"dateFilter\" is of type \"org.hisp.dhis.api.model.v40_0.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("eq".equals(name)) {
                    if (value instanceof String) {
                        setEq(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"eq\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("ge".equals(name)) {
                        if (value instanceof String) {
                            setGe(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"ge\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("gt".equals(name)) {
                            if (value instanceof String) {
                                setGt(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"gt\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("in".equals(name)) {
                                if (value instanceof List) {
                                    setIn(((List<String> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"in\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("le".equals(name)) {
                                    if (value instanceof String) {
                                        setLe(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"le\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("like".equals(name)) {
                                        if (value instanceof String) {
                                            setLike(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"like\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("lt".equals(name)) {
                                            if (value instanceof String) {
                                                setLt(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"lt\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataItem".equals(name)) {
            return getDataItem();
        } else {
            if ("dateFilter".equals(name)) {
                return getDateFilter();
            } else {
                if ("eq".equals(name)) {
                    return getEq();
                } else {
                    if ("ge".equals(name)) {
                        return getGe();
                    } else {
                        if ("gt".equals(name)) {
                            return getGt();
                        } else {
                            if ("in".equals(name)) {
                                return getIn();
                            } else {
                                if ("le".equals(name)) {
                                    return getLe();
                                } else {
                                    if ("like".equals(name)) {
                                        return getLike();
                                    } else {
                                        if ("lt".equals(name)) {
                                            return getLt();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EventDataFilter.NOT_FOUND_VALUE);
        if (EventDataFilter.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EventDataFilter with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventDataFilter.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataItem");
        sb.append('=');
        sb.append(((this.dataItem == null)?"<null>":this.dataItem));
        sb.append(',');
        sb.append("dateFilter");
        sb.append('=');
        sb.append(((this.dateFilter == null)?"<null>":this.dateFilter));
        sb.append(',');
        sb.append("eq");
        sb.append('=');
        sb.append(((this.eq == null)?"<null>":this.eq));
        sb.append(',');
        sb.append("ge");
        sb.append('=');
        sb.append(((this.ge == null)?"<null>":this.ge));
        sb.append(',');
        sb.append("gt");
        sb.append('=');
        sb.append(((this.gt == null)?"<null>":this.gt));
        sb.append(',');
        sb.append("in");
        sb.append('=');
        sb.append(((this.in == null)?"<null>":this.in));
        sb.append(',');
        sb.append("le");
        sb.append('=');
        sb.append(((this.le == null)?"<null>":this.le));
        sb.append(',');
        sb.append("like");
        sb.append('=');
        sb.append(((this.like == null)?"<null>":this.like));
        sb.append(',');
        sb.append("lt");
        sb.append('=');
        sb.append(((this.lt == null)?"<null>":this.lt));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataItem == null)? 0 :this.dataItem.hashCode()));
        result = ((result* 31)+((this.in == null)? 0 :this.in.hashCode()));
        result = ((result* 31)+((this.like == null)? 0 :this.like.hashCode()));
        result = ((result* 31)+((this.lt == null)? 0 :this.lt.hashCode()));
        result = ((result* 31)+((this.le == null)? 0 :this.le.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.eq == null)? 0 :this.eq.hashCode()));
        result = ((result* 31)+((this.gt == null)? 0 :this.gt.hashCode()));
        result = ((result* 31)+((this.ge == null)? 0 :this.ge.hashCode()));
        result = ((result* 31)+((this.dateFilter == null)? 0 :this.dateFilter.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EventDataFilter) == false) {
            return false;
        }
        EventDataFilter rhs = ((EventDataFilter) other);
        return (((((((((((this.dataItem == rhs.dataItem)||((this.dataItem!= null)&&this.dataItem.equals(rhs.dataItem)))&&((this.in == rhs.in)||((this.in!= null)&&this.in.equals(rhs.in))))&&((this.like == rhs.like)||((this.like!= null)&&this.like.equals(rhs.like))))&&((this.lt == rhs.lt)||((this.lt!= null)&&this.lt.equals(rhs.lt))))&&((this.le == rhs.le)||((this.le!= null)&&this.le.equals(rhs.le))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.eq == rhs.eq)||((this.eq!= null)&&this.eq.equals(rhs.eq))))&&((this.gt == rhs.gt)||((this.gt!= null)&&this.gt.equals(rhs.gt))))&&((this.ge == rhs.ge)||((this.ge!= null)&&this.ge.equals(rhs.ge))))&&((this.dateFilter == rhs.dateFilter)||((this.dateFilter!= null)&&this.dateFilter.equals(rhs.dateFilter))));
    }

}
