
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "headerWidth",
    "headers",
    "height",
    "internalMetaData",
    "lastDataRow",
    "metaColumnIndexes",
    "metaData",
    "metadataHeaders",
    "performanceMetrics",
    "refs",
    "rows",
    "subtitle",
    "table",
    "title",
    "visibleHeaders",
    "visibleRows",
    "visibleWidth",
    "width"
})
@Generated("jsonschema2pojo")
public class Grid implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("headerWidth")
    private Integer headerWidth;
    @JsonProperty("headers")
    private List<GridHeader> headers;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("height")
    private Integer height;
    @JsonProperty("internalMetaData")
    private InternalMetaData internalMetaData;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastDataRow")
    private Boolean lastDataRow;
    @JsonProperty("metaColumnIndexes")
    private List<Integer> metaColumnIndexes;
    @JsonProperty("metaData")
    private MetaData__1 metaData;
    @JsonProperty("metadataHeaders")
    private List<GridHeader> metadataHeaders;
    @JsonProperty("performanceMetrics")
    private PerformanceMetrics performanceMetrics;
    @JsonProperty("refs")
    private List<Reference> refs;
    @JsonProperty("rows")
    private List<List<Row>> rows;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("table")
    private String table;
    @JsonProperty("title")
    private String title;
    @JsonProperty("visibleHeaders")
    private List<GridHeader> visibleHeaders;
    @JsonProperty("visibleRows")
    private List<List<VisibleRow>> visibleRows;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("visibleWidth")
    private Integer visibleWidth;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("width")
    private Integer width;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -2378064896670641613L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Grid() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Grid(Grid source) {
        super();
        this.headerWidth = source.headerWidth;
        this.headers = source.headers;
        this.height = source.height;
        this.internalMetaData = source.internalMetaData;
        this.lastDataRow = source.lastDataRow;
        this.metaColumnIndexes = source.metaColumnIndexes;
        this.metaData = source.metaData;
        this.metadataHeaders = source.metadataHeaders;
        this.performanceMetrics = source.performanceMetrics;
        this.refs = source.refs;
        this.rows = source.rows;
        this.subtitle = source.subtitle;
        this.table = source.table;
        this.title = source.title;
        this.visibleHeaders = source.visibleHeaders;
        this.visibleRows = source.visibleRows;
        this.visibleWidth = source.visibleWidth;
        this.width = source.width;
    }

    public Grid(Integer headerWidth, List<GridHeader> headers, Integer height, InternalMetaData internalMetaData, Boolean lastDataRow, List<Integer> metaColumnIndexes, MetaData__1 metaData, List<GridHeader> metadataHeaders, PerformanceMetrics performanceMetrics, List<Reference> refs, List<List<Row>> rows, String subtitle, String table, String title, List<GridHeader> visibleHeaders, List<List<VisibleRow>> visibleRows, Integer visibleWidth, Integer width) {
        super();
        this.headerWidth = headerWidth;
        this.headers = headers;
        this.height = height;
        this.internalMetaData = internalMetaData;
        this.lastDataRow = lastDataRow;
        this.metaColumnIndexes = metaColumnIndexes;
        this.metaData = metaData;
        this.metadataHeaders = metadataHeaders;
        this.performanceMetrics = performanceMetrics;
        this.refs = refs;
        this.rows = rows;
        this.subtitle = subtitle;
        this.table = table;
        this.title = title;
        this.visibleHeaders = visibleHeaders;
        this.visibleRows = visibleRows;
        this.visibleWidth = visibleWidth;
        this.width = width;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("headerWidth")
    public Integer getHeaderWidth() {
        return headerWidth;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("headerWidth")
    public void setHeaderWidth(Integer headerWidth) {
        this.headerWidth = headerWidth;
    }

    public Grid withHeaderWidth(Integer headerWidth) {
        this.headerWidth = headerWidth;
        return this;
    }

    @JsonProperty("headers")
    public Optional<List<GridHeader>> getHeaders() {
        return Optional.ofNullable(headers);
    }

    @JsonProperty("headers")
    public void setHeaders(List<GridHeader> headers) {
        this.headers = headers;
    }

    public Grid withHeaders(List<GridHeader> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("height")
    public Integer getHeight() {
        return height;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("height")
    public void setHeight(Integer height) {
        this.height = height;
    }

    public Grid withHeight(Integer height) {
        this.height = height;
        return this;
    }

    @JsonProperty("internalMetaData")
    public Optional<InternalMetaData> getInternalMetaData() {
        return Optional.ofNullable(internalMetaData);
    }

    @JsonProperty("internalMetaData")
    public void setInternalMetaData(InternalMetaData internalMetaData) {
        this.internalMetaData = internalMetaData;
    }

    public Grid withInternalMetaData(InternalMetaData internalMetaData) {
        this.internalMetaData = internalMetaData;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastDataRow")
    public Boolean getLastDataRow() {
        return lastDataRow;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastDataRow")
    public void setLastDataRow(Boolean lastDataRow) {
        this.lastDataRow = lastDataRow;
    }

    public Grid withLastDataRow(Boolean lastDataRow) {
        this.lastDataRow = lastDataRow;
        return this;
    }

    @JsonProperty("metaColumnIndexes")
    public Optional<List<Integer>> getMetaColumnIndexes() {
        return Optional.ofNullable(metaColumnIndexes);
    }

    @JsonProperty("metaColumnIndexes")
    public void setMetaColumnIndexes(List<Integer> metaColumnIndexes) {
        this.metaColumnIndexes = metaColumnIndexes;
    }

    public Grid withMetaColumnIndexes(List<Integer> metaColumnIndexes) {
        this.metaColumnIndexes = metaColumnIndexes;
        return this;
    }

    @JsonProperty("metaData")
    public Optional<MetaData__1> getMetaData() {
        return Optional.ofNullable(metaData);
    }

    @JsonProperty("metaData")
    public void setMetaData(MetaData__1 metaData) {
        this.metaData = metaData;
    }

    public Grid withMetaData(MetaData__1 metaData) {
        this.metaData = metaData;
        return this;
    }

    @JsonProperty("metadataHeaders")
    public Optional<List<GridHeader>> getMetadataHeaders() {
        return Optional.ofNullable(metadataHeaders);
    }

    @JsonProperty("metadataHeaders")
    public void setMetadataHeaders(List<GridHeader> metadataHeaders) {
        this.metadataHeaders = metadataHeaders;
    }

    public Grid withMetadataHeaders(List<GridHeader> metadataHeaders) {
        this.metadataHeaders = metadataHeaders;
        return this;
    }

    @JsonProperty("performanceMetrics")
    public Optional<PerformanceMetrics> getPerformanceMetrics() {
        return Optional.ofNullable(performanceMetrics);
    }

    @JsonProperty("performanceMetrics")
    public void setPerformanceMetrics(PerformanceMetrics performanceMetrics) {
        this.performanceMetrics = performanceMetrics;
    }

    public Grid withPerformanceMetrics(PerformanceMetrics performanceMetrics) {
        this.performanceMetrics = performanceMetrics;
        return this;
    }

    @JsonProperty("refs")
    public Optional<List<Reference>> getRefs() {
        return Optional.ofNullable(refs);
    }

    @JsonProperty("refs")
    public void setRefs(List<Reference> refs) {
        this.refs = refs;
    }

    public Grid withRefs(List<Reference> refs) {
        this.refs = refs;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<List<Row>>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<List<Row>> rows) {
        this.rows = rows;
    }

    public Grid withRows(List<List<Row>> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Grid withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("table")
    public Optional<String> getTable() {
        return Optional.ofNullable(table);
    }

    @JsonProperty("table")
    public void setTable(String table) {
        this.table = table;
    }

    public Grid withTable(String table) {
        this.table = table;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Grid withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("visibleHeaders")
    public Optional<List<GridHeader>> getVisibleHeaders() {
        return Optional.ofNullable(visibleHeaders);
    }

    @JsonProperty("visibleHeaders")
    public void setVisibleHeaders(List<GridHeader> visibleHeaders) {
        this.visibleHeaders = visibleHeaders;
    }

    public Grid withVisibleHeaders(List<GridHeader> visibleHeaders) {
        this.visibleHeaders = visibleHeaders;
        return this;
    }

    @JsonProperty("visibleRows")
    public Optional<List<List<VisibleRow>>> getVisibleRows() {
        return Optional.ofNullable(visibleRows);
    }

    @JsonProperty("visibleRows")
    public void setVisibleRows(List<List<VisibleRow>> visibleRows) {
        this.visibleRows = visibleRows;
    }

    public Grid withVisibleRows(List<List<VisibleRow>> visibleRows) {
        this.visibleRows = visibleRows;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("visibleWidth")
    public Integer getVisibleWidth() {
        return visibleWidth;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("visibleWidth")
    public void setVisibleWidth(Integer visibleWidth) {
        this.visibleWidth = visibleWidth;
    }

    public Grid withVisibleWidth(Integer visibleWidth) {
        this.visibleWidth = visibleWidth;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("width")
    public Integer getWidth() {
        return width;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("width")
    public void setWidth(Integer width) {
        this.width = width;
    }

    public Grid withWidth(Integer width) {
        this.width = width;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Grid withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("headerWidth".equals(name)) {
            if (value instanceof Integer) {
                setHeaderWidth(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"headerWidth\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("headers".equals(name)) {
                if (value instanceof List) {
                    setHeaders(((List<GridHeader> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"headers\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.GridHeader>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("height".equals(name)) {
                    if (value instanceof Integer) {
                        setHeight(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"height\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("internalMetaData".equals(name)) {
                        if (value instanceof InternalMetaData) {
                            setInternalMetaData(((InternalMetaData) value));
                        } else {
                            throw new IllegalArgumentException(("property \"internalMetaData\" is of type \"org.hisp.dhis.api.model.v40_0.InternalMetaData\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("lastDataRow".equals(name)) {
                            if (value instanceof Boolean) {
                                setLastDataRow(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"lastDataRow\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("metaColumnIndexes".equals(name)) {
                                if (value instanceof List) {
                                    setMetaColumnIndexes(((List<Integer> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"metaColumnIndexes\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("metaData".equals(name)) {
                                    if (value instanceof MetaData__1) {
                                        setMetaData(((MetaData__1) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"metaData\" is of type \"org.hisp.dhis.api.model.v40_0.MetaData__1\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("metadataHeaders".equals(name)) {
                                        if (value instanceof List) {
                                            setMetadataHeaders(((List<GridHeader> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"metadataHeaders\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.GridHeader>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("performanceMetrics".equals(name)) {
                                            if (value instanceof PerformanceMetrics) {
                                                setPerformanceMetrics(((PerformanceMetrics) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"performanceMetrics\" is of type \"org.hisp.dhis.api.model.v40_0.PerformanceMetrics\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("refs".equals(name)) {
                                                if (value instanceof List) {
                                                    setRefs(((List<Reference> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"refs\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Reference>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("rows".equals(name)) {
                                                    if (value instanceof List) {
                                                        setRows(((List<List<Row>> ) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<java.util.List<org.hisp.dhis.api.model.v40_0.Row>>\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("subtitle".equals(name)) {
                                                        if (value instanceof String) {
                                                            setSubtitle(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("table".equals(name)) {
                                                            if (value instanceof String) {
                                                                setTable(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"table\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("title".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setTitle(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("visibleHeaders".equals(name)) {
                                                                    if (value instanceof List) {
                                                                        setVisibleHeaders(((List<GridHeader> ) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"visibleHeaders\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.GridHeader>\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("visibleRows".equals(name)) {
                                                                        if (value instanceof List) {
                                                                            setVisibleRows(((List<List<VisibleRow>> ) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"visibleRows\" is of type \"java.util.List<java.util.List<org.hisp.dhis.api.model.v40_0.VisibleRow>>\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("visibleWidth".equals(name)) {
                                                                            if (value instanceof Integer) {
                                                                                setVisibleWidth(((Integer) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"visibleWidth\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("width".equals(name)) {
                                                                                if (value instanceof Integer) {
                                                                                    setWidth(((Integer) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"width\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                return false;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("headerWidth".equals(name)) {
            return getHeaderWidth();
        } else {
            if ("headers".equals(name)) {
                return getHeaders();
            } else {
                if ("height".equals(name)) {
                    return getHeight();
                } else {
                    if ("internalMetaData".equals(name)) {
                        return getInternalMetaData();
                    } else {
                        if ("lastDataRow".equals(name)) {
                            return getLastDataRow();
                        } else {
                            if ("metaColumnIndexes".equals(name)) {
                                return getMetaColumnIndexes();
                            } else {
                                if ("metaData".equals(name)) {
                                    return getMetaData();
                                } else {
                                    if ("metadataHeaders".equals(name)) {
                                        return getMetadataHeaders();
                                    } else {
                                        if ("performanceMetrics".equals(name)) {
                                            return getPerformanceMetrics();
                                        } else {
                                            if ("refs".equals(name)) {
                                                return getRefs();
                                            } else {
                                                if ("rows".equals(name)) {
                                                    return getRows();
                                                } else {
                                                    if ("subtitle".equals(name)) {
                                                        return getSubtitle();
                                                    } else {
                                                        if ("table".equals(name)) {
                                                            return getTable();
                                                        } else {
                                                            if ("title".equals(name)) {
                                                                return getTitle();
                                                            } else {
                                                                if ("visibleHeaders".equals(name)) {
                                                                    return getVisibleHeaders();
                                                                } else {
                                                                    if ("visibleRows".equals(name)) {
                                                                        return getVisibleRows();
                                                                    } else {
                                                                        if ("visibleWidth".equals(name)) {
                                                                            return getVisibleWidth();
                                                                        } else {
                                                                            if ("width".equals(name)) {
                                                                                return getWidth();
                                                                            } else {
                                                                                return notFoundValue;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Grid.NOT_FOUND_VALUE);
        if (Grid.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Grid with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Grid.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("headerWidth");
        sb.append('=');
        sb.append(((this.headerWidth == null)?"<null>":this.headerWidth));
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(((this.headers == null)?"<null>":this.headers));
        sb.append(',');
        sb.append("height");
        sb.append('=');
        sb.append(((this.height == null)?"<null>":this.height));
        sb.append(',');
        sb.append("internalMetaData");
        sb.append('=');
        sb.append(((this.internalMetaData == null)?"<null>":this.internalMetaData));
        sb.append(',');
        sb.append("lastDataRow");
        sb.append('=');
        sb.append(((this.lastDataRow == null)?"<null>":this.lastDataRow));
        sb.append(',');
        sb.append("metaColumnIndexes");
        sb.append('=');
        sb.append(((this.metaColumnIndexes == null)?"<null>":this.metaColumnIndexes));
        sb.append(',');
        sb.append("metaData");
        sb.append('=');
        sb.append(((this.metaData == null)?"<null>":this.metaData));
        sb.append(',');
        sb.append("metadataHeaders");
        sb.append('=');
        sb.append(((this.metadataHeaders == null)?"<null>":this.metadataHeaders));
        sb.append(',');
        sb.append("performanceMetrics");
        sb.append('=');
        sb.append(((this.performanceMetrics == null)?"<null>":this.performanceMetrics));
        sb.append(',');
        sb.append("refs");
        sb.append('=');
        sb.append(((this.refs == null)?"<null>":this.refs));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("table");
        sb.append('=');
        sb.append(((this.table == null)?"<null>":this.table));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("visibleHeaders");
        sb.append('=');
        sb.append(((this.visibleHeaders == null)?"<null>":this.visibleHeaders));
        sb.append(',');
        sb.append("visibleRows");
        sb.append('=');
        sb.append(((this.visibleRows == null)?"<null>":this.visibleRows));
        sb.append(',');
        sb.append("visibleWidth");
        sb.append('=');
        sb.append(((this.visibleWidth == null)?"<null>":this.visibleWidth));
        sb.append(',');
        sb.append("width");
        sb.append('=');
        sb.append(((this.width == null)?"<null>":this.width));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.headers == null)? 0 :this.headers.hashCode()));
        result = ((result* 31)+((this.metaColumnIndexes == null)? 0 :this.metaColumnIndexes.hashCode()));
        result = ((result* 31)+((this.headerWidth == null)? 0 :this.headerWidth.hashCode()));
        result = ((result* 31)+((this.performanceMetrics == null)? 0 :this.performanceMetrics.hashCode()));
        result = ((result* 31)+((this.lastDataRow == null)? 0 :this.lastDataRow.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.visibleRows == null)? 0 :this.visibleRows.hashCode()));
        result = ((result* 31)+((this.metadataHeaders == null)? 0 :this.metadataHeaders.hashCode()));
        result = ((result* 31)+((this.metaData == null)? 0 :this.metaData.hashCode()));
        result = ((result* 31)+((this.visibleHeaders == null)? 0 :this.visibleHeaders.hashCode()));
        result = ((result* 31)+((this.visibleWidth == null)? 0 :this.visibleWidth.hashCode()));
        result = ((result* 31)+((this.internalMetaData == null)? 0 :this.internalMetaData.hashCode()));
        result = ((result* 31)+((this.refs == null)? 0 :this.refs.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.width == null)? 0 :this.width.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.table == null)? 0 :this.table.hashCode()));
        result = ((result* 31)+((this.height == null)? 0 :this.height.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Grid) == false) {
            return false;
        }
        Grid rhs = ((Grid) other);
        return ((((((((((((((((((((this.headers == rhs.headers)||((this.headers!= null)&&this.headers.equals(rhs.headers)))&&((this.metaColumnIndexes == rhs.metaColumnIndexes)||((this.metaColumnIndexes!= null)&&this.metaColumnIndexes.equals(rhs.metaColumnIndexes))))&&((this.headerWidth == rhs.headerWidth)||((this.headerWidth!= null)&&this.headerWidth.equals(rhs.headerWidth))))&&((this.performanceMetrics == rhs.performanceMetrics)||((this.performanceMetrics!= null)&&this.performanceMetrics.equals(rhs.performanceMetrics))))&&((this.lastDataRow == rhs.lastDataRow)||((this.lastDataRow!= null)&&this.lastDataRow.equals(rhs.lastDataRow))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.visibleRows == rhs.visibleRows)||((this.visibleRows!= null)&&this.visibleRows.equals(rhs.visibleRows))))&&((this.metadataHeaders == rhs.metadataHeaders)||((this.metadataHeaders!= null)&&this.metadataHeaders.equals(rhs.metadataHeaders))))&&((this.metaData == rhs.metaData)||((this.metaData!= null)&&this.metaData.equals(rhs.metaData))))&&((this.visibleHeaders == rhs.visibleHeaders)||((this.visibleHeaders!= null)&&this.visibleHeaders.equals(rhs.visibleHeaders))))&&((this.visibleWidth == rhs.visibleWidth)||((this.visibleWidth!= null)&&this.visibleWidth.equals(rhs.visibleWidth))))&&((this.internalMetaData == rhs.internalMetaData)||((this.internalMetaData!= null)&&this.internalMetaData.equals(rhs.internalMetaData))))&&((this.refs == rhs.refs)||((this.refs!= null)&&this.refs.equals(rhs.refs))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.width == rhs.width)||((this.width!= null)&&this.width.equals(rhs.width))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.table == rhs.table)||((this.table!= null)&&this.table.equals(rhs.table))))&&((this.height == rhs.height)||((this.height!= null)&&this.height.equals(rhs.height))));
    }

}
