
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "column",
    "hidden",
    "legendSet",
    "meta",
    "name",
    "optionSet",
    "programStage",
    "repeatableStageParams",
    "stageOffset",
    "type",
    "valueType"
})
@Generated("jsonschema2pojo")
public class GridHeader implements Serializable
{

    @JsonProperty("column")
    private String column;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hidden")
    private Boolean hidden;
    @JsonProperty("legendSet")
    private String legendSet;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("meta")
    private Boolean meta;
    @JsonProperty("name")
    private String name;
    @JsonProperty("optionSet")
    private String optionSet;
    @JsonProperty("programStage")
    private String programStage;
    @JsonProperty("repeatableStageParams")
    private String repeatableStageParams;
    @JsonProperty("stageOffset")
    private Integer stageOffset;
    @JsonProperty("type")
    private String type;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private GridHeader.ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6519320612437176619L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GridHeader() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public GridHeader(GridHeader source) {
        super();
        this.column = source.column;
        this.hidden = source.hidden;
        this.legendSet = source.legendSet;
        this.meta = source.meta;
        this.name = source.name;
        this.optionSet = source.optionSet;
        this.programStage = source.programStage;
        this.repeatableStageParams = source.repeatableStageParams;
        this.stageOffset = source.stageOffset;
        this.type = source.type;
        this.valueType = source.valueType;
    }

    public GridHeader(String column, Boolean hidden, String legendSet, Boolean meta, String name, String optionSet, String programStage, String repeatableStageParams, Integer stageOffset, String type, GridHeader.ValueType valueType) {
        super();
        this.column = column;
        this.hidden = hidden;
        this.legendSet = legendSet;
        this.meta = meta;
        this.name = name;
        this.optionSet = optionSet;
        this.programStage = programStage;
        this.repeatableStageParams = repeatableStageParams;
        this.stageOffset = stageOffset;
        this.type = type;
        this.valueType = valueType;
    }

    @JsonProperty("column")
    public Optional<String> getColumn() {
        return Optional.ofNullable(column);
    }

    @JsonProperty("column")
    public void setColumn(String column) {
        this.column = column;
    }

    public GridHeader withColumn(String column) {
        this.column = column;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hidden")
    public Boolean getHidden() {
        return hidden;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hidden")
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public GridHeader withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<String> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(String legendSet) {
        this.legendSet = legendSet;
    }

    public GridHeader withLegendSet(String legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("meta")
    public Boolean getMeta() {
        return meta;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("meta")
    public void setMeta(Boolean meta) {
        this.meta = meta;
    }

    public GridHeader withMeta(Boolean meta) {
        this.meta = meta;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public GridHeader withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("optionSet")
    public Optional<String> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    @JsonProperty("optionSet")
    public void setOptionSet(String optionSet) {
        this.optionSet = optionSet;
    }

    public GridHeader withOptionSet(String optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public GridHeader withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("repeatableStageParams")
    public Optional<String> getRepeatableStageParams() {
        return Optional.ofNullable(repeatableStageParams);
    }

    @JsonProperty("repeatableStageParams")
    public void setRepeatableStageParams(String repeatableStageParams) {
        this.repeatableStageParams = repeatableStageParams;
    }

    public GridHeader withRepeatableStageParams(String repeatableStageParams) {
        this.repeatableStageParams = repeatableStageParams;
        return this;
    }

    @JsonProperty("stageOffset")
    public Optional<Integer> getStageOffset() {
        return Optional.ofNullable(stageOffset);
    }

    @JsonProperty("stageOffset")
    public void setStageOffset(Integer stageOffset) {
        this.stageOffset = stageOffset;
    }

    public GridHeader withStageOffset(Integer stageOffset) {
        this.stageOffset = stageOffset;
        return this;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public GridHeader withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public GridHeader.ValueType getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(GridHeader.ValueType valueType) {
        this.valueType = valueType;
    }

    public GridHeader withValueType(GridHeader.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GridHeader withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("column".equals(name)) {
            if (value instanceof String) {
                setColumn(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"column\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("hidden".equals(name)) {
                if (value instanceof Boolean) {
                    setHidden(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hidden\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("legendSet".equals(name)) {
                    if (value instanceof String) {
                        setLegendSet(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"legendSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("meta".equals(name)) {
                        if (value instanceof Boolean) {
                            setMeta(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"meta\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("name".equals(name)) {
                            if (value instanceof String) {
                                setName(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("optionSet".equals(name)) {
                                if (value instanceof String) {
                                    setOptionSet(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"optionSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("programStage".equals(name)) {
                                    if (value instanceof String) {
                                        setProgramStage(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("repeatableStageParams".equals(name)) {
                                        if (value instanceof String) {
                                            setRepeatableStageParams(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"repeatableStageParams\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("stageOffset".equals(name)) {
                                            if (value instanceof Integer) {
                                                setStageOffset(((Integer) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"stageOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("type".equals(name)) {
                                                if (value instanceof String) {
                                                    setType(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("valueType".equals(name)) {
                                                    if (value instanceof GridHeader.ValueType) {
                                                        setValueType(((GridHeader.ValueType) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.GridHeader.ValueType\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    return false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("column".equals(name)) {
            return getColumn();
        } else {
            if ("hidden".equals(name)) {
                return getHidden();
            } else {
                if ("legendSet".equals(name)) {
                    return getLegendSet();
                } else {
                    if ("meta".equals(name)) {
                        return getMeta();
                    } else {
                        if ("name".equals(name)) {
                            return getName();
                        } else {
                            if ("optionSet".equals(name)) {
                                return getOptionSet();
                            } else {
                                if ("programStage".equals(name)) {
                                    return getProgramStage();
                                } else {
                                    if ("repeatableStageParams".equals(name)) {
                                        return getRepeatableStageParams();
                                    } else {
                                        if ("stageOffset".equals(name)) {
                                            return getStageOffset();
                                        } else {
                                            if ("type".equals(name)) {
                                                return getType();
                                            } else {
                                                if ("valueType".equals(name)) {
                                                    return getValueType();
                                                } else {
                                                    return notFoundValue;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GridHeader.NOT_FOUND_VALUE);
        if (GridHeader.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GridHeader with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GridHeader.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("column");
        sb.append('=');
        sb.append(((this.column == null)?"<null>":this.column));
        sb.append(',');
        sb.append("hidden");
        sb.append('=');
        sb.append(((this.hidden == null)?"<null>":this.hidden));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("meta");
        sb.append('=');
        sb.append(((this.meta == null)?"<null>":this.meta));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("repeatableStageParams");
        sb.append('=');
        sb.append(((this.repeatableStageParams == null)?"<null>":this.repeatableStageParams));
        sb.append(',');
        sb.append("stageOffset");
        sb.append('=');
        sb.append(((this.stageOffset == null)?"<null>":this.stageOffset));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.hidden == null)? 0 :this.hidden.hashCode()));
        result = ((result* 31)+((this.column == null)? 0 :this.column.hashCode()));
        result = ((result* 31)+((this.repeatableStageParams == null)? 0 :this.repeatableStageParams.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.stageOffset == null)? 0 :this.stageOffset.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.meta == null)? 0 :this.meta.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GridHeader) == false) {
            return false;
        }
        GridHeader rhs = ((GridHeader) other);
        return (((((((((((((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage)))&&((this.hidden == rhs.hidden)||((this.hidden!= null)&&this.hidden.equals(rhs.hidden))))&&((this.column == rhs.column)||((this.column!= null)&&this.column.equals(rhs.column))))&&((this.repeatableStageParams == rhs.repeatableStageParams)||((this.repeatableStageParams!= null)&&this.repeatableStageParams.equals(rhs.repeatableStageParams))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.stageOffset == rhs.stageOffset)||((this.stageOffset!= null)&&this.stageOffset.equals(rhs.stageOffset))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.meta == rhs.meta)||((this.meta!= null)&&this.meta.equals(rhs.meta))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueType {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, GridHeader.ValueType> CONSTANTS = new HashMap<String, GridHeader.ValueType>();

        static {
            for (GridHeader.ValueType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GridHeader.ValueType fromValue(String value) {
            GridHeader.ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
