
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "listGrid",
    "pager"
})
@Generated("jsonschema2pojo")
public class GridResponse implements Serializable
{

    @JsonProperty("listGrid")
    private Grid listGrid;
    @JsonProperty("pager")
    private Pager pager;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4343127885285874974L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GridResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public GridResponse(GridResponse source) {
        super();
        this.listGrid = source.listGrid;
        this.pager = source.pager;
    }

    public GridResponse(Grid listGrid, Pager pager) {
        super();
        this.listGrid = listGrid;
        this.pager = pager;
    }

    @JsonProperty("listGrid")
    public Optional<Grid> getListGrid() {
        return Optional.ofNullable(listGrid);
    }

    @JsonProperty("listGrid")
    public void setListGrid(Grid listGrid) {
        this.listGrid = listGrid;
    }

    public GridResponse withListGrid(Grid listGrid) {
        this.listGrid = listGrid;
        return this;
    }

    @JsonProperty("pager")
    public Optional<Pager> getPager() {
        return Optional.ofNullable(pager);
    }

    @JsonProperty("pager")
    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public GridResponse withPager(Pager pager) {
        this.pager = pager;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GridResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("listGrid".equals(name)) {
            if (value instanceof Grid) {
                setListGrid(((Grid) value));
            } else {
                throw new IllegalArgumentException(("property \"listGrid\" is of type \"org.hisp.dhis.api.model.v40_0.Grid\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("pager".equals(name)) {
                if (value instanceof Pager) {
                    setPager(((Pager) value));
                } else {
                    throw new IllegalArgumentException(("property \"pager\" is of type \"org.hisp.dhis.api.model.v40_0.Pager\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("listGrid".equals(name)) {
            return getListGrid();
        } else {
            if ("pager".equals(name)) {
                return getPager();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GridResponse.NOT_FOUND_VALUE);
        if (GridResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GridResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GridResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("listGrid");
        sb.append('=');
        sb.append(((this.listGrid == null)?"<null>":this.listGrid));
        sb.append(',');
        sb.append("pager");
        sb.append('=');
        sb.append(((this.pager == null)?"<null>":this.pager));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.listGrid == null)? 0 :this.listGrid.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.pager == null)? 0 :this.pager.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GridResponse) == false) {
            return false;
        }
        GridResponse rhs = ((GridResponse) other);
        return ((((this.listGrid == rhs.listGrid)||((this.listGrid!= null)&&this.listGrid.equals(rhs.listGrid)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.pager == rhs.pager)||((this.pager!= null)&&this.pager.equals(rhs.pager))));
    }

}
