
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataElementCount",
    "description",
    "fields",
    "label",
    "metaData"
})
@Generated("jsonschema2pojo")
public class Group implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementCount")
    private Integer dataElementCount;
    @JsonProperty("description")
    private String description;
    @JsonProperty("fields")
    private List<Field> fields;
    @JsonProperty("label")
    private String label;
    /**
     * keys are class java.lang.Object
     * 
     */
    @JsonProperty("metaData")
    @JsonPropertyDescription("keys are class java.lang.Object")
    private MetaData metaData;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3389371960108853520L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Group() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Group(Group source) {
        super();
        this.dataElementCount = source.dataElementCount;
        this.description = source.description;
        this.fields = source.fields;
        this.label = source.label;
        this.metaData = source.metaData;
    }

    /**
     * 
     * @param metaData
     *     keys are class java.lang.Object.
     */
    public Group(Integer dataElementCount, String description, List<Field> fields, String label, MetaData metaData) {
        super();
        this.dataElementCount = dataElementCount;
        this.description = description;
        this.fields = fields;
        this.label = label;
        this.metaData = metaData;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementCount")
    public Integer getDataElementCount() {
        return dataElementCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementCount")
    public void setDataElementCount(Integer dataElementCount) {
        this.dataElementCount = dataElementCount;
    }

    public Group withDataElementCount(Integer dataElementCount) {
        this.dataElementCount = dataElementCount;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Group withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("fields")
    public Optional<List<Field>> getFields() {
        return Optional.ofNullable(fields);
    }

    @JsonProperty("fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Group withFields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty("label")
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    @JsonProperty("label")
    public void setLabel(String label) {
        this.label = label;
    }

    public Group withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * keys are class java.lang.Object
     * 
     */
    @JsonProperty("metaData")
    public Optional<MetaData> getMetaData() {
        return Optional.ofNullable(metaData);
    }

    /**
     * keys are class java.lang.Object
     * 
     */
    @JsonProperty("metaData")
    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public Group withMetaData(MetaData metaData) {
        this.metaData = metaData;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Group withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataElementCount".equals(name)) {
            if (value instanceof Integer) {
                setDataElementCount(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"dataElementCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("description".equals(name)) {
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("fields".equals(name)) {
                    if (value instanceof List) {
                        setFields(((List<Field> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"fields\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Field>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("label".equals(name)) {
                        if (value instanceof String) {
                            setLabel(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"label\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("metaData".equals(name)) {
                            if (value instanceof MetaData) {
                                setMetaData(((MetaData) value));
                            } else {
                                throw new IllegalArgumentException(("property \"metaData\" is of type \"org.hisp.dhis.api.model.v40_0.MetaData\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataElementCount".equals(name)) {
            return getDataElementCount();
        } else {
            if ("description".equals(name)) {
                return getDescription();
            } else {
                if ("fields".equals(name)) {
                    return getFields();
                } else {
                    if ("label".equals(name)) {
                        return getLabel();
                    } else {
                        if ("metaData".equals(name)) {
                            return getMetaData();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Group.NOT_FOUND_VALUE);
        if (Group.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Group with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Group.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataElementCount");
        sb.append('=');
        sb.append(((this.dataElementCount == null)?"<null>":this.dataElementCount));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("fields");
        sb.append('=');
        sb.append(((this.fields == null)?"<null>":this.fields));
        sb.append(',');
        sb.append("label");
        sb.append('=');
        sb.append(((this.label == null)?"<null>":this.label));
        sb.append(',');
        sb.append("metaData");
        sb.append('=');
        sb.append(((this.metaData == null)?"<null>":this.metaData));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.metaData == null)? 0 :this.metaData.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.dataElementCount == null)? 0 :this.dataElementCount.hashCode()));
        result = ((result* 31)+((this.label == null)? 0 :this.label.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.fields == null)? 0 :this.fields.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Group) == false) {
            return false;
        }
        Group rhs = ((Group) other);
        return (((((((this.metaData == rhs.metaData)||((this.metaData!= null)&&this.metaData.equals(rhs.metaData)))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.dataElementCount == rhs.dataElementCount)||((this.dataElementCount!= null)&&this.dataElementCount.equals(rhs.dataElementCount))))&&((this.label == rhs.label)||((this.label!= null)&&this.label.equals(rhs.label))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.fields == rhs.fields)||((this.fields!= null)&&this.fields.equals(rhs.fields))));
    }

}
