
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "async",
    "dataSet",
    "datasetAllowsPeriods",
    "dryRun",
    "filename",
    "firstRowIsHeader",
    "force",
    "idSchemes",
    "ignoreEmptyCollection",
    "importStrategy",
    "mergeDataValues",
    "mergeMode",
    "notificationLevel",
    "preheatCache",
    "reportMode",
    "requireAttributeOptionCombo",
    "requireCategoryOptionCombo",
    "sharing",
    "skipAudit",
    "skipCache",
    "skipExistingCheck",
    "skipLastUpdated",
    "skipNotifications",
    "skipPatternValidation",
    "strictAttributeOptionCombos",
    "strictCategoryOptionCombos",
    "strictDataElements",
    "strictDataSetApproval",
    "strictDataSetInputPeriods",
    "strictDataSetLocking",
    "strictOrganisationUnits",
    "strictPeriods"
})
@Generated("jsonschema2pojo")
public class ImportOptions implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("async")
    private Boolean async;
    @JsonProperty("dataSet")
    private String dataSet;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("datasetAllowsPeriods")
    private Boolean datasetAllowsPeriods;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dryRun")
    private Boolean dryRun;
    @JsonProperty("filename")
    private String filename;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("firstRowIsHeader")
    private Boolean firstRowIsHeader;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("force")
    private Boolean force;
    @JsonProperty("idSchemes")
    private IdSchemes idSchemes;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ignoreEmptyCollection")
    private Boolean ignoreEmptyCollection;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    private ImportOptions.ImportStrategy importStrategy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeDataValues")
    private Boolean mergeDataValues;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    private ImportOptions.MergeMode mergeMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationLevel")
    private ImportOptions.NotificationLevel notificationLevel;
    @JsonProperty("preheatCache")
    private Boolean preheatCache;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("reportMode")
    private ImportOptions.ReportMode reportMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("requireAttributeOptionCombo")
    private Boolean requireAttributeOptionCombo;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("requireCategoryOptionCombo")
    private Boolean requireCategoryOptionCombo;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sharing")
    private Boolean sharing;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipAudit")
    private Boolean skipAudit;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipCache")
    private Boolean skipCache;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipExistingCheck")
    private Boolean skipExistingCheck;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipLastUpdated")
    private Boolean skipLastUpdated;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipNotifications")
    private Boolean skipNotifications;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipPatternValidation")
    private Boolean skipPatternValidation;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictAttributeOptionCombos")
    private Boolean strictAttributeOptionCombos;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictCategoryOptionCombos")
    private Boolean strictCategoryOptionCombos;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataElements")
    private Boolean strictDataElements;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetApproval")
    private Boolean strictDataSetApproval;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetInputPeriods")
    private Boolean strictDataSetInputPeriods;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetLocking")
    private Boolean strictDataSetLocking;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictOrganisationUnits")
    private Boolean strictOrganisationUnits;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictPeriods")
    private Boolean strictPeriods;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1033592195762191353L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportOptions() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportOptions(ImportOptions source) {
        super();
        this.async = source.async;
        this.dataSet = source.dataSet;
        this.datasetAllowsPeriods = source.datasetAllowsPeriods;
        this.dryRun = source.dryRun;
        this.filename = source.filename;
        this.firstRowIsHeader = source.firstRowIsHeader;
        this.force = source.force;
        this.idSchemes = source.idSchemes;
        this.ignoreEmptyCollection = source.ignoreEmptyCollection;
        this.importStrategy = source.importStrategy;
        this.mergeDataValues = source.mergeDataValues;
        this.mergeMode = source.mergeMode;
        this.notificationLevel = source.notificationLevel;
        this.preheatCache = source.preheatCache;
        this.reportMode = source.reportMode;
        this.requireAttributeOptionCombo = source.requireAttributeOptionCombo;
        this.requireCategoryOptionCombo = source.requireCategoryOptionCombo;
        this.sharing = source.sharing;
        this.skipAudit = source.skipAudit;
        this.skipCache = source.skipCache;
        this.skipExistingCheck = source.skipExistingCheck;
        this.skipLastUpdated = source.skipLastUpdated;
        this.skipNotifications = source.skipNotifications;
        this.skipPatternValidation = source.skipPatternValidation;
        this.strictAttributeOptionCombos = source.strictAttributeOptionCombos;
        this.strictCategoryOptionCombos = source.strictCategoryOptionCombos;
        this.strictDataElements = source.strictDataElements;
        this.strictDataSetApproval = source.strictDataSetApproval;
        this.strictDataSetInputPeriods = source.strictDataSetInputPeriods;
        this.strictDataSetLocking = source.strictDataSetLocking;
        this.strictOrganisationUnits = source.strictOrganisationUnits;
        this.strictPeriods = source.strictPeriods;
    }

    public ImportOptions(Boolean async, String dataSet, Boolean datasetAllowsPeriods, Boolean dryRun, String filename, Boolean firstRowIsHeader, Boolean force, IdSchemes idSchemes, Boolean ignoreEmptyCollection, ImportOptions.ImportStrategy importStrategy, Boolean mergeDataValues, ImportOptions.MergeMode mergeMode, ImportOptions.NotificationLevel notificationLevel, Boolean preheatCache, ImportOptions.ReportMode reportMode, Boolean requireAttributeOptionCombo, Boolean requireCategoryOptionCombo, Boolean sharing, Boolean skipAudit, Boolean skipCache, Boolean skipExistingCheck, Boolean skipLastUpdated, Boolean skipNotifications, Boolean skipPatternValidation, Boolean strictAttributeOptionCombos, Boolean strictCategoryOptionCombos, Boolean strictDataElements, Boolean strictDataSetApproval, Boolean strictDataSetInputPeriods, Boolean strictDataSetLocking, Boolean strictOrganisationUnits, Boolean strictPeriods) {
        super();
        this.async = async;
        this.dataSet = dataSet;
        this.datasetAllowsPeriods = datasetAllowsPeriods;
        this.dryRun = dryRun;
        this.filename = filename;
        this.firstRowIsHeader = firstRowIsHeader;
        this.force = force;
        this.idSchemes = idSchemes;
        this.ignoreEmptyCollection = ignoreEmptyCollection;
        this.importStrategy = importStrategy;
        this.mergeDataValues = mergeDataValues;
        this.mergeMode = mergeMode;
        this.notificationLevel = notificationLevel;
        this.preheatCache = preheatCache;
        this.reportMode = reportMode;
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
        this.sharing = sharing;
        this.skipAudit = skipAudit;
        this.skipCache = skipCache;
        this.skipExistingCheck = skipExistingCheck;
        this.skipLastUpdated = skipLastUpdated;
        this.skipNotifications = skipNotifications;
        this.skipPatternValidation = skipPatternValidation;
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
        this.strictDataElements = strictDataElements;
        this.strictDataSetApproval = strictDataSetApproval;
        this.strictDataSetInputPeriods = strictDataSetInputPeriods;
        this.strictDataSetLocking = strictDataSetLocking;
        this.strictOrganisationUnits = strictOrganisationUnits;
        this.strictPeriods = strictPeriods;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("async")
    public Boolean getAsync() {
        return async;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("async")
    public void setAsync(Boolean async) {
        this.async = async;
    }

    public ImportOptions withAsync(Boolean async) {
        this.async = async;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<String> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public ImportOptions withDataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("datasetAllowsPeriods")
    public Boolean getDatasetAllowsPeriods() {
        return datasetAllowsPeriods;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("datasetAllowsPeriods")
    public void setDatasetAllowsPeriods(Boolean datasetAllowsPeriods) {
        this.datasetAllowsPeriods = datasetAllowsPeriods;
    }

    public ImportOptions withDatasetAllowsPeriods(Boolean datasetAllowsPeriods) {
        this.datasetAllowsPeriods = datasetAllowsPeriods;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dryRun")
    public Boolean getDryRun() {
        return dryRun;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ImportOptions withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty("filename")
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    @JsonProperty("filename")
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ImportOptions withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("firstRowIsHeader")
    public Boolean getFirstRowIsHeader() {
        return firstRowIsHeader;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("firstRowIsHeader")
    public void setFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
    }

    public ImportOptions withFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("force")
    public Boolean getForce() {
        return force;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("force")
    public void setForce(Boolean force) {
        this.force = force;
    }

    public ImportOptions withForce(Boolean force) {
        this.force = force;
        return this;
    }

    @JsonProperty("idSchemes")
    public Optional<IdSchemes> getIdSchemes() {
        return Optional.ofNullable(idSchemes);
    }

    @JsonProperty("idSchemes")
    public void setIdSchemes(IdSchemes idSchemes) {
        this.idSchemes = idSchemes;
    }

    public ImportOptions withIdSchemes(IdSchemes idSchemes) {
        this.idSchemes = idSchemes;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ignoreEmptyCollection")
    public Boolean getIgnoreEmptyCollection() {
        return ignoreEmptyCollection;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ignoreEmptyCollection")
    public void setIgnoreEmptyCollection(Boolean ignoreEmptyCollection) {
        this.ignoreEmptyCollection = ignoreEmptyCollection;
    }

    public ImportOptions withIgnoreEmptyCollection(Boolean ignoreEmptyCollection) {
        this.ignoreEmptyCollection = ignoreEmptyCollection;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public ImportOptions.ImportStrategy getImportStrategy() {
        return importStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public void setImportStrategy(ImportOptions.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    public ImportOptions withImportStrategy(ImportOptions.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeDataValues")
    public Boolean getMergeDataValues() {
        return mergeDataValues;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeDataValues")
    public void setMergeDataValues(Boolean mergeDataValues) {
        this.mergeDataValues = mergeDataValues;
    }

    public ImportOptions withMergeDataValues(Boolean mergeDataValues) {
        this.mergeDataValues = mergeDataValues;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public ImportOptions.MergeMode getMergeMode() {
        return mergeMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public void setMergeMode(ImportOptions.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }

    public ImportOptions withMergeMode(ImportOptions.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationLevel")
    public ImportOptions.NotificationLevel getNotificationLevel() {
        return notificationLevel;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationLevel")
    public void setNotificationLevel(ImportOptions.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public ImportOptions withNotificationLevel(ImportOptions.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    @JsonProperty("preheatCache")
    public Optional<Boolean> getPreheatCache() {
        return Optional.ofNullable(preheatCache);
    }

    @JsonProperty("preheatCache")
    public void setPreheatCache(Boolean preheatCache) {
        this.preheatCache = preheatCache;
    }

    public ImportOptions withPreheatCache(Boolean preheatCache) {
        this.preheatCache = preheatCache;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("reportMode")
    public ImportOptions.ReportMode getReportMode() {
        return reportMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("reportMode")
    public void setReportMode(ImportOptions.ReportMode reportMode) {
        this.reportMode = reportMode;
    }

    public ImportOptions withReportMode(ImportOptions.ReportMode reportMode) {
        this.reportMode = reportMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("requireAttributeOptionCombo")
    public Boolean getRequireAttributeOptionCombo() {
        return requireAttributeOptionCombo;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("requireAttributeOptionCombo")
    public void setRequireAttributeOptionCombo(Boolean requireAttributeOptionCombo) {
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
    }

    public ImportOptions withRequireAttributeOptionCombo(Boolean requireAttributeOptionCombo) {
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("requireCategoryOptionCombo")
    public Boolean getRequireCategoryOptionCombo() {
        return requireCategoryOptionCombo;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("requireCategoryOptionCombo")
    public void setRequireCategoryOptionCombo(Boolean requireCategoryOptionCombo) {
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
    }

    public ImportOptions withRequireCategoryOptionCombo(Boolean requireCategoryOptionCombo) {
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sharing")
    public Boolean getSharing() {
        return sharing;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sharing")
    public void setSharing(Boolean sharing) {
        this.sharing = sharing;
    }

    public ImportOptions withSharing(Boolean sharing) {
        this.sharing = sharing;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipAudit")
    public Boolean getSkipAudit() {
        return skipAudit;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipAudit")
    public void setSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
    }

    public ImportOptions withSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipCache")
    public Boolean getSkipCache() {
        return skipCache;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipCache")
    public void setSkipCache(Boolean skipCache) {
        this.skipCache = skipCache;
    }

    public ImportOptions withSkipCache(Boolean skipCache) {
        this.skipCache = skipCache;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipExistingCheck")
    public Boolean getSkipExistingCheck() {
        return skipExistingCheck;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipExistingCheck")
    public void setSkipExistingCheck(Boolean skipExistingCheck) {
        this.skipExistingCheck = skipExistingCheck;
    }

    public ImportOptions withSkipExistingCheck(Boolean skipExistingCheck) {
        this.skipExistingCheck = skipExistingCheck;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipLastUpdated")
    public Boolean getSkipLastUpdated() {
        return skipLastUpdated;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipLastUpdated")
    public void setSkipLastUpdated(Boolean skipLastUpdated) {
        this.skipLastUpdated = skipLastUpdated;
    }

    public ImportOptions withSkipLastUpdated(Boolean skipLastUpdated) {
        this.skipLastUpdated = skipLastUpdated;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipNotifications")
    public Boolean getSkipNotifications() {
        return skipNotifications;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipNotifications")
    public void setSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
    }

    public ImportOptions withSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipPatternValidation")
    public Boolean getSkipPatternValidation() {
        return skipPatternValidation;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipPatternValidation")
    public void setSkipPatternValidation(Boolean skipPatternValidation) {
        this.skipPatternValidation = skipPatternValidation;
    }

    public ImportOptions withSkipPatternValidation(Boolean skipPatternValidation) {
        this.skipPatternValidation = skipPatternValidation;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictAttributeOptionCombos")
    public Boolean getStrictAttributeOptionCombos() {
        return strictAttributeOptionCombos;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictAttributeOptionCombos")
    public void setStrictAttributeOptionCombos(Boolean strictAttributeOptionCombos) {
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
    }

    public ImportOptions withStrictAttributeOptionCombos(Boolean strictAttributeOptionCombos) {
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictCategoryOptionCombos")
    public Boolean getStrictCategoryOptionCombos() {
        return strictCategoryOptionCombos;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictCategoryOptionCombos")
    public void setStrictCategoryOptionCombos(Boolean strictCategoryOptionCombos) {
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
    }

    public ImportOptions withStrictCategoryOptionCombos(Boolean strictCategoryOptionCombos) {
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataElements")
    public Boolean getStrictDataElements() {
        return strictDataElements;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataElements")
    public void setStrictDataElements(Boolean strictDataElements) {
        this.strictDataElements = strictDataElements;
    }

    public ImportOptions withStrictDataElements(Boolean strictDataElements) {
        this.strictDataElements = strictDataElements;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetApproval")
    public Boolean getStrictDataSetApproval() {
        return strictDataSetApproval;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetApproval")
    public void setStrictDataSetApproval(Boolean strictDataSetApproval) {
        this.strictDataSetApproval = strictDataSetApproval;
    }

    public ImportOptions withStrictDataSetApproval(Boolean strictDataSetApproval) {
        this.strictDataSetApproval = strictDataSetApproval;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetInputPeriods")
    public Boolean getStrictDataSetInputPeriods() {
        return strictDataSetInputPeriods;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetInputPeriods")
    public void setStrictDataSetInputPeriods(Boolean strictDataSetInputPeriods) {
        this.strictDataSetInputPeriods = strictDataSetInputPeriods;
    }

    public ImportOptions withStrictDataSetInputPeriods(Boolean strictDataSetInputPeriods) {
        this.strictDataSetInputPeriods = strictDataSetInputPeriods;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetLocking")
    public Boolean getStrictDataSetLocking() {
        return strictDataSetLocking;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictDataSetLocking")
    public void setStrictDataSetLocking(Boolean strictDataSetLocking) {
        this.strictDataSetLocking = strictDataSetLocking;
    }

    public ImportOptions withStrictDataSetLocking(Boolean strictDataSetLocking) {
        this.strictDataSetLocking = strictDataSetLocking;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictOrganisationUnits")
    public Boolean getStrictOrganisationUnits() {
        return strictOrganisationUnits;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictOrganisationUnits")
    public void setStrictOrganisationUnits(Boolean strictOrganisationUnits) {
        this.strictOrganisationUnits = strictOrganisationUnits;
    }

    public ImportOptions withStrictOrganisationUnits(Boolean strictOrganisationUnits) {
        this.strictOrganisationUnits = strictOrganisationUnits;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictPeriods")
    public Boolean getStrictPeriods() {
        return strictPeriods;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strictPeriods")
    public void setStrictPeriods(Boolean strictPeriods) {
        this.strictPeriods = strictPeriods;
    }

    public ImportOptions withStrictPeriods(Boolean strictPeriods) {
        this.strictPeriods = strictPeriods;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportOptions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("async".equals(name)) {
            if (value instanceof Boolean) {
                setAsync(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"async\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataSet".equals(name)) {
                if (value instanceof String) {
                    setDataSet(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("datasetAllowsPeriods".equals(name)) {
                    if (value instanceof Boolean) {
                        setDatasetAllowsPeriods(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"datasetAllowsPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dryRun".equals(name)) {
                        if (value instanceof Boolean) {
                            setDryRun(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dryRun\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("filename".equals(name)) {
                            if (value instanceof String) {
                                setFilename(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"filename\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("firstRowIsHeader".equals(name)) {
                                if (value instanceof Boolean) {
                                    setFirstRowIsHeader(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"firstRowIsHeader\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("force".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setForce(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"force\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("idSchemes".equals(name)) {
                                        if (value instanceof IdSchemes) {
                                            setIdSchemes(((IdSchemes) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"idSchemes\" is of type \"org.hisp.dhis.api.model.v40_0.IdSchemes\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("ignoreEmptyCollection".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setIgnoreEmptyCollection(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"ignoreEmptyCollection\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("importStrategy".equals(name)) {
                                                if (value instanceof ImportOptions.ImportStrategy) {
                                                    setImportStrategy(((ImportOptions.ImportStrategy) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v40_0.ImportOptions.ImportStrategy\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("mergeDataValues".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setMergeDataValues(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"mergeDataValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("mergeMode".equals(name)) {
                                                        if (value instanceof ImportOptions.MergeMode) {
                                                            setMergeMode(((ImportOptions.MergeMode) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"mergeMode\" is of type \"org.hisp.dhis.api.model.v40_0.ImportOptions.MergeMode\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("notificationLevel".equals(name)) {
                                                            if (value instanceof ImportOptions.NotificationLevel) {
                                                                setNotificationLevel(((ImportOptions.NotificationLevel) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"notificationLevel\" is of type \"org.hisp.dhis.api.model.v40_0.ImportOptions.NotificationLevel\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("preheatCache".equals(name)) {
                                                                if (value instanceof Boolean) {
                                                                    setPreheatCache(((Boolean) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"preheatCache\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("reportMode".equals(name)) {
                                                                    if (value instanceof ImportOptions.ReportMode) {
                                                                        setReportMode(((ImportOptions.ReportMode) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"reportMode\" is of type \"org.hisp.dhis.api.model.v40_0.ImportOptions.ReportMode\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("requireAttributeOptionCombo".equals(name)) {
                                                                        if (value instanceof Boolean) {
                                                                            setRequireAttributeOptionCombo(((Boolean) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"requireAttributeOptionCombo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("requireCategoryOptionCombo".equals(name)) {
                                                                            if (value instanceof Boolean) {
                                                                                setRequireCategoryOptionCombo(((Boolean) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"requireCategoryOptionCombo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("sharing".equals(name)) {
                                                                                if (value instanceof Boolean) {
                                                                                    setSharing(((Boolean) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"sharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("skipAudit".equals(name)) {
                                                                                    if (value instanceof Boolean) {
                                                                                        setSkipAudit(((Boolean) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"skipAudit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("skipCache".equals(name)) {
                                                                                        if (value instanceof Boolean) {
                                                                                            setSkipCache(((Boolean) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"skipCache\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("skipExistingCheck".equals(name)) {
                                                                                            if (value instanceof Boolean) {
                                                                                                setSkipExistingCheck(((Boolean) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"skipExistingCheck\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("skipLastUpdated".equals(name)) {
                                                                                                if (value instanceof Boolean) {
                                                                                                    setSkipLastUpdated(((Boolean) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"skipLastUpdated\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("skipNotifications".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setSkipNotifications(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"skipNotifications\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("skipPatternValidation".equals(name)) {
                                                                                                        if (value instanceof Boolean) {
                                                                                                            setSkipPatternValidation(((Boolean) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"skipPatternValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("strictAttributeOptionCombos".equals(name)) {
                                                                                                            if (value instanceof Boolean) {
                                                                                                                setStrictAttributeOptionCombos(((Boolean) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"strictAttributeOptionCombos\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("strictCategoryOptionCombos".equals(name)) {
                                                                                                                if (value instanceof Boolean) {
                                                                                                                    setStrictCategoryOptionCombos(((Boolean) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"strictCategoryOptionCombos\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("strictDataElements".equals(name)) {
                                                                                                                    if (value instanceof Boolean) {
                                                                                                                        setStrictDataElements(((Boolean) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"strictDataElements\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("strictDataSetApproval".equals(name)) {
                                                                                                                        if (value instanceof Boolean) {
                                                                                                                            setStrictDataSetApproval(((Boolean) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"strictDataSetApproval\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("strictDataSetInputPeriods".equals(name)) {
                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                setStrictDataSetInputPeriods(((Boolean) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"strictDataSetInputPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("strictDataSetLocking".equals(name)) {
                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                    setStrictDataSetLocking(((Boolean) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"strictDataSetLocking\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("strictOrganisationUnits".equals(name)) {
                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                        setStrictOrganisationUnits(((Boolean) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"strictOrganisationUnits\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("strictPeriods".equals(name)) {
                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                            setStrictPeriods(((Boolean) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"strictPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("async".equals(name)) {
            return getAsync();
        } else {
            if ("dataSet".equals(name)) {
                return getDataSet();
            } else {
                if ("datasetAllowsPeriods".equals(name)) {
                    return getDatasetAllowsPeriods();
                } else {
                    if ("dryRun".equals(name)) {
                        return getDryRun();
                    } else {
                        if ("filename".equals(name)) {
                            return getFilename();
                        } else {
                            if ("firstRowIsHeader".equals(name)) {
                                return getFirstRowIsHeader();
                            } else {
                                if ("force".equals(name)) {
                                    return getForce();
                                } else {
                                    if ("idSchemes".equals(name)) {
                                        return getIdSchemes();
                                    } else {
                                        if ("ignoreEmptyCollection".equals(name)) {
                                            return getIgnoreEmptyCollection();
                                        } else {
                                            if ("importStrategy".equals(name)) {
                                                return getImportStrategy();
                                            } else {
                                                if ("mergeDataValues".equals(name)) {
                                                    return getMergeDataValues();
                                                } else {
                                                    if ("mergeMode".equals(name)) {
                                                        return getMergeMode();
                                                    } else {
                                                        if ("notificationLevel".equals(name)) {
                                                            return getNotificationLevel();
                                                        } else {
                                                            if ("preheatCache".equals(name)) {
                                                                return getPreheatCache();
                                                            } else {
                                                                if ("reportMode".equals(name)) {
                                                                    return getReportMode();
                                                                } else {
                                                                    if ("requireAttributeOptionCombo".equals(name)) {
                                                                        return getRequireAttributeOptionCombo();
                                                                    } else {
                                                                        if ("requireCategoryOptionCombo".equals(name)) {
                                                                            return getRequireCategoryOptionCombo();
                                                                        } else {
                                                                            if ("sharing".equals(name)) {
                                                                                return getSharing();
                                                                            } else {
                                                                                if ("skipAudit".equals(name)) {
                                                                                    return getSkipAudit();
                                                                                } else {
                                                                                    if ("skipCache".equals(name)) {
                                                                                        return getSkipCache();
                                                                                    } else {
                                                                                        if ("skipExistingCheck".equals(name)) {
                                                                                            return getSkipExistingCheck();
                                                                                        } else {
                                                                                            if ("skipLastUpdated".equals(name)) {
                                                                                                return getSkipLastUpdated();
                                                                                            } else {
                                                                                                if ("skipNotifications".equals(name)) {
                                                                                                    return getSkipNotifications();
                                                                                                } else {
                                                                                                    if ("skipPatternValidation".equals(name)) {
                                                                                                        return getSkipPatternValidation();
                                                                                                    } else {
                                                                                                        if ("strictAttributeOptionCombos".equals(name)) {
                                                                                                            return getStrictAttributeOptionCombos();
                                                                                                        } else {
                                                                                                            if ("strictCategoryOptionCombos".equals(name)) {
                                                                                                                return getStrictCategoryOptionCombos();
                                                                                                            } else {
                                                                                                                if ("strictDataElements".equals(name)) {
                                                                                                                    return getStrictDataElements();
                                                                                                                } else {
                                                                                                                    if ("strictDataSetApproval".equals(name)) {
                                                                                                                        return getStrictDataSetApproval();
                                                                                                                    } else {
                                                                                                                        if ("strictDataSetInputPeriods".equals(name)) {
                                                                                                                            return getStrictDataSetInputPeriods();
                                                                                                                        } else {
                                                                                                                            if ("strictDataSetLocking".equals(name)) {
                                                                                                                                return getStrictDataSetLocking();
                                                                                                                            } else {
                                                                                                                                if ("strictOrganisationUnits".equals(name)) {
                                                                                                                                    return getStrictOrganisationUnits();
                                                                                                                                } else {
                                                                                                                                    if ("strictPeriods".equals(name)) {
                                                                                                                                        return getStrictPeriods();
                                                                                                                                    } else {
                                                                                                                                        return notFoundValue;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportOptions.NOT_FOUND_VALUE);
        if (ImportOptions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportOptions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportOptions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("async");
        sb.append('=');
        sb.append(((this.async == null)?"<null>":this.async));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("datasetAllowsPeriods");
        sb.append('=');
        sb.append(((this.datasetAllowsPeriods == null)?"<null>":this.datasetAllowsPeriods));
        sb.append(',');
        sb.append("dryRun");
        sb.append('=');
        sb.append(((this.dryRun == null)?"<null>":this.dryRun));
        sb.append(',');
        sb.append("filename");
        sb.append('=');
        sb.append(((this.filename == null)?"<null>":this.filename));
        sb.append(',');
        sb.append("firstRowIsHeader");
        sb.append('=');
        sb.append(((this.firstRowIsHeader == null)?"<null>":this.firstRowIsHeader));
        sb.append(',');
        sb.append("force");
        sb.append('=');
        sb.append(((this.force == null)?"<null>":this.force));
        sb.append(',');
        sb.append("idSchemes");
        sb.append('=');
        sb.append(((this.idSchemes == null)?"<null>":this.idSchemes));
        sb.append(',');
        sb.append("ignoreEmptyCollection");
        sb.append('=');
        sb.append(((this.ignoreEmptyCollection == null)?"<null>":this.ignoreEmptyCollection));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("mergeDataValues");
        sb.append('=');
        sb.append(((this.mergeDataValues == null)?"<null>":this.mergeDataValues));
        sb.append(',');
        sb.append("mergeMode");
        sb.append('=');
        sb.append(((this.mergeMode == null)?"<null>":this.mergeMode));
        sb.append(',');
        sb.append("notificationLevel");
        sb.append('=');
        sb.append(((this.notificationLevel == null)?"<null>":this.notificationLevel));
        sb.append(',');
        sb.append("preheatCache");
        sb.append('=');
        sb.append(((this.preheatCache == null)?"<null>":this.preheatCache));
        sb.append(',');
        sb.append("reportMode");
        sb.append('=');
        sb.append(((this.reportMode == null)?"<null>":this.reportMode));
        sb.append(',');
        sb.append("requireAttributeOptionCombo");
        sb.append('=');
        sb.append(((this.requireAttributeOptionCombo == null)?"<null>":this.requireAttributeOptionCombo));
        sb.append(',');
        sb.append("requireCategoryOptionCombo");
        sb.append('=');
        sb.append(((this.requireCategoryOptionCombo == null)?"<null>":this.requireCategoryOptionCombo));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("skipAudit");
        sb.append('=');
        sb.append(((this.skipAudit == null)?"<null>":this.skipAudit));
        sb.append(',');
        sb.append("skipCache");
        sb.append('=');
        sb.append(((this.skipCache == null)?"<null>":this.skipCache));
        sb.append(',');
        sb.append("skipExistingCheck");
        sb.append('=');
        sb.append(((this.skipExistingCheck == null)?"<null>":this.skipExistingCheck));
        sb.append(',');
        sb.append("skipLastUpdated");
        sb.append('=');
        sb.append(((this.skipLastUpdated == null)?"<null>":this.skipLastUpdated));
        sb.append(',');
        sb.append("skipNotifications");
        sb.append('=');
        sb.append(((this.skipNotifications == null)?"<null>":this.skipNotifications));
        sb.append(',');
        sb.append("skipPatternValidation");
        sb.append('=');
        sb.append(((this.skipPatternValidation == null)?"<null>":this.skipPatternValidation));
        sb.append(',');
        sb.append("strictAttributeOptionCombos");
        sb.append('=');
        sb.append(((this.strictAttributeOptionCombos == null)?"<null>":this.strictAttributeOptionCombos));
        sb.append(',');
        sb.append("strictCategoryOptionCombos");
        sb.append('=');
        sb.append(((this.strictCategoryOptionCombos == null)?"<null>":this.strictCategoryOptionCombos));
        sb.append(',');
        sb.append("strictDataElements");
        sb.append('=');
        sb.append(((this.strictDataElements == null)?"<null>":this.strictDataElements));
        sb.append(',');
        sb.append("strictDataSetApproval");
        sb.append('=');
        sb.append(((this.strictDataSetApproval == null)?"<null>":this.strictDataSetApproval));
        sb.append(',');
        sb.append("strictDataSetInputPeriods");
        sb.append('=');
        sb.append(((this.strictDataSetInputPeriods == null)?"<null>":this.strictDataSetInputPeriods));
        sb.append(',');
        sb.append("strictDataSetLocking");
        sb.append('=');
        sb.append(((this.strictDataSetLocking == null)?"<null>":this.strictDataSetLocking));
        sb.append(',');
        sb.append("strictOrganisationUnits");
        sb.append('=');
        sb.append(((this.strictOrganisationUnits == null)?"<null>":this.strictOrganisationUnits));
        sb.append(',');
        sb.append("strictPeriods");
        sb.append('=');
        sb.append(((this.strictPeriods == null)?"<null>":this.strictPeriods));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dryRun == null)? 0 :this.dryRun.hashCode()));
        result = ((result* 31)+((this.skipCache == null)? 0 :this.skipCache.hashCode()));
        result = ((result* 31)+((this.datasetAllowsPeriods == null)? 0 :this.datasetAllowsPeriods.hashCode()));
        result = ((result* 31)+((this.skipPatternValidation == null)? 0 :this.skipPatternValidation.hashCode()));
        result = ((result* 31)+((this.mergeMode == null)? 0 :this.mergeMode.hashCode()));
        result = ((result* 31)+((this.strictCategoryOptionCombos == null)? 0 :this.strictCategoryOptionCombos.hashCode()));
        result = ((result* 31)+((this.idSchemes == null)? 0 :this.idSchemes.hashCode()));
        result = ((result* 31)+((this.preheatCache == null)? 0 :this.preheatCache.hashCode()));
        result = ((result* 31)+((this.strictDataSetApproval == null)? 0 :this.strictDataSetApproval.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        result = ((result* 31)+((this.strictDataSetLocking == null)? 0 :this.strictDataSetLocking.hashCode()));
        result = ((result* 31)+((this.strictPeriods == null)? 0 :this.strictPeriods.hashCode()));
        result = ((result* 31)+((this.ignoreEmptyCollection == null)? 0 :this.ignoreEmptyCollection.hashCode()));
        result = ((result* 31)+((this.firstRowIsHeader == null)? 0 :this.firstRowIsHeader.hashCode()));
        result = ((result* 31)+((this.notificationLevel == null)? 0 :this.notificationLevel.hashCode()));
        result = ((result* 31)+((this.strictAttributeOptionCombos == null)? 0 :this.strictAttributeOptionCombos.hashCode()));
        result = ((result* 31)+((this.skipExistingCheck == null)? 0 :this.skipExistingCheck.hashCode()));
        result = ((result* 31)+((this.skipNotifications == null)? 0 :this.skipNotifications.hashCode()));
        result = ((result* 31)+((this.strictDataElements == null)? 0 :this.strictDataElements.hashCode()));
        result = ((result* 31)+((this.strictDataSetInputPeriods == null)? 0 :this.strictDataSetInputPeriods.hashCode()));
        result = ((result* 31)+((this.reportMode == null)? 0 :this.reportMode.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.requireAttributeOptionCombo == null)? 0 :this.requireAttributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.skipAudit == null)? 0 :this.skipAudit.hashCode()));
        result = ((result* 31)+((this.async == null)? 0 :this.async.hashCode()));
        result = ((result* 31)+((this.filename == null)? 0 :this.filename.hashCode()));
        result = ((result* 31)+((this.requireCategoryOptionCombo == null)? 0 :this.requireCategoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.force == null)? 0 :this.force.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.strictOrganisationUnits == null)? 0 :this.strictOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.mergeDataValues == null)? 0 :this.mergeDataValues.hashCode()));
        result = ((result* 31)+((this.skipLastUpdated == null)? 0 :this.skipLastUpdated.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportOptions) == false) {
            return false;
        }
        ImportOptions rhs = ((ImportOptions) other);
        return ((((((((((((((((((((((((((((((((((this.dryRun == rhs.dryRun)||((this.dryRun!= null)&&this.dryRun.equals(rhs.dryRun)))&&((this.skipCache == rhs.skipCache)||((this.skipCache!= null)&&this.skipCache.equals(rhs.skipCache))))&&((this.datasetAllowsPeriods == rhs.datasetAllowsPeriods)||((this.datasetAllowsPeriods!= null)&&this.datasetAllowsPeriods.equals(rhs.datasetAllowsPeriods))))&&((this.skipPatternValidation == rhs.skipPatternValidation)||((this.skipPatternValidation!= null)&&this.skipPatternValidation.equals(rhs.skipPatternValidation))))&&((this.mergeMode == rhs.mergeMode)||((this.mergeMode!= null)&&this.mergeMode.equals(rhs.mergeMode))))&&((this.strictCategoryOptionCombos == rhs.strictCategoryOptionCombos)||((this.strictCategoryOptionCombos!= null)&&this.strictCategoryOptionCombos.equals(rhs.strictCategoryOptionCombos))))&&((this.idSchemes == rhs.idSchemes)||((this.idSchemes!= null)&&this.idSchemes.equals(rhs.idSchemes))))&&((this.preheatCache == rhs.preheatCache)||((this.preheatCache!= null)&&this.preheatCache.equals(rhs.preheatCache))))&&((this.strictDataSetApproval == rhs.strictDataSetApproval)||((this.strictDataSetApproval!= null)&&this.strictDataSetApproval.equals(rhs.strictDataSetApproval))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))))&&((this.strictDataSetLocking == rhs.strictDataSetLocking)||((this.strictDataSetLocking!= null)&&this.strictDataSetLocking.equals(rhs.strictDataSetLocking))))&&((this.strictPeriods == rhs.strictPeriods)||((this.strictPeriods!= null)&&this.strictPeriods.equals(rhs.strictPeriods))))&&((this.ignoreEmptyCollection == rhs.ignoreEmptyCollection)||((this.ignoreEmptyCollection!= null)&&this.ignoreEmptyCollection.equals(rhs.ignoreEmptyCollection))))&&((this.firstRowIsHeader == rhs.firstRowIsHeader)||((this.firstRowIsHeader!= null)&&this.firstRowIsHeader.equals(rhs.firstRowIsHeader))))&&((this.notificationLevel == rhs.notificationLevel)||((this.notificationLevel!= null)&&this.notificationLevel.equals(rhs.notificationLevel))))&&((this.strictAttributeOptionCombos == rhs.strictAttributeOptionCombos)||((this.strictAttributeOptionCombos!= null)&&this.strictAttributeOptionCombos.equals(rhs.strictAttributeOptionCombos))))&&((this.skipExistingCheck == rhs.skipExistingCheck)||((this.skipExistingCheck!= null)&&this.skipExistingCheck.equals(rhs.skipExistingCheck))))&&((this.skipNotifications == rhs.skipNotifications)||((this.skipNotifications!= null)&&this.skipNotifications.equals(rhs.skipNotifications))))&&((this.strictDataElements == rhs.strictDataElements)||((this.strictDataElements!= null)&&this.strictDataElements.equals(rhs.strictDataElements))))&&((this.strictDataSetInputPeriods == rhs.strictDataSetInputPeriods)||((this.strictDataSetInputPeriods!= null)&&this.strictDataSetInputPeriods.equals(rhs.strictDataSetInputPeriods))))&&((this.reportMode == rhs.reportMode)||((this.reportMode!= null)&&this.reportMode.equals(rhs.reportMode))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.requireAttributeOptionCombo == rhs.requireAttributeOptionCombo)||((this.requireAttributeOptionCombo!= null)&&this.requireAttributeOptionCombo.equals(rhs.requireAttributeOptionCombo))))&&((this.skipAudit == rhs.skipAudit)||((this.skipAudit!= null)&&this.skipAudit.equals(rhs.skipAudit))))&&((this.async == rhs.async)||((this.async!= null)&&this.async.equals(rhs.async))))&&((this.filename == rhs.filename)||((this.filename!= null)&&this.filename.equals(rhs.filename))))&&((this.requireCategoryOptionCombo == rhs.requireCategoryOptionCombo)||((this.requireCategoryOptionCombo!= null)&&this.requireCategoryOptionCombo.equals(rhs.requireCategoryOptionCombo))))&&((this.force == rhs.force)||((this.force!= null)&&this.force.equals(rhs.force))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.strictOrganisationUnits == rhs.strictOrganisationUnits)||((this.strictOrganisationUnits!= null)&&this.strictOrganisationUnits.equals(rhs.strictOrganisationUnits))))&&((this.mergeDataValues == rhs.mergeDataValues)||((this.mergeDataValues!= null)&&this.mergeDataValues.equals(rhs.mergeDataValues))))&&((this.skipLastUpdated == rhs.skipLastUpdated)||((this.skipLastUpdated!= null)&&this.skipLastUpdated.equals(rhs.skipLastUpdated))));
    }

    @Generated("jsonschema2pojo")
    public enum ImportStrategy {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        CREATE_AND_UPDATE("CREATE_AND_UPDATE"),
        DELETE("DELETE"),
        SYNC("SYNC"),
        NEW_AND_UPDATES("NEW_AND_UPDATES"),
        NEW("NEW"),
        UPDATES("UPDATES"),
        DELETES("DELETES");
        private final String value;
        private final static Map<String, ImportOptions.ImportStrategy> CONSTANTS = new HashMap<String, ImportOptions.ImportStrategy>();

        static {
            for (ImportOptions.ImportStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.ImportStrategy fromValue(String value) {
            ImportOptions.ImportStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MergeMode {

        MERGE_ALWAYS("MERGE_ALWAYS"),
        MERGE_IF_NOT_NULL("MERGE_IF_NOT_NULL"),
        MERGE("MERGE"),
        REPLACE("REPLACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, ImportOptions.MergeMode> CONSTANTS = new HashMap<String, ImportOptions.MergeMode>();

        static {
            for (ImportOptions.MergeMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MergeMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.MergeMode fromValue(String value) {
            ImportOptions.MergeMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NotificationLevel {

        OFF("OFF"),
        DEBUG("DEBUG"),
        LOOP("LOOP"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, ImportOptions.NotificationLevel> CONSTANTS = new HashMap<String, ImportOptions.NotificationLevel>();

        static {
            for (ImportOptions.NotificationLevel c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NotificationLevel(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.NotificationLevel fromValue(String value) {
            ImportOptions.NotificationLevel constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ReportMode {

        FULL("FULL"),
        ERRORS("ERRORS"),
        ERRORS_NOT_OWNER("ERRORS_NOT_OWNER"),
        DEBUG("DEBUG");
        private final String value;
        private final static Map<String, ImportOptions.ReportMode> CONSTANTS = new HashMap<String, ImportOptions.ReportMode>();

        static {
            for (ImportOptions.ReportMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ReportMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.ReportMode fromValue(String value) {
            ImportOptions.ReportMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
