
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "complete",
    "completedTime",
    "description",
    "duration",
    "error",
    "onFailure",
    "status",
    "summary"
})
@Generated("jsonschema2pojo")
public class Item implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("complete")
    private Boolean complete;
    @JsonProperty("completedTime")
    private Date completedTime;
    @JsonProperty("description")
    private String description;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("duration")
    private Long duration;
    @JsonProperty("error")
    private String error;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("onFailure")
    private Item.OnFailure onFailure;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private Item.Status status;
    @JsonProperty("summary")
    private String summary;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 455129152051109427L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Item() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Item(Item source) {
        super();
        this.complete = source.complete;
        this.completedTime = source.completedTime;
        this.description = source.description;
        this.duration = source.duration;
        this.error = source.error;
        this.onFailure = source.onFailure;
        this.status = source.status;
        this.summary = source.summary;
    }

    public Item(Boolean complete, Date completedTime, String description, Long duration, String error, Item.OnFailure onFailure, Item.Status status, String summary) {
        super();
        this.complete = complete;
        this.completedTime = completedTime;
        this.description = description;
        this.duration = duration;
        this.error = error;
        this.onFailure = onFailure;
        this.status = status;
        this.summary = summary;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("complete")
    public Boolean getComplete() {
        return complete;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("complete")
    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public Item withComplete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    @JsonProperty("completedTime")
    public Optional<Date> getCompletedTime() {
        return Optional.ofNullable(completedTime);
    }

    @JsonProperty("completedTime")
    public void setCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
    }

    public Item withCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Item withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public Long getDuration() {
        return duration;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Item withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty("error")
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    @JsonProperty("error")
    public void setError(String error) {
        this.error = error;
    }

    public Item withError(String error) {
        this.error = error;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("onFailure")
    public Item.OnFailure getOnFailure() {
        return onFailure;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("onFailure")
    public void setOnFailure(Item.OnFailure onFailure) {
        this.onFailure = onFailure;
    }

    public Item withOnFailure(Item.OnFailure onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public Item.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(Item.Status status) {
        this.status = status;
    }

    public Item withStatus(Item.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("summary")
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    @JsonProperty("summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Item withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Item withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("complete".equals(name)) {
            if (value instanceof Boolean) {
                setComplete(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"complete\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("completedTime".equals(name)) {
                if (value instanceof Date) {
                    setCompletedTime(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("description".equals(name)) {
                    if (value instanceof String) {
                        setDescription(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("duration".equals(name)) {
                        if (value instanceof Long) {
                            setDuration(((Long) value));
                        } else {
                            throw new IllegalArgumentException(("property \"duration\" is of type \"java.lang.Long\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("error".equals(name)) {
                            if (value instanceof String) {
                                setError(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"error\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("onFailure".equals(name)) {
                                if (value instanceof Item.OnFailure) {
                                    setOnFailure(((Item.OnFailure) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"onFailure\" is of type \"org.hisp.dhis.api.model.v40_0.Item.OnFailure\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("status".equals(name)) {
                                    if (value instanceof Item.Status) {
                                        setStatus(((Item.Status) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.Item.Status\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("summary".equals(name)) {
                                        if (value instanceof String) {
                                            setSummary(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"summary\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("complete".equals(name)) {
            return getComplete();
        } else {
            if ("completedTime".equals(name)) {
                return getCompletedTime();
            } else {
                if ("description".equals(name)) {
                    return getDescription();
                } else {
                    if ("duration".equals(name)) {
                        return getDuration();
                    } else {
                        if ("error".equals(name)) {
                            return getError();
                        } else {
                            if ("onFailure".equals(name)) {
                                return getOnFailure();
                            } else {
                                if ("status".equals(name)) {
                                    return getStatus();
                                } else {
                                    if ("summary".equals(name)) {
                                        return getSummary();
                                    } else {
                                        return notFoundValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Item.NOT_FOUND_VALUE);
        if (Item.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Item with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Item.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("complete");
        sb.append('=');
        sb.append(((this.complete == null)?"<null>":this.complete));
        sb.append(',');
        sb.append("completedTime");
        sb.append('=');
        sb.append(((this.completedTime == null)?"<null>":this.completedTime));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(((this.duration == null)?"<null>":this.duration));
        sb.append(',');
        sb.append("error");
        sb.append('=');
        sb.append(((this.error == null)?"<null>":this.error));
        sb.append(',');
        sb.append("onFailure");
        sb.append('=');
        sb.append(((this.onFailure == null)?"<null>":this.onFailure));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(((this.summary == null)?"<null>":this.summary));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.duration == null)? 0 :this.duration.hashCode()));
        result = ((result* 31)+((this.summary == null)? 0 :this.summary.hashCode()));
        result = ((result* 31)+((this.completedTime == null)? 0 :this.completedTime.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.onFailure == null)? 0 :this.onFailure.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.complete == null)? 0 :this.complete.hashCode()));
        result = ((result* 31)+((this.error == null)? 0 :this.error.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Item) == false) {
            return false;
        }
        Item rhs = ((Item) other);
        return ((((((((((this.duration == rhs.duration)||((this.duration!= null)&&this.duration.equals(rhs.duration)))&&((this.summary == rhs.summary)||((this.summary!= null)&&this.summary.equals(rhs.summary))))&&((this.completedTime == rhs.completedTime)||((this.completedTime!= null)&&this.completedTime.equals(rhs.completedTime))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.onFailure == rhs.onFailure)||((this.onFailure!= null)&&this.onFailure.equals(rhs.onFailure))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.complete == rhs.complete)||((this.complete!= null)&&this.complete.equals(rhs.complete))))&&((this.error == rhs.error)||((this.error!= null)&&this.error.equals(rhs.error))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum OnFailure {

        PARENT("PARENT"),
        FAIL("FAIL"),
        SKIP_STAGE("SKIP_STAGE"),
        SKIP_ITEM("SKIP_ITEM"),
        SKIP_ITEM_OUTLIER("SKIP_ITEM_OUTLIER");
        private final String value;
        private final static Map<String, Item.OnFailure> CONSTANTS = new HashMap<String, Item.OnFailure>();

        static {
            for (Item.OnFailure c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        OnFailure(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Item.OnFailure fromValue(String value) {
            Item.OnFailure constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Status {

        RUNNING("RUNNING"),
        SUCCESS("SUCCESS"),
        ERROR("ERROR"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, Item.Status> CONSTANTS = new HashMap<String, Item.Status>();

        static {
            for (Item.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Item.Status fromValue(String value) {
            Item.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
