
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "insertHeight",
    "insertPosition"
})
@Generated("jsonschema2pojo")
public class ItemConfig implements Serializable
{

    @JsonProperty("insertHeight")
    private Integer insertHeight;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("insertPosition")
    private ItemConfig.InsertPosition insertPosition;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5342871164158841700L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ItemConfig() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ItemConfig(ItemConfig source) {
        super();
        this.insertHeight = source.insertHeight;
        this.insertPosition = source.insertPosition;
    }

    public ItemConfig(Integer insertHeight, ItemConfig.InsertPosition insertPosition) {
        super();
        this.insertHeight = insertHeight;
        this.insertPosition = insertPosition;
    }

    @JsonProperty("insertHeight")
    public Optional<Integer> getInsertHeight() {
        return Optional.ofNullable(insertHeight);
    }

    @JsonProperty("insertHeight")
    public void setInsertHeight(Integer insertHeight) {
        this.insertHeight = insertHeight;
    }

    public ItemConfig withInsertHeight(Integer insertHeight) {
        this.insertHeight = insertHeight;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("insertPosition")
    public ItemConfig.InsertPosition getInsertPosition() {
        return insertPosition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("insertPosition")
    public void setInsertPosition(ItemConfig.InsertPosition insertPosition) {
        this.insertPosition = insertPosition;
    }

    public ItemConfig withInsertPosition(ItemConfig.InsertPosition insertPosition) {
        this.insertPosition = insertPosition;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ItemConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("insertHeight".equals(name)) {
            if (value instanceof Integer) {
                setInsertHeight(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"insertHeight\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("insertPosition".equals(name)) {
                if (value instanceof ItemConfig.InsertPosition) {
                    setInsertPosition(((ItemConfig.InsertPosition) value));
                } else {
                    throw new IllegalArgumentException(("property \"insertPosition\" is of type \"org.hisp.dhis.api.model.v40_0.ItemConfig.InsertPosition\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("insertHeight".equals(name)) {
            return getInsertHeight();
        } else {
            if ("insertPosition".equals(name)) {
                return getInsertPosition();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ItemConfig.NOT_FOUND_VALUE);
        if (ItemConfig.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ItemConfig with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ItemConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("insertHeight");
        sb.append('=');
        sb.append(((this.insertHeight == null)?"<null>":this.insertHeight));
        sb.append(',');
        sb.append("insertPosition");
        sb.append('=');
        sb.append(((this.insertPosition == null)?"<null>":this.insertPosition));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.insertHeight == null)? 0 :this.insertHeight.hashCode()));
        result = ((result* 31)+((this.insertPosition == null)? 0 :this.insertPosition.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ItemConfig) == false) {
            return false;
        }
        ItemConfig rhs = ((ItemConfig) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.insertHeight == rhs.insertHeight)||((this.insertHeight!= null)&&this.insertHeight.equals(rhs.insertHeight))))&&((this.insertPosition == rhs.insertPosition)||((this.insertPosition!= null)&&this.insertPosition.equals(rhs.insertPosition))));
    }

    @Generated("jsonschema2pojo")
    public enum InsertPosition {

        START("START"),
        END("END");
        private final String value;
        private final static Map<String, ItemConfig.InsertPosition> CONSTANTS = new HashMap<String, ItemConfig.InsertPosition>();

        static {
            for (ItemConfig.InsertPosition c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        InsertPosition(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ItemConfig.InsertPosition fromValue(String value) {
            ItemConfig.InsertPosition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
