
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "authorities",
    "avatar",
    "birthday",
    "created",
    "dataSets",
    "dataViewOrganisationUnits",
    "displayName",
    "education",
    "email",
    "employer",
    "externalAccess",
    "facebookMessenger",
    "favorites",
    "firstName",
    "gender",
    "id",
    "impersonation",
    "interests",
    "introduction",
    "jobTitle",
    "languages",
    "lastUpdated",
    "name",
    "nationality",
    "organisationUnits",
    "phoneNumber",
    "programs",
    "settings",
    "sharing",
    "skype",
    "surname",
    "teiSearchOrganisationUnits",
    "telegram",
    "translations",
    "twitter",
    "userAccesses",
    "userCredentials",
    "userGroupAccesses",
    "userGroups",
    "userRoles",
    "username",
    "whatsApp"
})
@Generated("jsonschema2pojo")
public class MeDto implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("authorities")
    private List<String> authorities;
    /**
     * A UID reference to a FileResource  
     * (Java name `org.hisp.dhis.fileresource.FileResource`)
     * 
     */
    @JsonProperty("avatar")
    @JsonPropertyDescription("A UID reference to a FileResource  \n(Java name `org.hisp.dhis.fileresource.FileResource`)")
    private RefFileResource avatar;
    @JsonProperty("birthday")
    private Date birthday;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataSets")
    private List<String> dataSets;
    @JsonProperty("dataViewOrganisationUnits")
    private List<RefOrganisationUnit> dataViewOrganisationUnits;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("education")
    private String education;
    @JsonProperty("email")
    private String email;
    @JsonProperty("employer")
    private String employer;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("facebookMessenger")
    private String facebookMessenger;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("firstName")
    private String firstName;
    @JsonProperty("gender")
    private String gender;
    @JsonProperty("id")
    private String id;
    @JsonProperty("impersonation")
    private String impersonation;
    @JsonProperty("interests")
    private String interests;
    @JsonProperty("introduction")
    private String introduction;
    @JsonProperty("jobTitle")
    private String jobTitle;
    @JsonProperty("languages")
    private String languages;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("name")
    private String name;
    @JsonProperty("nationality")
    private String nationality;
    @JsonProperty("organisationUnits")
    private List<RefOrganisationUnit> organisationUnits;
    @JsonProperty("phoneNumber")
    private String phoneNumber;
    @JsonProperty("programs")
    private List<String> programs;
    @JsonProperty("settings")
    private Settings settings;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("skype")
    private String skype;
    @JsonProperty("surname")
    private String surname;
    @JsonProperty("teiSearchOrganisationUnits")
    private List<RefOrganisationUnit> teiSearchOrganisationUnits;
    @JsonProperty("telegram")
    private String telegram;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("twitter")
    private String twitter;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userCredentials")
    private UserCredentialsDto userCredentials;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("userGroups")
    private List<RefUserGroup> userGroups;
    @JsonProperty("userRoles")
    private List<RefUserRole> userRoles;
    @JsonProperty("username")
    private String username;
    @JsonProperty("whatsApp")
    private String whatsApp;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1017984052250180173L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MeDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MeDto(MeDto source) {
        super();
        this.access = source.access;
        this.authorities = source.authorities;
        this.avatar = source.avatar;
        this.birthday = source.birthday;
        this.created = source.created;
        this.dataSets = source.dataSets;
        this.dataViewOrganisationUnits = source.dataViewOrganisationUnits;
        this.displayName = source.displayName;
        this.education = source.education;
        this.email = source.email;
        this.employer = source.employer;
        this.externalAccess = source.externalAccess;
        this.facebookMessenger = source.facebookMessenger;
        this.favorites = source.favorites;
        this.firstName = source.firstName;
        this.gender = source.gender;
        this.id = source.id;
        this.impersonation = source.impersonation;
        this.interests = source.interests;
        this.introduction = source.introduction;
        this.jobTitle = source.jobTitle;
        this.languages = source.languages;
        this.lastUpdated = source.lastUpdated;
        this.name = source.name;
        this.nationality = source.nationality;
        this.organisationUnits = source.organisationUnits;
        this.phoneNumber = source.phoneNumber;
        this.programs = source.programs;
        this.settings = source.settings;
        this.sharing = source.sharing;
        this.skype = source.skype;
        this.surname = source.surname;
        this.teiSearchOrganisationUnits = source.teiSearchOrganisationUnits;
        this.telegram = source.telegram;
        this.translations = source.translations;
        this.twitter = source.twitter;
        this.userAccesses = source.userAccesses;
        this.userCredentials = source.userCredentials;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userGroups = source.userGroups;
        this.userRoles = source.userRoles;
        this.username = source.username;
        this.whatsApp = source.whatsApp;
    }

    public MeDto(Access access, List<String> authorities, RefFileResource avatar, Date birthday, Date created, List<String> dataSets, List<RefOrganisationUnit> dataViewOrganisationUnits, String displayName, String education, String email, String employer, Boolean externalAccess, String facebookMessenger, List<String> favorites, String firstName, String gender, String id, String impersonation, String interests, String introduction, String jobTitle, String languages, Date lastUpdated, String name, String nationality, List<RefOrganisationUnit> organisationUnits, String phoneNumber, List<String> programs, Settings settings, Sharing sharing, String skype, String surname, List<RefOrganisationUnit> teiSearchOrganisationUnits, String telegram, List<Translation> translations, String twitter, List<UserAccess> userAccesses, UserCredentialsDto userCredentials, List<UserGroupAccess> userGroupAccesses, List<RefUserGroup> userGroups, List<RefUserRole> userRoles, String username, String whatsApp) {
        super();
        this.access = access;
        this.authorities = authorities;
        this.avatar = avatar;
        this.birthday = birthday;
        this.created = created;
        this.dataSets = dataSets;
        this.dataViewOrganisationUnits = dataViewOrganisationUnits;
        this.displayName = displayName;
        this.education = education;
        this.email = email;
        this.employer = employer;
        this.externalAccess = externalAccess;
        this.facebookMessenger = facebookMessenger;
        this.favorites = favorites;
        this.firstName = firstName;
        this.gender = gender;
        this.id = id;
        this.impersonation = impersonation;
        this.interests = interests;
        this.introduction = introduction;
        this.jobTitle = jobTitle;
        this.languages = languages;
        this.lastUpdated = lastUpdated;
        this.name = name;
        this.nationality = nationality;
        this.organisationUnits = organisationUnits;
        this.phoneNumber = phoneNumber;
        this.programs = programs;
        this.settings = settings;
        this.sharing = sharing;
        this.skype = skype;
        this.surname = surname;
        this.teiSearchOrganisationUnits = teiSearchOrganisationUnits;
        this.telegram = telegram;
        this.translations = translations;
        this.twitter = twitter;
        this.userAccesses = userAccesses;
        this.userCredentials = userCredentials;
        this.userGroupAccesses = userGroupAccesses;
        this.userGroups = userGroups;
        this.userRoles = userRoles;
        this.username = username;
        this.whatsApp = whatsApp;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public MeDto withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("authorities")
    public Optional<List<String>> getAuthorities() {
        return Optional.ofNullable(authorities);
    }

    @JsonProperty("authorities")
    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public MeDto withAuthorities(List<String> authorities) {
        this.authorities = authorities;
        return this;
    }

    /**
     * A UID reference to a FileResource  
     * (Java name `org.hisp.dhis.fileresource.FileResource`)
     * 
     */
    @JsonProperty("avatar")
    public Optional<RefFileResource> getAvatar() {
        return Optional.ofNullable(avatar);
    }

    /**
     * A UID reference to a FileResource  
     * (Java name `org.hisp.dhis.fileresource.FileResource`)
     * 
     */
    @JsonProperty("avatar")
    public void setAvatar(RefFileResource avatar) {
        this.avatar = avatar;
    }

    public MeDto withAvatar(RefFileResource avatar) {
        this.avatar = avatar;
        return this;
    }

    @JsonProperty("birthday")
    public Optional<Date> getBirthday() {
        return Optional.ofNullable(birthday);
    }

    @JsonProperty("birthday")
    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public MeDto withBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public MeDto withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataSets")
    public Optional<List<String>> getDataSets() {
        return Optional.ofNullable(dataSets);
    }

    @JsonProperty("dataSets")
    public void setDataSets(List<String> dataSets) {
        this.dataSets = dataSets;
    }

    public MeDto withDataSets(List<String> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    @JsonProperty("dataViewOrganisationUnits")
    public Optional<List<RefOrganisationUnit>> getDataViewOrganisationUnits() {
        return Optional.ofNullable(dataViewOrganisationUnits);
    }

    @JsonProperty("dataViewOrganisationUnits")
    public void setDataViewOrganisationUnits(List<RefOrganisationUnit> dataViewOrganisationUnits) {
        this.dataViewOrganisationUnits = dataViewOrganisationUnits;
    }

    public MeDto withDataViewOrganisationUnits(List<RefOrganisationUnit> dataViewOrganisationUnits) {
        this.dataViewOrganisationUnits = dataViewOrganisationUnits;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MeDto withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("education")
    public Optional<String> getEducation() {
        return Optional.ofNullable(education);
    }

    @JsonProperty("education")
    public void setEducation(String education) {
        this.education = education;
    }

    public MeDto withEducation(String education) {
        this.education = education;
        return this;
    }

    @JsonProperty("email")
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    public MeDto withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty("employer")
    public Optional<String> getEmployer() {
        return Optional.ofNullable(employer);
    }

    @JsonProperty("employer")
    public void setEmployer(String employer) {
        this.employer = employer;
    }

    public MeDto withEmployer(String employer) {
        this.employer = employer;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public MeDto withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("facebookMessenger")
    public Optional<String> getFacebookMessenger() {
        return Optional.ofNullable(facebookMessenger);
    }

    @JsonProperty("facebookMessenger")
    public void setFacebookMessenger(String facebookMessenger) {
        this.facebookMessenger = facebookMessenger;
    }

    public MeDto withFacebookMessenger(String facebookMessenger) {
        this.facebookMessenger = facebookMessenger;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public MeDto withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("firstName")
    public Optional<String> getFirstName() {
        return Optional.ofNullable(firstName);
    }

    @JsonProperty("firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public MeDto withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @JsonProperty("gender")
    public Optional<String> getGender() {
        return Optional.ofNullable(gender);
    }

    @JsonProperty("gender")
    public void setGender(String gender) {
        this.gender = gender;
    }

    public MeDto withGender(String gender) {
        this.gender = gender;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public MeDto withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("impersonation")
    public Optional<String> getImpersonation() {
        return Optional.ofNullable(impersonation);
    }

    @JsonProperty("impersonation")
    public void setImpersonation(String impersonation) {
        this.impersonation = impersonation;
    }

    public MeDto withImpersonation(String impersonation) {
        this.impersonation = impersonation;
        return this;
    }

    @JsonProperty("interests")
    public Optional<String> getInterests() {
        return Optional.ofNullable(interests);
    }

    @JsonProperty("interests")
    public void setInterests(String interests) {
        this.interests = interests;
    }

    public MeDto withInterests(String interests) {
        this.interests = interests;
        return this;
    }

    @JsonProperty("introduction")
    public Optional<String> getIntroduction() {
        return Optional.ofNullable(introduction);
    }

    @JsonProperty("introduction")
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public MeDto withIntroduction(String introduction) {
        this.introduction = introduction;
        return this;
    }

    @JsonProperty("jobTitle")
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    @JsonProperty("jobTitle")
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public MeDto withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @JsonProperty("languages")
    public Optional<String> getLanguages() {
        return Optional.ofNullable(languages);
    }

    @JsonProperty("languages")
    public void setLanguages(String languages) {
        this.languages = languages;
    }

    public MeDto withLanguages(String languages) {
        this.languages = languages;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public MeDto withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public MeDto withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("nationality")
    public Optional<String> getNationality() {
        return Optional.ofNullable(nationality);
    }

    @JsonProperty("nationality")
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public MeDto withNationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<RefOrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<RefOrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public MeDto withOrganisationUnits(List<RefOrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("phoneNumber")
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    @JsonProperty("phoneNumber")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public MeDto withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty("programs")
    public Optional<List<String>> getPrograms() {
        return Optional.ofNullable(programs);
    }

    @JsonProperty("programs")
    public void setPrograms(List<String> programs) {
        this.programs = programs;
    }

    public MeDto withPrograms(List<String> programs) {
        this.programs = programs;
        return this;
    }

    @JsonProperty("settings")
    public Optional<Settings> getSettings() {
        return Optional.ofNullable(settings);
    }

    @JsonProperty("settings")
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public MeDto withSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public MeDto withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("skype")
    public Optional<String> getSkype() {
        return Optional.ofNullable(skype);
    }

    @JsonProperty("skype")
    public void setSkype(String skype) {
        this.skype = skype;
    }

    public MeDto withSkype(String skype) {
        this.skype = skype;
        return this;
    }

    @JsonProperty("surname")
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    @JsonProperty("surname")
    public void setSurname(String surname) {
        this.surname = surname;
    }

    public MeDto withSurname(String surname) {
        this.surname = surname;
        return this;
    }

    @JsonProperty("teiSearchOrganisationUnits")
    public Optional<List<RefOrganisationUnit>> getTeiSearchOrganisationUnits() {
        return Optional.ofNullable(teiSearchOrganisationUnits);
    }

    @JsonProperty("teiSearchOrganisationUnits")
    public void setTeiSearchOrganisationUnits(List<RefOrganisationUnit> teiSearchOrganisationUnits) {
        this.teiSearchOrganisationUnits = teiSearchOrganisationUnits;
    }

    public MeDto withTeiSearchOrganisationUnits(List<RefOrganisationUnit> teiSearchOrganisationUnits) {
        this.teiSearchOrganisationUnits = teiSearchOrganisationUnits;
        return this;
    }

    @JsonProperty("telegram")
    public Optional<String> getTelegram() {
        return Optional.ofNullable(telegram);
    }

    @JsonProperty("telegram")
    public void setTelegram(String telegram) {
        this.telegram = telegram;
    }

    public MeDto withTelegram(String telegram) {
        this.telegram = telegram;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public MeDto withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("twitter")
    public Optional<String> getTwitter() {
        return Optional.ofNullable(twitter);
    }

    @JsonProperty("twitter")
    public void setTwitter(String twitter) {
        this.twitter = twitter;
    }

    public MeDto withTwitter(String twitter) {
        this.twitter = twitter;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public MeDto withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userCredentials")
    public Optional<UserCredentialsDto> getUserCredentials() {
        return Optional.ofNullable(userCredentials);
    }

    @JsonProperty("userCredentials")
    public void setUserCredentials(UserCredentialsDto userCredentials) {
        this.userCredentials = userCredentials;
    }

    public MeDto withUserCredentials(UserCredentialsDto userCredentials) {
        this.userCredentials = userCredentials;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public MeDto withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userGroups")
    public Optional<List<RefUserGroup>> getUserGroups() {
        return Optional.ofNullable(userGroups);
    }

    @JsonProperty("userGroups")
    public void setUserGroups(List<RefUserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public MeDto withUserGroups(List<RefUserGroup> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    @JsonProperty("userRoles")
    public Optional<List<RefUserRole>> getUserRoles() {
        return Optional.ofNullable(userRoles);
    }

    @JsonProperty("userRoles")
    public void setUserRoles(List<RefUserRole> userRoles) {
        this.userRoles = userRoles;
    }

    public MeDto withUserRoles(List<RefUserRole> userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public MeDto withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty("whatsApp")
    public Optional<String> getWhatsApp() {
        return Optional.ofNullable(whatsApp);
    }

    @JsonProperty("whatsApp")
    public void setWhatsApp(String whatsApp) {
        this.whatsApp = whatsApp;
    }

    public MeDto withWhatsApp(String whatsApp) {
        this.whatsApp = whatsApp;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MeDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("authorities".equals(name)) {
                if (value instanceof List) {
                    setAuthorities(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"authorities\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("avatar".equals(name)) {
                    if (value instanceof RefFileResource) {
                        setAvatar(((RefFileResource) value));
                    } else {
                        throw new IllegalArgumentException(("property \"avatar\" is of type \"org.hisp.dhis.api.model.v40_0.RefFileResource\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("birthday".equals(name)) {
                        if (value instanceof Date) {
                            setBirthday(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"birthday\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dataSets".equals(name)) {
                                if (value instanceof List) {
                                    setDataSets(((List<String> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dataSets\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("dataViewOrganisationUnits".equals(name)) {
                                    if (value instanceof List) {
                                        setDataViewOrganisationUnits(((List<RefOrganisationUnit> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"dataViewOrganisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefOrganisationUnit>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("education".equals(name)) {
                                            if (value instanceof String) {
                                                setEducation(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"education\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("email".equals(name)) {
                                                if (value instanceof String) {
                                                    setEmail(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"email\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("employer".equals(name)) {
                                                    if (value instanceof String) {
                                                        setEmployer(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"employer\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("facebookMessenger".equals(name)) {
                                                            if (value instanceof String) {
                                                                setFacebookMessenger(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"facebookMessenger\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("firstName".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setFirstName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"firstName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("gender".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setGender(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"gender\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("id".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setId(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("impersonation".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setImpersonation(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"impersonation\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("interests".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setInterests(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"interests\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("introduction".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setIntroduction(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"introduction\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("jobTitle".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setJobTitle(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"jobTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("languages".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setLanguages(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"languages\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                    if (value instanceof Date) {
                                                                                                        setLastUpdated(((Date) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("name".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setName(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("nationality".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setNationality(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"nationality\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("organisationUnits".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setOrganisationUnits(((List<RefOrganisationUnit> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefOrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("phoneNumber".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setPhoneNumber(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"phoneNumber\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("programs".equals(name)) {
                                                                                                                        if (value instanceof List) {
                                                                                                                            setPrograms(((List<String> ) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"programs\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("settings".equals(name)) {
                                                                                                                            if (value instanceof Settings) {
                                                                                                                                setSettings(((Settings) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"settings\" is of type \"org.hisp.dhis.api.model.v40_0.Settings\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("sharing".equals(name)) {
                                                                                                                                if (value instanceof Sharing) {
                                                                                                                                    setSharing(((Sharing) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("skype".equals(name)) {
                                                                                                                                    if (value instanceof String) {
                                                                                                                                        setSkype(((String) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"skype\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("surname".equals(name)) {
                                                                                                                                        if (value instanceof String) {
                                                                                                                                            setSurname(((String) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"surname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("teiSearchOrganisationUnits".equals(name)) {
                                                                                                                                            if (value instanceof List) {
                                                                                                                                                setTeiSearchOrganisationUnits(((List<RefOrganisationUnit> ) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"teiSearchOrganisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefOrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("telegram".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setTelegram(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"telegram\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("translations".equals(name)) {
                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                        setTranslations(((List<Translation> ) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("twitter".equals(name)) {
                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                            setTwitter(((String) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"twitter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("userCredentials".equals(name)) {
                                                                                                                                                                if (value instanceof UserCredentialsDto) {
                                                                                                                                                                    setUserCredentials(((UserCredentialsDto) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"userCredentials\" is of type \"org.hisp.dhis.api.model.v40_0.UserCredentialsDto\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("userGroups".equals(name)) {
                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                            setUserGroups(((List<RefUserGroup> ) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"userGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefUserGroup>\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("userRoles".equals(name)) {
                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                setUserRoles(((List<RefUserRole> ) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"userRoles\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefUserRole>\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("username".equals(name)) {
                                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                                    setUsername(((String) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("whatsApp".equals(name)) {
                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                        setWhatsApp(((String) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"whatsApp\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("authorities".equals(name)) {
                return getAuthorities();
            } else {
                if ("avatar".equals(name)) {
                    return getAvatar();
                } else {
                    if ("birthday".equals(name)) {
                        return getBirthday();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("dataSets".equals(name)) {
                                return getDataSets();
                            } else {
                                if ("dataViewOrganisationUnits".equals(name)) {
                                    return getDataViewOrganisationUnits();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("education".equals(name)) {
                                            return getEducation();
                                        } else {
                                            if ("email".equals(name)) {
                                                return getEmail();
                                            } else {
                                                if ("employer".equals(name)) {
                                                    return getEmployer();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("facebookMessenger".equals(name)) {
                                                            return getFacebookMessenger();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("firstName".equals(name)) {
                                                                    return getFirstName();
                                                                } else {
                                                                    if ("gender".equals(name)) {
                                                                        return getGender();
                                                                    } else {
                                                                        if ("id".equals(name)) {
                                                                            return getId();
                                                                        } else {
                                                                            if ("impersonation".equals(name)) {
                                                                                return getImpersonation();
                                                                            } else {
                                                                                if ("interests".equals(name)) {
                                                                                    return getInterests();
                                                                                } else {
                                                                                    if ("introduction".equals(name)) {
                                                                                        return getIntroduction();
                                                                                    } else {
                                                                                        if ("jobTitle".equals(name)) {
                                                                                            return getJobTitle();
                                                                                        } else {
                                                                                            if ("languages".equals(name)) {
                                                                                                return getLanguages();
                                                                                            } else {
                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                    return getLastUpdated();
                                                                                                } else {
                                                                                                    if ("name".equals(name)) {
                                                                                                        return getName();
                                                                                                    } else {
                                                                                                        if ("nationality".equals(name)) {
                                                                                                            return getNationality();
                                                                                                        } else {
                                                                                                            if ("organisationUnits".equals(name)) {
                                                                                                                return getOrganisationUnits();
                                                                                                            } else {
                                                                                                                if ("phoneNumber".equals(name)) {
                                                                                                                    return getPhoneNumber();
                                                                                                                } else {
                                                                                                                    if ("programs".equals(name)) {
                                                                                                                        return getPrograms();
                                                                                                                    } else {
                                                                                                                        if ("settings".equals(name)) {
                                                                                                                            return getSettings();
                                                                                                                        } else {
                                                                                                                            if ("sharing".equals(name)) {
                                                                                                                                return getSharing();
                                                                                                                            } else {
                                                                                                                                if ("skype".equals(name)) {
                                                                                                                                    return getSkype();
                                                                                                                                } else {
                                                                                                                                    if ("surname".equals(name)) {
                                                                                                                                        return getSurname();
                                                                                                                                    } else {
                                                                                                                                        if ("teiSearchOrganisationUnits".equals(name)) {
                                                                                                                                            return getTeiSearchOrganisationUnits();
                                                                                                                                        } else {
                                                                                                                                            if ("telegram".equals(name)) {
                                                                                                                                                return getTelegram();
                                                                                                                                            } else {
                                                                                                                                                if ("translations".equals(name)) {
                                                                                                                                                    return getTranslations();
                                                                                                                                                } else {
                                                                                                                                                    if ("twitter".equals(name)) {
                                                                                                                                                        return getTwitter();
                                                                                                                                                    } else {
                                                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                                                            return getUserAccesses();
                                                                                                                                                        } else {
                                                                                                                                                            if ("userCredentials".equals(name)) {
                                                                                                                                                                return getUserCredentials();
                                                                                                                                                            } else {
                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("userGroups".equals(name)) {
                                                                                                                                                                        return getUserGroups();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("userRoles".equals(name)) {
                                                                                                                                                                            return getUserRoles();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("username".equals(name)) {
                                                                                                                                                                                return getUsername();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("whatsApp".equals(name)) {
                                                                                                                                                                                    return getWhatsApp();
                                                                                                                                                                                } else {
                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MeDto.NOT_FOUND_VALUE);
        if (MeDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MeDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MeDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("authorities");
        sb.append('=');
        sb.append(((this.authorities == null)?"<null>":this.authorities));
        sb.append(',');
        sb.append("avatar");
        sb.append('=');
        sb.append(((this.avatar == null)?"<null>":this.avatar));
        sb.append(',');
        sb.append("birthday");
        sb.append('=');
        sb.append(((this.birthday == null)?"<null>":this.birthday));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataSets");
        sb.append('=');
        sb.append(((this.dataSets == null)?"<null>":this.dataSets));
        sb.append(',');
        sb.append("dataViewOrganisationUnits");
        sb.append('=');
        sb.append(((this.dataViewOrganisationUnits == null)?"<null>":this.dataViewOrganisationUnits));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("education");
        sb.append('=');
        sb.append(((this.education == null)?"<null>":this.education));
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(((this.email == null)?"<null>":this.email));
        sb.append(',');
        sb.append("employer");
        sb.append('=');
        sb.append(((this.employer == null)?"<null>":this.employer));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("facebookMessenger");
        sb.append('=');
        sb.append(((this.facebookMessenger == null)?"<null>":this.facebookMessenger));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("firstName");
        sb.append('=');
        sb.append(((this.firstName == null)?"<null>":this.firstName));
        sb.append(',');
        sb.append("gender");
        sb.append('=');
        sb.append(((this.gender == null)?"<null>":this.gender));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("impersonation");
        sb.append('=');
        sb.append(((this.impersonation == null)?"<null>":this.impersonation));
        sb.append(',');
        sb.append("interests");
        sb.append('=');
        sb.append(((this.interests == null)?"<null>":this.interests));
        sb.append(',');
        sb.append("introduction");
        sb.append('=');
        sb.append(((this.introduction == null)?"<null>":this.introduction));
        sb.append(',');
        sb.append("jobTitle");
        sb.append('=');
        sb.append(((this.jobTitle == null)?"<null>":this.jobTitle));
        sb.append(',');
        sb.append("languages");
        sb.append('=');
        sb.append(((this.languages == null)?"<null>":this.languages));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nationality");
        sb.append('=');
        sb.append(((this.nationality == null)?"<null>":this.nationality));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(((this.phoneNumber == null)?"<null>":this.phoneNumber));
        sb.append(',');
        sb.append("programs");
        sb.append('=');
        sb.append(((this.programs == null)?"<null>":this.programs));
        sb.append(',');
        sb.append("settings");
        sb.append('=');
        sb.append(((this.settings == null)?"<null>":this.settings));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("skype");
        sb.append('=');
        sb.append(((this.skype == null)?"<null>":this.skype));
        sb.append(',');
        sb.append("surname");
        sb.append('=');
        sb.append(((this.surname == null)?"<null>":this.surname));
        sb.append(',');
        sb.append("teiSearchOrganisationUnits");
        sb.append('=');
        sb.append(((this.teiSearchOrganisationUnits == null)?"<null>":this.teiSearchOrganisationUnits));
        sb.append(',');
        sb.append("telegram");
        sb.append('=');
        sb.append(((this.telegram == null)?"<null>":this.telegram));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("twitter");
        sb.append('=');
        sb.append(((this.twitter == null)?"<null>":this.twitter));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userCredentials");
        sb.append('=');
        sb.append(((this.userCredentials == null)?"<null>":this.userCredentials));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userGroups");
        sb.append('=');
        sb.append(((this.userGroups == null)?"<null>":this.userGroups));
        sb.append(',');
        sb.append("userRoles");
        sb.append('=');
        sb.append(((this.userRoles == null)?"<null>":this.userRoles));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("whatsApp");
        sb.append('=');
        sb.append(((this.whatsApp == null)?"<null>":this.whatsApp));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.birthday == null)? 0 :this.birthday.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.education == null)? 0 :this.education.hashCode()));
        result = ((result* 31)+((this.impersonation == null)? 0 :this.impersonation.hashCode()));
        result = ((result* 31)+((this.gender == null)? 0 :this.gender.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.jobTitle == null)? 0 :this.jobTitle.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.skype == null)? 0 :this.skype.hashCode()));
        result = ((result* 31)+((this.teiSearchOrganisationUnits == null)? 0 :this.teiSearchOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.twitter == null)? 0 :this.twitter.hashCode()));
        result = ((result* 31)+((this.surname == null)? 0 :this.surname.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.employer == null)? 0 :this.employer.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.facebookMessenger == null)? 0 :this.facebookMessenger.hashCode()));
        result = ((result* 31)+((this.email == null)? 0 :this.email.hashCode()));
        result = ((result* 31)+((this.introduction == null)? 0 :this.introduction.hashCode()));
        result = ((result* 31)+((this.dataViewOrganisationUnits == null)? 0 :this.dataViewOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.settings == null)? 0 :this.settings.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.whatsApp == null)? 0 :this.whatsApp.hashCode()));
        result = ((result* 31)+((this.languages == null)? 0 :this.languages.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.userCredentials == null)? 0 :this.userCredentials.hashCode()));
        result = ((result* 31)+((this.telegram == null)? 0 :this.telegram.hashCode()));
        result = ((result* 31)+((this.avatar == null)? 0 :this.avatar.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.authorities == null)? 0 :this.authorities.hashCode()));
        result = ((result* 31)+((this.firstName == null)? 0 :this.firstName.hashCode()));
        result = ((result* 31)+((this.userGroups == null)? 0 :this.userGroups.hashCode()));
        result = ((result* 31)+((this.userRoles == null)? 0 :this.userRoles.hashCode()));
        result = ((result* 31)+((this.phoneNumber == null)? 0 :this.phoneNumber.hashCode()));
        result = ((result* 31)+((this.nationality == null)? 0 :this.nationality.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.dataSets == null)? 0 :this.dataSets.hashCode()));
        result = ((result* 31)+((this.programs == null)? 0 :this.programs.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.interests == null)? 0 :this.interests.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MeDto) == false) {
            return false;
        }
        MeDto rhs = ((MeDto) other);
        return (((((((((((((((((((((((((((((((((((((((((((((this.birthday == rhs.birthday)||((this.birthday!= null)&&this.birthday.equals(rhs.birthday)))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.education == rhs.education)||((this.education!= null)&&this.education.equals(rhs.education))))&&((this.impersonation == rhs.impersonation)||((this.impersonation!= null)&&this.impersonation.equals(rhs.impersonation))))&&((this.gender == rhs.gender)||((this.gender!= null)&&this.gender.equals(rhs.gender))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.jobTitle == rhs.jobTitle)||((this.jobTitle!= null)&&this.jobTitle.equals(rhs.jobTitle))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.skype == rhs.skype)||((this.skype!= null)&&this.skype.equals(rhs.skype))))&&((this.teiSearchOrganisationUnits == rhs.teiSearchOrganisationUnits)||((this.teiSearchOrganisationUnits!= null)&&this.teiSearchOrganisationUnits.equals(rhs.teiSearchOrganisationUnits))))&&((this.twitter == rhs.twitter)||((this.twitter!= null)&&this.twitter.equals(rhs.twitter))))&&((this.surname == rhs.surname)||((this.surname!= null)&&this.surname.equals(rhs.surname))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.employer == rhs.employer)||((this.employer!= null)&&this.employer.equals(rhs.employer))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.facebookMessenger == rhs.facebookMessenger)||((this.facebookMessenger!= null)&&this.facebookMessenger.equals(rhs.facebookMessenger))))&&((this.email == rhs.email)||((this.email!= null)&&this.email.equals(rhs.email))))&&((this.introduction == rhs.introduction)||((this.introduction!= null)&&this.introduction.equals(rhs.introduction))))&&((this.dataViewOrganisationUnits == rhs.dataViewOrganisationUnits)||((this.dataViewOrganisationUnits!= null)&&this.dataViewOrganisationUnits.equals(rhs.dataViewOrganisationUnits))))&&((this.settings == rhs.settings)||((this.settings!= null)&&this.settings.equals(rhs.settings))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.whatsApp == rhs.whatsApp)||((this.whatsApp!= null)&&this.whatsApp.equals(rhs.whatsApp))))&&((this.languages == rhs.languages)||((this.languages!= null)&&this.languages.equals(rhs.languages))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.userCredentials == rhs.userCredentials)||((this.userCredentials!= null)&&this.userCredentials.equals(rhs.userCredentials))))&&((this.telegram == rhs.telegram)||((this.telegram!= null)&&this.telegram.equals(rhs.telegram))))&&((this.avatar == rhs.avatar)||((this.avatar!= null)&&this.avatar.equals(rhs.avatar))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.authorities == rhs.authorities)||((this.authorities!= null)&&this.authorities.equals(rhs.authorities))))&&((this.firstName == rhs.firstName)||((this.firstName!= null)&&this.firstName.equals(rhs.firstName))))&&((this.userGroups == rhs.userGroups)||((this.userGroups!= null)&&this.userGroups.equals(rhs.userGroups))))&&((this.userRoles == rhs.userRoles)||((this.userRoles!= null)&&this.userRoles.equals(rhs.userRoles))))&&((this.phoneNumber == rhs.phoneNumber)||((this.phoneNumber!= null)&&this.phoneNumber.equals(rhs.phoneNumber))))&&((this.nationality == rhs.nationality)||((this.nationality!= null)&&this.nationality.equals(rhs.nationality))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.dataSets == rhs.dataSets)||((this.dataSets!= null)&&this.dataSets.equals(rhs.dataSets))))&&((this.programs == rhs.programs)||((this.programs!= null)&&this.programs.equals(rhs.programs))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.interests == rhs.interests)||((this.interests!= null)&&this.interests.equals(rhs.interests))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

}
