
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "executionPlans",
    "totalTimeInMillis"
})
@Generated("jsonschema2pojo")
public class PerformanceMetrics implements Serializable
{

    @JsonProperty("executionPlans")
    private List<ExecutionPlan> executionPlans;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalTimeInMillis")
    private Double totalTimeInMillis;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7785759750262402920L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PerformanceMetrics() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public PerformanceMetrics(PerformanceMetrics source) {
        super();
        this.executionPlans = source.executionPlans;
        this.totalTimeInMillis = source.totalTimeInMillis;
    }

    public PerformanceMetrics(List<ExecutionPlan> executionPlans, Double totalTimeInMillis) {
        super();
        this.executionPlans = executionPlans;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    @JsonProperty("executionPlans")
    public Optional<List<ExecutionPlan>> getExecutionPlans() {
        return Optional.ofNullable(executionPlans);
    }

    @JsonProperty("executionPlans")
    public void setExecutionPlans(List<ExecutionPlan> executionPlans) {
        this.executionPlans = executionPlans;
    }

    public PerformanceMetrics withExecutionPlans(List<ExecutionPlan> executionPlans) {
        this.executionPlans = executionPlans;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalTimeInMillis")
    public Double getTotalTimeInMillis() {
        return totalTimeInMillis;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalTimeInMillis")
    public void setTotalTimeInMillis(Double totalTimeInMillis) {
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public PerformanceMetrics withTotalTimeInMillis(Double totalTimeInMillis) {
        this.totalTimeInMillis = totalTimeInMillis;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public PerformanceMetrics withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("executionPlans".equals(name)) {
            if (value instanceof List) {
                setExecutionPlans(((List<ExecutionPlan> ) value));
            } else {
                throw new IllegalArgumentException(("property \"executionPlans\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ExecutionPlan>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("totalTimeInMillis".equals(name)) {
                if (value instanceof Double) {
                    setTotalTimeInMillis(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalTimeInMillis\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("executionPlans".equals(name)) {
            return getExecutionPlans();
        } else {
            if ("totalTimeInMillis".equals(name)) {
                return getTotalTimeInMillis();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, PerformanceMetrics.NOT_FOUND_VALUE);
        if (PerformanceMetrics.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public PerformanceMetrics with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PerformanceMetrics.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("executionPlans");
        sb.append('=');
        sb.append(((this.executionPlans == null)?"<null>":this.executionPlans));
        sb.append(',');
        sb.append("totalTimeInMillis");
        sb.append('=');
        sb.append(((this.totalTimeInMillis == null)?"<null>":this.totalTimeInMillis));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.executionPlans == null)? 0 :this.executionPlans.hashCode()));
        result = ((result* 31)+((this.totalTimeInMillis == null)? 0 :this.totalTimeInMillis.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PerformanceMetrics) == false) {
            return false;
        }
        PerformanceMetrics rhs = ((PerformanceMetrics) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.executionPlans == rhs.executionPlans)||((this.executionPlans!= null)&&this.executionPlans.equals(rhs.executionPlans))))&&((this.totalTimeInMillis == rhs.totalTimeInMillis)||((this.totalTimeInMillis!= null)&&this.totalTimeInMillis.equals(rhs.totalTimeInMillis))));
    }

}
