
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "cancelledTime",
    "completedTime",
    "description",
    "error",
    "jobId",
    "stages",
    "startedTime",
    "status",
    "summary"
})
@Generated("jsonschema2pojo")
public class ProcessInfo implements Serializable
{

    @JsonProperty("cancelledTime")
    private Date cancelledTime;
    @JsonProperty("completedTime")
    private Date completedTime;
    @JsonProperty("description")
    private String description;
    @JsonProperty("error")
    private String error;
    @JsonProperty("jobId")
    private String jobId;
    @JsonProperty("stages")
    private List<String> stages;
    @JsonProperty("startedTime")
    private Date startedTime;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private ProcessInfo.Status status;
    @JsonProperty("summary")
    private String summary;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2639541595329296106L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProcessInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProcessInfo(ProcessInfo source) {
        super();
        this.cancelledTime = source.cancelledTime;
        this.completedTime = source.completedTime;
        this.description = source.description;
        this.error = source.error;
        this.jobId = source.jobId;
        this.stages = source.stages;
        this.startedTime = source.startedTime;
        this.status = source.status;
        this.summary = source.summary;
    }

    public ProcessInfo(Date cancelledTime, Date completedTime, String description, String error, String jobId, List<String> stages, Date startedTime, ProcessInfo.Status status, String summary) {
        super();
        this.cancelledTime = cancelledTime;
        this.completedTime = completedTime;
        this.description = description;
        this.error = error;
        this.jobId = jobId;
        this.stages = stages;
        this.startedTime = startedTime;
        this.status = status;
        this.summary = summary;
    }

    @JsonProperty("cancelledTime")
    public Optional<Date> getCancelledTime() {
        return Optional.ofNullable(cancelledTime);
    }

    @JsonProperty("cancelledTime")
    public void setCancelledTime(Date cancelledTime) {
        this.cancelledTime = cancelledTime;
    }

    public ProcessInfo withCancelledTime(Date cancelledTime) {
        this.cancelledTime = cancelledTime;
        return this;
    }

    @JsonProperty("completedTime")
    public Optional<Date> getCompletedTime() {
        return Optional.ofNullable(completedTime);
    }

    @JsonProperty("completedTime")
    public void setCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
    }

    public ProcessInfo withCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("error")
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    @JsonProperty("error")
    public void setError(String error) {
        this.error = error;
    }

    public ProcessInfo withError(String error) {
        this.error = error;
        return this;
    }

    @JsonProperty("jobId")
    public Optional<String> getJobId() {
        return Optional.ofNullable(jobId);
    }

    @JsonProperty("jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ProcessInfo withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty("stages")
    public Optional<List<String>> getStages() {
        return Optional.ofNullable(stages);
    }

    @JsonProperty("stages")
    public void setStages(List<String> stages) {
        this.stages = stages;
    }

    public ProcessInfo withStages(List<String> stages) {
        this.stages = stages;
        return this;
    }

    @JsonProperty("startedTime")
    public Optional<Date> getStartedTime() {
        return Optional.ofNullable(startedTime);
    }

    @JsonProperty("startedTime")
    public void setStartedTime(Date startedTime) {
        this.startedTime = startedTime;
    }

    public ProcessInfo withStartedTime(Date startedTime) {
        this.startedTime = startedTime;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public ProcessInfo.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(ProcessInfo.Status status) {
        this.status = status;
    }

    public ProcessInfo withStatus(ProcessInfo.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("summary")
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    @JsonProperty("summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ProcessInfo withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProcessInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("cancelledTime".equals(name)) {
            if (value instanceof Date) {
                setCancelledTime(((Date) value));
            } else {
                throw new IllegalArgumentException(("property \"cancelledTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("completedTime".equals(name)) {
                if (value instanceof Date) {
                    setCompletedTime(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("description".equals(name)) {
                    if (value instanceof String) {
                        setDescription(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("error".equals(name)) {
                        if (value instanceof String) {
                            setError(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"error\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("jobId".equals(name)) {
                            if (value instanceof String) {
                                setJobId(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"jobId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("stages".equals(name)) {
                                if (value instanceof List) {
                                    setStages(((List<String> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"stages\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("startedTime".equals(name)) {
                                    if (value instanceof Date) {
                                        setStartedTime(((Date) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"startedTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("status".equals(name)) {
                                        if (value instanceof ProcessInfo.Status) {
                                            setStatus(((ProcessInfo.Status) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.ProcessInfo.Status\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("summary".equals(name)) {
                                            if (value instanceof String) {
                                                setSummary(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"summary\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("cancelledTime".equals(name)) {
            return getCancelledTime();
        } else {
            if ("completedTime".equals(name)) {
                return getCompletedTime();
            } else {
                if ("description".equals(name)) {
                    return getDescription();
                } else {
                    if ("error".equals(name)) {
                        return getError();
                    } else {
                        if ("jobId".equals(name)) {
                            return getJobId();
                        } else {
                            if ("stages".equals(name)) {
                                return getStages();
                            } else {
                                if ("startedTime".equals(name)) {
                                    return getStartedTime();
                                } else {
                                    if ("status".equals(name)) {
                                        return getStatus();
                                    } else {
                                        if ("summary".equals(name)) {
                                            return getSummary();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProcessInfo.NOT_FOUND_VALUE);
        if (ProcessInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProcessInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProcessInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("cancelledTime");
        sb.append('=');
        sb.append(((this.cancelledTime == null)?"<null>":this.cancelledTime));
        sb.append(',');
        sb.append("completedTime");
        sb.append('=');
        sb.append(((this.completedTime == null)?"<null>":this.completedTime));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("error");
        sb.append('=');
        sb.append(((this.error == null)?"<null>":this.error));
        sb.append(',');
        sb.append("jobId");
        sb.append('=');
        sb.append(((this.jobId == null)?"<null>":this.jobId));
        sb.append(',');
        sb.append("stages");
        sb.append('=');
        sb.append(((this.stages == null)?"<null>":this.stages));
        sb.append(',');
        sb.append("startedTime");
        sb.append('=');
        sb.append(((this.startedTime == null)?"<null>":this.startedTime));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(((this.summary == null)?"<null>":this.summary));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.summary == null)? 0 :this.summary.hashCode()));
        result = ((result* 31)+((this.jobId == null)? 0 :this.jobId.hashCode()));
        result = ((result* 31)+((this.startedTime == null)? 0 :this.startedTime.hashCode()));
        result = ((result* 31)+((this.cancelledTime == null)? 0 :this.cancelledTime.hashCode()));
        result = ((result* 31)+((this.completedTime == null)? 0 :this.completedTime.hashCode()));
        result = ((result* 31)+((this.stages == null)? 0 :this.stages.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.error == null)? 0 :this.error.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProcessInfo) == false) {
            return false;
        }
        ProcessInfo rhs = ((ProcessInfo) other);
        return (((((((((((this.summary == rhs.summary)||((this.summary!= null)&&this.summary.equals(rhs.summary)))&&((this.jobId == rhs.jobId)||((this.jobId!= null)&&this.jobId.equals(rhs.jobId))))&&((this.startedTime == rhs.startedTime)||((this.startedTime!= null)&&this.startedTime.equals(rhs.startedTime))))&&((this.cancelledTime == rhs.cancelledTime)||((this.cancelledTime!= null)&&this.cancelledTime.equals(rhs.cancelledTime))))&&((this.completedTime == rhs.completedTime)||((this.completedTime!= null)&&this.completedTime.equals(rhs.completedTime))))&&((this.stages == rhs.stages)||((this.stages!= null)&&this.stages.equals(rhs.stages))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.error == rhs.error)||((this.error!= null)&&this.error.equals(rhs.error))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum Status {

        RUNNING("RUNNING"),
        SUCCESS("SUCCESS"),
        ERROR("ERROR"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, ProcessInfo.Status> CONSTANTS = new HashMap<String, ProcessInfo.Status>();

        static {
            for (ProcessInfo.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProcessInfo.Status fromValue(String value) {
            ProcessInfo.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
