
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "allowGenerateNextVisit",
    "attributeValues",
    "autoGenerateEvent",
    "blockEntryForm",
    "code",
    "created",
    "createdBy",
    "dataEntryForm",
    "description",
    "displayDescription",
    "displayDueDateLabel",
    "displayExecutionDateLabel",
    "displayFormName",
    "displayGenerateEventBox",
    "displayName",
    "displayShortName",
    "dueDateLabel",
    "enableUserAssignment",
    "executionDateLabel",
    "externalAccess",
    "favorite",
    "favorites",
    "featureType",
    "formName",
    "formType",
    "generatedByEnrollmentDate",
    "hideDueDate",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "minDaysFromStart",
    "name",
    "nextScheduleDate",
    "notificationTemplates",
    "openAfterEnrollment",
    "periodType",
    "preGenerateUID",
    "program",
    "programStageDataElements",
    "programStageSections",
    "publicAccess",
    "referral",
    "remindCompleted",
    "repeatable",
    "reportDateToUse",
    "sharing",
    "shortName",
    "sortOrder",
    "standardInterval",
    "style",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "validationStrategy"
})
@Generated("jsonschema2pojo")
public class ProgramStage implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("allowGenerateNextVisit")
    private Boolean allowGenerateNextVisit;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("autoGenerateEvent")
    private Boolean autoGenerateEvent;
    @JsonProperty("blockEntryForm")
    private Boolean blockEntryForm;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    /**
     * A UID reference to a DataEntryForm  
     * (Java name `org.hisp.dhis.dataentryform.DataEntryForm`)
     * 
     */
    @JsonProperty("dataEntryForm")
    @JsonPropertyDescription("A UID reference to a DataEntryForm  \n(Java name `org.hisp.dhis.dataentryform.DataEntryForm`)")
    private RefDataEntryForm dataEntryForm;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayDueDateLabel")
    private String displayDueDateLabel;
    @JsonProperty("displayExecutionDateLabel")
    private String displayExecutionDateLabel;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayGenerateEventBox")
    private Boolean displayGenerateEventBox;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("dueDateLabel")
    private String dueDateLabel;
    @JsonProperty("enableUserAssignment")
    private Boolean enableUserAssignment;
    @JsonProperty("executionDateLabel")
    private String executionDateLabel;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    private ProgramStage.FeatureType featureType;
    @JsonProperty("formName")
    private String formName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("formType")
    private ProgramStage.FormType formType;
    @JsonProperty("generatedByEnrollmentDate")
    private Boolean generatedByEnrollmentDate;
    @JsonProperty("hideDueDate")
    private Boolean hideDueDate;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("minDaysFromStart")
    private Integer minDaysFromStart;
    @JsonProperty("name")
    private String name;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("nextScheduleDate")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private RefDataElement nextScheduleDate;
    @JsonProperty("notificationTemplates")
    private List<RefProgramNotificationTemplate> notificationTemplates;
    @JsonProperty("openAfterEnrollment")
    private Boolean openAfterEnrollment;
    @JsonProperty("periodType")
    private ProgramStage.PeriodType periodType;
    @JsonProperty("preGenerateUID")
    private Boolean preGenerateUID;
    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private RefProgram program;
    @JsonProperty("programStageDataElements")
    private List<RefProgramStageDataElement> programStageDataElements;
    @JsonProperty("programStageSections")
    private List<RefProgramStageSection> programStageSections;
    @JsonProperty("publicAccess")
    private String publicAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("referral")
    private Boolean referral;
    @JsonProperty("remindCompleted")
    private Boolean remindCompleted;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("repeatable")
    private Boolean repeatable;
    @JsonProperty("reportDateToUse")
    private String reportDateToUse;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("standardInterval")
    private Integer standardInterval;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationStrategy")
    private ProgramStage.ValidationStrategy validationStrategy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8487806690525221946L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramStage() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramStage(ProgramStage source) {
        super();
        this.access = source.access;
        this.allowGenerateNextVisit = source.allowGenerateNextVisit;
        this.attributeValues = source.attributeValues;
        this.autoGenerateEvent = source.autoGenerateEvent;
        this.blockEntryForm = source.blockEntryForm;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataEntryForm = source.dataEntryForm;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayDueDateLabel = source.displayDueDateLabel;
        this.displayExecutionDateLabel = source.displayExecutionDateLabel;
        this.displayFormName = source.displayFormName;
        this.displayGenerateEventBox = source.displayGenerateEventBox;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.dueDateLabel = source.dueDateLabel;
        this.enableUserAssignment = source.enableUserAssignment;
        this.executionDateLabel = source.executionDateLabel;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.featureType = source.featureType;
        this.formName = source.formName;
        this.formType = source.formType;
        this.generatedByEnrollmentDate = source.generatedByEnrollmentDate;
        this.hideDueDate = source.hideDueDate;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.minDaysFromStart = source.minDaysFromStart;
        this.name = source.name;
        this.nextScheduleDate = source.nextScheduleDate;
        this.notificationTemplates = source.notificationTemplates;
        this.openAfterEnrollment = source.openAfterEnrollment;
        this.periodType = source.periodType;
        this.preGenerateUID = source.preGenerateUID;
        this.program = source.program;
        this.programStageDataElements = source.programStageDataElements;
        this.programStageSections = source.programStageSections;
        this.publicAccess = source.publicAccess;
        this.referral = source.referral;
        this.remindCompleted = source.remindCompleted;
        this.repeatable = source.repeatable;
        this.reportDateToUse = source.reportDateToUse;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.sortOrder = source.sortOrder;
        this.standardInterval = source.standardInterval;
        this.style = source.style;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.validationStrategy = source.validationStrategy;
    }

    public ProgramStage(Access access, Boolean allowGenerateNextVisit, List<AttributeValue> attributeValues, Boolean autoGenerateEvent, Boolean blockEntryForm, String code, Date created, RefUser createdBy, RefDataEntryForm dataEntryForm, String description, String displayDescription, String displayDueDateLabel, String displayExecutionDateLabel, String displayFormName, Boolean displayGenerateEventBox, String displayName, String displayShortName, String dueDateLabel, Boolean enableUserAssignment, String executionDateLabel, Boolean externalAccess, Boolean favorite, List<String> favorites, ProgramStage.FeatureType featureType, String formName, ProgramStage.FormType formType, Boolean generatedByEnrollmentDate, Boolean hideDueDate, String href, String id, Date lastUpdated, RefUser lastUpdatedBy, Integer minDaysFromStart, String name, RefDataElement nextScheduleDate, List<RefProgramNotificationTemplate> notificationTemplates, Boolean openAfterEnrollment, ProgramStage.PeriodType periodType, Boolean preGenerateUID, RefProgram program, List<RefProgramStageDataElement> programStageDataElements, List<RefProgramStageSection> programStageSections, String publicAccess, Boolean referral, Boolean remindCompleted, Boolean repeatable, String reportDateToUse, Sharing sharing, String shortName, Integer sortOrder, Integer standardInterval, ObjectStyle style, List<Translation> translations, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, ProgramStage.ValidationStrategy validationStrategy) {
        super();
        this.access = access;
        this.allowGenerateNextVisit = allowGenerateNextVisit;
        this.attributeValues = attributeValues;
        this.autoGenerateEvent = autoGenerateEvent;
        this.blockEntryForm = blockEntryForm;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dataEntryForm = dataEntryForm;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayDueDateLabel = displayDueDateLabel;
        this.displayExecutionDateLabel = displayExecutionDateLabel;
        this.displayFormName = displayFormName;
        this.displayGenerateEventBox = displayGenerateEventBox;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.dueDateLabel = dueDateLabel;
        this.enableUserAssignment = enableUserAssignment;
        this.executionDateLabel = executionDateLabel;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.featureType = featureType;
        this.formName = formName;
        this.formType = formType;
        this.generatedByEnrollmentDate = generatedByEnrollmentDate;
        this.hideDueDate = hideDueDate;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.minDaysFromStart = minDaysFromStart;
        this.name = name;
        this.nextScheduleDate = nextScheduleDate;
        this.notificationTemplates = notificationTemplates;
        this.openAfterEnrollment = openAfterEnrollment;
        this.periodType = periodType;
        this.preGenerateUID = preGenerateUID;
        this.program = program;
        this.programStageDataElements = programStageDataElements;
        this.programStageSections = programStageSections;
        this.publicAccess = publicAccess;
        this.referral = referral;
        this.remindCompleted = remindCompleted;
        this.repeatable = repeatable;
        this.reportDateToUse = reportDateToUse;
        this.sharing = sharing;
        this.shortName = shortName;
        this.sortOrder = sortOrder;
        this.standardInterval = standardInterval;
        this.style = style;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.validationStrategy = validationStrategy;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramStage withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("allowGenerateNextVisit")
    public Optional<Boolean> getAllowGenerateNextVisit() {
        return Optional.ofNullable(allowGenerateNextVisit);
    }

    @JsonProperty("allowGenerateNextVisit")
    public void setAllowGenerateNextVisit(Boolean allowGenerateNextVisit) {
        this.allowGenerateNextVisit = allowGenerateNextVisit;
    }

    public ProgramStage withAllowGenerateNextVisit(Boolean allowGenerateNextVisit) {
        this.allowGenerateNextVisit = allowGenerateNextVisit;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramStage withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("autoGenerateEvent")
    public Optional<Boolean> getAutoGenerateEvent() {
        return Optional.ofNullable(autoGenerateEvent);
    }

    @JsonProperty("autoGenerateEvent")
    public void setAutoGenerateEvent(Boolean autoGenerateEvent) {
        this.autoGenerateEvent = autoGenerateEvent;
    }

    public ProgramStage withAutoGenerateEvent(Boolean autoGenerateEvent) {
        this.autoGenerateEvent = autoGenerateEvent;
        return this;
    }

    @JsonProperty("blockEntryForm")
    public Optional<Boolean> getBlockEntryForm() {
        return Optional.ofNullable(blockEntryForm);
    }

    @JsonProperty("blockEntryForm")
    public void setBlockEntryForm(Boolean blockEntryForm) {
        this.blockEntryForm = blockEntryForm;
    }

    public ProgramStage withBlockEntryForm(Boolean blockEntryForm) {
        this.blockEntryForm = blockEntryForm;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramStage withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramStage withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramStage withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * A UID reference to a DataEntryForm  
     * (Java name `org.hisp.dhis.dataentryform.DataEntryForm`)
     * 
     */
    @JsonProperty("dataEntryForm")
    public Optional<RefDataEntryForm> getDataEntryForm() {
        return Optional.ofNullable(dataEntryForm);
    }

    /**
     * A UID reference to a DataEntryForm  
     * (Java name `org.hisp.dhis.dataentryform.DataEntryForm`)
     * 
     */
    @JsonProperty("dataEntryForm")
    public void setDataEntryForm(RefDataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
    }

    public ProgramStage withDataEntryForm(RefDataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ProgramStage withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ProgramStage withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayDueDateLabel")
    public Optional<String> getDisplayDueDateLabel() {
        return Optional.ofNullable(displayDueDateLabel);
    }

    @JsonProperty("displayDueDateLabel")
    public void setDisplayDueDateLabel(String displayDueDateLabel) {
        this.displayDueDateLabel = displayDueDateLabel;
    }

    public ProgramStage withDisplayDueDateLabel(String displayDueDateLabel) {
        this.displayDueDateLabel = displayDueDateLabel;
        return this;
    }

    @JsonProperty("displayExecutionDateLabel")
    public Optional<String> getDisplayExecutionDateLabel() {
        return Optional.ofNullable(displayExecutionDateLabel);
    }

    @JsonProperty("displayExecutionDateLabel")
    public void setDisplayExecutionDateLabel(String displayExecutionDateLabel) {
        this.displayExecutionDateLabel = displayExecutionDateLabel;
    }

    public ProgramStage withDisplayExecutionDateLabel(String displayExecutionDateLabel) {
        this.displayExecutionDateLabel = displayExecutionDateLabel;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public ProgramStage withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayGenerateEventBox")
    public Optional<Boolean> getDisplayGenerateEventBox() {
        return Optional.ofNullable(displayGenerateEventBox);
    }

    @JsonProperty("displayGenerateEventBox")
    public void setDisplayGenerateEventBox(Boolean displayGenerateEventBox) {
        this.displayGenerateEventBox = displayGenerateEventBox;
    }

    public ProgramStage withDisplayGenerateEventBox(Boolean displayGenerateEventBox) {
        this.displayGenerateEventBox = displayGenerateEventBox;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramStage withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public ProgramStage withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("dueDateLabel")
    public Optional<String> getDueDateLabel() {
        return Optional.ofNullable(dueDateLabel);
    }

    @JsonProperty("dueDateLabel")
    public void setDueDateLabel(String dueDateLabel) {
        this.dueDateLabel = dueDateLabel;
    }

    public ProgramStage withDueDateLabel(String dueDateLabel) {
        this.dueDateLabel = dueDateLabel;
        return this;
    }

    @JsonProperty("enableUserAssignment")
    public Optional<Boolean> getEnableUserAssignment() {
        return Optional.ofNullable(enableUserAssignment);
    }

    @JsonProperty("enableUserAssignment")
    public void setEnableUserAssignment(Boolean enableUserAssignment) {
        this.enableUserAssignment = enableUserAssignment;
    }

    public ProgramStage withEnableUserAssignment(Boolean enableUserAssignment) {
        this.enableUserAssignment = enableUserAssignment;
        return this;
    }

    @JsonProperty("executionDateLabel")
    public Optional<String> getExecutionDateLabel() {
        return Optional.ofNullable(executionDateLabel);
    }

    @JsonProperty("executionDateLabel")
    public void setExecutionDateLabel(String executionDateLabel) {
        this.executionDateLabel = executionDateLabel;
    }

    public ProgramStage withExecutionDateLabel(String executionDateLabel) {
        this.executionDateLabel = executionDateLabel;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramStage withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramStage withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramStage withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public ProgramStage.FeatureType getFeatureType() {
        return featureType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public void setFeatureType(ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
    }

    public ProgramStage withFeatureType(ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public ProgramStage withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("formType")
    public ProgramStage.FormType getFormType() {
        return formType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("formType")
    public void setFormType(ProgramStage.FormType formType) {
        this.formType = formType;
    }

    public ProgramStage withFormType(ProgramStage.FormType formType) {
        this.formType = formType;
        return this;
    }

    @JsonProperty("generatedByEnrollmentDate")
    public Optional<Boolean> getGeneratedByEnrollmentDate() {
        return Optional.ofNullable(generatedByEnrollmentDate);
    }

    @JsonProperty("generatedByEnrollmentDate")
    public void setGeneratedByEnrollmentDate(Boolean generatedByEnrollmentDate) {
        this.generatedByEnrollmentDate = generatedByEnrollmentDate;
    }

    public ProgramStage withGeneratedByEnrollmentDate(Boolean generatedByEnrollmentDate) {
        this.generatedByEnrollmentDate = generatedByEnrollmentDate;
        return this;
    }

    @JsonProperty("hideDueDate")
    public Optional<Boolean> getHideDueDate() {
        return Optional.ofNullable(hideDueDate);
    }

    @JsonProperty("hideDueDate")
    public void setHideDueDate(Boolean hideDueDate) {
        this.hideDueDate = hideDueDate;
    }

    public ProgramStage withHideDueDate(Boolean hideDueDate) {
        this.hideDueDate = hideDueDate;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramStage withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramStage withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramStage withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramStage withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("minDaysFromStart")
    public Integer getMinDaysFromStart() {
        return minDaysFromStart;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("minDaysFromStart")
    public void setMinDaysFromStart(Integer minDaysFromStart) {
        this.minDaysFromStart = minDaysFromStart;
    }

    public ProgramStage withMinDaysFromStart(Integer minDaysFromStart) {
        this.minDaysFromStart = minDaysFromStart;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramStage withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("nextScheduleDate")
    public Optional<RefDataElement> getNextScheduleDate() {
        return Optional.ofNullable(nextScheduleDate);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("nextScheduleDate")
    public void setNextScheduleDate(RefDataElement nextScheduleDate) {
        this.nextScheduleDate = nextScheduleDate;
    }

    public ProgramStage withNextScheduleDate(RefDataElement nextScheduleDate) {
        this.nextScheduleDate = nextScheduleDate;
        return this;
    }

    @JsonProperty("notificationTemplates")
    public Optional<List<RefProgramNotificationTemplate>> getNotificationTemplates() {
        return Optional.ofNullable(notificationTemplates);
    }

    @JsonProperty("notificationTemplates")
    public void setNotificationTemplates(List<RefProgramNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }

    public ProgramStage withNotificationTemplates(List<RefProgramNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
        return this;
    }

    @JsonProperty("openAfterEnrollment")
    public Optional<Boolean> getOpenAfterEnrollment() {
        return Optional.ofNullable(openAfterEnrollment);
    }

    @JsonProperty("openAfterEnrollment")
    public void setOpenAfterEnrollment(Boolean openAfterEnrollment) {
        this.openAfterEnrollment = openAfterEnrollment;
    }

    public ProgramStage withOpenAfterEnrollment(Boolean openAfterEnrollment) {
        this.openAfterEnrollment = openAfterEnrollment;
        return this;
    }

    @JsonProperty("periodType")
    public Optional<ProgramStage.PeriodType> getPeriodType() {
        return Optional.ofNullable(periodType);
    }

    @JsonProperty("periodType")
    public void setPeriodType(ProgramStage.PeriodType periodType) {
        this.periodType = periodType;
    }

    public ProgramStage withPeriodType(ProgramStage.PeriodType periodType) {
        this.periodType = periodType;
        return this;
    }

    @JsonProperty("preGenerateUID")
    public Optional<Boolean> getPreGenerateUID() {
        return Optional.ofNullable(preGenerateUID);
    }

    @JsonProperty("preGenerateUID")
    public void setPreGenerateUID(Boolean preGenerateUID) {
        this.preGenerateUID = preGenerateUID;
    }

    public ProgramStage withPreGenerateUID(Boolean preGenerateUID) {
        this.preGenerateUID = preGenerateUID;
        return this;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<RefProgram> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(RefProgram program) {
        this.program = program;
    }

    public ProgramStage withProgram(RefProgram program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStageDataElements")
    public Optional<List<RefProgramStageDataElement>> getProgramStageDataElements() {
        return Optional.ofNullable(programStageDataElements);
    }

    @JsonProperty("programStageDataElements")
    public void setProgramStageDataElements(List<RefProgramStageDataElement> programStageDataElements) {
        this.programStageDataElements = programStageDataElements;
    }

    public ProgramStage withProgramStageDataElements(List<RefProgramStageDataElement> programStageDataElements) {
        this.programStageDataElements = programStageDataElements;
        return this;
    }

    @JsonProperty("programStageSections")
    public Optional<List<RefProgramStageSection>> getProgramStageSections() {
        return Optional.ofNullable(programStageSections);
    }

    @JsonProperty("programStageSections")
    public void setProgramStageSections(List<RefProgramStageSection> programStageSections) {
        this.programStageSections = programStageSections;
    }

    public ProgramStage withProgramStageSections(List<RefProgramStageSection> programStageSections) {
        this.programStageSections = programStageSections;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramStage withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("referral")
    public Boolean getReferral() {
        return referral;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("referral")
    public void setReferral(Boolean referral) {
        this.referral = referral;
    }

    public ProgramStage withReferral(Boolean referral) {
        this.referral = referral;
        return this;
    }

    @JsonProperty("remindCompleted")
    public Optional<Boolean> getRemindCompleted() {
        return Optional.ofNullable(remindCompleted);
    }

    @JsonProperty("remindCompleted")
    public void setRemindCompleted(Boolean remindCompleted) {
        this.remindCompleted = remindCompleted;
    }

    public ProgramStage withRemindCompleted(Boolean remindCompleted) {
        this.remindCompleted = remindCompleted;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("repeatable")
    public Boolean getRepeatable() {
        return repeatable;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("repeatable")
    public void setRepeatable(Boolean repeatable) {
        this.repeatable = repeatable;
    }

    public ProgramStage withRepeatable(Boolean repeatable) {
        this.repeatable = repeatable;
        return this;
    }

    @JsonProperty("reportDateToUse")
    public Optional<String> getReportDateToUse() {
        return Optional.ofNullable(reportDateToUse);
    }

    @JsonProperty("reportDateToUse")
    public void setReportDateToUse(String reportDateToUse) {
        this.reportDateToUse = reportDateToUse;
    }

    public ProgramStage withReportDateToUse(String reportDateToUse) {
        this.reportDateToUse = reportDateToUse;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramStage withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ProgramStage withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ProgramStage withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("standardInterval")
    public Optional<Integer> getStandardInterval() {
        return Optional.ofNullable(standardInterval);
    }

    @JsonProperty("standardInterval")
    public void setStandardInterval(Integer standardInterval) {
        this.standardInterval = standardInterval;
    }

    public ProgramStage withStandardInterval(Integer standardInterval) {
        this.standardInterval = standardInterval;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public ProgramStage withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramStage withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public ProgramStage withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramStage withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramStage withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationStrategy")
    public ProgramStage.ValidationStrategy getValidationStrategy() {
        return validationStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("validationStrategy")
    public void setValidationStrategy(ProgramStage.ValidationStrategy validationStrategy) {
        this.validationStrategy = validationStrategy;
    }

    public ProgramStage withValidationStrategy(ProgramStage.ValidationStrategy validationStrategy) {
        this.validationStrategy = validationStrategy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramStage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("allowGenerateNextVisit".equals(name)) {
                if (value instanceof Boolean) {
                    setAllowGenerateNextVisit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowGenerateNextVisit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("autoGenerateEvent".equals(name)) {
                        if (value instanceof Boolean) {
                            setAutoGenerateEvent(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"autoGenerateEvent\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("blockEntryForm".equals(name)) {
                            if (value instanceof Boolean) {
                                setBlockEntryForm(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"blockEntryForm\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("code".equals(name)) {
                                if (value instanceof String) {
                                    setCode(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("created".equals(name)) {
                                    if (value instanceof Date) {
                                        setCreated(((Date) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("createdBy".equals(name)) {
                                        if (value instanceof RefUser) {
                                            setCreatedBy(((RefUser) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dataEntryForm".equals(name)) {
                                            if (value instanceof RefDataEntryForm) {
                                                setDataEntryForm(((RefDataEntryForm) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dataEntryForm\" is of type \"org.hisp.dhis.api.model.v40_0.RefDataEntryForm\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("description".equals(name)) {
                                                if (value instanceof String) {
                                                    setDescription(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayDescription".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayDescription(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("displayDueDateLabel".equals(name)) {
                                                        if (value instanceof String) {
                                                            setDisplayDueDateLabel(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"displayDueDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("displayExecutionDateLabel".equals(name)) {
                                                            if (value instanceof String) {
                                                                setDisplayExecutionDateLabel(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"displayExecutionDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("displayFormName".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDisplayFormName(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("displayGenerateEventBox".equals(name)) {
                                                                    if (value instanceof Boolean) {
                                                                        setDisplayGenerateEventBox(((Boolean) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"displayGenerateEventBox\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("displayName".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setDisplayName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("displayShortName".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setDisplayShortName(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("dueDateLabel".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setDueDateLabel(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"dueDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("enableUserAssignment".equals(name)) {
                                                                                    if (value instanceof Boolean) {
                                                                                        setEnableUserAssignment(((Boolean) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"enableUserAssignment\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("executionDateLabel".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setExecutionDateLabel(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"executionDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("externalAccess".equals(name)) {
                                                                                            if (value instanceof Boolean) {
                                                                                                setExternalAccess(((Boolean) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("favorite".equals(name)) {
                                                                                                if (value instanceof Boolean) {
                                                                                                    setFavorite(((Boolean) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("favorites".equals(name)) {
                                                                                                    if (value instanceof List) {
                                                                                                        setFavorites(((List<String> ) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("featureType".equals(name)) {
                                                                                                        if (value instanceof ProgramStage.FeatureType) {
                                                                                                            setFeatureType(((ProgramStage.FeatureType) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStage.FeatureType\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("formName".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setFormName(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("formType".equals(name)) {
                                                                                                                if (value instanceof ProgramStage.FormType) {
                                                                                                                    setFormType(((ProgramStage.FormType) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"formType\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStage.FormType\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("generatedByEnrollmentDate".equals(name)) {
                                                                                                                    if (value instanceof Boolean) {
                                                                                                                        setGeneratedByEnrollmentDate(((Boolean) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"generatedByEnrollmentDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("hideDueDate".equals(name)) {
                                                                                                                        if (value instanceof Boolean) {
                                                                                                                            setHideDueDate(((Boolean) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"hideDueDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("href".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setHref(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("id".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setId(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                                                    if (value instanceof Date) {
                                                                                                                                        setLastUpdated(((Date) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                                                                        if (value instanceof RefUser) {
                                                                                                                                            setLastUpdatedBy(((RefUser) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("minDaysFromStart".equals(name)) {
                                                                                                                                            if (value instanceof Integer) {
                                                                                                                                                setMinDaysFromStart(((Integer) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"minDaysFromStart\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("name".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setName(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("nextScheduleDate".equals(name)) {
                                                                                                                                                    if (value instanceof RefDataElement) {
                                                                                                                                                        setNextScheduleDate(((RefDataElement) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"nextScheduleDate\" is of type \"org.hisp.dhis.api.model.v40_0.RefDataElement\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("notificationTemplates".equals(name)) {
                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                            setNotificationTemplates(((List<RefProgramNotificationTemplate> ) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"notificationTemplates\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefProgramNotificationTemplate>\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("openAfterEnrollment".equals(name)) {
                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                setOpenAfterEnrollment(((Boolean) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"openAfterEnrollment\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("periodType".equals(name)) {
                                                                                                                                                                if (value instanceof ProgramStage.PeriodType) {
                                                                                                                                                                    setPeriodType(((ProgramStage.PeriodType) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"periodType\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStage.PeriodType\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("preGenerateUID".equals(name)) {
                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                        setPreGenerateUID(((Boolean) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"preGenerateUID\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("program".equals(name)) {
                                                                                                                                                                        if (value instanceof RefProgram) {
                                                                                                                                                                            setProgram(((RefProgram) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgram\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("programStageDataElements".equals(name)) {
                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                setProgramStageDataElements(((List<RefProgramStageDataElement> ) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"programStageDataElements\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefProgramStageDataElement>\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("programStageSections".equals(name)) {
                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                    setProgramStageSections(((List<RefProgramStageSection> ) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"programStageSections\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefProgramStageSection>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("publicAccess".equals(name)) {
                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                        setPublicAccess(((String) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("referral".equals(name)) {
                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                            setReferral(((Boolean) value));
                                                                                                                                                                                        } else {
                                                                                                                                                                                            throw new IllegalArgumentException(("property \"referral\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                        }
                                                                                                                                                                                        return true;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("remindCompleted".equals(name)) {
                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                setRemindCompleted(((Boolean) value));
                                                                                                                                                                                            } else {
                                                                                                                                                                                                throw new IllegalArgumentException(("property \"remindCompleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                            }
                                                                                                                                                                                            return true;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("repeatable".equals(name)) {
                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                    setRepeatable(((Boolean) value));
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"repeatable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                }
                                                                                                                                                                                                return true;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("reportDateToUse".equals(name)) {
                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                        setReportDateToUse(((String) value));
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"reportDateToUse\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                    }
                                                                                                                                                                                                    return true;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                                                                                        if (value instanceof Sharing) {
                                                                                                                                                                                                            setSharing(((Sharing) value));
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        return true;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                setShortName(((String) value));
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                            }
                                                                                                                                                                                                            return true;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                if (value instanceof Integer) {
                                                                                                                                                                                                                    setSortOrder(((Integer) value));
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                }
                                                                                                                                                                                                                return true;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("standardInterval".equals(name)) {
                                                                                                                                                                                                                    if (value instanceof Integer) {
                                                                                                                                                                                                                        setStandardInterval(((Integer) value));
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"standardInterval\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("style".equals(name)) {
                                                                                                                                                                                                                        if (value instanceof ObjectStyle) {
                                                                                                                                                                                                                            setStyle(((ObjectStyle) value));
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_0.ObjectStyle\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                setTranslations(((List<Translation> ) value));
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("user".equals(name)) {
                                                                                                                                                                                                                                if (value instanceof RefUser) {
                                                                                                                                                                                                                                    setUser(((RefUser) value));
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                        setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                            setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("validationStrategy".equals(name)) {
                                                                                                                                                                                                                                            if (value instanceof ProgramStage.ValidationStrategy) {
                                                                                                                                                                                                                                                setValidationStrategy(((ProgramStage.ValidationStrategy) value));
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"validationStrategy\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStage.ValidationStrategy\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("allowGenerateNextVisit".equals(name)) {
                return getAllowGenerateNextVisit();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("autoGenerateEvent".equals(name)) {
                        return getAutoGenerateEvent();
                    } else {
                        if ("blockEntryForm".equals(name)) {
                            return getBlockEntryForm();
                        } else {
                            if ("code".equals(name)) {
                                return getCode();
                            } else {
                                if ("created".equals(name)) {
                                    return getCreated();
                                } else {
                                    if ("createdBy".equals(name)) {
                                        return getCreatedBy();
                                    } else {
                                        if ("dataEntryForm".equals(name)) {
                                            return getDataEntryForm();
                                        } else {
                                            if ("description".equals(name)) {
                                                return getDescription();
                                            } else {
                                                if ("displayDescription".equals(name)) {
                                                    return getDisplayDescription();
                                                } else {
                                                    if ("displayDueDateLabel".equals(name)) {
                                                        return getDisplayDueDateLabel();
                                                    } else {
                                                        if ("displayExecutionDateLabel".equals(name)) {
                                                            return getDisplayExecutionDateLabel();
                                                        } else {
                                                            if ("displayFormName".equals(name)) {
                                                                return getDisplayFormName();
                                                            } else {
                                                                if ("displayGenerateEventBox".equals(name)) {
                                                                    return getDisplayGenerateEventBox();
                                                                } else {
                                                                    if ("displayName".equals(name)) {
                                                                        return getDisplayName();
                                                                    } else {
                                                                        if ("displayShortName".equals(name)) {
                                                                            return getDisplayShortName();
                                                                        } else {
                                                                            if ("dueDateLabel".equals(name)) {
                                                                                return getDueDateLabel();
                                                                            } else {
                                                                                if ("enableUserAssignment".equals(name)) {
                                                                                    return getEnableUserAssignment();
                                                                                } else {
                                                                                    if ("executionDateLabel".equals(name)) {
                                                                                        return getExecutionDateLabel();
                                                                                    } else {
                                                                                        if ("externalAccess".equals(name)) {
                                                                                            return getExternalAccess();
                                                                                        } else {
                                                                                            if ("favorite".equals(name)) {
                                                                                                return getFavorite();
                                                                                            } else {
                                                                                                if ("favorites".equals(name)) {
                                                                                                    return getFavorites();
                                                                                                } else {
                                                                                                    if ("featureType".equals(name)) {
                                                                                                        return getFeatureType();
                                                                                                    } else {
                                                                                                        if ("formName".equals(name)) {
                                                                                                            return getFormName();
                                                                                                        } else {
                                                                                                            if ("formType".equals(name)) {
                                                                                                                return getFormType();
                                                                                                            } else {
                                                                                                                if ("generatedByEnrollmentDate".equals(name)) {
                                                                                                                    return getGeneratedByEnrollmentDate();
                                                                                                                } else {
                                                                                                                    if ("hideDueDate".equals(name)) {
                                                                                                                        return getHideDueDate();
                                                                                                                    } else {
                                                                                                                        if ("href".equals(name)) {
                                                                                                                            return getHref();
                                                                                                                        } else {
                                                                                                                            if ("id".equals(name)) {
                                                                                                                                return getId();
                                                                                                                            } else {
                                                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                                                    return getLastUpdated();
                                                                                                                                } else {
                                                                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                                                                        return getLastUpdatedBy();
                                                                                                                                    } else {
                                                                                                                                        if ("minDaysFromStart".equals(name)) {
                                                                                                                                            return getMinDaysFromStart();
                                                                                                                                        } else {
                                                                                                                                            if ("name".equals(name)) {
                                                                                                                                                return getName();
                                                                                                                                            } else {
                                                                                                                                                if ("nextScheduleDate".equals(name)) {
                                                                                                                                                    return getNextScheduleDate();
                                                                                                                                                } else {
                                                                                                                                                    if ("notificationTemplates".equals(name)) {
                                                                                                                                                        return getNotificationTemplates();
                                                                                                                                                    } else {
                                                                                                                                                        if ("openAfterEnrollment".equals(name)) {
                                                                                                                                                            return getOpenAfterEnrollment();
                                                                                                                                                        } else {
                                                                                                                                                            if ("periodType".equals(name)) {
                                                                                                                                                                return getPeriodType();
                                                                                                                                                            } else {
                                                                                                                                                                if ("preGenerateUID".equals(name)) {
                                                                                                                                                                    return getPreGenerateUID();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("program".equals(name)) {
                                                                                                                                                                        return getProgram();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("programStageDataElements".equals(name)) {
                                                                                                                                                                            return getProgramStageDataElements();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("programStageSections".equals(name)) {
                                                                                                                                                                                return getProgramStageSections();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("publicAccess".equals(name)) {
                                                                                                                                                                                    return getPublicAccess();
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("referral".equals(name)) {
                                                                                                                                                                                        return getReferral();
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("remindCompleted".equals(name)) {
                                                                                                                                                                                            return getRemindCompleted();
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("repeatable".equals(name)) {
                                                                                                                                                                                                return getRepeatable();
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("reportDateToUse".equals(name)) {
                                                                                                                                                                                                    return getReportDateToUse();
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                                                                                        return getSharing();
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                                                                                            return getShortName();
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                return getSortOrder();
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("standardInterval".equals(name)) {
                                                                                                                                                                                                                    return getStandardInterval();
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("style".equals(name)) {
                                                                                                                                                                                                                        return getStyle();
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                                                                                            return getTranslations();
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("user".equals(name)) {
                                                                                                                                                                                                                                return getUser();
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                    return getUserAccesses();
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                        return getUserGroupAccesses();
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("validationStrategy".equals(name)) {
                                                                                                                                                                                                                                            return getValidationStrategy();
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            return notFoundValue;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramStage.NOT_FOUND_VALUE);
        if (ProgramStage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramStage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramStage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("allowGenerateNextVisit");
        sb.append('=');
        sb.append(((this.allowGenerateNextVisit == null)?"<null>":this.allowGenerateNextVisit));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("autoGenerateEvent");
        sb.append('=');
        sb.append(((this.autoGenerateEvent == null)?"<null>":this.autoGenerateEvent));
        sb.append(',');
        sb.append("blockEntryForm");
        sb.append('=');
        sb.append(((this.blockEntryForm == null)?"<null>":this.blockEntryForm));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataEntryForm");
        sb.append('=');
        sb.append(((this.dataEntryForm == null)?"<null>":this.dataEntryForm));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayDueDateLabel");
        sb.append('=');
        sb.append(((this.displayDueDateLabel == null)?"<null>":this.displayDueDateLabel));
        sb.append(',');
        sb.append("displayExecutionDateLabel");
        sb.append('=');
        sb.append(((this.displayExecutionDateLabel == null)?"<null>":this.displayExecutionDateLabel));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayGenerateEventBox");
        sb.append('=');
        sb.append(((this.displayGenerateEventBox == null)?"<null>":this.displayGenerateEventBox));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("dueDateLabel");
        sb.append('=');
        sb.append(((this.dueDateLabel == null)?"<null>":this.dueDateLabel));
        sb.append(',');
        sb.append("enableUserAssignment");
        sb.append('=');
        sb.append(((this.enableUserAssignment == null)?"<null>":this.enableUserAssignment));
        sb.append(',');
        sb.append("executionDateLabel");
        sb.append('=');
        sb.append(((this.executionDateLabel == null)?"<null>":this.executionDateLabel));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("formType");
        sb.append('=');
        sb.append(((this.formType == null)?"<null>":this.formType));
        sb.append(',');
        sb.append("generatedByEnrollmentDate");
        sb.append('=');
        sb.append(((this.generatedByEnrollmentDate == null)?"<null>":this.generatedByEnrollmentDate));
        sb.append(',');
        sb.append("hideDueDate");
        sb.append('=');
        sb.append(((this.hideDueDate == null)?"<null>":this.hideDueDate));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("minDaysFromStart");
        sb.append('=');
        sb.append(((this.minDaysFromStart == null)?"<null>":this.minDaysFromStart));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nextScheduleDate");
        sb.append('=');
        sb.append(((this.nextScheduleDate == null)?"<null>":this.nextScheduleDate));
        sb.append(',');
        sb.append("notificationTemplates");
        sb.append('=');
        sb.append(((this.notificationTemplates == null)?"<null>":this.notificationTemplates));
        sb.append(',');
        sb.append("openAfterEnrollment");
        sb.append('=');
        sb.append(((this.openAfterEnrollment == null)?"<null>":this.openAfterEnrollment));
        sb.append(',');
        sb.append("periodType");
        sb.append('=');
        sb.append(((this.periodType == null)?"<null>":this.periodType));
        sb.append(',');
        sb.append("preGenerateUID");
        sb.append('=');
        sb.append(((this.preGenerateUID == null)?"<null>":this.preGenerateUID));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStageDataElements");
        sb.append('=');
        sb.append(((this.programStageDataElements == null)?"<null>":this.programStageDataElements));
        sb.append(',');
        sb.append("programStageSections");
        sb.append('=');
        sb.append(((this.programStageSections == null)?"<null>":this.programStageSections));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("referral");
        sb.append('=');
        sb.append(((this.referral == null)?"<null>":this.referral));
        sb.append(',');
        sb.append("remindCompleted");
        sb.append('=');
        sb.append(((this.remindCompleted == null)?"<null>":this.remindCompleted));
        sb.append(',');
        sb.append("repeatable");
        sb.append('=');
        sb.append(((this.repeatable == null)?"<null>":this.repeatable));
        sb.append(',');
        sb.append("reportDateToUse");
        sb.append('=');
        sb.append(((this.reportDateToUse == null)?"<null>":this.reportDateToUse));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("standardInterval");
        sb.append('=');
        sb.append(((this.standardInterval == null)?"<null>":this.standardInterval));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("validationStrategy");
        sb.append('=');
        sb.append(((this.validationStrategy == null)?"<null>":this.validationStrategy));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.allowGenerateNextVisit == null)? 0 :this.allowGenerateNextVisit.hashCode()));
        result = ((result* 31)+((this.dataEntryForm == null)? 0 :this.dataEntryForm.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.reportDateToUse == null)? 0 :this.reportDateToUse.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.programStageDataElements == null)? 0 :this.programStageDataElements.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.formType == null)? 0 :this.formType.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.generatedByEnrollmentDate == null)? 0 :this.generatedByEnrollmentDate.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.hideDueDate == null)? 0 :this.hideDueDate.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.enableUserAssignment == null)? 0 :this.enableUserAssignment.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.minDaysFromStart == null)? 0 :this.minDaysFromStart.hashCode()));
        result = ((result* 31)+((this.standardInterval == null)? 0 :this.standardInterval.hashCode()));
        result = ((result* 31)+((this.dueDateLabel == null)? 0 :this.dueDateLabel.hashCode()));
        result = ((result* 31)+((this.executionDateLabel == null)? 0 :this.executionDateLabel.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.preGenerateUID == null)? 0 :this.preGenerateUID.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.displayExecutionDateLabel == null)? 0 :this.displayExecutionDateLabel.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.notificationTemplates == null)? 0 :this.notificationTemplates.hashCode()));
        result = ((result* 31)+((this.openAfterEnrollment == null)? 0 :this.openAfterEnrollment.hashCode()));
        result = ((result* 31)+((this.repeatable == null)? 0 :this.repeatable.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.remindCompleted == null)? 0 :this.remindCompleted.hashCode()));
        result = ((result* 31)+((this.displayGenerateEventBox == null)? 0 :this.displayGenerateEventBox.hashCode()));
        result = ((result* 31)+((this.nextScheduleDate == null)? 0 :this.nextScheduleDate.hashCode()));
        result = ((result* 31)+((this.validationStrategy == null)? 0 :this.validationStrategy.hashCode()));
        result = ((result* 31)+((this.autoGenerateEvent == null)? 0 :this.autoGenerateEvent.hashCode()));
        result = ((result* 31)+((this.periodType == null)? 0 :this.periodType.hashCode()));
        result = ((result* 31)+((this.referral == null)? 0 :this.referral.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.displayDueDateLabel == null)? 0 :this.displayDueDateLabel.hashCode()));
        result = ((result* 31)+((this.blockEntryForm == null)? 0 :this.blockEntryForm.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.programStageSections == null)? 0 :this.programStageSections.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramStage) == false) {
            return false;
        }
        ProgramStage rhs = ((ProgramStage) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.allowGenerateNextVisit == rhs.allowGenerateNextVisit)||((this.allowGenerateNextVisit!= null)&&this.allowGenerateNextVisit.equals(rhs.allowGenerateNextVisit)))&&((this.dataEntryForm == rhs.dataEntryForm)||((this.dataEntryForm!= null)&&this.dataEntryForm.equals(rhs.dataEntryForm))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.reportDateToUse == rhs.reportDateToUse)||((this.reportDateToUse!= null)&&this.reportDateToUse.equals(rhs.reportDateToUse))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.programStageDataElements == rhs.programStageDataElements)||((this.programStageDataElements!= null)&&this.programStageDataElements.equals(rhs.programStageDataElements))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.formType == rhs.formType)||((this.formType!= null)&&this.formType.equals(rhs.formType))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.generatedByEnrollmentDate == rhs.generatedByEnrollmentDate)||((this.generatedByEnrollmentDate!= null)&&this.generatedByEnrollmentDate.equals(rhs.generatedByEnrollmentDate))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.hideDueDate == rhs.hideDueDate)||((this.hideDueDate!= null)&&this.hideDueDate.equals(rhs.hideDueDate))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.enableUserAssignment == rhs.enableUserAssignment)||((this.enableUserAssignment!= null)&&this.enableUserAssignment.equals(rhs.enableUserAssignment))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.minDaysFromStart == rhs.minDaysFromStart)||((this.minDaysFromStart!= null)&&this.minDaysFromStart.equals(rhs.minDaysFromStart))))&&((this.standardInterval == rhs.standardInterval)||((this.standardInterval!= null)&&this.standardInterval.equals(rhs.standardInterval))))&&((this.dueDateLabel == rhs.dueDateLabel)||((this.dueDateLabel!= null)&&this.dueDateLabel.equals(rhs.dueDateLabel))))&&((this.executionDateLabel == rhs.executionDateLabel)||((this.executionDateLabel!= null)&&this.executionDateLabel.equals(rhs.executionDateLabel))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.preGenerateUID == rhs.preGenerateUID)||((this.preGenerateUID!= null)&&this.preGenerateUID.equals(rhs.preGenerateUID))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.displayExecutionDateLabel == rhs.displayExecutionDateLabel)||((this.displayExecutionDateLabel!= null)&&this.displayExecutionDateLabel.equals(rhs.displayExecutionDateLabel))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.notificationTemplates == rhs.notificationTemplates)||((this.notificationTemplates!= null)&&this.notificationTemplates.equals(rhs.notificationTemplates))))&&((this.openAfterEnrollment == rhs.openAfterEnrollment)||((this.openAfterEnrollment!= null)&&this.openAfterEnrollment.equals(rhs.openAfterEnrollment))))&&((this.repeatable == rhs.repeatable)||((this.repeatable!= null)&&this.repeatable.equals(rhs.repeatable))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.remindCompleted == rhs.remindCompleted)||((this.remindCompleted!= null)&&this.remindCompleted.equals(rhs.remindCompleted))))&&((this.displayGenerateEventBox == rhs.displayGenerateEventBox)||((this.displayGenerateEventBox!= null)&&this.displayGenerateEventBox.equals(rhs.displayGenerateEventBox))))&&((this.nextScheduleDate == rhs.nextScheduleDate)||((this.nextScheduleDate!= null)&&this.nextScheduleDate.equals(rhs.nextScheduleDate))))&&((this.validationStrategy == rhs.validationStrategy)||((this.validationStrategy!= null)&&this.validationStrategy.equals(rhs.validationStrategy))))&&((this.autoGenerateEvent == rhs.autoGenerateEvent)||((this.autoGenerateEvent!= null)&&this.autoGenerateEvent.equals(rhs.autoGenerateEvent))))&&((this.periodType == rhs.periodType)||((this.periodType!= null)&&this.periodType.equals(rhs.periodType))))&&((this.referral == rhs.referral)||((this.referral!= null)&&this.referral.equals(rhs.referral))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.displayDueDateLabel == rhs.displayDueDateLabel)||((this.displayDueDateLabel!= null)&&this.displayDueDateLabel.equals(rhs.displayDueDateLabel))))&&((this.blockEntryForm == rhs.blockEntryForm)||((this.blockEntryForm!= null)&&this.blockEntryForm.equals(rhs.blockEntryForm))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.programStageSections == rhs.programStageSections)||((this.programStageSections!= null)&&this.programStageSections.equals(rhs.programStageSections))));
    }

    @Generated("jsonschema2pojo")
    public enum FeatureType {

        NONE("NONE"),
        MULTI_POLYGON("MULTI_POLYGON"),
        POLYGON("POLYGON"),
        POINT("POINT"),
        SYMBOL("SYMBOL");
        private final String value;
        private final static Map<String, ProgramStage.FeatureType> CONSTANTS = new HashMap<String, ProgramStage.FeatureType>();

        static {
            for (ProgramStage.FeatureType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FeatureType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.FeatureType fromValue(String value) {
            ProgramStage.FeatureType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum FormType {

        DEFAULT("DEFAULT"),
        CUSTOM("CUSTOM"),
        SECTION("SECTION"),
        SECTION_MULTIORG("SECTION_MULTIORG");
        private final String value;
        private final static Map<String, ProgramStage.FormType> CONSTANTS = new HashMap<String, ProgramStage.FormType>();

        static {
            for (ProgramStage.FormType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FormType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.FormType fromValue(String value) {
            ProgramStage.FormType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PeriodType {

        BI_MONTHLY("BiMonthly"),
        BI_WEEKLY("BiWeekly"),
        DAILY("Daily"),
        FINANCIAL_APRIL("FinancialApril"),
        FINANCIAL_JULY("FinancialJuly"),
        FINANCIAL_NOV("FinancialNov"),
        FINANCIAL_OCT("FinancialOct"),
        MONTHLY("Monthly"),
        QUARTERLY("Quarterly"),
        SIX_MONTHLY_APRIL("SixMonthlyApril"),
        SIX_MONTHLY_NOV("SixMonthlyNov"),
        SIX_MONTHLY("SixMonthly"),
        TWO_YEARLY("TwoYearly"),
        WEEKLY("Weekly"),
        WEEKLY_SATURDAY("WeeklySaturday"),
        WEEKLY_SUNDAY("WeeklySunday"),
        WEEKLY_THURSDAY("WeeklyThursday"),
        WEEKLY_WEDNESDAY("WeeklyWednesday"),
        YEARLY("Yearly");
        private final String value;
        private final static Map<String, ProgramStage.PeriodType> CONSTANTS = new HashMap<String, ProgramStage.PeriodType>();

        static {
            for (ProgramStage.PeriodType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PeriodType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.PeriodType fromValue(String value) {
            ProgramStage.PeriodType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValidationStrategy {

        ON_COMPLETE("ON_COMPLETE"),
        ON_UPDATE_AND_INSERT("ON_UPDATE_AND_INSERT");
        private final String value;
        private final static Map<String, ProgramStage.ValidationStrategy> CONSTANTS = new HashMap<String, ProgramStage.ValidationStrategy>();

        static {
            for (ProgramStage.ValidationStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValidationStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.ValidationStrategy fromValue(String value) {
            ProgramStage.ValidationStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
