
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUserMode",
    "assignedUsers",
    "attributeValueFilters",
    "dataFilters",
    "displayColumnOrder",
    "enrolledAt",
    "enrollmentOccurredAt",
    "enrollmentStatus",
    "eventCreatedAt",
    "eventOccurredAt",
    "eventScheduledAt",
    "eventStatus",
    "order",
    "orgUnit",
    "ouMode"
})
@Generated("jsonschema2pojo")
public class ProgramStageQueryCriteria implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("assignedUserMode")
    private ProgramStageQueryCriteria.AssignedUserMode assignedUserMode;
    @JsonProperty("assignedUsers")
    private List<String> assignedUsers;
    @JsonProperty("attributeValueFilters")
    private List<AttributeValueFilter> attributeValueFilters;
    @JsonProperty("dataFilters")
    private List<EventDataFilter> dataFilters;
    @JsonProperty("displayColumnOrder")
    private List<String> displayColumnOrder;
    @JsonProperty("enrolledAt")
    private DateFilterPeriod enrolledAt;
    @JsonProperty("enrollmentOccurredAt")
    private DateFilterPeriod enrollmentOccurredAt;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    private ProgramStageQueryCriteria.EnrollmentStatus enrollmentStatus;
    @JsonProperty("eventCreatedAt")
    private DateFilterPeriod eventCreatedAt;
    @JsonProperty("eventOccurredAt")
    private DateFilterPeriod eventOccurredAt;
    @JsonProperty("eventScheduledAt")
    private DateFilterPeriod eventScheduledAt;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventStatus")
    private ProgramStageQueryCriteria.EventStatus eventStatus;
    @JsonProperty("order")
    private String order;
    @JsonProperty("orgUnit")
    private String orgUnit;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ouMode")
    private ProgramStageQueryCriteria.OuMode ouMode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2080410537366590017L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramStageQueryCriteria() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramStageQueryCriteria(ProgramStageQueryCriteria source) {
        super();
        this.assignedUserMode = source.assignedUserMode;
        this.assignedUsers = source.assignedUsers;
        this.attributeValueFilters = source.attributeValueFilters;
        this.dataFilters = source.dataFilters;
        this.displayColumnOrder = source.displayColumnOrder;
        this.enrolledAt = source.enrolledAt;
        this.enrollmentOccurredAt = source.enrollmentOccurredAt;
        this.enrollmentStatus = source.enrollmentStatus;
        this.eventCreatedAt = source.eventCreatedAt;
        this.eventOccurredAt = source.eventOccurredAt;
        this.eventScheduledAt = source.eventScheduledAt;
        this.eventStatus = source.eventStatus;
        this.order = source.order;
        this.orgUnit = source.orgUnit;
        this.ouMode = source.ouMode;
    }

    public ProgramStageQueryCriteria(ProgramStageQueryCriteria.AssignedUserMode assignedUserMode, List<String> assignedUsers, List<AttributeValueFilter> attributeValueFilters, List<EventDataFilter> dataFilters, List<String> displayColumnOrder, DateFilterPeriod enrolledAt, DateFilterPeriod enrollmentOccurredAt, ProgramStageQueryCriteria.EnrollmentStatus enrollmentStatus, DateFilterPeriod eventCreatedAt, DateFilterPeriod eventOccurredAt, DateFilterPeriod eventScheduledAt, ProgramStageQueryCriteria.EventStatus eventStatus, String order, String orgUnit, ProgramStageQueryCriteria.OuMode ouMode) {
        super();
        this.assignedUserMode = assignedUserMode;
        this.assignedUsers = assignedUsers;
        this.attributeValueFilters = attributeValueFilters;
        this.dataFilters = dataFilters;
        this.displayColumnOrder = displayColumnOrder;
        this.enrolledAt = enrolledAt;
        this.enrollmentOccurredAt = enrollmentOccurredAt;
        this.enrollmentStatus = enrollmentStatus;
        this.eventCreatedAt = eventCreatedAt;
        this.eventOccurredAt = eventOccurredAt;
        this.eventScheduledAt = eventScheduledAt;
        this.eventStatus = eventStatus;
        this.order = order;
        this.orgUnit = orgUnit;
        this.ouMode = ouMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("assignedUserMode")
    public ProgramStageQueryCriteria.AssignedUserMode getAssignedUserMode() {
        return assignedUserMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("assignedUserMode")
    public void setAssignedUserMode(ProgramStageQueryCriteria.AssignedUserMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
    }

    public ProgramStageQueryCriteria withAssignedUserMode(ProgramStageQueryCriteria.AssignedUserMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
        return this;
    }

    @JsonProperty("assignedUsers")
    public Optional<List<String>> getAssignedUsers() {
        return Optional.ofNullable(assignedUsers);
    }

    @JsonProperty("assignedUsers")
    public void setAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
    }

    public ProgramStageQueryCriteria withAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
        return this;
    }

    @JsonProperty("attributeValueFilters")
    public Optional<List<AttributeValueFilter>> getAttributeValueFilters() {
        return Optional.ofNullable(attributeValueFilters);
    }

    @JsonProperty("attributeValueFilters")
    public void setAttributeValueFilters(List<AttributeValueFilter> attributeValueFilters) {
        this.attributeValueFilters = attributeValueFilters;
    }

    public ProgramStageQueryCriteria withAttributeValueFilters(List<AttributeValueFilter> attributeValueFilters) {
        this.attributeValueFilters = attributeValueFilters;
        return this;
    }

    @JsonProperty("dataFilters")
    public Optional<List<EventDataFilter>> getDataFilters() {
        return Optional.ofNullable(dataFilters);
    }

    @JsonProperty("dataFilters")
    public void setDataFilters(List<EventDataFilter> dataFilters) {
        this.dataFilters = dataFilters;
    }

    public ProgramStageQueryCriteria withDataFilters(List<EventDataFilter> dataFilters) {
        this.dataFilters = dataFilters;
        return this;
    }

    @JsonProperty("displayColumnOrder")
    public Optional<List<String>> getDisplayColumnOrder() {
        return Optional.ofNullable(displayColumnOrder);
    }

    @JsonProperty("displayColumnOrder")
    public void setDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
    }

    public ProgramStageQueryCriteria withDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
        return this;
    }

    @JsonProperty("enrolledAt")
    public Optional<DateFilterPeriod> getEnrolledAt() {
        return Optional.ofNullable(enrolledAt);
    }

    @JsonProperty("enrolledAt")
    public void setEnrolledAt(DateFilterPeriod enrolledAt) {
        this.enrolledAt = enrolledAt;
    }

    public ProgramStageQueryCriteria withEnrolledAt(DateFilterPeriod enrolledAt) {
        this.enrolledAt = enrolledAt;
        return this;
    }

    @JsonProperty("enrollmentOccurredAt")
    public Optional<DateFilterPeriod> getEnrollmentOccurredAt() {
        return Optional.ofNullable(enrollmentOccurredAt);
    }

    @JsonProperty("enrollmentOccurredAt")
    public void setEnrollmentOccurredAt(DateFilterPeriod enrollmentOccurredAt) {
        this.enrollmentOccurredAt = enrollmentOccurredAt;
    }

    public ProgramStageQueryCriteria withEnrollmentOccurredAt(DateFilterPeriod enrollmentOccurredAt) {
        this.enrollmentOccurredAt = enrollmentOccurredAt;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    public ProgramStageQueryCriteria.EnrollmentStatus getEnrollmentStatus() {
        return enrollmentStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    public void setEnrollmentStatus(ProgramStageQueryCriteria.EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public ProgramStageQueryCriteria withEnrollmentStatus(ProgramStageQueryCriteria.EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
        return this;
    }

    @JsonProperty("eventCreatedAt")
    public Optional<DateFilterPeriod> getEventCreatedAt() {
        return Optional.ofNullable(eventCreatedAt);
    }

    @JsonProperty("eventCreatedAt")
    public void setEventCreatedAt(DateFilterPeriod eventCreatedAt) {
        this.eventCreatedAt = eventCreatedAt;
    }

    public ProgramStageQueryCriteria withEventCreatedAt(DateFilterPeriod eventCreatedAt) {
        this.eventCreatedAt = eventCreatedAt;
        return this;
    }

    @JsonProperty("eventOccurredAt")
    public Optional<DateFilterPeriod> getEventOccurredAt() {
        return Optional.ofNullable(eventOccurredAt);
    }

    @JsonProperty("eventOccurredAt")
    public void setEventOccurredAt(DateFilterPeriod eventOccurredAt) {
        this.eventOccurredAt = eventOccurredAt;
    }

    public ProgramStageQueryCriteria withEventOccurredAt(DateFilterPeriod eventOccurredAt) {
        this.eventOccurredAt = eventOccurredAt;
        return this;
    }

    @JsonProperty("eventScheduledAt")
    public Optional<DateFilterPeriod> getEventScheduledAt() {
        return Optional.ofNullable(eventScheduledAt);
    }

    @JsonProperty("eventScheduledAt")
    public void setEventScheduledAt(DateFilterPeriod eventScheduledAt) {
        this.eventScheduledAt = eventScheduledAt;
    }

    public ProgramStageQueryCriteria withEventScheduledAt(DateFilterPeriod eventScheduledAt) {
        this.eventScheduledAt = eventScheduledAt;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventStatus")
    public ProgramStageQueryCriteria.EventStatus getEventStatus() {
        return eventStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventStatus")
    public void setEventStatus(ProgramStageQueryCriteria.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    public ProgramStageQueryCriteria withEventStatus(ProgramStageQueryCriteria.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
        return this;
    }

    @JsonProperty("order")
    public Optional<String> getOrder() {
        return Optional.ofNullable(order);
    }

    @JsonProperty("order")
    public void setOrder(String order) {
        this.order = order;
    }

    public ProgramStageQueryCriteria withOrder(String order) {
        this.order = order;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public ProgramStageQueryCriteria withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ouMode")
    public ProgramStageQueryCriteria.OuMode getOuMode() {
        return ouMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ouMode")
    public void setOuMode(ProgramStageQueryCriteria.OuMode ouMode) {
        this.ouMode = ouMode;
    }

    public ProgramStageQueryCriteria withOuMode(ProgramStageQueryCriteria.OuMode ouMode) {
        this.ouMode = ouMode;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramStageQueryCriteria withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assignedUserMode".equals(name)) {
            if (value instanceof ProgramStageQueryCriteria.AssignedUserMode) {
                setAssignedUserMode(((ProgramStageQueryCriteria.AssignedUserMode) value));
            } else {
                throw new IllegalArgumentException(("property \"assignedUserMode\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStageQueryCriteria.AssignedUserMode\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("assignedUsers".equals(name)) {
                if (value instanceof List) {
                    setAssignedUsers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUsers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValueFilters".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValueFilters(((List<AttributeValueFilter> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValueFilters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValueFilter>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dataFilters".equals(name)) {
                        if (value instanceof List) {
                            setDataFilters(((List<EventDataFilter> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dataFilters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.EventDataFilter>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("displayColumnOrder".equals(name)) {
                            if (value instanceof List) {
                                setDisplayColumnOrder(((List<String> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"displayColumnOrder\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("enrolledAt".equals(name)) {
                                if (value instanceof DateFilterPeriod) {
                                    setEnrolledAt(((DateFilterPeriod) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"enrolledAt\" is of type \"org.hisp.dhis.api.model.v40_0.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("enrollmentOccurredAt".equals(name)) {
                                    if (value instanceof DateFilterPeriod) {
                                        setEnrollmentOccurredAt(((DateFilterPeriod) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"enrollmentOccurredAt\" is of type \"org.hisp.dhis.api.model.v40_0.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("enrollmentStatus".equals(name)) {
                                        if (value instanceof ProgramStageQueryCriteria.EnrollmentStatus) {
                                            setEnrollmentStatus(((ProgramStageQueryCriteria.EnrollmentStatus) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"enrollmentStatus\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStageQueryCriteria.EnrollmentStatus\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("eventCreatedAt".equals(name)) {
                                            if (value instanceof DateFilterPeriod) {
                                                setEventCreatedAt(((DateFilterPeriod) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"eventCreatedAt\" is of type \"org.hisp.dhis.api.model.v40_0.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("eventOccurredAt".equals(name)) {
                                                if (value instanceof DateFilterPeriod) {
                                                    setEventOccurredAt(((DateFilterPeriod) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"eventOccurredAt\" is of type \"org.hisp.dhis.api.model.v40_0.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("eventScheduledAt".equals(name)) {
                                                    if (value instanceof DateFilterPeriod) {
                                                        setEventScheduledAt(((DateFilterPeriod) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"eventScheduledAt\" is of type \"org.hisp.dhis.api.model.v40_0.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("eventStatus".equals(name)) {
                                                        if (value instanceof ProgramStageQueryCriteria.EventStatus) {
                                                            setEventStatus(((ProgramStageQueryCriteria.EventStatus) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"eventStatus\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStageQueryCriteria.EventStatus\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("order".equals(name)) {
                                                            if (value instanceof String) {
                                                                setOrder(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"order\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("orgUnit".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setOrgUnit(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("ouMode".equals(name)) {
                                                                    if (value instanceof ProgramStageQueryCriteria.OuMode) {
                                                                        setOuMode(((ProgramStageQueryCriteria.OuMode) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"ouMode\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramStageQueryCriteria.OuMode\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    return false;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assignedUserMode".equals(name)) {
            return getAssignedUserMode();
        } else {
            if ("assignedUsers".equals(name)) {
                return getAssignedUsers();
            } else {
                if ("attributeValueFilters".equals(name)) {
                    return getAttributeValueFilters();
                } else {
                    if ("dataFilters".equals(name)) {
                        return getDataFilters();
                    } else {
                        if ("displayColumnOrder".equals(name)) {
                            return getDisplayColumnOrder();
                        } else {
                            if ("enrolledAt".equals(name)) {
                                return getEnrolledAt();
                            } else {
                                if ("enrollmentOccurredAt".equals(name)) {
                                    return getEnrollmentOccurredAt();
                                } else {
                                    if ("enrollmentStatus".equals(name)) {
                                        return getEnrollmentStatus();
                                    } else {
                                        if ("eventCreatedAt".equals(name)) {
                                            return getEventCreatedAt();
                                        } else {
                                            if ("eventOccurredAt".equals(name)) {
                                                return getEventOccurredAt();
                                            } else {
                                                if ("eventScheduledAt".equals(name)) {
                                                    return getEventScheduledAt();
                                                } else {
                                                    if ("eventStatus".equals(name)) {
                                                        return getEventStatus();
                                                    } else {
                                                        if ("order".equals(name)) {
                                                            return getOrder();
                                                        } else {
                                                            if ("orgUnit".equals(name)) {
                                                                return getOrgUnit();
                                                            } else {
                                                                if ("ouMode".equals(name)) {
                                                                    return getOuMode();
                                                                } else {
                                                                    return notFoundValue;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramStageQueryCriteria.NOT_FOUND_VALUE);
        if (ProgramStageQueryCriteria.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramStageQueryCriteria with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramStageQueryCriteria.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUserMode");
        sb.append('=');
        sb.append(((this.assignedUserMode == null)?"<null>":this.assignedUserMode));
        sb.append(',');
        sb.append("assignedUsers");
        sb.append('=');
        sb.append(((this.assignedUsers == null)?"<null>":this.assignedUsers));
        sb.append(',');
        sb.append("attributeValueFilters");
        sb.append('=');
        sb.append(((this.attributeValueFilters == null)?"<null>":this.attributeValueFilters));
        sb.append(',');
        sb.append("dataFilters");
        sb.append('=');
        sb.append(((this.dataFilters == null)?"<null>":this.dataFilters));
        sb.append(',');
        sb.append("displayColumnOrder");
        sb.append('=');
        sb.append(((this.displayColumnOrder == null)?"<null>":this.displayColumnOrder));
        sb.append(',');
        sb.append("enrolledAt");
        sb.append('=');
        sb.append(((this.enrolledAt == null)?"<null>":this.enrolledAt));
        sb.append(',');
        sb.append("enrollmentOccurredAt");
        sb.append('=');
        sb.append(((this.enrollmentOccurredAt == null)?"<null>":this.enrollmentOccurredAt));
        sb.append(',');
        sb.append("enrollmentStatus");
        sb.append('=');
        sb.append(((this.enrollmentStatus == null)?"<null>":this.enrollmentStatus));
        sb.append(',');
        sb.append("eventCreatedAt");
        sb.append('=');
        sb.append(((this.eventCreatedAt == null)?"<null>":this.eventCreatedAt));
        sb.append(',');
        sb.append("eventOccurredAt");
        sb.append('=');
        sb.append(((this.eventOccurredAt == null)?"<null>":this.eventOccurredAt));
        sb.append(',');
        sb.append("eventScheduledAt");
        sb.append('=');
        sb.append(((this.eventScheduledAt == null)?"<null>":this.eventScheduledAt));
        sb.append(',');
        sb.append("eventStatus");
        sb.append('=');
        sb.append(((this.eventStatus == null)?"<null>":this.eventStatus));
        sb.append(',');
        sb.append("order");
        sb.append('=');
        sb.append(((this.order == null)?"<null>":this.order));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("ouMode");
        sb.append('=');
        sb.append(((this.ouMode == null)?"<null>":this.ouMode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.assignedUserMode == null)? 0 :this.assignedUserMode.hashCode()));
        result = ((result* 31)+((this.eventCreatedAt == null)? 0 :this.eventCreatedAt.hashCode()));
        result = ((result* 31)+((this.eventScheduledAt == null)? 0 :this.eventScheduledAt.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.assignedUsers == null)? 0 :this.assignedUsers.hashCode()));
        result = ((result* 31)+((this.attributeValueFilters == null)? 0 :this.attributeValueFilters.hashCode()));
        result = ((result* 31)+((this.eventOccurredAt == null)? 0 :this.eventOccurredAt.hashCode()));
        result = ((result* 31)+((this.dataFilters == null)? 0 :this.dataFilters.hashCode()));
        result = ((result* 31)+((this.enrollmentStatus == null)? 0 :this.enrollmentStatus.hashCode()));
        result = ((result* 31)+((this.ouMode == null)? 0 :this.ouMode.hashCode()));
        result = ((result* 31)+((this.displayColumnOrder == null)? 0 :this.displayColumnOrder.hashCode()));
        result = ((result* 31)+((this.enrollmentOccurredAt == null)? 0 :this.enrollmentOccurredAt.hashCode()));
        result = ((result* 31)+((this.eventStatus == null)? 0 :this.eventStatus.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.enrolledAt == null)? 0 :this.enrolledAt.hashCode()));
        result = ((result* 31)+((this.order == null)? 0 :this.order.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramStageQueryCriteria) == false) {
            return false;
        }
        ProgramStageQueryCriteria rhs = ((ProgramStageQueryCriteria) other);
        return (((((((((((((((((this.assignedUserMode == rhs.assignedUserMode)||((this.assignedUserMode!= null)&&this.assignedUserMode.equals(rhs.assignedUserMode)))&&((this.eventCreatedAt == rhs.eventCreatedAt)||((this.eventCreatedAt!= null)&&this.eventCreatedAt.equals(rhs.eventCreatedAt))))&&((this.eventScheduledAt == rhs.eventScheduledAt)||((this.eventScheduledAt!= null)&&this.eventScheduledAt.equals(rhs.eventScheduledAt))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.assignedUsers == rhs.assignedUsers)||((this.assignedUsers!= null)&&this.assignedUsers.equals(rhs.assignedUsers))))&&((this.attributeValueFilters == rhs.attributeValueFilters)||((this.attributeValueFilters!= null)&&this.attributeValueFilters.equals(rhs.attributeValueFilters))))&&((this.eventOccurredAt == rhs.eventOccurredAt)||((this.eventOccurredAt!= null)&&this.eventOccurredAt.equals(rhs.eventOccurredAt))))&&((this.dataFilters == rhs.dataFilters)||((this.dataFilters!= null)&&this.dataFilters.equals(rhs.dataFilters))))&&((this.enrollmentStatus == rhs.enrollmentStatus)||((this.enrollmentStatus!= null)&&this.enrollmentStatus.equals(rhs.enrollmentStatus))))&&((this.ouMode == rhs.ouMode)||((this.ouMode!= null)&&this.ouMode.equals(rhs.ouMode))))&&((this.displayColumnOrder == rhs.displayColumnOrder)||((this.displayColumnOrder!= null)&&this.displayColumnOrder.equals(rhs.displayColumnOrder))))&&((this.enrollmentOccurredAt == rhs.enrollmentOccurredAt)||((this.enrollmentOccurredAt!= null)&&this.enrollmentOccurredAt.equals(rhs.enrollmentOccurredAt))))&&((this.eventStatus == rhs.eventStatus)||((this.eventStatus!= null)&&this.eventStatus.equals(rhs.eventStatus))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.enrolledAt == rhs.enrolledAt)||((this.enrolledAt!= null)&&this.enrolledAt.equals(rhs.enrolledAt))))&&((this.order == rhs.order)||((this.order!= null)&&this.order.equals(rhs.order))));
    }

    @Generated("jsonschema2pojo")
    public enum AssignedUserMode {

        CURRENT("CURRENT"),
        PROVIDED("PROVIDED"),
        NONE("NONE"),
        ANY("ANY"),
        ALL("ALL");
        private final String value;
        private final static Map<String, ProgramStageQueryCriteria.AssignedUserMode> CONSTANTS = new HashMap<String, ProgramStageQueryCriteria.AssignedUserMode>();

        static {
            for (ProgramStageQueryCriteria.AssignedUserMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AssignedUserMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStageQueryCriteria.AssignedUserMode fromValue(String value) {
            ProgramStageQueryCriteria.AssignedUserMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum EnrollmentStatus {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, ProgramStageQueryCriteria.EnrollmentStatus> CONSTANTS = new HashMap<String, ProgramStageQueryCriteria.EnrollmentStatus>();

        static {
            for (ProgramStageQueryCriteria.EnrollmentStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        EnrollmentStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStageQueryCriteria.EnrollmentStatus fromValue(String value) {
            ProgramStageQueryCriteria.EnrollmentStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum EventStatus {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        VISITED("VISITED"),
        SCHEDULE("SCHEDULE"),
        OVERDUE("OVERDUE"),
        SKIPPED("SKIPPED");
        private final String value;
        private final static Map<String, ProgramStageQueryCriteria.EventStatus> CONSTANTS = new HashMap<String, ProgramStageQueryCriteria.EventStatus>();

        static {
            for (ProgramStageQueryCriteria.EventStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        EventStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStageQueryCriteria.EventStatus fromValue(String value) {
            ProgramStageQueryCriteria.EventStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum OuMode {

        SELECTED("SELECTED"),
        CHILDREN("CHILDREN"),
        DESCENDANTS("DESCENDANTS"),
        ACCESSIBLE("ACCESSIBLE"),
        CAPTURE("CAPTURE"),
        ALL("ALL");
        private final String value;
        private final static Map<String, ProgramStageQueryCriteria.OuMode> CONSTANTS = new HashMap<String, ProgramStageQueryCriteria.OuMode>();

        static {
            for (ProgramStageQueryCriteria.OuMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        OuMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStageQueryCriteria.OuMode fromValue(String value) {
            ProgramStageQueryCriteria.OuMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
