
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "dashboard",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "message",
    "name",
    "publicAccess",
    "recipientUserGroups",
    "sharing",
    "title",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class PushAnalysis implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    /**
     * A UID reference to a Dashboard  
     * (Java name `org.hisp.dhis.dashboard.Dashboard`)
     * 
     */
    @JsonProperty("dashboard")
    @JsonPropertyDescription("A UID reference to a Dashboard  \n(Java name `org.hisp.dhis.dashboard.Dashboard`)")
    private RefDashboard dashboard;
    @JsonProperty("displayName")
    private String displayName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    @JsonProperty("message")
    private String message;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("recipientUserGroups")
    private List<RefUserGroup> recipientUserGroups;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("title")
    private String title;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3762191718030917931L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PushAnalysis() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public PushAnalysis(PushAnalysis source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dashboard = source.dashboard;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.message = source.message;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.recipientUserGroups = source.recipientUserGroups;
        this.sharing = source.sharing;
        this.title = source.title;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public PushAnalysis(Access access, List<AttributeValue> attributeValues, String code, Date created, RefUser createdBy, RefDashboard dashboard, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, RefUser lastUpdatedBy, String message, String name, String publicAccess, List<RefUserGroup> recipientUserGroups, Sharing sharing, String title, List<Translation> translations, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dashboard = dashboard;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.message = message;
        this.name = name;
        this.publicAccess = publicAccess;
        this.recipientUserGroups = recipientUserGroups;
        this.sharing = sharing;
        this.title = title;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public PushAnalysis withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public PushAnalysis withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public PushAnalysis withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public PushAnalysis withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public PushAnalysis withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * A UID reference to a Dashboard  
     * (Java name `org.hisp.dhis.dashboard.Dashboard`)
     * 
     */
    @JsonProperty("dashboard")
    public Optional<RefDashboard> getDashboard() {
        return Optional.ofNullable(dashboard);
    }

    /**
     * A UID reference to a Dashboard  
     * (Java name `org.hisp.dhis.dashboard.Dashboard`)
     * 
     */
    @JsonProperty("dashboard")
    public void setDashboard(RefDashboard dashboard) {
        this.dashboard = dashboard;
    }

    public PushAnalysis withDashboard(RefDashboard dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public PushAnalysis withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public PushAnalysis withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public PushAnalysis withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public PushAnalysis withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public PushAnalysis withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public PushAnalysis withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public PushAnalysis withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public PushAnalysis withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public PushAnalysis withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public PushAnalysis withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public PushAnalysis withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("recipientUserGroups")
    public Optional<List<RefUserGroup>> getRecipientUserGroups() {
        return Optional.ofNullable(recipientUserGroups);
    }

    @JsonProperty("recipientUserGroups")
    public void setRecipientUserGroups(List<RefUserGroup> recipientUserGroups) {
        this.recipientUserGroups = recipientUserGroups;
    }

    public PushAnalysis withRecipientUserGroups(List<RefUserGroup> recipientUserGroups) {
        this.recipientUserGroups = recipientUserGroups;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public PushAnalysis withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public PushAnalysis withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public PushAnalysis withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public PushAnalysis withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public PushAnalysis withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public PushAnalysis withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public PushAnalysis withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("createdBy".equals(name)) {
                            if (value instanceof RefUser) {
                                setCreatedBy(((RefUser) value));
                            } else {
                                throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dashboard".equals(name)) {
                                if (value instanceof RefDashboard) {
                                    setDashboard(((RefDashboard) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dashboard\" is of type \"org.hisp.dhis.api.model.v40_0.RefDashboard\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("displayName".equals(name)) {
                                    if (value instanceof String) {
                                        setDisplayName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("externalAccess".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setExternalAccess(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("favorite".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setFavorite(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("favorites".equals(name)) {
                                                if (value instanceof List) {
                                                    setFavorites(((List<String> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("href".equals(name)) {
                                                    if (value instanceof String) {
                                                        setHref(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("id".equals(name)) {
                                                        if (value instanceof String) {
                                                            setId(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            if (value instanceof Date) {
                                                                setLastUpdated(((Date) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                if (value instanceof RefUser) {
                                                                    setLastUpdatedBy(((RefUser) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("message".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setMessage(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("name".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("publicAccess".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setPublicAccess(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("recipientUserGroups".equals(name)) {
                                                                                if (value instanceof List) {
                                                                                    setRecipientUserGroups(((List<RefUserGroup> ) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"recipientUserGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefUserGroup>\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("sharing".equals(name)) {
                                                                                    if (value instanceof Sharing) {
                                                                                        setSharing(((Sharing) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("title".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setTitle(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("translations".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setTranslations(((List<Translation> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("user".equals(name)) {
                                                                                                if (value instanceof RefUser) {
                                                                                                    setUser(((RefUser) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("userAccesses".equals(name)) {
                                                                                                    if (value instanceof List) {
                                                                                                        setUserAccesses(((List<UserAccess> ) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("createdBy".equals(name)) {
                            return getCreatedBy();
                        } else {
                            if ("dashboard".equals(name)) {
                                return getDashboard();
                            } else {
                                if ("displayName".equals(name)) {
                                    return getDisplayName();
                                } else {
                                    if ("externalAccess".equals(name)) {
                                        return getExternalAccess();
                                    } else {
                                        if ("favorite".equals(name)) {
                                            return getFavorite();
                                        } else {
                                            if ("favorites".equals(name)) {
                                                return getFavorites();
                                            } else {
                                                if ("href".equals(name)) {
                                                    return getHref();
                                                } else {
                                                    if ("id".equals(name)) {
                                                        return getId();
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            return getLastUpdated();
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                return getLastUpdatedBy();
                                                            } else {
                                                                if ("message".equals(name)) {
                                                                    return getMessage();
                                                                } else {
                                                                    if ("name".equals(name)) {
                                                                        return getName();
                                                                    } else {
                                                                        if ("publicAccess".equals(name)) {
                                                                            return getPublicAccess();
                                                                        } else {
                                                                            if ("recipientUserGroups".equals(name)) {
                                                                                return getRecipientUserGroups();
                                                                            } else {
                                                                                if ("sharing".equals(name)) {
                                                                                    return getSharing();
                                                                                } else {
                                                                                    if ("title".equals(name)) {
                                                                                        return getTitle();
                                                                                    } else {
                                                                                        if ("translations".equals(name)) {
                                                                                            return getTranslations();
                                                                                        } else {
                                                                                            if ("user".equals(name)) {
                                                                                                return getUser();
                                                                                            } else {
                                                                                                if ("userAccesses".equals(name)) {
                                                                                                    return getUserAccesses();
                                                                                                } else {
                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                        return getUserGroupAccesses();
                                                                                                    } else {
                                                                                                        return notFoundValue;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, PushAnalysis.NOT_FOUND_VALUE);
        if (PushAnalysis.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public PushAnalysis with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PushAnalysis.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dashboard");
        sb.append('=');
        sb.append(((this.dashboard == null)?"<null>":this.dashboard));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("recipientUserGroups");
        sb.append('=');
        sb.append(((this.recipientUserGroups == null)?"<null>":this.recipientUserGroups));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.recipientUserGroups == null)? 0 :this.recipientUserGroups.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.dashboard == null)? 0 :this.dashboard.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PushAnalysis) == false) {
            return false;
        }
        PushAnalysis rhs = ((PushAnalysis) other);
        return ((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.recipientUserGroups == rhs.recipientUserGroups)||((this.recipientUserGroups!= null)&&this.recipientUserGroups.equals(rhs.recipientUserGroups))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.dashboard == rhs.dashboard)||((this.dashboard!= null)&&this.dashboard.equals(rhs.dashboard))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
