
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "count",
    "extent"
})
@Generated("jsonschema2pojo")
public class Rectangle implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("count")
    private Long count;
    @JsonProperty("extent")
    private String extent;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4753124083363364468L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Rectangle() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Rectangle(Rectangle source) {
        super();
        this.count = source.count;
        this.extent = source.extent;
    }

    public Rectangle(Long count, String extent) {
        super();
        this.count = count;
        this.extent = extent;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("count")
    public Long getCount() {
        return count;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("count")
    public void setCount(Long count) {
        this.count = count;
    }

    public Rectangle withCount(Long count) {
        this.count = count;
        return this;
    }

    @JsonProperty("extent")
    public Optional<String> getExtent() {
        return Optional.ofNullable(extent);
    }

    @JsonProperty("extent")
    public void setExtent(String extent) {
        this.extent = extent;
    }

    public Rectangle withExtent(String extent) {
        this.extent = extent;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Rectangle withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("count".equals(name)) {
            if (value instanceof Long) {
                setCount(((Long) value));
            } else {
                throw new IllegalArgumentException(("property \"count\" is of type \"java.lang.Long\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("extent".equals(name)) {
                if (value instanceof String) {
                    setExtent(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"extent\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("count".equals(name)) {
            return getCount();
        } else {
            if ("extent".equals(name)) {
                return getExtent();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Rectangle.NOT_FOUND_VALUE);
        if (Rectangle.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Rectangle with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Rectangle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("count");
        sb.append('=');
        sb.append(((this.count == null)?"<null>":this.count));
        sb.append(',');
        sb.append("extent");
        sb.append('=');
        sb.append(((this.extent == null)?"<null>":this.extent));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.count == null)? 0 :this.count.hashCode()));
        result = ((result* 31)+((this.extent == null)? 0 :this.extent.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Rectangle) == false) {
            return false;
        }
        Rectangle rhs = ((Rectangle) other);
        return ((((this.count == rhs.count)||((this.count!= null)&&this.count.equals(rhs.count)))&&((this.extent == rhs.extent)||((this.extent!= null)&&this.extent.equals(rhs.extent))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
