
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "codeValueSeparator",
    "completenessMethod",
    "created",
    "createdBy",
    "currentPeriodUsedForReporting",
    "dataset",
    "defaultMessage",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "moreThanOneOrgUnitMessage",
    "name",
    "noUserMessage",
    "parserType",
    "program",
    "programStage",
    "publicAccess",
    "receivedMessage",
    "separator",
    "sharing",
    "smsCodes",
    "specialCharacters",
    "successMessage",
    "translations",
    "user",
    "userAccesses",
    "userGroup",
    "userGroupAccesses",
    "wrongFormatMessage"
})
@Generated("jsonschema2pojo")
public class SMSCommand implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("codeValueSeparator")
    private String codeValueSeparator;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("completenessMethod")
    private SMSCommand.CompletenessMethod completenessMethod;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("currentPeriodUsedForReporting")
    private Boolean currentPeriodUsedForReporting;
    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataset")
    @JsonPropertyDescription("A UID reference to a DataSet  \n(Java name `org.hisp.dhis.dataset.DataSet`)")
    private RefDataSet dataset;
    @JsonProperty("defaultMessage")
    private String defaultMessage;
    @JsonProperty("displayName")
    private String displayName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    @JsonProperty("moreThanOneOrgUnitMessage")
    private String moreThanOneOrgUnitMessage;
    @JsonProperty("name")
    private String name;
    @JsonProperty("noUserMessage")
    private String noUserMessage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("parserType")
    private SMSCommand.ParserType parserType;
    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private RefProgram program;
    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    @JsonPropertyDescription("A UID reference to a ProgramStage  \n(Java name `org.hisp.dhis.program.ProgramStage`)")
    private RefProgramStage programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("receivedMessage")
    private String receivedMessage;
    @JsonProperty("separator")
    private String separator;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("smsCodes")
    private List<SMSCode> smsCodes;
    @JsonProperty("specialCharacters")
    private List<SMSSpecialCharacter> specialCharacters;
    @JsonProperty("successMessage")
    private String successMessage;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("userGroup")
    @JsonPropertyDescription("A UID reference to a UserGroup  \n(Java name `org.hisp.dhis.user.UserGroup`)")
    private RefUserGroup userGroup;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("wrongFormatMessage")
    private String wrongFormatMessage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3368463225324885660L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SMSCommand() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SMSCommand(SMSCommand source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.codeValueSeparator = source.codeValueSeparator;
        this.completenessMethod = source.completenessMethod;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.currentPeriodUsedForReporting = source.currentPeriodUsedForReporting;
        this.dataset = source.dataset;
        this.defaultMessage = source.defaultMessage;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.moreThanOneOrgUnitMessage = source.moreThanOneOrgUnitMessage;
        this.name = source.name;
        this.noUserMessage = source.noUserMessage;
        this.parserType = source.parserType;
        this.program = source.program;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.receivedMessage = source.receivedMessage;
        this.separator = source.separator;
        this.sharing = source.sharing;
        this.smsCodes = source.smsCodes;
        this.specialCharacters = source.specialCharacters;
        this.successMessage = source.successMessage;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroup = source.userGroup;
        this.userGroupAccesses = source.userGroupAccesses;
        this.wrongFormatMessage = source.wrongFormatMessage;
    }

    public SMSCommand(Access access, List<AttributeValue> attributeValues, String code, String codeValueSeparator, SMSCommand.CompletenessMethod completenessMethod, Date created, RefUser createdBy, Boolean currentPeriodUsedForReporting, RefDataSet dataset, String defaultMessage, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, RefUser lastUpdatedBy, String moreThanOneOrgUnitMessage, String name, String noUserMessage, SMSCommand.ParserType parserType, RefProgram program, RefProgramStage programStage, String publicAccess, String receivedMessage, String separator, Sharing sharing, List<SMSCode> smsCodes, List<SMSSpecialCharacter> specialCharacters, String successMessage, List<Translation> translations, RefUser user, List<UserAccess> userAccesses, RefUserGroup userGroup, List<UserGroupAccess> userGroupAccesses, String wrongFormatMessage) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.codeValueSeparator = codeValueSeparator;
        this.completenessMethod = completenessMethod;
        this.created = created;
        this.createdBy = createdBy;
        this.currentPeriodUsedForReporting = currentPeriodUsedForReporting;
        this.dataset = dataset;
        this.defaultMessage = defaultMessage;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.moreThanOneOrgUnitMessage = moreThanOneOrgUnitMessage;
        this.name = name;
        this.noUserMessage = noUserMessage;
        this.parserType = parserType;
        this.program = program;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.receivedMessage = receivedMessage;
        this.separator = separator;
        this.sharing = sharing;
        this.smsCodes = smsCodes;
        this.specialCharacters = specialCharacters;
        this.successMessage = successMessage;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroup = userGroup;
        this.userGroupAccesses = userGroupAccesses;
        this.wrongFormatMessage = wrongFormatMessage;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public SMSCommand withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public SMSCommand withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public SMSCommand withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("codeValueSeparator")
    public Optional<String> getCodeValueSeparator() {
        return Optional.ofNullable(codeValueSeparator);
    }

    @JsonProperty("codeValueSeparator")
    public void setCodeValueSeparator(String codeValueSeparator) {
        this.codeValueSeparator = codeValueSeparator;
    }

    public SMSCommand withCodeValueSeparator(String codeValueSeparator) {
        this.codeValueSeparator = codeValueSeparator;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("completenessMethod")
    public SMSCommand.CompletenessMethod getCompletenessMethod() {
        return completenessMethod;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("completenessMethod")
    public void setCompletenessMethod(SMSCommand.CompletenessMethod completenessMethod) {
        this.completenessMethod = completenessMethod;
    }

    public SMSCommand withCompletenessMethod(SMSCommand.CompletenessMethod completenessMethod) {
        this.completenessMethod = completenessMethod;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public SMSCommand withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public SMSCommand withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("currentPeriodUsedForReporting")
    public Boolean getCurrentPeriodUsedForReporting() {
        return currentPeriodUsedForReporting;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("currentPeriodUsedForReporting")
    public void setCurrentPeriodUsedForReporting(Boolean currentPeriodUsedForReporting) {
        this.currentPeriodUsedForReporting = currentPeriodUsedForReporting;
    }

    public SMSCommand withCurrentPeriodUsedForReporting(Boolean currentPeriodUsedForReporting) {
        this.currentPeriodUsedForReporting = currentPeriodUsedForReporting;
        return this;
    }

    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataset")
    public Optional<RefDataSet> getDataset() {
        return Optional.ofNullable(dataset);
    }

    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataset")
    public void setDataset(RefDataSet dataset) {
        this.dataset = dataset;
    }

    public SMSCommand withDataset(RefDataSet dataset) {
        this.dataset = dataset;
        return this;
    }

    @JsonProperty("defaultMessage")
    public Optional<String> getDefaultMessage() {
        return Optional.ofNullable(defaultMessage);
    }

    @JsonProperty("defaultMessage")
    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public SMSCommand withDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SMSCommand withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public SMSCommand withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public SMSCommand withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public SMSCommand withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public SMSCommand withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public SMSCommand withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public SMSCommand withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public SMSCommand withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("moreThanOneOrgUnitMessage")
    public Optional<String> getMoreThanOneOrgUnitMessage() {
        return Optional.ofNullable(moreThanOneOrgUnitMessage);
    }

    @JsonProperty("moreThanOneOrgUnitMessage")
    public void setMoreThanOneOrgUnitMessage(String moreThanOneOrgUnitMessage) {
        this.moreThanOneOrgUnitMessage = moreThanOneOrgUnitMessage;
    }

    public SMSCommand withMoreThanOneOrgUnitMessage(String moreThanOneOrgUnitMessage) {
        this.moreThanOneOrgUnitMessage = moreThanOneOrgUnitMessage;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public SMSCommand withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("noUserMessage")
    public Optional<String> getNoUserMessage() {
        return Optional.ofNullable(noUserMessage);
    }

    @JsonProperty("noUserMessage")
    public void setNoUserMessage(String noUserMessage) {
        this.noUserMessage = noUserMessage;
    }

    public SMSCommand withNoUserMessage(String noUserMessage) {
        this.noUserMessage = noUserMessage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("parserType")
    public SMSCommand.ParserType getParserType() {
        return parserType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("parserType")
    public void setParserType(SMSCommand.ParserType parserType) {
        this.parserType = parserType;
    }

    public SMSCommand withParserType(SMSCommand.ParserType parserType) {
        this.parserType = parserType;
        return this;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<RefProgram> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(RefProgram program) {
        this.program = program;
    }

    public SMSCommand withProgram(RefProgram program) {
        this.program = program;
        return this;
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public Optional<RefProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public void setProgramStage(RefProgramStage programStage) {
        this.programStage = programStage;
    }

    public SMSCommand withProgramStage(RefProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public SMSCommand withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("receivedMessage")
    public Optional<String> getReceivedMessage() {
        return Optional.ofNullable(receivedMessage);
    }

    @JsonProperty("receivedMessage")
    public void setReceivedMessage(String receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public SMSCommand withReceivedMessage(String receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @JsonProperty("separator")
    public Optional<String> getSeparator() {
        return Optional.ofNullable(separator);
    }

    @JsonProperty("separator")
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public SMSCommand withSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public SMSCommand withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("smsCodes")
    public Optional<List<SMSCode>> getSmsCodes() {
        return Optional.ofNullable(smsCodes);
    }

    @JsonProperty("smsCodes")
    public void setSmsCodes(List<SMSCode> smsCodes) {
        this.smsCodes = smsCodes;
    }

    public SMSCommand withSmsCodes(List<SMSCode> smsCodes) {
        this.smsCodes = smsCodes;
        return this;
    }

    @JsonProperty("specialCharacters")
    public Optional<List<SMSSpecialCharacter>> getSpecialCharacters() {
        return Optional.ofNullable(specialCharacters);
    }

    @JsonProperty("specialCharacters")
    public void setSpecialCharacters(List<SMSSpecialCharacter> specialCharacters) {
        this.specialCharacters = specialCharacters;
    }

    public SMSCommand withSpecialCharacters(List<SMSSpecialCharacter> specialCharacters) {
        this.specialCharacters = specialCharacters;
        return this;
    }

    @JsonProperty("successMessage")
    public Optional<String> getSuccessMessage() {
        return Optional.ofNullable(successMessage);
    }

    @JsonProperty("successMessage")
    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public SMSCommand withSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public SMSCommand withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public SMSCommand withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public SMSCommand withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("userGroup")
    public Optional<RefUserGroup> getUserGroup() {
        return Optional.ofNullable(userGroup);
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("userGroup")
    public void setUserGroup(RefUserGroup userGroup) {
        this.userGroup = userGroup;
    }

    public SMSCommand withUserGroup(RefUserGroup userGroup) {
        this.userGroup = userGroup;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public SMSCommand withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("wrongFormatMessage")
    public Optional<String> getWrongFormatMessage() {
        return Optional.ofNullable(wrongFormatMessage);
    }

    @JsonProperty("wrongFormatMessage")
    public void setWrongFormatMessage(String wrongFormatMessage) {
        this.wrongFormatMessage = wrongFormatMessage;
    }

    public SMSCommand withWrongFormatMessage(String wrongFormatMessage) {
        this.wrongFormatMessage = wrongFormatMessage;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SMSCommand withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("codeValueSeparator".equals(name)) {
                        if (value instanceof String) {
                            setCodeValueSeparator(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"codeValueSeparator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("completenessMethod".equals(name)) {
                            if (value instanceof SMSCommand.CompletenessMethod) {
                                setCompletenessMethod(((SMSCommand.CompletenessMethod) value));
                            } else {
                                throw new IllegalArgumentException(("property \"completenessMethod\" is of type \"org.hisp.dhis.api.model.v40_0.SMSCommand.CompletenessMethod\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("created".equals(name)) {
                                if (value instanceof Date) {
                                    setCreated(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdBy".equals(name)) {
                                    if (value instanceof RefUser) {
                                        setCreatedBy(((RefUser) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("currentPeriodUsedForReporting".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setCurrentPeriodUsedForReporting(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"currentPeriodUsedForReporting\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dataset".equals(name)) {
                                            if (value instanceof RefDataSet) {
                                                setDataset(((RefDataSet) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dataset\" is of type \"org.hisp.dhis.api.model.v40_0.RefDataSet\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("defaultMessage".equals(name)) {
                                                if (value instanceof String) {
                                                    setDefaultMessage(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"defaultMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayName".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayName(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setHref(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setId(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setLastUpdated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                if (value instanceof RefUser) {
                                                                                    setLastUpdatedBy(((RefUser) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("moreThanOneOrgUnitMessage".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setMoreThanOneOrgUnitMessage(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"moreThanOneOrgUnitMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("name".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setName(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("noUserMessage".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setNoUserMessage(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"noUserMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("parserType".equals(name)) {
                                                                                                if (value instanceof SMSCommand.ParserType) {
                                                                                                    setParserType(((SMSCommand.ParserType) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"parserType\" is of type \"org.hisp.dhis.api.model.v40_0.SMSCommand.ParserType\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("program".equals(name)) {
                                                                                                    if (value instanceof RefProgram) {
                                                                                                        setProgram(((RefProgram) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgram\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("programStage".equals(name)) {
                                                                                                        if (value instanceof RefProgramStage) {
                                                                                                            setProgramStage(((RefProgramStage) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgramStage\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setPublicAccess(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("receivedMessage".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setReceivedMessage(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"receivedMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("separator".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setSeparator(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"separator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                        if (value instanceof Sharing) {
                                                                                                                            setSharing(((Sharing) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("smsCodes".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setSmsCodes(((List<SMSCode> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"smsCodes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.SMSCode>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("specialCharacters".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setSpecialCharacters(((List<SMSSpecialCharacter> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"specialCharacters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.SMSSpecialCharacter>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("successMessage".equals(name)) {
                                                                                                                                    if (value instanceof String) {
                                                                                                                                        setSuccessMessage(((String) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"successMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                            if (value instanceof RefUser) {
                                                                                                                                                setUser(((RefUser) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                if (value instanceof List) {
                                                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("userGroup".equals(name)) {
                                                                                                                                                    if (value instanceof RefUserGroup) {
                                                                                                                                                        setUserGroup(((RefUserGroup) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroup\" is of type \"org.hisp.dhis.api.model.v40_0.RefUserGroup\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                            setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("wrongFormatMessage".equals(name)) {
                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                setWrongFormatMessage(((String) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"wrongFormatMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("codeValueSeparator".equals(name)) {
                        return getCodeValueSeparator();
                    } else {
                        if ("completenessMethod".equals(name)) {
                            return getCompletenessMethod();
                        } else {
                            if ("created".equals(name)) {
                                return getCreated();
                            } else {
                                if ("createdBy".equals(name)) {
                                    return getCreatedBy();
                                } else {
                                    if ("currentPeriodUsedForReporting".equals(name)) {
                                        return getCurrentPeriodUsedForReporting();
                                    } else {
                                        if ("dataset".equals(name)) {
                                            return getDataset();
                                        } else {
                                            if ("defaultMessage".equals(name)) {
                                                return getDefaultMessage();
                                            } else {
                                                if ("displayName".equals(name)) {
                                                    return getDisplayName();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    return getHref();
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        return getId();
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            return getLastUpdated();
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                return getLastUpdatedBy();
                                                                            } else {
                                                                                if ("moreThanOneOrgUnitMessage".equals(name)) {
                                                                                    return getMoreThanOneOrgUnitMessage();
                                                                                } else {
                                                                                    if ("name".equals(name)) {
                                                                                        return getName();
                                                                                    } else {
                                                                                        if ("noUserMessage".equals(name)) {
                                                                                            return getNoUserMessage();
                                                                                        } else {
                                                                                            if ("parserType".equals(name)) {
                                                                                                return getParserType();
                                                                                            } else {
                                                                                                if ("program".equals(name)) {
                                                                                                    return getProgram();
                                                                                                } else {
                                                                                                    if ("programStage".equals(name)) {
                                                                                                        return getProgramStage();
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            return getPublicAccess();
                                                                                                        } else {
                                                                                                            if ("receivedMessage".equals(name)) {
                                                                                                                return getReceivedMessage();
                                                                                                            } else {
                                                                                                                if ("separator".equals(name)) {
                                                                                                                    return getSeparator();
                                                                                                                } else {
                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                        return getSharing();
                                                                                                                    } else {
                                                                                                                        if ("smsCodes".equals(name)) {
                                                                                                                            return getSmsCodes();
                                                                                                                        } else {
                                                                                                                            if ("specialCharacters".equals(name)) {
                                                                                                                                return getSpecialCharacters();
                                                                                                                            } else {
                                                                                                                                if ("successMessage".equals(name)) {
                                                                                                                                    return getSuccessMessage();
                                                                                                                                } else {
                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                        return getTranslations();
                                                                                                                                    } else {
                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                            return getUser();
                                                                                                                                        } else {
                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                return getUserAccesses();
                                                                                                                                            } else {
                                                                                                                                                if ("userGroup".equals(name)) {
                                                                                                                                                    return getUserGroup();
                                                                                                                                                } else {
                                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                                        return getUserGroupAccesses();
                                                                                                                                                    } else {
                                                                                                                                                        if ("wrongFormatMessage".equals(name)) {
                                                                                                                                                            return getWrongFormatMessage();
                                                                                                                                                        } else {
                                                                                                                                                            return notFoundValue;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SMSCommand.NOT_FOUND_VALUE);
        if (SMSCommand.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SMSCommand with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SMSCommand.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("codeValueSeparator");
        sb.append('=');
        sb.append(((this.codeValueSeparator == null)?"<null>":this.codeValueSeparator));
        sb.append(',');
        sb.append("completenessMethod");
        sb.append('=');
        sb.append(((this.completenessMethod == null)?"<null>":this.completenessMethod));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("currentPeriodUsedForReporting");
        sb.append('=');
        sb.append(((this.currentPeriodUsedForReporting == null)?"<null>":this.currentPeriodUsedForReporting));
        sb.append(',');
        sb.append("dataset");
        sb.append('=');
        sb.append(((this.dataset == null)?"<null>":this.dataset));
        sb.append(',');
        sb.append("defaultMessage");
        sb.append('=');
        sb.append(((this.defaultMessage == null)?"<null>":this.defaultMessage));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("moreThanOneOrgUnitMessage");
        sb.append('=');
        sb.append(((this.moreThanOneOrgUnitMessage == null)?"<null>":this.moreThanOneOrgUnitMessage));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("noUserMessage");
        sb.append('=');
        sb.append(((this.noUserMessage == null)?"<null>":this.noUserMessage));
        sb.append(',');
        sb.append("parserType");
        sb.append('=');
        sb.append(((this.parserType == null)?"<null>":this.parserType));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("receivedMessage");
        sb.append('=');
        sb.append(((this.receivedMessage == null)?"<null>":this.receivedMessage));
        sb.append(',');
        sb.append("separator");
        sb.append('=');
        sb.append(((this.separator == null)?"<null>":this.separator));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("smsCodes");
        sb.append('=');
        sb.append(((this.smsCodes == null)?"<null>":this.smsCodes));
        sb.append(',');
        sb.append("specialCharacters");
        sb.append('=');
        sb.append(((this.specialCharacters == null)?"<null>":this.specialCharacters));
        sb.append(',');
        sb.append("successMessage");
        sb.append('=');
        sb.append(((this.successMessage == null)?"<null>":this.successMessage));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroup");
        sb.append('=');
        sb.append(((this.userGroup == null)?"<null>":this.userGroup));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("wrongFormatMessage");
        sb.append('=');
        sb.append(((this.wrongFormatMessage == null)?"<null>":this.wrongFormatMessage));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.moreThanOneOrgUnitMessage == null)? 0 :this.moreThanOneOrgUnitMessage.hashCode()));
        result = ((result* 31)+((this.smsCodes == null)? 0 :this.smsCodes.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.specialCharacters == null)? 0 :this.specialCharacters.hashCode()));
        result = ((result* 31)+((this.currentPeriodUsedForReporting == null)? 0 :this.currentPeriodUsedForReporting.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.noUserMessage == null)? 0 :this.noUserMessage.hashCode()));
        result = ((result* 31)+((this.receivedMessage == null)? 0 :this.receivedMessage.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.defaultMessage == null)? 0 :this.defaultMessage.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.userGroup == null)? 0 :this.userGroup.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.completenessMethod == null)? 0 :this.completenessMethod.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.wrongFormatMessage == null)? 0 :this.wrongFormatMessage.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.separator == null)? 0 :this.separator.hashCode()));
        result = ((result* 31)+((this.successMessage == null)? 0 :this.successMessage.hashCode()));
        result = ((result* 31)+((this.codeValueSeparator == null)? 0 :this.codeValueSeparator.hashCode()));
        result = ((result* 31)+((this.parserType == null)? 0 :this.parserType.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataset == null)? 0 :this.dataset.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SMSCommand) == false) {
            return false;
        }
        SMSCommand rhs = ((SMSCommand) other);
        return (((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.moreThanOneOrgUnitMessage == rhs.moreThanOneOrgUnitMessage)||((this.moreThanOneOrgUnitMessage!= null)&&this.moreThanOneOrgUnitMessage.equals(rhs.moreThanOneOrgUnitMessage))))&&((this.smsCodes == rhs.smsCodes)||((this.smsCodes!= null)&&this.smsCodes.equals(rhs.smsCodes))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.specialCharacters == rhs.specialCharacters)||((this.specialCharacters!= null)&&this.specialCharacters.equals(rhs.specialCharacters))))&&((this.currentPeriodUsedForReporting == rhs.currentPeriodUsedForReporting)||((this.currentPeriodUsedForReporting!= null)&&this.currentPeriodUsedForReporting.equals(rhs.currentPeriodUsedForReporting))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.noUserMessage == rhs.noUserMessage)||((this.noUserMessage!= null)&&this.noUserMessage.equals(rhs.noUserMessage))))&&((this.receivedMessage == rhs.receivedMessage)||((this.receivedMessage!= null)&&this.receivedMessage.equals(rhs.receivedMessage))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.defaultMessage == rhs.defaultMessage)||((this.defaultMessage!= null)&&this.defaultMessage.equals(rhs.defaultMessage))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.userGroup == rhs.userGroup)||((this.userGroup!= null)&&this.userGroup.equals(rhs.userGroup))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.completenessMethod == rhs.completenessMethod)||((this.completenessMethod!= null)&&this.completenessMethod.equals(rhs.completenessMethod))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.wrongFormatMessage == rhs.wrongFormatMessage)||((this.wrongFormatMessage!= null)&&this.wrongFormatMessage.equals(rhs.wrongFormatMessage))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.separator == rhs.separator)||((this.separator!= null)&&this.separator.equals(rhs.separator))))&&((this.successMessage == rhs.successMessage)||((this.successMessage!= null)&&this.successMessage.equals(rhs.successMessage))))&&((this.codeValueSeparator == rhs.codeValueSeparator)||((this.codeValueSeparator!= null)&&this.codeValueSeparator.equals(rhs.codeValueSeparator))))&&((this.parserType == rhs.parserType)||((this.parserType!= null)&&this.parserType.equals(rhs.parserType))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataset == rhs.dataset)||((this.dataset!= null)&&this.dataset.equals(rhs.dataset))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum CompletenessMethod {

        ALL_DATAVALUE("ALL_DATAVALUE"),
        AT_LEAST_ONE_DATAVALUE("AT_LEAST_ONE_DATAVALUE"),
        DO_NOT_MARK_COMPLETE("DO_NOT_MARK_COMPLETE");
        private final String value;
        private final static Map<String, SMSCommand.CompletenessMethod> CONSTANTS = new HashMap<String, SMSCommand.CompletenessMethod>();

        static {
            for (SMSCommand.CompletenessMethod c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CompletenessMethod(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMSCommand.CompletenessMethod fromValue(String value) {
            SMSCommand.CompletenessMethod constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ParserType {

        KEY_VALUE_PARSER("KEY_VALUE_PARSER"),
        J_2_ME_PARSER("J2ME_PARSER"),
        ALERT_PARSER("ALERT_PARSER"),
        UNREGISTERED_PARSER("UNREGISTERED_PARSER"),
        TRACKED_ENTITY_REGISTRATION_PARSER("TRACKED_ENTITY_REGISTRATION_PARSER"),
        PROGRAM_STAGE_DATAENTRY_PARSER("PROGRAM_STAGE_DATAENTRY_PARSER"),
        EVENT_REGISTRATION_PARSER("EVENT_REGISTRATION_PARSER");
        private final String value;
        private final static Map<String, SMSCommand.ParserType> CONSTANTS = new HashMap<String, SMSCommand.ParserType>();

        static {
            for (SMSCommand.ParserType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ParserType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMSCommand.ParserType fromValue(String value) {
            SMSCommand.ParserType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
