
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "api",
    "request",
    "type"
})
@Generated("jsonschema2pojo")
public class Target implements Serializable
{

    @JsonProperty("api")
    private Api api;
    @JsonProperty("request")
    private TargetRequest request;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private Target.Type type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3008446554621335779L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Target() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Target(Target source) {
        super();
        this.api = source.api;
        this.request = source.request;
        this.type = source.type;
    }

    public Target(Api api, TargetRequest request, Target.Type type) {
        super();
        this.api = api;
        this.request = request;
        this.type = type;
    }

    @JsonProperty("api")
    public Optional<Api> getApi() {
        return Optional.ofNullable(api);
    }

    @JsonProperty("api")
    public void setApi(Api api) {
        this.api = api;
    }

    public Target withApi(Api api) {
        this.api = api;
        return this;
    }

    @JsonProperty("request")
    public Optional<TargetRequest> getRequest() {
        return Optional.ofNullable(request);
    }

    @JsonProperty("request")
    public void setRequest(TargetRequest request) {
        this.request = request;
    }

    public Target withRequest(TargetRequest request) {
        this.request = request;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public Target.Type getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(Target.Type type) {
        this.type = type;
    }

    public Target withType(Target.Type type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Target withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("api".equals(name)) {
            if (value instanceof Api) {
                setApi(((Api) value));
            } else {
                throw new IllegalArgumentException(("property \"api\" is of type \"org.hisp.dhis.api.model.v40_0.Api\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("request".equals(name)) {
                if (value instanceof TargetRequest) {
                    setRequest(((TargetRequest) value));
                } else {
                    throw new IllegalArgumentException(("property \"request\" is of type \"org.hisp.dhis.api.model.v40_0.TargetRequest\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("type".equals(name)) {
                    if (value instanceof Target.Type) {
                        setType(((Target.Type) value));
                    } else {
                        throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_0.Target.Type\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("api".equals(name)) {
            return getApi();
        } else {
            if ("request".equals(name)) {
                return getRequest();
            } else {
                if ("type".equals(name)) {
                    return getType();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Target.NOT_FOUND_VALUE);
        if (Target.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Target with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Target.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("api");
        sb.append('=');
        sb.append(((this.api == null)?"<null>":this.api));
        sb.append(',');
        sb.append("request");
        sb.append('=');
        sb.append(((this.request == null)?"<null>":this.request));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.request == null)? 0 :this.request.hashCode()));
        result = ((result* 31)+((this.api == null)? 0 :this.api.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Target) == false) {
            return false;
        }
        Target rhs = ((Target) other);
        return (((((this.request == rhs.request)||((this.request!= null)&&this.request.equals(rhs.request)))&&((this.api == rhs.api)||((this.api!= null)&&this.api.equals(rhs.api))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }

    @Generated("jsonschema2pojo")
    public enum Type {

        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");
        private final String value;
        private final static Map<String, Target.Type> CONSTANTS = new HashMap<String, Target.Type>();

        static {
            for (Target.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Target.Type fromValue(String value) {
            Target.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
