
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "objectReports",
    "stats",
    "trackerType"
})
@Generated("jsonschema2pojo")
public class TrackerTypeReport implements Serializable
{

    @JsonProperty("objectReports")
    private List<Entity> objectReports;
    @JsonProperty("stats")
    private TrackerReportStats stats;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackerType")
    private TrackerTypeReport.TrackerType trackerType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8009773562481092566L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerTypeReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerTypeReport(TrackerTypeReport source) {
        super();
        this.objectReports = source.objectReports;
        this.stats = source.stats;
        this.trackerType = source.trackerType;
    }

    public TrackerTypeReport(List<Entity> objectReports, TrackerReportStats stats, TrackerTypeReport.TrackerType trackerType) {
        super();
        this.objectReports = objectReports;
        this.stats = stats;
        this.trackerType = trackerType;
    }

    @JsonProperty("objectReports")
    public Optional<List<Entity>> getObjectReports() {
        return Optional.ofNullable(objectReports);
    }

    @JsonProperty("objectReports")
    public void setObjectReports(List<Entity> objectReports) {
        this.objectReports = objectReports;
    }

    public TrackerTypeReport withObjectReports(List<Entity> objectReports) {
        this.objectReports = objectReports;
        return this;
    }

    @JsonProperty("stats")
    public Optional<TrackerReportStats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(TrackerReportStats stats) {
        this.stats = stats;
    }

    public TrackerTypeReport withStats(TrackerReportStats stats) {
        this.stats = stats;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackerType")
    public TrackerTypeReport.TrackerType getTrackerType() {
        return trackerType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackerType")
    public void setTrackerType(TrackerTypeReport.TrackerType trackerType) {
        this.trackerType = trackerType;
    }

    public TrackerTypeReport withTrackerType(TrackerTypeReport.TrackerType trackerType) {
        this.trackerType = trackerType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerTypeReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("objectReports".equals(name)) {
            if (value instanceof List) {
                setObjectReports(((List<Entity> ) value));
            } else {
                throw new IllegalArgumentException(("property \"objectReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Entity>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("stats".equals(name)) {
                if (value instanceof TrackerReportStats) {
                    setStats(((TrackerReportStats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v40_0.TrackerReportStats\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("trackerType".equals(name)) {
                    if (value instanceof TrackerTypeReport.TrackerType) {
                        setTrackerType(((TrackerTypeReport.TrackerType) value));
                    } else {
                        throw new IllegalArgumentException(("property \"trackerType\" is of type \"org.hisp.dhis.api.model.v40_0.TrackerTypeReport.TrackerType\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("objectReports".equals(name)) {
            return getObjectReports();
        } else {
            if ("stats".equals(name)) {
                return getStats();
            } else {
                if ("trackerType".equals(name)) {
                    return getTrackerType();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerTypeReport.NOT_FOUND_VALUE);
        if (TrackerTypeReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerTypeReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerTypeReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("objectReports");
        sb.append('=');
        sb.append(((this.objectReports == null)?"<null>":this.objectReports));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("trackerType");
        sb.append('=');
        sb.append(((this.trackerType == null)?"<null>":this.trackerType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.trackerType == null)? 0 :this.trackerType.hashCode()));
        result = ((result* 31)+((this.objectReports == null)? 0 :this.objectReports.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerTypeReport) == false) {
            return false;
        }
        TrackerTypeReport rhs = ((TrackerTypeReport) other);
        return (((((this.trackerType == rhs.trackerType)||((this.trackerType!= null)&&this.trackerType.equals(rhs.trackerType)))&&((this.objectReports == rhs.objectReports)||((this.objectReports!= null)&&this.objectReports.equals(rhs.objectReports))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))));
    }

    @Generated("jsonschema2pojo")
    public enum TrackerType {

        TRACKED_ENTITY("TRACKED_ENTITY"),
        ENROLLMENT("ENROLLMENT"),
        EVENT("EVENT"),
        RELATIONSHIP("RELATIONSHIP");
        private final String value;
        private final static Map<String, TrackerTypeReport.TrackerType> CONSTANTS = new HashMap<String, TrackerTypeReport.TrackerType>();

        static {
            for (TrackerTypeReport.TrackerType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerTypeReport.TrackerType fromValue(String value) {
            TrackerTypeReport.TrackerType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
