
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionComboDisplayName",
    "attributeOptionComboId",
    "importance",
    "leftSideValue",
    "operator",
    "organisationUnitAncestorNames",
    "organisationUnitDisplayName",
    "organisationUnitId",
    "organisationUnitPath",
    "periodDisplayName",
    "periodId",
    "rightSideValue",
    "validationRuleDescription",
    "validationRuleId"
})
@Generated("jsonschema2pojo")
public class ValidationResultView implements Serializable
{

    @JsonProperty("attributeOptionComboDisplayName")
    private String attributeOptionComboDisplayName;
    @JsonProperty("attributeOptionComboId")
    private String attributeOptionComboId;
    @JsonProperty("importance")
    private String importance;
    @JsonProperty("leftSideValue")
    private Double leftSideValue;
    @JsonProperty("operator")
    private String operator;
    @JsonProperty("organisationUnitAncestorNames")
    private String organisationUnitAncestorNames;
    @JsonProperty("organisationUnitDisplayName")
    private String organisationUnitDisplayName;
    @JsonProperty("organisationUnitId")
    private String organisationUnitId;
    @JsonProperty("organisationUnitPath")
    private String organisationUnitPath;
    @JsonProperty("periodDisplayName")
    private String periodDisplayName;
    @JsonProperty("periodId")
    private String periodId;
    @JsonProperty("rightSideValue")
    private Double rightSideValue;
    @JsonProperty("validationRuleDescription")
    private String validationRuleDescription;
    @JsonProperty("validationRuleId")
    private String validationRuleId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3909531089942977596L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValidationResultView() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ValidationResultView(ValidationResultView source) {
        super();
        this.attributeOptionComboDisplayName = source.attributeOptionComboDisplayName;
        this.attributeOptionComboId = source.attributeOptionComboId;
        this.importance = source.importance;
        this.leftSideValue = source.leftSideValue;
        this.operator = source.operator;
        this.organisationUnitAncestorNames = source.organisationUnitAncestorNames;
        this.organisationUnitDisplayName = source.organisationUnitDisplayName;
        this.organisationUnitId = source.organisationUnitId;
        this.organisationUnitPath = source.organisationUnitPath;
        this.periodDisplayName = source.periodDisplayName;
        this.periodId = source.periodId;
        this.rightSideValue = source.rightSideValue;
        this.validationRuleDescription = source.validationRuleDescription;
        this.validationRuleId = source.validationRuleId;
    }

    public ValidationResultView(String attributeOptionComboDisplayName, String attributeOptionComboId, String importance, Double leftSideValue, String operator, String organisationUnitAncestorNames, String organisationUnitDisplayName, String organisationUnitId, String organisationUnitPath, String periodDisplayName, String periodId, Double rightSideValue, String validationRuleDescription, String validationRuleId) {
        super();
        this.attributeOptionComboDisplayName = attributeOptionComboDisplayName;
        this.attributeOptionComboId = attributeOptionComboId;
        this.importance = importance;
        this.leftSideValue = leftSideValue;
        this.operator = operator;
        this.organisationUnitAncestorNames = organisationUnitAncestorNames;
        this.organisationUnitDisplayName = organisationUnitDisplayName;
        this.organisationUnitId = organisationUnitId;
        this.organisationUnitPath = organisationUnitPath;
        this.periodDisplayName = periodDisplayName;
        this.periodId = periodId;
        this.rightSideValue = rightSideValue;
        this.validationRuleDescription = validationRuleDescription;
        this.validationRuleId = validationRuleId;
    }

    @JsonProperty("attributeOptionComboDisplayName")
    public Optional<String> getAttributeOptionComboDisplayName() {
        return Optional.ofNullable(attributeOptionComboDisplayName);
    }

    @JsonProperty("attributeOptionComboDisplayName")
    public void setAttributeOptionComboDisplayName(String attributeOptionComboDisplayName) {
        this.attributeOptionComboDisplayName = attributeOptionComboDisplayName;
    }

    public ValidationResultView withAttributeOptionComboDisplayName(String attributeOptionComboDisplayName) {
        this.attributeOptionComboDisplayName = attributeOptionComboDisplayName;
        return this;
    }

    @JsonProperty("attributeOptionComboId")
    public Optional<String> getAttributeOptionComboId() {
        return Optional.ofNullable(attributeOptionComboId);
    }

    @JsonProperty("attributeOptionComboId")
    public void setAttributeOptionComboId(String attributeOptionComboId) {
        this.attributeOptionComboId = attributeOptionComboId;
    }

    public ValidationResultView withAttributeOptionComboId(String attributeOptionComboId) {
        this.attributeOptionComboId = attributeOptionComboId;
        return this;
    }

    @JsonProperty("importance")
    public Optional<String> getImportance() {
        return Optional.ofNullable(importance);
    }

    @JsonProperty("importance")
    public void setImportance(String importance) {
        this.importance = importance;
    }

    public ValidationResultView withImportance(String importance) {
        this.importance = importance;
        return this;
    }

    @JsonProperty("leftSideValue")
    public Optional<Double> getLeftSideValue() {
        return Optional.ofNullable(leftSideValue);
    }

    @JsonProperty("leftSideValue")
    public void setLeftSideValue(Double leftSideValue) {
        this.leftSideValue = leftSideValue;
    }

    public ValidationResultView withLeftSideValue(Double leftSideValue) {
        this.leftSideValue = leftSideValue;
        return this;
    }

    @JsonProperty("operator")
    public Optional<String> getOperator() {
        return Optional.ofNullable(operator);
    }

    @JsonProperty("operator")
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public ValidationResultView withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty("organisationUnitAncestorNames")
    public Optional<String> getOrganisationUnitAncestorNames() {
        return Optional.ofNullable(organisationUnitAncestorNames);
    }

    @JsonProperty("organisationUnitAncestorNames")
    public void setOrganisationUnitAncestorNames(String organisationUnitAncestorNames) {
        this.organisationUnitAncestorNames = organisationUnitAncestorNames;
    }

    public ValidationResultView withOrganisationUnitAncestorNames(String organisationUnitAncestorNames) {
        this.organisationUnitAncestorNames = organisationUnitAncestorNames;
        return this;
    }

    @JsonProperty("organisationUnitDisplayName")
    public Optional<String> getOrganisationUnitDisplayName() {
        return Optional.ofNullable(organisationUnitDisplayName);
    }

    @JsonProperty("organisationUnitDisplayName")
    public void setOrganisationUnitDisplayName(String organisationUnitDisplayName) {
        this.organisationUnitDisplayName = organisationUnitDisplayName;
    }

    public ValidationResultView withOrganisationUnitDisplayName(String organisationUnitDisplayName) {
        this.organisationUnitDisplayName = organisationUnitDisplayName;
        return this;
    }

    @JsonProperty("organisationUnitId")
    public Optional<String> getOrganisationUnitId() {
        return Optional.ofNullable(organisationUnitId);
    }

    @JsonProperty("organisationUnitId")
    public void setOrganisationUnitId(String organisationUnitId) {
        this.organisationUnitId = organisationUnitId;
    }

    public ValidationResultView withOrganisationUnitId(String organisationUnitId) {
        this.organisationUnitId = organisationUnitId;
        return this;
    }

    @JsonProperty("organisationUnitPath")
    public Optional<String> getOrganisationUnitPath() {
        return Optional.ofNullable(organisationUnitPath);
    }

    @JsonProperty("organisationUnitPath")
    public void setOrganisationUnitPath(String organisationUnitPath) {
        this.organisationUnitPath = organisationUnitPath;
    }

    public ValidationResultView withOrganisationUnitPath(String organisationUnitPath) {
        this.organisationUnitPath = organisationUnitPath;
        return this;
    }

    @JsonProperty("periodDisplayName")
    public Optional<String> getPeriodDisplayName() {
        return Optional.ofNullable(periodDisplayName);
    }

    @JsonProperty("periodDisplayName")
    public void setPeriodDisplayName(String periodDisplayName) {
        this.periodDisplayName = periodDisplayName;
    }

    public ValidationResultView withPeriodDisplayName(String periodDisplayName) {
        this.periodDisplayName = periodDisplayName;
        return this;
    }

    @JsonProperty("periodId")
    public Optional<String> getPeriodId() {
        return Optional.ofNullable(periodId);
    }

    @JsonProperty("periodId")
    public void setPeriodId(String periodId) {
        this.periodId = periodId;
    }

    public ValidationResultView withPeriodId(String periodId) {
        this.periodId = periodId;
        return this;
    }

    @JsonProperty("rightSideValue")
    public Optional<Double> getRightSideValue() {
        return Optional.ofNullable(rightSideValue);
    }

    @JsonProperty("rightSideValue")
    public void setRightSideValue(Double rightSideValue) {
        this.rightSideValue = rightSideValue;
    }

    public ValidationResultView withRightSideValue(Double rightSideValue) {
        this.rightSideValue = rightSideValue;
        return this;
    }

    @JsonProperty("validationRuleDescription")
    public Optional<String> getValidationRuleDescription() {
        return Optional.ofNullable(validationRuleDescription);
    }

    @JsonProperty("validationRuleDescription")
    public void setValidationRuleDescription(String validationRuleDescription) {
        this.validationRuleDescription = validationRuleDescription;
    }

    public ValidationResultView withValidationRuleDescription(String validationRuleDescription) {
        this.validationRuleDescription = validationRuleDescription;
        return this;
    }

    @JsonProperty("validationRuleId")
    public Optional<String> getValidationRuleId() {
        return Optional.ofNullable(validationRuleId);
    }

    @JsonProperty("validationRuleId")
    public void setValidationRuleId(String validationRuleId) {
        this.validationRuleId = validationRuleId;
    }

    public ValidationResultView withValidationRuleId(String validationRuleId) {
        this.validationRuleId = validationRuleId;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValidationResultView withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributeOptionComboDisplayName".equals(name)) {
            if (value instanceof String) {
                setAttributeOptionComboDisplayName(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"attributeOptionComboDisplayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeOptionComboId".equals(name)) {
                if (value instanceof String) {
                    setAttributeOptionComboId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionComboId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("importance".equals(name)) {
                    if (value instanceof String) {
                        setImportance(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"importance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("leftSideValue".equals(name)) {
                        if (value instanceof Double) {
                            setLeftSideValue(((Double) value));
                        } else {
                            throw new IllegalArgumentException(("property \"leftSideValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("operator".equals(name)) {
                            if (value instanceof String) {
                                setOperator(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"operator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("organisationUnitAncestorNames".equals(name)) {
                                if (value instanceof String) {
                                    setOrganisationUnitAncestorNames(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"organisationUnitAncestorNames\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("organisationUnitDisplayName".equals(name)) {
                                    if (value instanceof String) {
                                        setOrganisationUnitDisplayName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"organisationUnitDisplayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("organisationUnitId".equals(name)) {
                                        if (value instanceof String) {
                                            setOrganisationUnitId(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"organisationUnitId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("organisationUnitPath".equals(name)) {
                                            if (value instanceof String) {
                                                setOrganisationUnitPath(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"organisationUnitPath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("periodDisplayName".equals(name)) {
                                                if (value instanceof String) {
                                                    setPeriodDisplayName(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"periodDisplayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("periodId".equals(name)) {
                                                    if (value instanceof String) {
                                                        setPeriodId(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"periodId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("rightSideValue".equals(name)) {
                                                        if (value instanceof Double) {
                                                            setRightSideValue(((Double) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"rightSideValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("validationRuleDescription".equals(name)) {
                                                            if (value instanceof String) {
                                                                setValidationRuleDescription(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"validationRuleDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("validationRuleId".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setValidationRuleId(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"validationRuleId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                return false;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributeOptionComboDisplayName".equals(name)) {
            return getAttributeOptionComboDisplayName();
        } else {
            if ("attributeOptionComboId".equals(name)) {
                return getAttributeOptionComboId();
            } else {
                if ("importance".equals(name)) {
                    return getImportance();
                } else {
                    if ("leftSideValue".equals(name)) {
                        return getLeftSideValue();
                    } else {
                        if ("operator".equals(name)) {
                            return getOperator();
                        } else {
                            if ("organisationUnitAncestorNames".equals(name)) {
                                return getOrganisationUnitAncestorNames();
                            } else {
                                if ("organisationUnitDisplayName".equals(name)) {
                                    return getOrganisationUnitDisplayName();
                                } else {
                                    if ("organisationUnitId".equals(name)) {
                                        return getOrganisationUnitId();
                                    } else {
                                        if ("organisationUnitPath".equals(name)) {
                                            return getOrganisationUnitPath();
                                        } else {
                                            if ("periodDisplayName".equals(name)) {
                                                return getPeriodDisplayName();
                                            } else {
                                                if ("periodId".equals(name)) {
                                                    return getPeriodId();
                                                } else {
                                                    if ("rightSideValue".equals(name)) {
                                                        return getRightSideValue();
                                                    } else {
                                                        if ("validationRuleDescription".equals(name)) {
                                                            return getValidationRuleDescription();
                                                        } else {
                                                            if ("validationRuleId".equals(name)) {
                                                                return getValidationRuleId();
                                                            } else {
                                                                return notFoundValue;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValidationResultView.NOT_FOUND_VALUE);
        if (ValidationResultView.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValidationResultView with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidationResultView.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionComboDisplayName");
        sb.append('=');
        sb.append(((this.attributeOptionComboDisplayName == null)?"<null>":this.attributeOptionComboDisplayName));
        sb.append(',');
        sb.append("attributeOptionComboId");
        sb.append('=');
        sb.append(((this.attributeOptionComboId == null)?"<null>":this.attributeOptionComboId));
        sb.append(',');
        sb.append("importance");
        sb.append('=');
        sb.append(((this.importance == null)?"<null>":this.importance));
        sb.append(',');
        sb.append("leftSideValue");
        sb.append('=');
        sb.append(((this.leftSideValue == null)?"<null>":this.leftSideValue));
        sb.append(',');
        sb.append("operator");
        sb.append('=');
        sb.append(((this.operator == null)?"<null>":this.operator));
        sb.append(',');
        sb.append("organisationUnitAncestorNames");
        sb.append('=');
        sb.append(((this.organisationUnitAncestorNames == null)?"<null>":this.organisationUnitAncestorNames));
        sb.append(',');
        sb.append("organisationUnitDisplayName");
        sb.append('=');
        sb.append(((this.organisationUnitDisplayName == null)?"<null>":this.organisationUnitDisplayName));
        sb.append(',');
        sb.append("organisationUnitId");
        sb.append('=');
        sb.append(((this.organisationUnitId == null)?"<null>":this.organisationUnitId));
        sb.append(',');
        sb.append("organisationUnitPath");
        sb.append('=');
        sb.append(((this.organisationUnitPath == null)?"<null>":this.organisationUnitPath));
        sb.append(',');
        sb.append("periodDisplayName");
        sb.append('=');
        sb.append(((this.periodDisplayName == null)?"<null>":this.periodDisplayName));
        sb.append(',');
        sb.append("periodId");
        sb.append('=');
        sb.append(((this.periodId == null)?"<null>":this.periodId));
        sb.append(',');
        sb.append("rightSideValue");
        sb.append('=');
        sb.append(((this.rightSideValue == null)?"<null>":this.rightSideValue));
        sb.append(',');
        sb.append("validationRuleDescription");
        sb.append('=');
        sb.append(((this.validationRuleDescription == null)?"<null>":this.validationRuleDescription));
        sb.append(',');
        sb.append("validationRuleId");
        sb.append('=');
        sb.append(((this.validationRuleId == null)?"<null>":this.validationRuleId));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.periodId == null)? 0 :this.periodId.hashCode()));
        result = ((result* 31)+((this.organisationUnitPath == null)? 0 :this.organisationUnitPath.hashCode()));
        result = ((result* 31)+((this.validationRuleId == null)? 0 :this.validationRuleId.hashCode()));
        result = ((result* 31)+((this.importance == null)? 0 :this.importance.hashCode()));
        result = ((result* 31)+((this.attributeOptionComboId == null)? 0 :this.attributeOptionComboId.hashCode()));
        result = ((result* 31)+((this.operator == null)? 0 :this.operator.hashCode()));
        result = ((result* 31)+((this.organisationUnitAncestorNames == null)? 0 :this.organisationUnitAncestorNames.hashCode()));
        result = ((result* 31)+((this.leftSideValue == null)? 0 :this.leftSideValue.hashCode()));
        result = ((result* 31)+((this.organisationUnitDisplayName == null)? 0 :this.organisationUnitDisplayName.hashCode()));
        result = ((result* 31)+((this.organisationUnitId == null)? 0 :this.organisationUnitId.hashCode()));
        result = ((result* 31)+((this.validationRuleDescription == null)? 0 :this.validationRuleDescription.hashCode()));
        result = ((result* 31)+((this.rightSideValue == null)? 0 :this.rightSideValue.hashCode()));
        result = ((result* 31)+((this.periodDisplayName == null)? 0 :this.periodDisplayName.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.attributeOptionComboDisplayName == null)? 0 :this.attributeOptionComboDisplayName.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValidationResultView) == false) {
            return false;
        }
        ValidationResultView rhs = ((ValidationResultView) other);
        return ((((((((((((((((this.periodId == rhs.periodId)||((this.periodId!= null)&&this.periodId.equals(rhs.periodId)))&&((this.organisationUnitPath == rhs.organisationUnitPath)||((this.organisationUnitPath!= null)&&this.organisationUnitPath.equals(rhs.organisationUnitPath))))&&((this.validationRuleId == rhs.validationRuleId)||((this.validationRuleId!= null)&&this.validationRuleId.equals(rhs.validationRuleId))))&&((this.importance == rhs.importance)||((this.importance!= null)&&this.importance.equals(rhs.importance))))&&((this.attributeOptionComboId == rhs.attributeOptionComboId)||((this.attributeOptionComboId!= null)&&this.attributeOptionComboId.equals(rhs.attributeOptionComboId))))&&((this.operator == rhs.operator)||((this.operator!= null)&&this.operator.equals(rhs.operator))))&&((this.organisationUnitAncestorNames == rhs.organisationUnitAncestorNames)||((this.organisationUnitAncestorNames!= null)&&this.organisationUnitAncestorNames.equals(rhs.organisationUnitAncestorNames))))&&((this.leftSideValue == rhs.leftSideValue)||((this.leftSideValue!= null)&&this.leftSideValue.equals(rhs.leftSideValue))))&&((this.organisationUnitDisplayName == rhs.organisationUnitDisplayName)||((this.organisationUnitDisplayName!= null)&&this.organisationUnitDisplayName.equals(rhs.organisationUnitDisplayName))))&&((this.organisationUnitId == rhs.organisationUnitId)||((this.organisationUnitId!= null)&&this.organisationUnitId.equals(rhs.organisationUnitId))))&&((this.validationRuleDescription == rhs.validationRuleDescription)||((this.validationRuleDescription!= null)&&this.validationRuleDescription.equals(rhs.validationRuleDescription))))&&((this.rightSideValue == rhs.rightSideValue)||((this.rightSideValue!= null)&&this.rightSideValue.equals(rhs.rightSideValue))))&&((this.periodDisplayName == rhs.periodDisplayName)||((this.periodDisplayName!= null)&&this.periodDisplayName.equals(rhs.periodDisplayName))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.attributeOptionComboDisplayName == rhs.attributeOptionComboDisplayName)||((this.attributeOptionComboDisplayName!= null)&&this.attributeOptionComboDisplayName.equals(rhs.attributeOptionComboDisplayName))));
    }

}
