
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "baseLineLabel",
    "categoryAxisLabel",
    "horizontalAxisTitle",
    "legend",
    "seriesAxisLabel",
    "targetLineLabel",
    "verticalAxisTitle",
    "visualizationSubtitle",
    "visualizationTitle"
})
@Generated("jsonschema2pojo")
public class VisualizationFontStyle implements Serializable
{

    @JsonProperty("baseLineLabel")
    private FontStyle baseLineLabel;
    @JsonProperty("categoryAxisLabel")
    private FontStyle categoryAxisLabel;
    @JsonProperty("horizontalAxisTitle")
    private FontStyle horizontalAxisTitle;
    @JsonProperty("legend")
    private FontStyle legend;
    @JsonProperty("seriesAxisLabel")
    private FontStyle seriesAxisLabel;
    @JsonProperty("targetLineLabel")
    private FontStyle targetLineLabel;
    @JsonProperty("verticalAxisTitle")
    private FontStyle verticalAxisTitle;
    @JsonProperty("visualizationSubtitle")
    private FontStyle visualizationSubtitle;
    @JsonProperty("visualizationTitle")
    private FontStyle visualizationTitle;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8817412689450829469L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public VisualizationFontStyle() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public VisualizationFontStyle(VisualizationFontStyle source) {
        super();
        this.baseLineLabel = source.baseLineLabel;
        this.categoryAxisLabel = source.categoryAxisLabel;
        this.horizontalAxisTitle = source.horizontalAxisTitle;
        this.legend = source.legend;
        this.seriesAxisLabel = source.seriesAxisLabel;
        this.targetLineLabel = source.targetLineLabel;
        this.verticalAxisTitle = source.verticalAxisTitle;
        this.visualizationSubtitle = source.visualizationSubtitle;
        this.visualizationTitle = source.visualizationTitle;
    }

    public VisualizationFontStyle(FontStyle baseLineLabel, FontStyle categoryAxisLabel, FontStyle horizontalAxisTitle, FontStyle legend, FontStyle seriesAxisLabel, FontStyle targetLineLabel, FontStyle verticalAxisTitle, FontStyle visualizationSubtitle, FontStyle visualizationTitle) {
        super();
        this.baseLineLabel = baseLineLabel;
        this.categoryAxisLabel = categoryAxisLabel;
        this.horizontalAxisTitle = horizontalAxisTitle;
        this.legend = legend;
        this.seriesAxisLabel = seriesAxisLabel;
        this.targetLineLabel = targetLineLabel;
        this.verticalAxisTitle = verticalAxisTitle;
        this.visualizationSubtitle = visualizationSubtitle;
        this.visualizationTitle = visualizationTitle;
    }

    @JsonProperty("baseLineLabel")
    public Optional<FontStyle> getBaseLineLabel() {
        return Optional.ofNullable(baseLineLabel);
    }

    @JsonProperty("baseLineLabel")
    public void setBaseLineLabel(FontStyle baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
    }

    public VisualizationFontStyle withBaseLineLabel(FontStyle baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
        return this;
    }

    @JsonProperty("categoryAxisLabel")
    public Optional<FontStyle> getCategoryAxisLabel() {
        return Optional.ofNullable(categoryAxisLabel);
    }

    @JsonProperty("categoryAxisLabel")
    public void setCategoryAxisLabel(FontStyle categoryAxisLabel) {
        this.categoryAxisLabel = categoryAxisLabel;
    }

    public VisualizationFontStyle withCategoryAxisLabel(FontStyle categoryAxisLabel) {
        this.categoryAxisLabel = categoryAxisLabel;
        return this;
    }

    @JsonProperty("horizontalAxisTitle")
    public Optional<FontStyle> getHorizontalAxisTitle() {
        return Optional.ofNullable(horizontalAxisTitle);
    }

    @JsonProperty("horizontalAxisTitle")
    public void setHorizontalAxisTitle(FontStyle horizontalAxisTitle) {
        this.horizontalAxisTitle = horizontalAxisTitle;
    }

    public VisualizationFontStyle withHorizontalAxisTitle(FontStyle horizontalAxisTitle) {
        this.horizontalAxisTitle = horizontalAxisTitle;
        return this;
    }

    @JsonProperty("legend")
    public Optional<FontStyle> getLegend() {
        return Optional.ofNullable(legend);
    }

    @JsonProperty("legend")
    public void setLegend(FontStyle legend) {
        this.legend = legend;
    }

    public VisualizationFontStyle withLegend(FontStyle legend) {
        this.legend = legend;
        return this;
    }

    @JsonProperty("seriesAxisLabel")
    public Optional<FontStyle> getSeriesAxisLabel() {
        return Optional.ofNullable(seriesAxisLabel);
    }

    @JsonProperty("seriesAxisLabel")
    public void setSeriesAxisLabel(FontStyle seriesAxisLabel) {
        this.seriesAxisLabel = seriesAxisLabel;
    }

    public VisualizationFontStyle withSeriesAxisLabel(FontStyle seriesAxisLabel) {
        this.seriesAxisLabel = seriesAxisLabel;
        return this;
    }

    @JsonProperty("targetLineLabel")
    public Optional<FontStyle> getTargetLineLabel() {
        return Optional.ofNullable(targetLineLabel);
    }

    @JsonProperty("targetLineLabel")
    public void setTargetLineLabel(FontStyle targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
    }

    public VisualizationFontStyle withTargetLineLabel(FontStyle targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
        return this;
    }

    @JsonProperty("verticalAxisTitle")
    public Optional<FontStyle> getVerticalAxisTitle() {
        return Optional.ofNullable(verticalAxisTitle);
    }

    @JsonProperty("verticalAxisTitle")
    public void setVerticalAxisTitle(FontStyle verticalAxisTitle) {
        this.verticalAxisTitle = verticalAxisTitle;
    }

    public VisualizationFontStyle withVerticalAxisTitle(FontStyle verticalAxisTitle) {
        this.verticalAxisTitle = verticalAxisTitle;
        return this;
    }

    @JsonProperty("visualizationSubtitle")
    public Optional<FontStyle> getVisualizationSubtitle() {
        return Optional.ofNullable(visualizationSubtitle);
    }

    @JsonProperty("visualizationSubtitle")
    public void setVisualizationSubtitle(FontStyle visualizationSubtitle) {
        this.visualizationSubtitle = visualizationSubtitle;
    }

    public VisualizationFontStyle withVisualizationSubtitle(FontStyle visualizationSubtitle) {
        this.visualizationSubtitle = visualizationSubtitle;
        return this;
    }

    @JsonProperty("visualizationTitle")
    public Optional<FontStyle> getVisualizationTitle() {
        return Optional.ofNullable(visualizationTitle);
    }

    @JsonProperty("visualizationTitle")
    public void setVisualizationTitle(FontStyle visualizationTitle) {
        this.visualizationTitle = visualizationTitle;
    }

    public VisualizationFontStyle withVisualizationTitle(FontStyle visualizationTitle) {
        this.visualizationTitle = visualizationTitle;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public VisualizationFontStyle withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("baseLineLabel".equals(name)) {
            if (value instanceof FontStyle) {
                setBaseLineLabel(((FontStyle) value));
            } else {
                throw new IllegalArgumentException(("property \"baseLineLabel\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("categoryAxisLabel".equals(name)) {
                if (value instanceof FontStyle) {
                    setCategoryAxisLabel(((FontStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryAxisLabel\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("horizontalAxisTitle".equals(name)) {
                    if (value instanceof FontStyle) {
                        setHorizontalAxisTitle(((FontStyle) value));
                    } else {
                        throw new IllegalArgumentException(("property \"horizontalAxisTitle\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("legend".equals(name)) {
                        if (value instanceof FontStyle) {
                            setLegend(((FontStyle) value));
                        } else {
                            throw new IllegalArgumentException(("property \"legend\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("seriesAxisLabel".equals(name)) {
                            if (value instanceof FontStyle) {
                                setSeriesAxisLabel(((FontStyle) value));
                            } else {
                                throw new IllegalArgumentException(("property \"seriesAxisLabel\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("targetLineLabel".equals(name)) {
                                if (value instanceof FontStyle) {
                                    setTargetLineLabel(((FontStyle) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"targetLineLabel\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("verticalAxisTitle".equals(name)) {
                                    if (value instanceof FontStyle) {
                                        setVerticalAxisTitle(((FontStyle) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"verticalAxisTitle\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("visualizationSubtitle".equals(name)) {
                                        if (value instanceof FontStyle) {
                                            setVisualizationSubtitle(((FontStyle) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"visualizationSubtitle\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("visualizationTitle".equals(name)) {
                                            if (value instanceof FontStyle) {
                                                setVisualizationTitle(((FontStyle) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"visualizationTitle\" is of type \"org.hisp.dhis.api.model.v40_0.FontStyle\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("baseLineLabel".equals(name)) {
            return getBaseLineLabel();
        } else {
            if ("categoryAxisLabel".equals(name)) {
                return getCategoryAxisLabel();
            } else {
                if ("horizontalAxisTitle".equals(name)) {
                    return getHorizontalAxisTitle();
                } else {
                    if ("legend".equals(name)) {
                        return getLegend();
                    } else {
                        if ("seriesAxisLabel".equals(name)) {
                            return getSeriesAxisLabel();
                        } else {
                            if ("targetLineLabel".equals(name)) {
                                return getTargetLineLabel();
                            } else {
                                if ("verticalAxisTitle".equals(name)) {
                                    return getVerticalAxisTitle();
                                } else {
                                    if ("visualizationSubtitle".equals(name)) {
                                        return getVisualizationSubtitle();
                                    } else {
                                        if ("visualizationTitle".equals(name)) {
                                            return getVisualizationTitle();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, VisualizationFontStyle.NOT_FOUND_VALUE);
        if (VisualizationFontStyle.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public VisualizationFontStyle with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VisualizationFontStyle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("baseLineLabel");
        sb.append('=');
        sb.append(((this.baseLineLabel == null)?"<null>":this.baseLineLabel));
        sb.append(',');
        sb.append("categoryAxisLabel");
        sb.append('=');
        sb.append(((this.categoryAxisLabel == null)?"<null>":this.categoryAxisLabel));
        sb.append(',');
        sb.append("horizontalAxisTitle");
        sb.append('=');
        sb.append(((this.horizontalAxisTitle == null)?"<null>":this.horizontalAxisTitle));
        sb.append(',');
        sb.append("legend");
        sb.append('=');
        sb.append(((this.legend == null)?"<null>":this.legend));
        sb.append(',');
        sb.append("seriesAxisLabel");
        sb.append('=');
        sb.append(((this.seriesAxisLabel == null)?"<null>":this.seriesAxisLabel));
        sb.append(',');
        sb.append("targetLineLabel");
        sb.append('=');
        sb.append(((this.targetLineLabel == null)?"<null>":this.targetLineLabel));
        sb.append(',');
        sb.append("verticalAxisTitle");
        sb.append('=');
        sb.append(((this.verticalAxisTitle == null)?"<null>":this.verticalAxisTitle));
        sb.append(',');
        sb.append("visualizationSubtitle");
        sb.append('=');
        sb.append(((this.visualizationSubtitle == null)?"<null>":this.visualizationSubtitle));
        sb.append(',');
        sb.append("visualizationTitle");
        sb.append('=');
        sb.append(((this.visualizationTitle == null)?"<null>":this.visualizationTitle));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.categoryAxisLabel == null)? 0 :this.categoryAxisLabel.hashCode()));
        result = ((result* 31)+((this.baseLineLabel == null)? 0 :this.baseLineLabel.hashCode()));
        result = ((result* 31)+((this.horizontalAxisTitle == null)? 0 :this.horizontalAxisTitle.hashCode()));
        result = ((result* 31)+((this.legend == null)? 0 :this.legend.hashCode()));
        result = ((result* 31)+((this.targetLineLabel == null)? 0 :this.targetLineLabel.hashCode()));
        result = ((result* 31)+((this.visualizationSubtitle == null)? 0 :this.visualizationSubtitle.hashCode()));
        result = ((result* 31)+((this.seriesAxisLabel == null)? 0 :this.seriesAxisLabel.hashCode()));
        result = ((result* 31)+((this.verticalAxisTitle == null)? 0 :this.verticalAxisTitle.hashCode()));
        result = ((result* 31)+((this.visualizationTitle == null)? 0 :this.visualizationTitle.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof VisualizationFontStyle) == false) {
            return false;
        }
        VisualizationFontStyle rhs = ((VisualizationFontStyle) other);
        return (((((((((((this.categoryAxisLabel == rhs.categoryAxisLabel)||((this.categoryAxisLabel!= null)&&this.categoryAxisLabel.equals(rhs.categoryAxisLabel)))&&((this.baseLineLabel == rhs.baseLineLabel)||((this.baseLineLabel!= null)&&this.baseLineLabel.equals(rhs.baseLineLabel))))&&((this.horizontalAxisTitle == rhs.horizontalAxisTitle)||((this.horizontalAxisTitle!= null)&&this.horizontalAxisTitle.equals(rhs.horizontalAxisTitle))))&&((this.legend == rhs.legend)||((this.legend!= null)&&this.legend.equals(rhs.legend))))&&((this.targetLineLabel == rhs.targetLineLabel)||((this.targetLineLabel!= null)&&this.targetLineLabel.equals(rhs.targetLineLabel))))&&((this.visualizationSubtitle == rhs.visualizationSubtitle)||((this.visualizationSubtitle!= null)&&this.visualizationSubtitle.equals(rhs.visualizationSubtitle))))&&((this.seriesAxisLabel == rhs.seriesAxisLabel)||((this.seriesAxisLabel!= null)&&this.seriesAxisLabel.equals(rhs.seriesAxisLabel))))&&((this.verticalAxisTitle == rhs.verticalAxisTitle)||((this.verticalAxisTitle!= null)&&this.verticalAxisTitle.equals(rhs.verticalAxisTitle))))&&((this.visualizationTitle == rhs.visualizationTitle)||((this.visualizationTitle!= null)&&this.visualizationTitle.equals(rhs.visualizationTitle))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
