
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "aoc",
    "level",
    "ou",
    "ouName",
    "pe",
    "permissions",
    "state",
    "wf"
})
@Generated("jsonschema2pojo")
public class ApprovalStatusDto implements Serializable
{

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("aoc")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String aoc;
    @JsonProperty("level")
    private String level;
    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("ou")
    @JsonPropertyDescription("A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String ou;
    @JsonProperty("ouName")
    private String ouName;
    @JsonProperty("pe")
    private String pe;
    @JsonProperty("permissions")
    private DataApprovalPermissions permissions;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("state")
    private ApprovalStatusDto.StateRef state;
    /**
     * A UID for an DataApprovalWorkflow object  
     * (Java name `org.hisp.dhis.dataapproval.DataApprovalWorkflow`)
     * 
     */
    @JsonProperty("wf")
    @JsonPropertyDescription("A UID for an DataApprovalWorkflow object  \n(Java name `org.hisp.dhis.dataapproval.DataApprovalWorkflow`)")
    private String wf;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -138559521257132406L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApprovalStatusDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ApprovalStatusDto(ApprovalStatusDto source) {
        super();
        this.aoc = source.aoc;
        this.level = source.level;
        this.ou = source.ou;
        this.ouName = source.ouName;
        this.pe = source.pe;
        this.permissions = source.permissions;
        this.state = source.state;
        this.wf = source.wf;
    }

    /**
     * 
     * @param aoc
     *     A UID for an CategoryOptionCombo object  
     *     (Java name `org.hisp.dhis.category.CategoryOptionCombo`).
     * @param ou
     *     A UID for an OrganisationUnit object  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`).
     * @param wf
     *     A UID for an DataApprovalWorkflow object  
     *     (Java name `org.hisp.dhis.dataapproval.DataApprovalWorkflow`).
     */
    public ApprovalStatusDto(String aoc, String level, String ou, String ouName, String pe, DataApprovalPermissions permissions, ApprovalStatusDto.StateRef state, String wf) {
        super();
        this.aoc = aoc;
        this.level = level;
        this.ou = ou;
        this.ouName = ouName;
        this.pe = pe;
        this.permissions = permissions;
        this.state = state;
        this.wf = wf;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("aoc")
    public Optional<String> getAoc() {
        return Optional.ofNullable(aoc);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("aoc")
    public void setAoc(String aoc) {
        this.aoc = aoc;
    }

    public ApprovalStatusDto withAoc(String aoc) {
        this.aoc = aoc;
        return this;
    }

    @JsonProperty("level")
    public Optional<String> getLevel() {
        return Optional.ofNullable(level);
    }

    @JsonProperty("level")
    public void setLevel(String level) {
        this.level = level;
    }

    public ApprovalStatusDto withLevel(String level) {
        this.level = level;
        return this;
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("ou")
    public Optional<String> getOu() {
        return Optional.ofNullable(ou);
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("ou")
    public void setOu(String ou) {
        this.ou = ou;
    }

    public ApprovalStatusDto withOu(String ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("ouName")
    public Optional<String> getOuName() {
        return Optional.ofNullable(ouName);
    }

    @JsonProperty("ouName")
    public void setOuName(String ouName) {
        this.ouName = ouName;
    }

    public ApprovalStatusDto withOuName(String ouName) {
        this.ouName = ouName;
        return this;
    }

    @JsonProperty("pe")
    public Optional<String> getPe() {
        return Optional.ofNullable(pe);
    }

    @JsonProperty("pe")
    public void setPe(String pe) {
        this.pe = pe;
    }

    public ApprovalStatusDto withPe(String pe) {
        this.pe = pe;
        return this;
    }

    @JsonProperty("permissions")
    public Optional<DataApprovalPermissions> getPermissions() {
        return Optional.ofNullable(permissions);
    }

    @JsonProperty("permissions")
    public void setPermissions(DataApprovalPermissions permissions) {
        this.permissions = permissions;
    }

    public ApprovalStatusDto withPermissions(DataApprovalPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("state")
    public ApprovalStatusDto.StateRef getState() {
        return state;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("state")
    public void setState(ApprovalStatusDto.StateRef state) {
        this.state = state;
    }

    public ApprovalStatusDto withState(ApprovalStatusDto.StateRef state) {
        this.state = state;
        return this;
    }

    /**
     * A UID for an DataApprovalWorkflow object  
     * (Java name `org.hisp.dhis.dataapproval.DataApprovalWorkflow`)
     * 
     */
    @JsonProperty("wf")
    public Optional<String> getWf() {
        return Optional.ofNullable(wf);
    }

    /**
     * A UID for an DataApprovalWorkflow object  
     * (Java name `org.hisp.dhis.dataapproval.DataApprovalWorkflow`)
     * 
     */
    @JsonProperty("wf")
    public void setWf(String wf) {
        this.wf = wf;
    }

    public ApprovalStatusDto withWf(String wf) {
        this.wf = wf;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ApprovalStatusDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("aoc".equals(name)) {
            if (value instanceof String) {
                setAoc(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"aoc\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("level".equals(name)) {
                if (value instanceof String) {
                    setLevel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"level\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("ou".equals(name)) {
                    if (value instanceof String) {
                        setOu(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"ou\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("ouName".equals(name)) {
                        if (value instanceof String) {
                            setOuName(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"ouName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("pe".equals(name)) {
                            if (value instanceof String) {
                                setPe(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"pe\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("permissions".equals(name)) {
                                if (value instanceof DataApprovalPermissions) {
                                    setPermissions(((DataApprovalPermissions) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"permissions\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataApprovalPermissions\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("state".equals(name)) {
                                    if (value instanceof ApprovalStatusDto.StateRef) {
                                        setState(((ApprovalStatusDto.StateRef) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"state\" is of type \"org.hisp.dhis.api.model.v40_2_2.ApprovalStatusDto.StateRef\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("wf".equals(name)) {
                                        if (value instanceof String) {
                                            setWf(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"wf\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("aoc".equals(name)) {
            return getAoc();
        } else {
            if ("level".equals(name)) {
                return getLevel();
            } else {
                if ("ou".equals(name)) {
                    return getOu();
                } else {
                    if ("ouName".equals(name)) {
                        return getOuName();
                    } else {
                        if ("pe".equals(name)) {
                            return getPe();
                        } else {
                            if ("permissions".equals(name)) {
                                return getPermissions();
                            } else {
                                if ("state".equals(name)) {
                                    return getState();
                                } else {
                                    if ("wf".equals(name)) {
                                        return getWf();
                                    } else {
                                        return notFoundValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ApprovalStatusDto.NOT_FOUND_VALUE);
        if (ApprovalStatusDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ApprovalStatusDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApprovalStatusDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aoc");
        sb.append('=');
        sb.append(((this.aoc == null)?"<null>":this.aoc));
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(((this.level == null)?"<null>":this.level));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("ouName");
        sb.append('=');
        sb.append(((this.ouName == null)?"<null>":this.ouName));
        sb.append(',');
        sb.append("pe");
        sb.append('=');
        sb.append(((this.pe == null)?"<null>":this.pe));
        sb.append(',');
        sb.append("permissions");
        sb.append('=');
        sb.append(((this.permissions == null)?"<null>":this.permissions));
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(((this.state == null)?"<null>":this.state));
        sb.append(',');
        sb.append("wf");
        sb.append('=');
        sb.append(((this.wf == null)?"<null>":this.wf));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.aoc == null)? 0 :this.aoc.hashCode()));
        result = ((result* 31)+((this.level == null)? 0 :this.level.hashCode()));
        result = ((result* 31)+((this.pe == null)? 0 :this.pe.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.permissions == null)? 0 :this.permissions.hashCode()));
        result = ((result* 31)+((this.state == null)? 0 :this.state.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ouName == null)? 0 :this.ouName.hashCode()));
        result = ((result* 31)+((this.wf == null)? 0 :this.wf.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ApprovalStatusDto) == false) {
            return false;
        }
        ApprovalStatusDto rhs = ((ApprovalStatusDto) other);
        return ((((((((((this.aoc == rhs.aoc)||((this.aoc!= null)&&this.aoc.equals(rhs.aoc)))&&((this.level == rhs.level)||((this.level!= null)&&this.level.equals(rhs.level))))&&((this.pe == rhs.pe)||((this.pe!= null)&&this.pe.equals(rhs.pe))))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.permissions == rhs.permissions)||((this.permissions!= null)&&this.permissions.equals(rhs.permissions))))&&((this.state == rhs.state)||((this.state!= null)&&this.state.equals(rhs.state))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.ouName == rhs.ouName)||((this.ouName!= null)&&this.ouName.equals(rhs.ouName))))&&((this.wf == rhs.wf)||((this.wf!= null)&&this.wf.equals(rhs.wf))));
    }

    @Generated("jsonschema2pojo")
    public enum StateRef {

        UNAPPROVABLE("UNAPPROVABLE"),
        UNAPPROVED_ABOVE("UNAPPROVED_ABOVE"),
        UNAPPROVED_WAITING("UNAPPROVED_WAITING"),
        UNAPPROVED_READY("UNAPPROVED_READY"),
        APPROVED_ABOVE("APPROVED_ABOVE"),
        APPROVED_HERE("APPROVED_HERE"),
        ACCEPTED_HERE("ACCEPTED_HERE");
        private final String value;
        private final static Map<String, ApprovalStatusDto.StateRef> CONSTANTS = new HashMap<String, ApprovalStatusDto.StateRef>();

        static {
            for (ApprovalStatusDto.StateRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StateRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ApprovalStatusDto.StateRef fromValue(String value) {
            ApprovalStatusDto.StateRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
