
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "code",
    "createdAt",
    "displayName",
    "storedBy",
    "updatedAt",
    "value",
    "valueType"
})
@Generated("jsonschema2pojo")
public class AttributeInfo implements Serializable
{

    @JsonProperty("attribute")
    private String attribute;
    @JsonProperty("code")
    private String code;
    @JsonProperty("createdAt")
    private Object createdAt;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("updatedAt")
    private Object updatedAt;
    @JsonProperty("value")
    private String value;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private AttributeInfo.ValueTypeRef valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3841433620179749441L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AttributeInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public AttributeInfo(AttributeInfo source) {
        super();
        this.attribute = source.attribute;
        this.code = source.code;
        this.createdAt = source.createdAt;
        this.displayName = source.displayName;
        this.storedBy = source.storedBy;
        this.updatedAt = source.updatedAt;
        this.value = source.value;
        this.valueType = source.valueType;
    }

    public AttributeInfo(String attribute, String code, Object createdAt, String displayName, String storedBy, Object updatedAt, String value, AttributeInfo.ValueTypeRef valueType) {
        super();
        this.attribute = attribute;
        this.code = code;
        this.createdAt = createdAt;
        this.displayName = displayName;
        this.storedBy = storedBy;
        this.updatedAt = updatedAt;
        this.value = value;
        this.valueType = valueType;
    }

    @JsonProperty("attribute")
    public Optional<String> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public AttributeInfo withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public AttributeInfo withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("createdAt")
    public Optional<Object> getCreatedAt() {
        return Optional.ofNullable(createdAt);
    }

    @JsonProperty("createdAt")
    public void setCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
    }

    public AttributeInfo withCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AttributeInfo withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public AttributeInfo withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("updatedAt")
    public Optional<Object> getUpdatedAt() {
        return Optional.ofNullable(updatedAt);
    }

    @JsonProperty("updatedAt")
    public void setUpdatedAt(Object updatedAt) {
        this.updatedAt = updatedAt;
    }

    public AttributeInfo withUpdatedAt(Object updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public AttributeInfo withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public AttributeInfo.ValueTypeRef getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(AttributeInfo.ValueTypeRef valueType) {
        this.valueType = valueType;
    }

    public AttributeInfo withValueType(AttributeInfo.ValueTypeRef valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AttributeInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (value instanceof String) {
                setAttribute(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("code".equals(name)) {
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("createdAt".equals(name)) {
                    if (value instanceof Object) {
                        setCreatedAt(((Object) value));
                    } else {
                        throw new IllegalArgumentException(("property \"createdAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("displayName".equals(name)) {
                        if (value instanceof String) {
                            setDisplayName(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("storedBy".equals(name)) {
                            if (value instanceof String) {
                                setStoredBy(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("updatedAt".equals(name)) {
                                if (value instanceof Object) {
                                    setUpdatedAt(((Object) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"updatedAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("value".equals(name)) {
                                    if (value instanceof String) {
                                        setValue(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("valueType".equals(name)) {
                                        if (value instanceof AttributeInfo.ValueTypeRef) {
                                            setValueType(((AttributeInfo.ValueTypeRef) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_2_2.AttributeInfo.ValueTypeRef\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return getAttribute();
        } else {
            if ("code".equals(name)) {
                return getCode();
            } else {
                if ("createdAt".equals(name)) {
                    return getCreatedAt();
                } else {
                    if ("displayName".equals(name)) {
                        return getDisplayName();
                    } else {
                        if ("storedBy".equals(name)) {
                            return getStoredBy();
                        } else {
                            if ("updatedAt".equals(name)) {
                                return getUpdatedAt();
                            } else {
                                if ("value".equals(name)) {
                                    return getValue();
                                } else {
                                    if ("valueType".equals(name)) {
                                        return getValueType();
                                    } else {
                                        return notFoundValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AttributeInfo.NOT_FOUND_VALUE);
        if (AttributeInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AttributeInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AttributeInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(((this.createdAt == null)?"<null>":this.createdAt));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(((this.updatedAt == null)?"<null>":this.updatedAt));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.createdAt == null)? 0 :this.createdAt.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.updatedAt == null)? 0 :this.updatedAt.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AttributeInfo) == false) {
            return false;
        }
        AttributeInfo rhs = ((AttributeInfo) other);
        return ((((((((((this.createdAt == rhs.createdAt)||((this.createdAt!= null)&&this.createdAt.equals(rhs.createdAt)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.updatedAt == rhs.updatedAt)||((this.updatedAt!= null)&&this.updatedAt.equals(rhs.updatedAt))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueTypeRef {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, AttributeInfo.ValueTypeRef> CONSTANTS = new HashMap<String, AttributeInfo.ValueTypeRef>();

        static {
            for (AttributeInfo.ValueTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AttributeInfo.ValueTypeRef fromValue(String value) {
            AttributeInfo.ValueTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
