
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "baseLine",
    "decimals",
    "index",
    "label",
    "maxValue",
    "minValue",
    "steps",
    "targetLine",
    "title",
    "type"
})
@Generated("jsonschema2pojo")
public class AxisV2 implements Serializable
{

    @JsonProperty("baseLine")
    private Line baseLine;
    @JsonProperty("decimals")
    private Integer decimals;
    @JsonProperty("index")
    private Integer index;
    @JsonProperty("label")
    private StyledObject label;
    @JsonProperty("maxValue")
    private Double maxValue;
    @JsonProperty("minValue")
    private Double minValue;
    @JsonProperty("steps")
    private Integer steps;
    @JsonProperty("targetLine")
    private Line targetLine;
    @JsonProperty("title")
    private StyledObject title;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private AxisV2 .TypeRef type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3521237163256551919L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AxisV2() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public AxisV2(AxisV2 source) {
        super();
        this.baseLine = source.baseLine;
        this.decimals = source.decimals;
        this.index = source.index;
        this.label = source.label;
        this.maxValue = source.maxValue;
        this.minValue = source.minValue;
        this.steps = source.steps;
        this.targetLine = source.targetLine;
        this.title = source.title;
        this.type = source.type;
    }

    public AxisV2(Line baseLine, Integer decimals, Integer index, StyledObject label, Double maxValue, Double minValue, Integer steps, Line targetLine, StyledObject title, AxisV2 .TypeRef type) {
        super();
        this.baseLine = baseLine;
        this.decimals = decimals;
        this.index = index;
        this.label = label;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.steps = steps;
        this.targetLine = targetLine;
        this.title = title;
        this.type = type;
    }

    @JsonProperty("baseLine")
    public Optional<Line> getBaseLine() {
        return Optional.ofNullable(baseLine);
    }

    @JsonProperty("baseLine")
    public void setBaseLine(Line baseLine) {
        this.baseLine = baseLine;
    }

    public AxisV2 withBaseLine(Line baseLine) {
        this.baseLine = baseLine;
        return this;
    }

    @JsonProperty("decimals")
    public Optional<Integer> getDecimals() {
        return Optional.ofNullable(decimals);
    }

    @JsonProperty("decimals")
    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public AxisV2 withDecimals(Integer decimals) {
        this.decimals = decimals;
        return this;
    }

    @JsonProperty("index")
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    @JsonProperty("index")
    public void setIndex(Integer index) {
        this.index = index;
    }

    public AxisV2 withIndex(Integer index) {
        this.index = index;
        return this;
    }

    @JsonProperty("label")
    public Optional<StyledObject> getLabel() {
        return Optional.ofNullable(label);
    }

    @JsonProperty("label")
    public void setLabel(StyledObject label) {
        this.label = label;
    }

    public AxisV2 withLabel(StyledObject label) {
        this.label = label;
        return this;
    }

    @JsonProperty("maxValue")
    public Optional<Double> getMaxValue() {
        return Optional.ofNullable(maxValue);
    }

    @JsonProperty("maxValue")
    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public AxisV2 withMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @JsonProperty("minValue")
    public Optional<Double> getMinValue() {
        return Optional.ofNullable(minValue);
    }

    @JsonProperty("minValue")
    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public AxisV2 withMinValue(Double minValue) {
        this.minValue = minValue;
        return this;
    }

    @JsonProperty("steps")
    public Optional<Integer> getSteps() {
        return Optional.ofNullable(steps);
    }

    @JsonProperty("steps")
    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public AxisV2 withSteps(Integer steps) {
        this.steps = steps;
        return this;
    }

    @JsonProperty("targetLine")
    public Optional<Line> getTargetLine() {
        return Optional.ofNullable(targetLine);
    }

    @JsonProperty("targetLine")
    public void setTargetLine(Line targetLine) {
        this.targetLine = targetLine;
    }

    public AxisV2 withTargetLine(Line targetLine) {
        this.targetLine = targetLine;
        return this;
    }

    @JsonProperty("title")
    public Optional<StyledObject> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(StyledObject title) {
        this.title = title;
    }

    public AxisV2 withTitle(StyledObject title) {
        this.title = title;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public AxisV2 .TypeRef getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(AxisV2 .TypeRef type) {
        this.type = type;
    }

    public AxisV2 withType(AxisV2 .TypeRef type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AxisV2 withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("baseLine".equals(name)) {
            if (value instanceof Line) {
                setBaseLine(((Line) value));
            } else {
                throw new IllegalArgumentException(("property \"baseLine\" is of type \"org.hisp.dhis.api.model.v40_2_2.Line\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("decimals".equals(name)) {
                if (value instanceof Integer) {
                    setDecimals(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"decimals\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("index".equals(name)) {
                    if (value instanceof Integer) {
                        setIndex(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"index\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("label".equals(name)) {
                        if (value instanceof StyledObject) {
                            setLabel(((StyledObject) value));
                        } else {
                            throw new IllegalArgumentException(("property \"label\" is of type \"org.hisp.dhis.api.model.v40_2_2.StyledObject\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("maxValue".equals(name)) {
                            if (value instanceof Double) {
                                setMaxValue(((Double) value));
                            } else {
                                throw new IllegalArgumentException(("property \"maxValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("minValue".equals(name)) {
                                if (value instanceof Double) {
                                    setMinValue(((Double) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"minValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("steps".equals(name)) {
                                    if (value instanceof Integer) {
                                        setSteps(((Integer) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"steps\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("targetLine".equals(name)) {
                                        if (value instanceof Line) {
                                            setTargetLine(((Line) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"targetLine\" is of type \"org.hisp.dhis.api.model.v40_2_2.Line\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("title".equals(name)) {
                                            if (value instanceof StyledObject) {
                                                setTitle(((StyledObject) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"title\" is of type \"org.hisp.dhis.api.model.v40_2_2.StyledObject\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("type".equals(name)) {
                                                if (value instanceof AxisV2 .TypeRef) {
                                                    setType(((AxisV2 .TypeRef) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_2_2.AxisV2.TypeRef\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("baseLine".equals(name)) {
            return getBaseLine();
        } else {
            if ("decimals".equals(name)) {
                return getDecimals();
            } else {
                if ("index".equals(name)) {
                    return getIndex();
                } else {
                    if ("label".equals(name)) {
                        return getLabel();
                    } else {
                        if ("maxValue".equals(name)) {
                            return getMaxValue();
                        } else {
                            if ("minValue".equals(name)) {
                                return getMinValue();
                            } else {
                                if ("steps".equals(name)) {
                                    return getSteps();
                                } else {
                                    if ("targetLine".equals(name)) {
                                        return getTargetLine();
                                    } else {
                                        if ("title".equals(name)) {
                                            return getTitle();
                                        } else {
                                            if ("type".equals(name)) {
                                                return getType();
                                            } else {
                                                return notFoundValue;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AxisV2 .NOT_FOUND_VALUE);
        if (AxisV2 .NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AxisV2 with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AxisV2 .class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("baseLine");
        sb.append('=');
        sb.append(((this.baseLine == null)?"<null>":this.baseLine));
        sb.append(',');
        sb.append("decimals");
        sb.append('=');
        sb.append(((this.decimals == null)?"<null>":this.decimals));
        sb.append(',');
        sb.append("index");
        sb.append('=');
        sb.append(((this.index == null)?"<null>":this.index));
        sb.append(',');
        sb.append("label");
        sb.append('=');
        sb.append(((this.label == null)?"<null>":this.label));
        sb.append(',');
        sb.append("maxValue");
        sb.append('=');
        sb.append(((this.maxValue == null)?"<null>":this.maxValue));
        sb.append(',');
        sb.append("minValue");
        sb.append('=');
        sb.append(((this.minValue == null)?"<null>":this.minValue));
        sb.append(',');
        sb.append("steps");
        sb.append('=');
        sb.append(((this.steps == null)?"<null>":this.steps));
        sb.append(',');
        sb.append("targetLine");
        sb.append('=');
        sb.append(((this.targetLine == null)?"<null>":this.targetLine));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.baseLine == null)? 0 :this.baseLine.hashCode()));
        result = ((result* 31)+((this.maxValue == null)? 0 :this.maxValue.hashCode()));
        result = ((result* 31)+((this.index == null)? 0 :this.index.hashCode()));
        result = ((result* 31)+((this.label == null)? 0 :this.label.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.steps == null)? 0 :this.steps.hashCode()));
        result = ((result* 31)+((this.minValue == null)? 0 :this.minValue.hashCode()));
        result = ((result* 31)+((this.decimals == null)? 0 :this.decimals.hashCode()));
        result = ((result* 31)+((this.targetLine == null)? 0 :this.targetLine.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AxisV2) == false) {
            return false;
        }
        AxisV2 rhs = ((AxisV2) other);
        return ((((((((((((this.baseLine == rhs.baseLine)||((this.baseLine!= null)&&this.baseLine.equals(rhs.baseLine)))&&((this.maxValue == rhs.maxValue)||((this.maxValue!= null)&&this.maxValue.equals(rhs.maxValue))))&&((this.index == rhs.index)||((this.index!= null)&&this.index.equals(rhs.index))))&&((this.label == rhs.label)||((this.label!= null)&&this.label.equals(rhs.label))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.steps == rhs.steps)||((this.steps!= null)&&this.steps.equals(rhs.steps))))&&((this.minValue == rhs.minValue)||((this.minValue!= null)&&this.minValue.equals(rhs.minValue))))&&((this.decimals == rhs.decimals)||((this.decimals!= null)&&this.decimals.equals(rhs.decimals))))&&((this.targetLine == rhs.targetLine)||((this.targetLine!= null)&&this.targetLine.equals(rhs.targetLine))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum TypeRef {

        DOMAIN("DOMAIN"),
        RANGE("RANGE");
        private final String value;
        private final static Map<String, AxisV2 .TypeRef> CONSTANTS = new HashMap<String, AxisV2 .TypeRef>();

        static {
            for (AxisV2 .TypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AxisV2 .TypeRef fromValue(String value) {
            AxisV2 .TypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
