
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "corsWhitelist",
    "facilityOrgUnitGroupSet",
    "facilityOrgUnitLevel",
    "feedbackRecipients",
    "infrastructuralDataElements",
    "infrastructuralIndicators",
    "infrastructuralPeriodType",
    "offlineOrganisationUnitLevel",
    "selfRegistrationOrgUnit",
    "selfRegistrationRole",
    "systemId",
    "systemUpdateNotificationRecipients"
})
@Generated("jsonschema2pojo")
public class Configuration implements Serializable
{

    @JsonProperty("corsWhitelist")
    private List<String> corsWhitelist;
    /**
     * A UID reference to a OrganisationUnitGroupSet  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitGroupSet`)
     * 
     */
    @JsonProperty("facilityOrgUnitGroupSet")
    @JsonPropertyDescription("A UID reference to a OrganisationUnitGroupSet  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnitGroupSet`)")
    private FacilityOrgUnitGroupSetRef facilityOrgUnitGroupSet;
    /**
     * A UID reference to a OrganisationUnitLevel  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)
     * 
     */
    @JsonProperty("facilityOrgUnitLevel")
    @JsonPropertyDescription("A UID reference to a OrganisationUnitLevel  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)")
    private FacilityOrgUnitLevelRef facilityOrgUnitLevel;
    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("feedbackRecipients")
    @JsonPropertyDescription("A UID reference to a UserGroup  \n(Java name `org.hisp.dhis.user.UserGroup`)")
    private FeedbackRecipientsRef feedbackRecipients;
    /**
     * A UID reference to a DataElementGroup  
     * (Java name `org.hisp.dhis.dataelement.DataElementGroup`)
     * 
     */
    @JsonProperty("infrastructuralDataElements")
    @JsonPropertyDescription("A UID reference to a DataElementGroup  \n(Java name `org.hisp.dhis.dataelement.DataElementGroup`)")
    private InfrastructuralDataElementsRef infrastructuralDataElements;
    /**
     * A UID reference to a IndicatorGroup  
     * (Java name `org.hisp.dhis.indicator.IndicatorGroup`)
     * 
     */
    @JsonProperty("infrastructuralIndicators")
    @JsonPropertyDescription("A UID reference to a IndicatorGroup  \n(Java name `org.hisp.dhis.indicator.IndicatorGroup`)")
    private InfrastructuralIndicatorsRef infrastructuralIndicators;
    @JsonProperty("infrastructuralPeriodType")
    private Configuration.InfrastructuralPeriodTypeRef infrastructuralPeriodType;
    /**
     * A UID reference to a OrganisationUnitLevel  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)
     * 
     */
    @JsonProperty("offlineOrganisationUnitLevel")
    @JsonPropertyDescription("A UID reference to a OrganisationUnitLevel  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)")
    private OfflineOrganisationUnitLevelRef offlineOrganisationUnitLevel;
    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("selfRegistrationOrgUnit")
    @JsonPropertyDescription("A UID reference to a OrganisationUnit  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private SelfRegistrationOrgUnitRef selfRegistrationOrgUnit;
    /**
     * A UID reference to a UserRole  
     * (Java name `org.hisp.dhis.user.UserRole`)
     * 
     */
    @JsonProperty("selfRegistrationRole")
    @JsonPropertyDescription("A UID reference to a UserRole  \n(Java name `org.hisp.dhis.user.UserRole`)")
    private SelfRegistrationRoleRef selfRegistrationRole;
    @JsonProperty("systemId")
    private String systemId;
    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("systemUpdateNotificationRecipients")
    @JsonPropertyDescription("A UID reference to a UserGroup  \n(Java name `org.hisp.dhis.user.UserGroup`)")
    private SystemUpdateNotificationRecipientsRef systemUpdateNotificationRecipients;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1902360393549690073L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Configuration() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Configuration(Configuration source) {
        super();
        this.corsWhitelist = source.corsWhitelist;
        this.facilityOrgUnitGroupSet = source.facilityOrgUnitGroupSet;
        this.facilityOrgUnitLevel = source.facilityOrgUnitLevel;
        this.feedbackRecipients = source.feedbackRecipients;
        this.infrastructuralDataElements = source.infrastructuralDataElements;
        this.infrastructuralIndicators = source.infrastructuralIndicators;
        this.infrastructuralPeriodType = source.infrastructuralPeriodType;
        this.offlineOrganisationUnitLevel = source.offlineOrganisationUnitLevel;
        this.selfRegistrationOrgUnit = source.selfRegistrationOrgUnit;
        this.selfRegistrationRole = source.selfRegistrationRole;
        this.systemId = source.systemId;
        this.systemUpdateNotificationRecipients = source.systemUpdateNotificationRecipients;
    }

    /**
     * 
     * @param infrastructuralIndicators
     *     A UID reference to a IndicatorGroup  
     *     (Java name `org.hisp.dhis.indicator.IndicatorGroup`).
     * @param feedbackRecipients
     *     A UID reference to a UserGroup  
     *     (Java name `org.hisp.dhis.user.UserGroup`).
     * @param infrastructuralDataElements
     *     A UID reference to a DataElementGroup  
     *     (Java name `org.hisp.dhis.dataelement.DataElementGroup`).
     * @param selfRegistrationRole
     *     A UID reference to a UserRole  
     *     (Java name `org.hisp.dhis.user.UserRole`).
     * @param selfRegistrationOrgUnit
     *     A UID reference to a OrganisationUnit  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`).
     * @param facilityOrgUnitLevel
     *     A UID reference to a OrganisationUnitLevel  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`).
     * @param systemUpdateNotificationRecipients
     *     A UID reference to a UserGroup  
     *     (Java name `org.hisp.dhis.user.UserGroup`).
     * @param facilityOrgUnitGroupSet
     *     A UID reference to a OrganisationUnitGroupSet  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnitGroupSet`).
     * @param offlineOrganisationUnitLevel
     *     A UID reference to a OrganisationUnitLevel  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`).
     */
    public Configuration(List<String> corsWhitelist, FacilityOrgUnitGroupSetRef facilityOrgUnitGroupSet, FacilityOrgUnitLevelRef facilityOrgUnitLevel, FeedbackRecipientsRef feedbackRecipients, InfrastructuralDataElementsRef infrastructuralDataElements, InfrastructuralIndicatorsRef infrastructuralIndicators, Configuration.InfrastructuralPeriodTypeRef infrastructuralPeriodType, OfflineOrganisationUnitLevelRef offlineOrganisationUnitLevel, SelfRegistrationOrgUnitRef selfRegistrationOrgUnit, SelfRegistrationRoleRef selfRegistrationRole, String systemId, SystemUpdateNotificationRecipientsRef systemUpdateNotificationRecipients) {
        super();
        this.corsWhitelist = corsWhitelist;
        this.facilityOrgUnitGroupSet = facilityOrgUnitGroupSet;
        this.facilityOrgUnitLevel = facilityOrgUnitLevel;
        this.feedbackRecipients = feedbackRecipients;
        this.infrastructuralDataElements = infrastructuralDataElements;
        this.infrastructuralIndicators = infrastructuralIndicators;
        this.infrastructuralPeriodType = infrastructuralPeriodType;
        this.offlineOrganisationUnitLevel = offlineOrganisationUnitLevel;
        this.selfRegistrationOrgUnit = selfRegistrationOrgUnit;
        this.selfRegistrationRole = selfRegistrationRole;
        this.systemId = systemId;
        this.systemUpdateNotificationRecipients = systemUpdateNotificationRecipients;
    }

    @JsonProperty("corsWhitelist")
    public Optional<List<String>> getCorsWhitelist() {
        return Optional.ofNullable(corsWhitelist);
    }

    @JsonProperty("corsWhitelist")
    public void setCorsWhitelist(List<String> corsWhitelist) {
        this.corsWhitelist = corsWhitelist;
    }

    public Configuration withCorsWhitelist(List<String> corsWhitelist) {
        this.corsWhitelist = corsWhitelist;
        return this;
    }

    /**
     * A UID reference to a OrganisationUnitGroupSet  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitGroupSet`)
     * 
     */
    @JsonProperty("facilityOrgUnitGroupSet")
    public Optional<FacilityOrgUnitGroupSetRef> getFacilityOrgUnitGroupSet() {
        return Optional.ofNullable(facilityOrgUnitGroupSet);
    }

    /**
     * A UID reference to a OrganisationUnitGroupSet  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitGroupSet`)
     * 
     */
    @JsonProperty("facilityOrgUnitGroupSet")
    public void setFacilityOrgUnitGroupSet(FacilityOrgUnitGroupSetRef facilityOrgUnitGroupSet) {
        this.facilityOrgUnitGroupSet = facilityOrgUnitGroupSet;
    }

    public Configuration withFacilityOrgUnitGroupSet(FacilityOrgUnitGroupSetRef facilityOrgUnitGroupSet) {
        this.facilityOrgUnitGroupSet = facilityOrgUnitGroupSet;
        return this;
    }

    /**
     * A UID reference to a OrganisationUnitLevel  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)
     * 
     */
    @JsonProperty("facilityOrgUnitLevel")
    public Optional<FacilityOrgUnitLevelRef> getFacilityOrgUnitLevel() {
        return Optional.ofNullable(facilityOrgUnitLevel);
    }

    /**
     * A UID reference to a OrganisationUnitLevel  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)
     * 
     */
    @JsonProperty("facilityOrgUnitLevel")
    public void setFacilityOrgUnitLevel(FacilityOrgUnitLevelRef facilityOrgUnitLevel) {
        this.facilityOrgUnitLevel = facilityOrgUnitLevel;
    }

    public Configuration withFacilityOrgUnitLevel(FacilityOrgUnitLevelRef facilityOrgUnitLevel) {
        this.facilityOrgUnitLevel = facilityOrgUnitLevel;
        return this;
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("feedbackRecipients")
    public Optional<FeedbackRecipientsRef> getFeedbackRecipients() {
        return Optional.ofNullable(feedbackRecipients);
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("feedbackRecipients")
    public void setFeedbackRecipients(FeedbackRecipientsRef feedbackRecipients) {
        this.feedbackRecipients = feedbackRecipients;
    }

    public Configuration withFeedbackRecipients(FeedbackRecipientsRef feedbackRecipients) {
        this.feedbackRecipients = feedbackRecipients;
        return this;
    }

    /**
     * A UID reference to a DataElementGroup  
     * (Java name `org.hisp.dhis.dataelement.DataElementGroup`)
     * 
     */
    @JsonProperty("infrastructuralDataElements")
    public Optional<InfrastructuralDataElementsRef> getInfrastructuralDataElements() {
        return Optional.ofNullable(infrastructuralDataElements);
    }

    /**
     * A UID reference to a DataElementGroup  
     * (Java name `org.hisp.dhis.dataelement.DataElementGroup`)
     * 
     */
    @JsonProperty("infrastructuralDataElements")
    public void setInfrastructuralDataElements(InfrastructuralDataElementsRef infrastructuralDataElements) {
        this.infrastructuralDataElements = infrastructuralDataElements;
    }

    public Configuration withInfrastructuralDataElements(InfrastructuralDataElementsRef infrastructuralDataElements) {
        this.infrastructuralDataElements = infrastructuralDataElements;
        return this;
    }

    /**
     * A UID reference to a IndicatorGroup  
     * (Java name `org.hisp.dhis.indicator.IndicatorGroup`)
     * 
     */
    @JsonProperty("infrastructuralIndicators")
    public Optional<InfrastructuralIndicatorsRef> getInfrastructuralIndicators() {
        return Optional.ofNullable(infrastructuralIndicators);
    }

    /**
     * A UID reference to a IndicatorGroup  
     * (Java name `org.hisp.dhis.indicator.IndicatorGroup`)
     * 
     */
    @JsonProperty("infrastructuralIndicators")
    public void setInfrastructuralIndicators(InfrastructuralIndicatorsRef infrastructuralIndicators) {
        this.infrastructuralIndicators = infrastructuralIndicators;
    }

    public Configuration withInfrastructuralIndicators(InfrastructuralIndicatorsRef infrastructuralIndicators) {
        this.infrastructuralIndicators = infrastructuralIndicators;
        return this;
    }

    @JsonProperty("infrastructuralPeriodType")
    public Optional<Configuration.InfrastructuralPeriodTypeRef> getInfrastructuralPeriodType() {
        return Optional.ofNullable(infrastructuralPeriodType);
    }

    @JsonProperty("infrastructuralPeriodType")
    public void setInfrastructuralPeriodType(Configuration.InfrastructuralPeriodTypeRef infrastructuralPeriodType) {
        this.infrastructuralPeriodType = infrastructuralPeriodType;
    }

    public Configuration withInfrastructuralPeriodType(Configuration.InfrastructuralPeriodTypeRef infrastructuralPeriodType) {
        this.infrastructuralPeriodType = infrastructuralPeriodType;
        return this;
    }

    /**
     * A UID reference to a OrganisationUnitLevel  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)
     * 
     */
    @JsonProperty("offlineOrganisationUnitLevel")
    public Optional<OfflineOrganisationUnitLevelRef> getOfflineOrganisationUnitLevel() {
        return Optional.ofNullable(offlineOrganisationUnitLevel);
    }

    /**
     * A UID reference to a OrganisationUnitLevel  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnitLevel`)
     * 
     */
    @JsonProperty("offlineOrganisationUnitLevel")
    public void setOfflineOrganisationUnitLevel(OfflineOrganisationUnitLevelRef offlineOrganisationUnitLevel) {
        this.offlineOrganisationUnitLevel = offlineOrganisationUnitLevel;
    }

    public Configuration withOfflineOrganisationUnitLevel(OfflineOrganisationUnitLevelRef offlineOrganisationUnitLevel) {
        this.offlineOrganisationUnitLevel = offlineOrganisationUnitLevel;
        return this;
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("selfRegistrationOrgUnit")
    public Optional<SelfRegistrationOrgUnitRef> getSelfRegistrationOrgUnit() {
        return Optional.ofNullable(selfRegistrationOrgUnit);
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("selfRegistrationOrgUnit")
    public void setSelfRegistrationOrgUnit(SelfRegistrationOrgUnitRef selfRegistrationOrgUnit) {
        this.selfRegistrationOrgUnit = selfRegistrationOrgUnit;
    }

    public Configuration withSelfRegistrationOrgUnit(SelfRegistrationOrgUnitRef selfRegistrationOrgUnit) {
        this.selfRegistrationOrgUnit = selfRegistrationOrgUnit;
        return this;
    }

    /**
     * A UID reference to a UserRole  
     * (Java name `org.hisp.dhis.user.UserRole`)
     * 
     */
    @JsonProperty("selfRegistrationRole")
    public Optional<SelfRegistrationRoleRef> getSelfRegistrationRole() {
        return Optional.ofNullable(selfRegistrationRole);
    }

    /**
     * A UID reference to a UserRole  
     * (Java name `org.hisp.dhis.user.UserRole`)
     * 
     */
    @JsonProperty("selfRegistrationRole")
    public void setSelfRegistrationRole(SelfRegistrationRoleRef selfRegistrationRole) {
        this.selfRegistrationRole = selfRegistrationRole;
    }

    public Configuration withSelfRegistrationRole(SelfRegistrationRoleRef selfRegistrationRole) {
        this.selfRegistrationRole = selfRegistrationRole;
        return this;
    }

    @JsonProperty("systemId")
    public Optional<String> getSystemId() {
        return Optional.ofNullable(systemId);
    }

    @JsonProperty("systemId")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Configuration withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("systemUpdateNotificationRecipients")
    public Optional<SystemUpdateNotificationRecipientsRef> getSystemUpdateNotificationRecipients() {
        return Optional.ofNullable(systemUpdateNotificationRecipients);
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("systemUpdateNotificationRecipients")
    public void setSystemUpdateNotificationRecipients(SystemUpdateNotificationRecipientsRef systemUpdateNotificationRecipients) {
        this.systemUpdateNotificationRecipients = systemUpdateNotificationRecipients;
    }

    public Configuration withSystemUpdateNotificationRecipients(SystemUpdateNotificationRecipientsRef systemUpdateNotificationRecipients) {
        this.systemUpdateNotificationRecipients = systemUpdateNotificationRecipients;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Configuration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("corsWhitelist".equals(name)) {
            if (value instanceof List) {
                setCorsWhitelist(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"corsWhitelist\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("facilityOrgUnitGroupSet".equals(name)) {
                if (value instanceof FacilityOrgUnitGroupSetRef) {
                    setFacilityOrgUnitGroupSet(((FacilityOrgUnitGroupSetRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"facilityOrgUnitGroupSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.FacilityOrgUnitGroupSetRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("facilityOrgUnitLevel".equals(name)) {
                    if (value instanceof FacilityOrgUnitLevelRef) {
                        setFacilityOrgUnitLevel(((FacilityOrgUnitLevelRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"facilityOrgUnitLevel\" is of type \"org.hisp.dhis.api.model.v40_2_2.FacilityOrgUnitLevelRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("feedbackRecipients".equals(name)) {
                        if (value instanceof FeedbackRecipientsRef) {
                            setFeedbackRecipients(((FeedbackRecipientsRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"feedbackRecipients\" is of type \"org.hisp.dhis.api.model.v40_2_2.FeedbackRecipientsRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("infrastructuralDataElements".equals(name)) {
                            if (value instanceof InfrastructuralDataElementsRef) {
                                setInfrastructuralDataElements(((InfrastructuralDataElementsRef) value));
                            } else {
                                throw new IllegalArgumentException(("property \"infrastructuralDataElements\" is of type \"org.hisp.dhis.api.model.v40_2_2.InfrastructuralDataElementsRef\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("infrastructuralIndicators".equals(name)) {
                                if (value instanceof InfrastructuralIndicatorsRef) {
                                    setInfrastructuralIndicators(((InfrastructuralIndicatorsRef) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"infrastructuralIndicators\" is of type \"org.hisp.dhis.api.model.v40_2_2.InfrastructuralIndicatorsRef\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("infrastructuralPeriodType".equals(name)) {
                                    if (value instanceof Configuration.InfrastructuralPeriodTypeRef) {
                                        setInfrastructuralPeriodType(((Configuration.InfrastructuralPeriodTypeRef) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"infrastructuralPeriodType\" is of type \"org.hisp.dhis.api.model.v40_2_2.Configuration.InfrastructuralPeriodTypeRef\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("offlineOrganisationUnitLevel".equals(name)) {
                                        if (value instanceof OfflineOrganisationUnitLevelRef) {
                                            setOfflineOrganisationUnitLevel(((OfflineOrganisationUnitLevelRef) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"offlineOrganisationUnitLevel\" is of type \"org.hisp.dhis.api.model.v40_2_2.OfflineOrganisationUnitLevelRef\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("selfRegistrationOrgUnit".equals(name)) {
                                            if (value instanceof SelfRegistrationOrgUnitRef) {
                                                setSelfRegistrationOrgUnit(((SelfRegistrationOrgUnitRef) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"selfRegistrationOrgUnit\" is of type \"org.hisp.dhis.api.model.v40_2_2.SelfRegistrationOrgUnitRef\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("selfRegistrationRole".equals(name)) {
                                                if (value instanceof SelfRegistrationRoleRef) {
                                                    setSelfRegistrationRole(((SelfRegistrationRoleRef) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"selfRegistrationRole\" is of type \"org.hisp.dhis.api.model.v40_2_2.SelfRegistrationRoleRef\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("systemId".equals(name)) {
                                                    if (value instanceof String) {
                                                        setSystemId(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"systemId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("systemUpdateNotificationRecipients".equals(name)) {
                                                        if (value instanceof SystemUpdateNotificationRecipientsRef) {
                                                            setSystemUpdateNotificationRecipients(((SystemUpdateNotificationRecipientsRef) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"systemUpdateNotificationRecipients\" is of type \"org.hisp.dhis.api.model.v40_2_2.SystemUpdateNotificationRecipientsRef\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        return false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("corsWhitelist".equals(name)) {
            return getCorsWhitelist();
        } else {
            if ("facilityOrgUnitGroupSet".equals(name)) {
                return getFacilityOrgUnitGroupSet();
            } else {
                if ("facilityOrgUnitLevel".equals(name)) {
                    return getFacilityOrgUnitLevel();
                } else {
                    if ("feedbackRecipients".equals(name)) {
                        return getFeedbackRecipients();
                    } else {
                        if ("infrastructuralDataElements".equals(name)) {
                            return getInfrastructuralDataElements();
                        } else {
                            if ("infrastructuralIndicators".equals(name)) {
                                return getInfrastructuralIndicators();
                            } else {
                                if ("infrastructuralPeriodType".equals(name)) {
                                    return getInfrastructuralPeriodType();
                                } else {
                                    if ("offlineOrganisationUnitLevel".equals(name)) {
                                        return getOfflineOrganisationUnitLevel();
                                    } else {
                                        if ("selfRegistrationOrgUnit".equals(name)) {
                                            return getSelfRegistrationOrgUnit();
                                        } else {
                                            if ("selfRegistrationRole".equals(name)) {
                                                return getSelfRegistrationRole();
                                            } else {
                                                if ("systemId".equals(name)) {
                                                    return getSystemId();
                                                } else {
                                                    if ("systemUpdateNotificationRecipients".equals(name)) {
                                                        return getSystemUpdateNotificationRecipients();
                                                    } else {
                                                        return notFoundValue;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Configuration.NOT_FOUND_VALUE);
        if (Configuration.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Configuration with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Configuration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("corsWhitelist");
        sb.append('=');
        sb.append(((this.corsWhitelist == null)?"<null>":this.corsWhitelist));
        sb.append(',');
        sb.append("facilityOrgUnitGroupSet");
        sb.append('=');
        sb.append(((this.facilityOrgUnitGroupSet == null)?"<null>":this.facilityOrgUnitGroupSet));
        sb.append(',');
        sb.append("facilityOrgUnitLevel");
        sb.append('=');
        sb.append(((this.facilityOrgUnitLevel == null)?"<null>":this.facilityOrgUnitLevel));
        sb.append(',');
        sb.append("feedbackRecipients");
        sb.append('=');
        sb.append(((this.feedbackRecipients == null)?"<null>":this.feedbackRecipients));
        sb.append(',');
        sb.append("infrastructuralDataElements");
        sb.append('=');
        sb.append(((this.infrastructuralDataElements == null)?"<null>":this.infrastructuralDataElements));
        sb.append(',');
        sb.append("infrastructuralIndicators");
        sb.append('=');
        sb.append(((this.infrastructuralIndicators == null)?"<null>":this.infrastructuralIndicators));
        sb.append(',');
        sb.append("infrastructuralPeriodType");
        sb.append('=');
        sb.append(((this.infrastructuralPeriodType == null)?"<null>":this.infrastructuralPeriodType));
        sb.append(',');
        sb.append("offlineOrganisationUnitLevel");
        sb.append('=');
        sb.append(((this.offlineOrganisationUnitLevel == null)?"<null>":this.offlineOrganisationUnitLevel));
        sb.append(',');
        sb.append("selfRegistrationOrgUnit");
        sb.append('=');
        sb.append(((this.selfRegistrationOrgUnit == null)?"<null>":this.selfRegistrationOrgUnit));
        sb.append(',');
        sb.append("selfRegistrationRole");
        sb.append('=');
        sb.append(((this.selfRegistrationRole == null)?"<null>":this.selfRegistrationRole));
        sb.append(',');
        sb.append("systemId");
        sb.append('=');
        sb.append(((this.systemId == null)?"<null>":this.systemId));
        sb.append(',');
        sb.append("systemUpdateNotificationRecipients");
        sb.append('=');
        sb.append(((this.systemUpdateNotificationRecipients == null)?"<null>":this.systemUpdateNotificationRecipients));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.infrastructuralIndicators == null)? 0 :this.infrastructuralIndicators.hashCode()));
        result = ((result* 31)+((this.systemId == null)? 0 :this.systemId.hashCode()));
        result = ((result* 31)+((this.feedbackRecipients == null)? 0 :this.feedbackRecipients.hashCode()));
        result = ((result* 31)+((this.infrastructuralDataElements == null)? 0 :this.infrastructuralDataElements.hashCode()));
        result = ((result* 31)+((this.selfRegistrationOrgUnit == null)? 0 :this.selfRegistrationOrgUnit.hashCode()));
        result = ((result* 31)+((this.offlineOrganisationUnitLevel == null)? 0 :this.offlineOrganisationUnitLevel.hashCode()));
        result = ((result* 31)+((this.selfRegistrationRole == null)? 0 :this.selfRegistrationRole.hashCode()));
        result = ((result* 31)+((this.infrastructuralPeriodType == null)? 0 :this.infrastructuralPeriodType.hashCode()));
        result = ((result* 31)+((this.facilityOrgUnitLevel == null)? 0 :this.facilityOrgUnitLevel.hashCode()));
        result = ((result* 31)+((this.systemUpdateNotificationRecipients == null)? 0 :this.systemUpdateNotificationRecipients.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.corsWhitelist == null)? 0 :this.corsWhitelist.hashCode()));
        result = ((result* 31)+((this.facilityOrgUnitGroupSet == null)? 0 :this.facilityOrgUnitGroupSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Configuration) == false) {
            return false;
        }
        Configuration rhs = ((Configuration) other);
        return ((((((((((((((this.infrastructuralIndicators == rhs.infrastructuralIndicators)||((this.infrastructuralIndicators!= null)&&this.infrastructuralIndicators.equals(rhs.infrastructuralIndicators)))&&((this.systemId == rhs.systemId)||((this.systemId!= null)&&this.systemId.equals(rhs.systemId))))&&((this.feedbackRecipients == rhs.feedbackRecipients)||((this.feedbackRecipients!= null)&&this.feedbackRecipients.equals(rhs.feedbackRecipients))))&&((this.infrastructuralDataElements == rhs.infrastructuralDataElements)||((this.infrastructuralDataElements!= null)&&this.infrastructuralDataElements.equals(rhs.infrastructuralDataElements))))&&((this.selfRegistrationOrgUnit == rhs.selfRegistrationOrgUnit)||((this.selfRegistrationOrgUnit!= null)&&this.selfRegistrationOrgUnit.equals(rhs.selfRegistrationOrgUnit))))&&((this.offlineOrganisationUnitLevel == rhs.offlineOrganisationUnitLevel)||((this.offlineOrganisationUnitLevel!= null)&&this.offlineOrganisationUnitLevel.equals(rhs.offlineOrganisationUnitLevel))))&&((this.selfRegistrationRole == rhs.selfRegistrationRole)||((this.selfRegistrationRole!= null)&&this.selfRegistrationRole.equals(rhs.selfRegistrationRole))))&&((this.infrastructuralPeriodType == rhs.infrastructuralPeriodType)||((this.infrastructuralPeriodType!= null)&&this.infrastructuralPeriodType.equals(rhs.infrastructuralPeriodType))))&&((this.facilityOrgUnitLevel == rhs.facilityOrgUnitLevel)||((this.facilityOrgUnitLevel!= null)&&this.facilityOrgUnitLevel.equals(rhs.facilityOrgUnitLevel))))&&((this.systemUpdateNotificationRecipients == rhs.systemUpdateNotificationRecipients)||((this.systemUpdateNotificationRecipients!= null)&&this.systemUpdateNotificationRecipients.equals(rhs.systemUpdateNotificationRecipients))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.corsWhitelist == rhs.corsWhitelist)||((this.corsWhitelist!= null)&&this.corsWhitelist.equals(rhs.corsWhitelist))))&&((this.facilityOrgUnitGroupSet == rhs.facilityOrgUnitGroupSet)||((this.facilityOrgUnitGroupSet!= null)&&this.facilityOrgUnitGroupSet.equals(rhs.facilityOrgUnitGroupSet))));
    }

    @Generated("jsonschema2pojo")
    public enum InfrastructuralPeriodTypeRef {

        BI_MONTHLY("BiMonthly"),
        BI_WEEKLY("BiWeekly"),
        DAILY("Daily"),
        FINANCIAL_APRIL("FinancialApril"),
        FINANCIAL_JULY("FinancialJuly"),
        FINANCIAL_NOV("FinancialNov"),
        FINANCIAL_OCT("FinancialOct"),
        MONTHLY("Monthly"),
        QUARTERLY("Quarterly"),
        QUARTERLY_NOV("QuarterlyNov"),
        SIX_MONTHLY_APRIL("SixMonthlyApril"),
        SIX_MONTHLY_NOV("SixMonthlyNov"),
        SIX_MONTHLY("SixMonthly"),
        TWO_YEARLY("TwoYearly"),
        WEEKLY("Weekly"),
        WEEKLY_SATURDAY("WeeklySaturday"),
        WEEKLY_SUNDAY("WeeklySunday"),
        WEEKLY_THURSDAY("WeeklyThursday"),
        WEEKLY_WEDNESDAY("WeeklyWednesday"),
        YEARLY("Yearly");
        private final String value;
        private final static Map<String, Configuration.InfrastructuralPeriodTypeRef> CONSTANTS = new HashMap<String, Configuration.InfrastructuralPeriodTypeRef>();

        static {
            for (Configuration.InfrastructuralPeriodTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        InfrastructuralPeriodTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Configuration.InfrastructuralPeriodTypeRef fromValue(String value) {
            Configuration.InfrastructuralPeriodTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
