
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "count",
    "error",
    "finishedTime",
    "percentage",
    "startTime"
})
@Generated("jsonschema2pojo")
public class DataIntegritySummary implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("count")
    private Integer count;
    @JsonProperty("error")
    private String error;
    @JsonProperty("finishedTime")
    private Date finishedTime;
    @JsonProperty("percentage")
    private Double percentage;
    @JsonProperty("startTime")
    private Date startTime;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3719890368895398342L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataIntegritySummary() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataIntegritySummary(DataIntegritySummary source) {
        super();
        this.count = source.count;
        this.error = source.error;
        this.finishedTime = source.finishedTime;
        this.percentage = source.percentage;
        this.startTime = source.startTime;
    }

    public DataIntegritySummary(Integer count, String error, Date finishedTime, Double percentage, Date startTime) {
        super();
        this.count = count;
        this.error = error;
        this.finishedTime = finishedTime;
        this.percentage = percentage;
        this.startTime = startTime;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("count")
    public Integer getCount() {
        return count;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("count")
    public void setCount(Integer count) {
        this.count = count;
    }

    public DataIntegritySummary withCount(Integer count) {
        this.count = count;
        return this;
    }

    @JsonProperty("error")
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    @JsonProperty("error")
    public void setError(String error) {
        this.error = error;
    }

    public DataIntegritySummary withError(String error) {
        this.error = error;
        return this;
    }

    @JsonProperty("finishedTime")
    public Optional<Date> getFinishedTime() {
        return Optional.ofNullable(finishedTime);
    }

    @JsonProperty("finishedTime")
    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public DataIntegritySummary withFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
        return this;
    }

    @JsonProperty("percentage")
    public Optional<Double> getPercentage() {
        return Optional.ofNullable(percentage);
    }

    @JsonProperty("percentage")
    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public DataIntegritySummary withPercentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @JsonProperty("startTime")
    public Optional<Date> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    @JsonProperty("startTime")
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public DataIntegritySummary withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataIntegritySummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("count".equals(name)) {
            if (value instanceof Integer) {
                setCount(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"count\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("error".equals(name)) {
                if (value instanceof String) {
                    setError(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"error\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("finishedTime".equals(name)) {
                    if (value instanceof Date) {
                        setFinishedTime(((Date) value));
                    } else {
                        throw new IllegalArgumentException(("property \"finishedTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("percentage".equals(name)) {
                        if (value instanceof Double) {
                            setPercentage(((Double) value));
                        } else {
                            throw new IllegalArgumentException(("property \"percentage\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("startTime".equals(name)) {
                            if (value instanceof Date) {
                                setStartTime(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"startTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("count".equals(name)) {
            return getCount();
        } else {
            if ("error".equals(name)) {
                return getError();
            } else {
                if ("finishedTime".equals(name)) {
                    return getFinishedTime();
                } else {
                    if ("percentage".equals(name)) {
                        return getPercentage();
                    } else {
                        if ("startTime".equals(name)) {
                            return getStartTime();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataIntegritySummary.NOT_FOUND_VALUE);
        if (DataIntegritySummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataIntegritySummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataIntegritySummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("count");
        sb.append('=');
        sb.append(((this.count == null)?"<null>":this.count));
        sb.append(',');
        sb.append("error");
        sb.append('=');
        sb.append(((this.error == null)?"<null>":this.error));
        sb.append(',');
        sb.append("finishedTime");
        sb.append('=');
        sb.append(((this.finishedTime == null)?"<null>":this.finishedTime));
        sb.append(',');
        sb.append("percentage");
        sb.append('=');
        sb.append(((this.percentage == null)?"<null>":this.percentage));
        sb.append(',');
        sb.append("startTime");
        sb.append('=');
        sb.append(((this.startTime == null)?"<null>":this.startTime));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.percentage == null)? 0 :this.percentage.hashCode()));
        result = ((result* 31)+((this.count == null)? 0 :this.count.hashCode()));
        result = ((result* 31)+((this.finishedTime == null)? 0 :this.finishedTime.hashCode()));
        result = ((result* 31)+((this.startTime == null)? 0 :this.startTime.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.error == null)? 0 :this.error.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataIntegritySummary) == false) {
            return false;
        }
        DataIntegritySummary rhs = ((DataIntegritySummary) other);
        return (((((((this.percentage == rhs.percentage)||((this.percentage!= null)&&this.percentage.equals(rhs.percentage)))&&((this.count == rhs.count)||((this.count!= null)&&this.count.equals(rhs.count))))&&((this.finishedTime == rhs.finishedTime)||((this.finishedTime!= null)&&this.finishedTime.equals(rhs.finishedTime))))&&((this.startTime == rhs.startTime)||((this.startTime!= null)&&this.startTime.equals(rhs.startTime))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.error == rhs.error)||((this.error!= null)&&this.error.equals(rhs.error))));
    }

}
