
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "dataSetNotificationTrigger",
    "dataSets",
    "deliveryChannels",
    "displayMessageTemplate",
    "displayName",
    "displaySubjectTemplate",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "messageTemplate",
    "name",
    "notificationRecipient",
    "notifyParentOrganisationUnitOnly",
    "notifyUsersInHierarchyOnly",
    "publicAccess",
    "recipientUserGroup",
    "relativeScheduledDays",
    "sendStrategy",
    "sharing",
    "subjectTemplate",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class DataSetNotificationTemplate implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__26 createdBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataSetNotificationTrigger")
    private DataSetNotificationTemplate.DataSetNotificationTriggerRef dataSetNotificationTrigger;
    @JsonProperty("dataSets")
    private List<DataSetsRefRef__1> dataSets;
    @JsonProperty("deliveryChannels")
    private List<DeliveryChannelsRefRef> deliveryChannels;
    @JsonProperty("displayMessageTemplate")
    private String displayMessageTemplate;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displaySubjectTemplate")
    private String displaySubjectTemplate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__26 lastUpdatedBy;
    @JsonProperty("messageTemplate")
    private String messageTemplate;
    @JsonProperty("name")
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationRecipient")
    private DataSetNotificationTemplate.NotificationRecipientRef notificationRecipient;
    @JsonProperty("notifyParentOrganisationUnitOnly")
    private Boolean notifyParentOrganisationUnitOnly;
    @JsonProperty("notifyUsersInHierarchyOnly")
    private Boolean notifyUsersInHierarchyOnly;
    @JsonProperty("publicAccess")
    private String publicAccess;
    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("recipientUserGroup")
    @JsonPropertyDescription("A UID reference to a UserGroup  \n(Java name `org.hisp.dhis.user.UserGroup`)")
    private RecipientUserGroupRef recipientUserGroup;
    @JsonProperty("relativeScheduledDays")
    private Integer relativeScheduledDays;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendStrategy")
    private DataSetNotificationTemplate.SendStrategyRef sendStrategy;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("subjectTemplate")
    private String subjectTemplate;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__27 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7867728678815235883L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataSetNotificationTemplate() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataSetNotificationTemplate(DataSetNotificationTemplate source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataSetNotificationTrigger = source.dataSetNotificationTrigger;
        this.dataSets = source.dataSets;
        this.deliveryChannels = source.deliveryChannels;
        this.displayMessageTemplate = source.displayMessageTemplate;
        this.displayName = source.displayName;
        this.displaySubjectTemplate = source.displaySubjectTemplate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.messageTemplate = source.messageTemplate;
        this.name = source.name;
        this.notificationRecipient = source.notificationRecipient;
        this.notifyParentOrganisationUnitOnly = source.notifyParentOrganisationUnitOnly;
        this.notifyUsersInHierarchyOnly = source.notifyUsersInHierarchyOnly;
        this.publicAccess = source.publicAccess;
        this.recipientUserGroup = source.recipientUserGroup;
        this.relativeScheduledDays = source.relativeScheduledDays;
        this.sendStrategy = source.sendStrategy;
        this.sharing = source.sharing;
        this.subjectTemplate = source.subjectTemplate;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param recipientUserGroup
     *     A UID reference to a UserGroup  
     *     (Java name `org.hisp.dhis.user.UserGroup`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public DataSetNotificationTemplate(Access access, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__26 createdBy, DataSetNotificationTemplate.DataSetNotificationTriggerRef dataSetNotificationTrigger, List<DataSetsRefRef__1> dataSets, List<DeliveryChannelsRefRef> deliveryChannels, String displayMessageTemplate, String displayName, String displaySubjectTemplate, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, LastUpdatedByRef__26 lastUpdatedBy, String messageTemplate, String name, DataSetNotificationTemplate.NotificationRecipientRef notificationRecipient, Boolean notifyParentOrganisationUnitOnly, Boolean notifyUsersInHierarchyOnly, String publicAccess, RecipientUserGroupRef recipientUserGroup, Integer relativeScheduledDays, DataSetNotificationTemplate.SendStrategyRef sendStrategy, Sharing sharing, String subjectTemplate, List<Translation> translations, UserRef__27 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dataSetNotificationTrigger = dataSetNotificationTrigger;
        this.dataSets = dataSets;
        this.deliveryChannels = deliveryChannels;
        this.displayMessageTemplate = displayMessageTemplate;
        this.displayName = displayName;
        this.displaySubjectTemplate = displaySubjectTemplate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.messageTemplate = messageTemplate;
        this.name = name;
        this.notificationRecipient = notificationRecipient;
        this.notifyParentOrganisationUnitOnly = notifyParentOrganisationUnitOnly;
        this.notifyUsersInHierarchyOnly = notifyUsersInHierarchyOnly;
        this.publicAccess = publicAccess;
        this.recipientUserGroup = recipientUserGroup;
        this.relativeScheduledDays = relativeScheduledDays;
        this.sendStrategy = sendStrategy;
        this.sharing = sharing;
        this.subjectTemplate = subjectTemplate;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DataSetNotificationTemplate withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DataSetNotificationTemplate withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DataSetNotificationTemplate withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataSetNotificationTemplate withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__26> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__26 createdBy) {
        this.createdBy = createdBy;
    }

    public DataSetNotificationTemplate withCreatedBy(CreatedByRef__26 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataSetNotificationTrigger")
    public DataSetNotificationTemplate.DataSetNotificationTriggerRef getDataSetNotificationTrigger() {
        return dataSetNotificationTrigger;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataSetNotificationTrigger")
    public void setDataSetNotificationTrigger(DataSetNotificationTemplate.DataSetNotificationTriggerRef dataSetNotificationTrigger) {
        this.dataSetNotificationTrigger = dataSetNotificationTrigger;
    }

    public DataSetNotificationTemplate withDataSetNotificationTrigger(DataSetNotificationTemplate.DataSetNotificationTriggerRef dataSetNotificationTrigger) {
        this.dataSetNotificationTrigger = dataSetNotificationTrigger;
        return this;
    }

    @JsonProperty("dataSets")
    public Optional<List<DataSetsRefRef__1>> getDataSets() {
        return Optional.ofNullable(dataSets);
    }

    @JsonProperty("dataSets")
    public void setDataSets(List<DataSetsRefRef__1> dataSets) {
        this.dataSets = dataSets;
    }

    public DataSetNotificationTemplate withDataSets(List<DataSetsRefRef__1> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    @JsonProperty("deliveryChannels")
    public Optional<List<DeliveryChannelsRefRef>> getDeliveryChannels() {
        return Optional.ofNullable(deliveryChannels);
    }

    @JsonProperty("deliveryChannels")
    public void setDeliveryChannels(List<DeliveryChannelsRefRef> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
    }

    public DataSetNotificationTemplate withDeliveryChannels(List<DeliveryChannelsRefRef> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
        return this;
    }

    @JsonProperty("displayMessageTemplate")
    public Optional<String> getDisplayMessageTemplate() {
        return Optional.ofNullable(displayMessageTemplate);
    }

    @JsonProperty("displayMessageTemplate")
    public void setDisplayMessageTemplate(String displayMessageTemplate) {
        this.displayMessageTemplate = displayMessageTemplate;
    }

    public DataSetNotificationTemplate withDisplayMessageTemplate(String displayMessageTemplate) {
        this.displayMessageTemplate = displayMessageTemplate;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DataSetNotificationTemplate withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displaySubjectTemplate")
    public Optional<String> getDisplaySubjectTemplate() {
        return Optional.ofNullable(displaySubjectTemplate);
    }

    @JsonProperty("displaySubjectTemplate")
    public void setDisplaySubjectTemplate(String displaySubjectTemplate) {
        this.displaySubjectTemplate = displaySubjectTemplate;
    }

    public DataSetNotificationTemplate withDisplaySubjectTemplate(String displaySubjectTemplate) {
        this.displaySubjectTemplate = displaySubjectTemplate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DataSetNotificationTemplate withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DataSetNotificationTemplate withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DataSetNotificationTemplate withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DataSetNotificationTemplate withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public DataSetNotificationTemplate withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataSetNotificationTemplate withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__26> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__26 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DataSetNotificationTemplate withLastUpdatedBy(LastUpdatedByRef__26 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("messageTemplate")
    public Optional<String> getMessageTemplate() {
        return Optional.ofNullable(messageTemplate);
    }

    @JsonProperty("messageTemplate")
    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public DataSetNotificationTemplate withMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataSetNotificationTemplate withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationRecipient")
    public DataSetNotificationTemplate.NotificationRecipientRef getNotificationRecipient() {
        return notificationRecipient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationRecipient")
    public void setNotificationRecipient(DataSetNotificationTemplate.NotificationRecipientRef notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
    }

    public DataSetNotificationTemplate withNotificationRecipient(DataSetNotificationTemplate.NotificationRecipientRef notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
        return this;
    }

    @JsonProperty("notifyParentOrganisationUnitOnly")
    public Optional<Boolean> getNotifyParentOrganisationUnitOnly() {
        return Optional.ofNullable(notifyParentOrganisationUnitOnly);
    }

    @JsonProperty("notifyParentOrganisationUnitOnly")
    public void setNotifyParentOrganisationUnitOnly(Boolean notifyParentOrganisationUnitOnly) {
        this.notifyParentOrganisationUnitOnly = notifyParentOrganisationUnitOnly;
    }

    public DataSetNotificationTemplate withNotifyParentOrganisationUnitOnly(Boolean notifyParentOrganisationUnitOnly) {
        this.notifyParentOrganisationUnitOnly = notifyParentOrganisationUnitOnly;
        return this;
    }

    @JsonProperty("notifyUsersInHierarchyOnly")
    public Optional<Boolean> getNotifyUsersInHierarchyOnly() {
        return Optional.ofNullable(notifyUsersInHierarchyOnly);
    }

    @JsonProperty("notifyUsersInHierarchyOnly")
    public void setNotifyUsersInHierarchyOnly(Boolean notifyUsersInHierarchyOnly) {
        this.notifyUsersInHierarchyOnly = notifyUsersInHierarchyOnly;
    }

    public DataSetNotificationTemplate withNotifyUsersInHierarchyOnly(Boolean notifyUsersInHierarchyOnly) {
        this.notifyUsersInHierarchyOnly = notifyUsersInHierarchyOnly;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DataSetNotificationTemplate withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("recipientUserGroup")
    public Optional<RecipientUserGroupRef> getRecipientUserGroup() {
        return Optional.ofNullable(recipientUserGroup);
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * 
     */
    @JsonProperty("recipientUserGroup")
    public void setRecipientUserGroup(RecipientUserGroupRef recipientUserGroup) {
        this.recipientUserGroup = recipientUserGroup;
    }

    public DataSetNotificationTemplate withRecipientUserGroup(RecipientUserGroupRef recipientUserGroup) {
        this.recipientUserGroup = recipientUserGroup;
        return this;
    }

    @JsonProperty("relativeScheduledDays")
    public Optional<Integer> getRelativeScheduledDays() {
        return Optional.ofNullable(relativeScheduledDays);
    }

    @JsonProperty("relativeScheduledDays")
    public void setRelativeScheduledDays(Integer relativeScheduledDays) {
        this.relativeScheduledDays = relativeScheduledDays;
    }

    public DataSetNotificationTemplate withRelativeScheduledDays(Integer relativeScheduledDays) {
        this.relativeScheduledDays = relativeScheduledDays;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendStrategy")
    public DataSetNotificationTemplate.SendStrategyRef getSendStrategy() {
        return sendStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendStrategy")
    public void setSendStrategy(DataSetNotificationTemplate.SendStrategyRef sendStrategy) {
        this.sendStrategy = sendStrategy;
    }

    public DataSetNotificationTemplate withSendStrategy(DataSetNotificationTemplate.SendStrategyRef sendStrategy) {
        this.sendStrategy = sendStrategy;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public DataSetNotificationTemplate withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("subjectTemplate")
    public Optional<String> getSubjectTemplate() {
        return Optional.ofNullable(subjectTemplate);
    }

    @JsonProperty("subjectTemplate")
    public void setSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public DataSetNotificationTemplate withSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DataSetNotificationTemplate withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__27> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__27 user) {
        this.user = user;
    }

    public DataSetNotificationTemplate withUser(UserRef__27 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DataSetNotificationTemplate withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DataSetNotificationTemplate withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataSetNotificationTemplate withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("createdBy".equals(name)) {
                            if (value instanceof CreatedByRef__26) {
                                setCreatedBy(((CreatedByRef__26) value));
                            } else {
                                throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__26\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dataSetNotificationTrigger".equals(name)) {
                                if (value instanceof DataSetNotificationTemplate.DataSetNotificationTriggerRef) {
                                    setDataSetNotificationTrigger(((DataSetNotificationTemplate.DataSetNotificationTriggerRef) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dataSetNotificationTrigger\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataSetNotificationTemplate.DataSetNotificationTriggerRef\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("dataSets".equals(name)) {
                                    if (value instanceof List) {
                                        setDataSets(((List<DataSetsRefRef__1> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"dataSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.DataSetsRefRef__1>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("deliveryChannels".equals(name)) {
                                        if (value instanceof List) {
                                            setDeliveryChannels(((List<DeliveryChannelsRefRef> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"deliveryChannels\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.DeliveryChannelsRefRef>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("displayMessageTemplate".equals(name)) {
                                            if (value instanceof String) {
                                                setDisplayMessageTemplate(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"displayMessageTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("displayName".equals(name)) {
                                                if (value instanceof String) {
                                                    setDisplayName(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displaySubjectTemplate".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplaySubjectTemplate(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displaySubjectTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setHref(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setId(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setLastUpdated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                if (value instanceof LastUpdatedByRef__26) {
                                                                                    setLastUpdatedBy(((LastUpdatedByRef__26) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__26\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("messageTemplate".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setMessageTemplate(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"messageTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("name".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setName(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("notificationRecipient".equals(name)) {
                                                                                            if (value instanceof DataSetNotificationTemplate.NotificationRecipientRef) {
                                                                                                setNotificationRecipient(((DataSetNotificationTemplate.NotificationRecipientRef) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"notificationRecipient\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataSetNotificationTemplate.NotificationRecipientRef\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("notifyParentOrganisationUnitOnly".equals(name)) {
                                                                                                if (value instanceof Boolean) {
                                                                                                    setNotifyParentOrganisationUnitOnly(((Boolean) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"notifyParentOrganisationUnitOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("notifyUsersInHierarchyOnly".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setNotifyUsersInHierarchyOnly(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"notifyUsersInHierarchyOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setPublicAccess(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("recipientUserGroup".equals(name)) {
                                                                                                            if (value instanceof RecipientUserGroupRef) {
                                                                                                                setRecipientUserGroup(((RecipientUserGroupRef) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"recipientUserGroup\" is of type \"org.hisp.dhis.api.model.v40_2_2.RecipientUserGroupRef\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("relativeScheduledDays".equals(name)) {
                                                                                                                if (value instanceof Integer) {
                                                                                                                    setRelativeScheduledDays(((Integer) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"relativeScheduledDays\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("sendStrategy".equals(name)) {
                                                                                                                    if (value instanceof DataSetNotificationTemplate.SendStrategyRef) {
                                                                                                                        setSendStrategy(((DataSetNotificationTemplate.SendStrategyRef) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"sendStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataSetNotificationTemplate.SendStrategyRef\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                        if (value instanceof Sharing) {
                                                                                                                            setSharing(((Sharing) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("subjectTemplate".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setSubjectTemplate(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"subjectTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("translations".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setTranslations(((List<Translation> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("user".equals(name)) {
                                                                                                                                    if (value instanceof UserRef__27) {
                                                                                                                                        setUser(((UserRef__27) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__27\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                                            if (value instanceof List) {
                                                                                                                                                setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("createdBy".equals(name)) {
                            return getCreatedBy();
                        } else {
                            if ("dataSetNotificationTrigger".equals(name)) {
                                return getDataSetNotificationTrigger();
                            } else {
                                if ("dataSets".equals(name)) {
                                    return getDataSets();
                                } else {
                                    if ("deliveryChannels".equals(name)) {
                                        return getDeliveryChannels();
                                    } else {
                                        if ("displayMessageTemplate".equals(name)) {
                                            return getDisplayMessageTemplate();
                                        } else {
                                            if ("displayName".equals(name)) {
                                                return getDisplayName();
                                            } else {
                                                if ("displaySubjectTemplate".equals(name)) {
                                                    return getDisplaySubjectTemplate();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    return getHref();
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        return getId();
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            return getLastUpdated();
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                return getLastUpdatedBy();
                                                                            } else {
                                                                                if ("messageTemplate".equals(name)) {
                                                                                    return getMessageTemplate();
                                                                                } else {
                                                                                    if ("name".equals(name)) {
                                                                                        return getName();
                                                                                    } else {
                                                                                        if ("notificationRecipient".equals(name)) {
                                                                                            return getNotificationRecipient();
                                                                                        } else {
                                                                                            if ("notifyParentOrganisationUnitOnly".equals(name)) {
                                                                                                return getNotifyParentOrganisationUnitOnly();
                                                                                            } else {
                                                                                                if ("notifyUsersInHierarchyOnly".equals(name)) {
                                                                                                    return getNotifyUsersInHierarchyOnly();
                                                                                                } else {
                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                        return getPublicAccess();
                                                                                                    } else {
                                                                                                        if ("recipientUserGroup".equals(name)) {
                                                                                                            return getRecipientUserGroup();
                                                                                                        } else {
                                                                                                            if ("relativeScheduledDays".equals(name)) {
                                                                                                                return getRelativeScheduledDays();
                                                                                                            } else {
                                                                                                                if ("sendStrategy".equals(name)) {
                                                                                                                    return getSendStrategy();
                                                                                                                } else {
                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                        return getSharing();
                                                                                                                    } else {
                                                                                                                        if ("subjectTemplate".equals(name)) {
                                                                                                                            return getSubjectTemplate();
                                                                                                                        } else {
                                                                                                                            if ("translations".equals(name)) {
                                                                                                                                return getTranslations();
                                                                                                                            } else {
                                                                                                                                if ("user".equals(name)) {
                                                                                                                                    return getUser();
                                                                                                                                } else {
                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                        return getUserAccesses();
                                                                                                                                    } else {
                                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                                            return getUserGroupAccesses();
                                                                                                                                        } else {
                                                                                                                                            return notFoundValue;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataSetNotificationTemplate.NOT_FOUND_VALUE);
        if (DataSetNotificationTemplate.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataSetNotificationTemplate with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataSetNotificationTemplate.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataSetNotificationTrigger");
        sb.append('=');
        sb.append(((this.dataSetNotificationTrigger == null)?"<null>":this.dataSetNotificationTrigger));
        sb.append(',');
        sb.append("dataSets");
        sb.append('=');
        sb.append(((this.dataSets == null)?"<null>":this.dataSets));
        sb.append(',');
        sb.append("deliveryChannels");
        sb.append('=');
        sb.append(((this.deliveryChannels == null)?"<null>":this.deliveryChannels));
        sb.append(',');
        sb.append("displayMessageTemplate");
        sb.append('=');
        sb.append(((this.displayMessageTemplate == null)?"<null>":this.displayMessageTemplate));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displaySubjectTemplate");
        sb.append('=');
        sb.append(((this.displaySubjectTemplate == null)?"<null>":this.displaySubjectTemplate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("messageTemplate");
        sb.append('=');
        sb.append(((this.messageTemplate == null)?"<null>":this.messageTemplate));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationRecipient");
        sb.append('=');
        sb.append(((this.notificationRecipient == null)?"<null>":this.notificationRecipient));
        sb.append(',');
        sb.append("notifyParentOrganisationUnitOnly");
        sb.append('=');
        sb.append(((this.notifyParentOrganisationUnitOnly == null)?"<null>":this.notifyParentOrganisationUnitOnly));
        sb.append(',');
        sb.append("notifyUsersInHierarchyOnly");
        sb.append('=');
        sb.append(((this.notifyUsersInHierarchyOnly == null)?"<null>":this.notifyUsersInHierarchyOnly));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("recipientUserGroup");
        sb.append('=');
        sb.append(((this.recipientUserGroup == null)?"<null>":this.recipientUserGroup));
        sb.append(',');
        sb.append("relativeScheduledDays");
        sb.append('=');
        sb.append(((this.relativeScheduledDays == null)?"<null>":this.relativeScheduledDays));
        sb.append(',');
        sb.append("sendStrategy");
        sb.append('=');
        sb.append(((this.sendStrategy == null)?"<null>":this.sendStrategy));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("subjectTemplate");
        sb.append('=');
        sb.append(((this.subjectTemplate == null)?"<null>":this.subjectTemplate));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.relativeScheduledDays == null)? 0 :this.relativeScheduledDays.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.subjectTemplate == null)? 0 :this.subjectTemplate.hashCode()));
        result = ((result* 31)+((this.dataSetNotificationTrigger == null)? 0 :this.dataSetNotificationTrigger.hashCode()));
        result = ((result* 31)+((this.sendStrategy == null)? 0 :this.sendStrategy.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.deliveryChannels == null)? 0 :this.deliveryChannels.hashCode()));
        result = ((result* 31)+((this.displaySubjectTemplate == null)? 0 :this.displaySubjectTemplate.hashCode()));
        result = ((result* 31)+((this.notifyUsersInHierarchyOnly == null)? 0 :this.notifyUsersInHierarchyOnly.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.notificationRecipient == null)? 0 :this.notificationRecipient.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.notifyParentOrganisationUnitOnly == null)? 0 :this.notifyParentOrganisationUnitOnly.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.dataSets == null)? 0 :this.dataSets.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.displayMessageTemplate == null)? 0 :this.displayMessageTemplate.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.recipientUserGroup == null)? 0 :this.recipientUserGroup.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.messageTemplate == null)? 0 :this.messageTemplate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataSetNotificationTemplate) == false) {
            return false;
        }
        DataSetNotificationTemplate rhs = ((DataSetNotificationTemplate) other);
        return (((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.relativeScheduledDays == rhs.relativeScheduledDays)||((this.relativeScheduledDays!= null)&&this.relativeScheduledDays.equals(rhs.relativeScheduledDays))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.subjectTemplate == rhs.subjectTemplate)||((this.subjectTemplate!= null)&&this.subjectTemplate.equals(rhs.subjectTemplate))))&&((this.dataSetNotificationTrigger == rhs.dataSetNotificationTrigger)||((this.dataSetNotificationTrigger!= null)&&this.dataSetNotificationTrigger.equals(rhs.dataSetNotificationTrigger))))&&((this.sendStrategy == rhs.sendStrategy)||((this.sendStrategy!= null)&&this.sendStrategy.equals(rhs.sendStrategy))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.deliveryChannels == rhs.deliveryChannels)||((this.deliveryChannels!= null)&&this.deliveryChannels.equals(rhs.deliveryChannels))))&&((this.displaySubjectTemplate == rhs.displaySubjectTemplate)||((this.displaySubjectTemplate!= null)&&this.displaySubjectTemplate.equals(rhs.displaySubjectTemplate))))&&((this.notifyUsersInHierarchyOnly == rhs.notifyUsersInHierarchyOnly)||((this.notifyUsersInHierarchyOnly!= null)&&this.notifyUsersInHierarchyOnly.equals(rhs.notifyUsersInHierarchyOnly))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.notificationRecipient == rhs.notificationRecipient)||((this.notificationRecipient!= null)&&this.notificationRecipient.equals(rhs.notificationRecipient))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.notifyParentOrganisationUnitOnly == rhs.notifyParentOrganisationUnitOnly)||((this.notifyParentOrganisationUnitOnly!= null)&&this.notifyParentOrganisationUnitOnly.equals(rhs.notifyParentOrganisationUnitOnly))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.dataSets == rhs.dataSets)||((this.dataSets!= null)&&this.dataSets.equals(rhs.dataSets))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.displayMessageTemplate == rhs.displayMessageTemplate)||((this.displayMessageTemplate!= null)&&this.displayMessageTemplate.equals(rhs.displayMessageTemplate))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.recipientUserGroup == rhs.recipientUserGroup)||((this.recipientUserGroup!= null)&&this.recipientUserGroup.equals(rhs.recipientUserGroup))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.messageTemplate == rhs.messageTemplate)||((this.messageTemplate!= null)&&this.messageTemplate.equals(rhs.messageTemplate))));
    }

    @Generated("jsonschema2pojo")
    public enum DataSetNotificationTriggerRef {

        DATA_SET_COMPLETION("DATA_SET_COMPLETION"),
        SCHEDULED_DAYS("SCHEDULED_DAYS");
        private final String value;
        private final static Map<String, DataSetNotificationTemplate.DataSetNotificationTriggerRef> CONSTANTS = new HashMap<String, DataSetNotificationTemplate.DataSetNotificationTriggerRef>();

        static {
            for (DataSetNotificationTemplate.DataSetNotificationTriggerRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataSetNotificationTriggerRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataSetNotificationTemplate.DataSetNotificationTriggerRef fromValue(String value) {
            DataSetNotificationTemplate.DataSetNotificationTriggerRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NotificationRecipientRef {

        ORGANISATION_UNIT_CONTACT("ORGANISATION_UNIT_CONTACT"),
        USER_GROUP("USER_GROUP");
        private final String value;
        private final static Map<String, DataSetNotificationTemplate.NotificationRecipientRef> CONSTANTS = new HashMap<String, DataSetNotificationTemplate.NotificationRecipientRef>();

        static {
            for (DataSetNotificationTemplate.NotificationRecipientRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NotificationRecipientRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataSetNotificationTemplate.NotificationRecipientRef fromValue(String value) {
            DataSetNotificationTemplate.NotificationRecipientRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum SendStrategyRef {

        COLLECTIVE_SUMMARY("COLLECTIVE_SUMMARY"),
        SINGLE_NOTIFICATION("SINGLE_NOTIFICATION");
        private final String value;
        private final static Map<String, DataSetNotificationTemplate.SendStrategyRef> CONSTANTS = new HashMap<String, DataSetNotificationTemplate.SendStrategyRef>();

        static {
            for (DataSetNotificationTemplate.SendStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SendStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataSetNotificationTemplate.SendStrategyRef fromValue(String value) {
            DataSetNotificationTemplate.SendStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
