
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "address",
    "email",
    "name",
    "organisation"
})
@Generated("jsonschema2pojo")
public class Developer implements Serializable
{

    @JsonProperty("address")
    private String address;
    @JsonProperty("email")
    private String email;
    @JsonProperty("name")
    private String name;
    @JsonProperty("organisation")
    private String organisation;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3352449627735245019L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Developer() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Developer(Developer source) {
        super();
        this.address = source.address;
        this.email = source.email;
        this.name = source.name;
        this.organisation = source.organisation;
    }

    public Developer(String address, String email, String name, String organisation) {
        super();
        this.address = address;
        this.email = email;
        this.name = name;
        this.organisation = organisation;
    }

    @JsonProperty("address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    public Developer withAddress(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty("email")
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    public Developer withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Developer withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("organisation")
    public Optional<String> getOrganisation() {
        return Optional.ofNullable(organisation);
    }

    @JsonProperty("organisation")
    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public Developer withOrganisation(String organisation) {
        this.organisation = organisation;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Developer withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("address".equals(name)) {
            if (value instanceof String) {
                setAddress(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"address\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("email".equals(name)) {
                if (value instanceof String) {
                    setEmail(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"email\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("name".equals(name)) {
                    if (value instanceof String) {
                        setName(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("organisation".equals(name)) {
                        if (value instanceof String) {
                            setOrganisation(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"organisation\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("address".equals(name)) {
            return getAddress();
        } else {
            if ("email".equals(name)) {
                return getEmail();
            } else {
                if ("name".equals(name)) {
                    return getName();
                } else {
                    if ("organisation".equals(name)) {
                        return getOrganisation();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Developer.NOT_FOUND_VALUE);
        if (Developer.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Developer with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Developer.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("address");
        sb.append('=');
        sb.append(((this.address == null)?"<null>":this.address));
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(((this.email == null)?"<null>":this.email));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("organisation");
        sb.append('=');
        sb.append(((this.organisation == null)?"<null>":this.organisation));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.address == null)? 0 :this.address.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.organisation == null)? 0 :this.organisation.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.email == null)? 0 :this.email.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Developer) == false) {
            return false;
        }
        Developer rhs = ((Developer) other);
        return ((((((this.address == rhs.address)||((this.address!= null)&&this.address.equals(rhs.address)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.organisation == rhs.organisation)||((this.organisation!= null)&&this.organisation.equals(rhs.organisation))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.email == rhs.email)||((this.email!= null)&&this.email.equals(rhs.email))));
    }

}
